/*
 * Decompiled with CFR 0.152.
 */
package org.soitoolkit.commons.mule.error;

import java.util.Map;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.context.MuleContextAware;
import org.mule.config.ExceptionHelper;
import org.soitoolkit.commons.mule.api.log.EventLogMessage;
import org.soitoolkit.commons.mule.api.log.EventLogger;
import org.soitoolkit.commons.mule.log.EventLoggerFactory;

public class ExceptionHandler
implements MuleContextAware {
    private EventLogger eventLogger;
    private MuleContext muleContext;

    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
        this.eventLogger = EventLoggerFactory.getEventLogger(muleContext);
    }

    protected void logException(Throwable t) {
        MuleException muleException = ExceptionHelper.getRootMuleException((Throwable)t);
        if (muleException != null) {
            if (muleException instanceof MessagingException) {
                MessagingException me = (MessagingException)muleException;
                EventLogMessage elm = new EventLogMessage();
                elm.setMuleMessage(me.getMuleMessage());
                this.eventLogger.logErrorEvent((Throwable)muleException, elm);
            } else {
                Map info = ExceptionHelper.getExceptionInfo((Throwable)muleException);
                EventLogMessage elm = new EventLogMessage();
                this.eventLogger.logErrorEvent((Throwable)muleException, info.get("Payload"), elm);
            }
        } else {
            EventLogMessage elm = new EventLogMessage();
            this.eventLogger.logErrorEvent(t, elm);
        }
    }

    protected void logFatal(MuleMessage message, Throwable t) {
        EventLogMessage elm = new EventLogMessage();
        elm.setMuleMessage(message);
        this.eventLogger.logErrorEvent(t, elm);
    }
}

