/*
 * Decompiled with CFR 0.152.
 */
package org.soitoolkit.commons.mule.monitor;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.Session;
import javax.sql.DataSource;
import org.mule.api.MuleContext;
import org.mule.transport.jms.JmsConnector;
import org.soitoolkit.commons.mule.jdbc.JdbcUtil;
import org.soitoolkit.commons.mule.util.MiscUtil;
import org.soitoolkit.commons.mule.util.MuleUtil;

public class MonitorEndpointHelper {
    public static final String OK_PREFIX = "OK";
    public static final String ERROR_PREFIX = "ERROR";

    public static String pingHttpEndpoint(String url) {
        return OK_PREFIX;
    }

    public static String pingHttpsEndpoint(String url, String truststorePath, String truststorePassword, String privateKeyPassword) {
        return OK_PREFIX;
    }

    public static String pingJdbcEndpoint(MuleContext muleContext, String tableName) {
        return MonitorEndpointHelper.pingJdbcEndpoint(muleContext, "soitoolkit-jdbc-datasource", tableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String pingJdbcEndpoint(MuleContext muleContext, String muleJdbcDataSourceName, String tableName) {
        DataSource ds = JdbcUtil.lookupDataSource(muleContext, muleJdbcDataSourceName);
        Connection c = null;
        Statement s = null;
        ResultSet rs = null;
        try {
            c = ds.getConnection();
            s = c.createStatement();
            rs = s.executeQuery("select 1 from " + tableName);
        }
        catch (SQLException e) {
            String string = "ERROR: The table " + tableName + " was not found in the data source " + muleJdbcDataSourceName + ", reason: " + e.getMessage();
            return string;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e) {}
            try {
                if (s != null) {
                    s.close();
                }
            }
            catch (SQLException e) {}
            try {
                if (c != null) {
                    c.close();
                }
            }
            catch (SQLException e) {}
        }
        return "OK: The table " + tableName + " was found in the data source " + muleJdbcDataSourceName;
    }

    public static String pingJmsEndpoint(MuleContext muleContext, String queueName) {
        return MonitorEndpointHelper.pingJmsEndpoint(muleContext, "soitoolkit-jms-connector", queueName);
    }

    public static String pingJmsEndpoint(MuleContext muleContext, String muleJmsConnectorName, String queueName) {
        try {
            MonitorEndpointHelper.isQueueEmpty(muleContext, muleJmsConnectorName, queueName);
            return "OK: The queue " + queueName + " was found in the queue manager " + muleJmsConnectorName;
        }
        catch (JMSException e) {
            return "ERROR: The queue " + queueName + " was not found in the queue manager " + muleJmsConnectorName + ", reason: " + e.getMessage();
        }
    }

    public static String pingJmsBackoutQueue(MuleContext muleContext, String queueName) {
        return MonitorEndpointHelper.pingJmsBackoutQueue(muleContext, "soitoolkit-jms-connector", queueName);
    }

    public static String pingJmsBackoutQueue(MuleContext muleContext, String muleJmsConnectorName, String queueName) {
        try {
            if (MonitorEndpointHelper.isQueueEmpty(muleContext, muleJmsConnectorName, queueName)) {
                return "OK: The queue " + queueName + " in the queue manager " + muleJmsConnectorName + " is empty";
            }
            return "ERROR: The queue " + queueName + " in the queue manager " + muleJmsConnectorName + " is not empty";
        }
        catch (JMSException e) {
            return "ERROR: The queue " + queueName + " was not found in the queue manager " + muleJmsConnectorName + ", reason: " + e.getMessage();
        }
    }

    public static String pingSoapHttpUrl(String soapHttpUrl) {
        soapHttpUrl = soapHttpUrl + "?wsdl";
        try {
            URL url = new URL(soapHttpUrl);
            Object content = url.getContent();
            InputStream is = (InputStream)content;
            String c = MiscUtil.convertStreamToString(is);
            boolean isWsdl = c.contains("http://schemas.xmlsoap.org/wsdl");
            if (isWsdl) {
                return "OK: The url " + soapHttpUrl + " responded with a wsdl as expected";
            }
            return "ERROR: The url " + soapHttpUrl + " does not seem to expose a wsdl, unexpected response: " + c;
        }
        catch (MalformedURLException e) {
            return "ERROR: The url " + soapHttpUrl + " did not respon as expected, reason: " + e;
        }
        catch (IOException e) {
            return "ERROR: The url " + soapHttpUrl + " did not respon as expected, reason: " + e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isQueueEmpty(MuleContext muleContext, String muleJmsConnectorName, String queueName) throws JMSException {
        JmsConnector muleCon = (JmsConnector)MuleUtil.getSpringBean(muleContext, muleJmsConnectorName);
        Session s = null;
        QueueBrowser b = null;
        try {
            s = muleCon.getConnection().createSession(false, 1);
            Queue q = s.createQueue(queueName);
            b = s.createBrowser(q);
            Enumeration e = b.getEnumeration();
            boolean bl = !e.hasMoreElements();
            return bl;
        }
        finally {
            try {
                if (b != null) {
                    b.close();
                }
            }
            catch (JMSException e) {}
            try {
                if (s != null) {
                    s.close();
                }
            }
            catch (JMSException e) {}
        }
    }
}

