/*
 * Decompiled with CFR 0.152.
 */
package org.soitoolkit.commons.mule.jaxb;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class JaxbUtil {
    private JAXBContext jaxbContext = null;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Map<String, Object> unmarshallProps = null;
    private Map<String, Object> marshallProps = null;

    public JaxbUtil(Class ... classesToBeBound) {
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Load JAXBContext based on classes: " + Arrays.toString(classesToBeBound));
            }
            this.jaxbContext = JAXBContext.newInstance((Class[])classesToBeBound);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    public JaxbUtil(String contextPath) {
        this.setContextPath(contextPath);
    }

    public JAXBContext getContext() {
        return this.jaxbContext;
    }

    public void setContextPath(String contextPath) {
        try {
            if (contextPath == null || contextPath.length() == 0) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("No context path, let's wait with creating the jaxbContext");
                }
            } else {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Load JAXBContext based on context path: " + contextPath);
                }
                this.jaxbContext = JAXBContext.newInstance((String)contextPath);
            }
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    public void addMarshallProperty(String name, Object value) {
        if (this.marshallProps == null) {
            this.marshallProps = new HashMap<String, Object>();
        }
        this.marshallProps.put(name, value);
    }

    public void addUnmarshallProperty(String name, Object value) {
        if (this.unmarshallProps == null) {
            this.unmarshallProps = new HashMap<String, Object>();
        }
        this.unmarshallProps.put(name, value);
    }

    public String marshal(Object jaxbObject) {
        if (this.jaxbContext == null) {
            this.logger.error("Trying to marshal with a null jaxbContext, returns null. Check your configuration, e.g. jaxb-transformers!");
            return null;
        }
        try {
            StringWriter writer = new StringWriter();
            Marshaller marshaller = this.jaxbContext.createMarshaller();
            if (this.marshallProps != null) {
                for (Map.Entry<String, Object> entry : this.marshallProps.entrySet()) {
                    marshaller.setProperty(entry.getKey(), entry.getValue());
                }
            }
            marshaller.marshal(jaxbObject, (Writer)writer);
            String xml = writer.toString();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("marshalled jaxb object of type {}, returns xml: {}", (Object)jaxbObject.getClass().getSimpleName(), (Object)xml);
            }
            return xml;
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    public String marshal(Object jaxbObject, String namespaceURI, String localPart) {
        jaxbObject = new JAXBElement(new QName(namespaceURI, localPart), jaxbObject.getClass(), jaxbObject);
        return this.marshal(jaxbObject);
    }

    public Object unmarshal(Object payload) {
        if (this.jaxbContext == null) {
            this.logger.error("Trying to unmarshal with a null jaxbContext, returns null. Check your configuration, e.g. jaxb-transformers!");
            return null;
        }
        try {
            Object src;
            Unmarshaller unmarshaller = this.jaxbContext.createUnmarshaller();
            if (this.unmarshallProps != null) {
                for (Map.Entry<String, Object> entry : this.unmarshallProps.entrySet()) {
                    unmarshaller.setProperty(entry.getKey(), entry.getValue());
                }
            }
            Object jaxbObject = null;
            if (payload instanceof String) {
                src = (String)payload;
                jaxbObject = unmarshaller.unmarshal((Reader)new StringReader((String)src));
            } else if (payload instanceof byte[]) {
                src = (byte[])payload;
                jaxbObject = unmarshaller.unmarshal((InputStream)new ByteArrayInputStream((byte[])src));
            } else if (payload instanceof File) {
                jaxbObject = unmarshaller.unmarshal((File)payload);
            } else if (payload instanceof InputSource) {
                jaxbObject = unmarshaller.unmarshal((InputSource)payload);
            } else if (payload instanceof InputStream) {
                jaxbObject = unmarshaller.unmarshal((InputStream)payload);
            } else if (payload instanceof Reader) {
                jaxbObject = unmarshaller.unmarshal((Reader)payload);
            } else if (payload instanceof URL) {
                jaxbObject = unmarshaller.unmarshal((URL)payload);
            } else if (payload instanceof InputSource) {
                jaxbObject = unmarshaller.unmarshal((InputSource)payload);
            } else if (payload instanceof Node) {
                jaxbObject = unmarshaller.unmarshal((Node)payload);
            } else if (payload instanceof Source) {
                jaxbObject = unmarshaller.unmarshal((Source)payload);
            } else if (payload instanceof XMLEventReader) {
                jaxbObject = unmarshaller.unmarshal((XMLEventReader)payload);
            } else if (payload instanceof XMLStreamReader) {
                jaxbObject = unmarshaller.unmarshal((XMLStreamReader)payload);
            } else {
                throw new RuntimeException("Unknown sourcetype of the xml payload: " + payload.getClass().getName());
            }
            if (jaxbObject instanceof JAXBElement) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Found a JAXBElement, returns it value");
                }
                jaxbObject = ((JAXBElement)jaxbObject).getValue();
            }
            this.logger.debug("unmarshalled xml payload of type: {}, returns jaxb object of type {}", (Object)payload.getClass().getName(), (Object)jaxbObject.getClass().getName());
            return jaxbObject;
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }
}

