/*
 * Decompiled with CFR 0.152.
 */
package org.soitoolkit.commons.mule.test;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.QueueBrowser;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSession;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJmsTestUtil {
    protected QueueConnection connection = null;
    protected QueueSession session = null;
    protected TopicConnection topicConnection = null;
    protected TopicSession topicSession = null;
    protected static final Logger logger = LoggerFactory.getLogger(AbstractJmsTestUtil.class);

    protected abstract QueueConnectionFactory createQueueConnectionFactory() throws Exception;

    protected abstract TopicConnectionFactory createTopicConnectionFactory() throws Exception;

    protected abstract String getUsername();

    protected abstract String getPassword();

    public abstract int getNoOfMsgsIncludingPendingForRetry(String var1);

    public QueueSession getSession() {
        return this.session;
    }

    public TopicSession getTopicSession() {
        return this.topicSession;
    }

    public void sendOneTextMessage(String queueName, String message) {
        this.sendOneTextMessage(queueName, message, null);
    }

    public void sendOneTextMessage(String queueName, String message, Map<String, String> headers) {
        MessageProducer publisher = null;
        try {
            publisher = this.session.createProducer((Destination)this.session.createQueue(queueName));
            TextMessage textMessage = this.session.createTextMessage(message);
            if (headers != null) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    textMessage.setStringProperty(entry.getKey(), entry.getValue());
                }
            }
            publisher.send((Message)textMessage);
        }
        catch (JMSException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (publisher != null) {
                    publisher.close();
                }
            }
            catch (JMSException e) {}
        }
    }

    public List<Message> browseMessagesOnQueue(String queueName) {
        QueueBrowser browser = null;
        try {
            browser = this.session.createBrowser(this.session.createQueue(queueName));
            ArrayList<Message> result = new ArrayList<Message>();
            Enumeration messages = browser.getEnumeration();
            while (messages.hasMoreElements()) {
                Message message = (Message)messages.nextElement();
                result.add(message);
            }
            ArrayList<Message> arrayList = result;
            return arrayList;
        }
        catch (JMSException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (browser != null) {
                    browser.close();
                }
            }
            catch (JMSException e) {}
        }
    }

    public List<Message> consumeMessagesOnQueue(String queueName) {
        MessageConsumer consumer = null;
        try {
            consumer = this.session.createConsumer((Destination)this.session.createQueue(queueName));
            ArrayList<Message> result = new ArrayList<Message>();
            Message message = null;
            while ((message = consumer.receive(100L)) != null) {
                result.add(message);
            }
            ArrayList<Message> arrayList = result;
            return arrayList;
        }
        catch (JMSException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (consumer != null) {
                    consumer.close();
                }
            }
            catch (JMSException e) {}
        }
    }

    public String consumeOneTextMessage(String queueName, long timeout) {
        String textMessage = null;
        Message msg = this.consumeOneMessage(queueName, timeout);
        if (msg != null) {
            try {
                textMessage = ((TextMessage)msg).getText();
            }
            catch (JMSException e) {
                throw new RuntimeException(e);
            }
        }
        return textMessage;
    }

    public Message consumeOneMessage(String queueName, long timeout) {
        MessageConsumer consumer = null;
        try {
            consumer = this.session.createConsumer((Destination)this.session.createQueue(queueName));
            Message message = consumer.receive(timeout);
            return message;
        }
        catch (JMSException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (consumer != null) {
                    consumer.close();
                }
            }
            catch (JMSException e) {}
        }
    }

    public void clearQueues(String ... queueNames) {
        if (logger.isInfoEnabled()) {
            StringBuffer queues = new StringBuffer();
            for (int i = 0; i < queueNames.length; ++i) {
                queues.append(queueNames[i]);
                queues.append(' ');
            }
            logger.info("Clearing messages on queues: {}", (Object)queues);
        }
        for (int i = 0; i < queueNames.length; ++i) {
            logger.debug("Start to consume messages from queue {}", (Object)queueNames[i]);
            List<Message> messages = this.consumeMessagesOnQueue(queueNames[i]);
            logger.debug("CONSUMED {} MESSAGES FROM QUEUE {}", (Object)messages.size(), (Object)queueNames[i]);
        }
    }

    public Message consumeMessageOnTopic(String topicName, String subName, int timeout) {
        TopicSubscriber topicSubscriber = null;
        try {
            topicSubscriber = this.createDurableSubscriber(topicName, subName);
            Message message = topicSubscriber.receive((long)timeout);
            return message;
        }
        catch (JMSException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (topicSubscriber != null) {
                    topicSubscriber.close();
                }
            }
            catch (JMSException e) {}
        }
    }

    public List<Message> consumeMessagesOnTopic(String topicName, String subName, int timeout) {
        ArrayList<Message> result = new ArrayList<Message>();
        TopicSubscriber topicSubscriber = null;
        try {
            topicSubscriber = this.createDurableSubscriber(topicName, subName);
            Message message = null;
            while ((message = topicSubscriber.receive((long)timeout)) != null) {
                result.add(message);
            }
            ArrayList<Message> arrayList = result;
            return arrayList;
        }
        catch (JMSException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (topicSubscriber != null) {
                    topicSubscriber.close();
                }
            }
            catch (JMSException e) {}
        }
    }

    public TopicSubscriber createDurableSubscriber(String topicName, String subName) {
        TopicSubscriber topicSubscriber = null;
        try {
            Topic topic = this.topicSession.createTopic(topicName);
            topicSubscriber = this.topicSession.createDurableSubscriber(topic, subName);
        }
        catch (JMSException e) {
            throw new RuntimeException(e);
        }
        return topicSubscriber;
    }

    public void clearTopic(String topicName, String ... subNames) {
        for (String subName : subNames) {
            if (logger.isInfoEnabled()) {
                logger.info("Clearing messages on topic: {} and subscription: {}", (Object)topicName, (Object)subName);
            }
            TopicSubscriber topicSubscriber = null;
            try {
                topicSubscriber = this.createDurableSubscriber(topicName, subName);
                while (topicSubscriber != null && topicSubscriber.receiveNoWait() != null) {
                }
            }
            catch (JMSException e) {
                throw new RuntimeException(e);
            }
            finally {
                try {
                    if (topicSubscriber != null) {
                        topicSubscriber.close();
                    }
                }
                catch (JMSException e) {}
            }
        }
    }

    protected void init(String clientId) {
        String username;
        boolean ok = false;
        try {
            QueueConnectionFactory connectionFactory = this.createQueueConnectionFactory();
            username = this.getUsername();
            this.connection = username == null ? connectionFactory.createQueueConnection() : connectionFactory.createQueueConnection(username, this.getPassword());
            this.connection.start();
            this.session = this.connection.createQueueSession(false, 1);
            ok = true;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (!ok) {
                this.cleanup();
            }
        }
        if (clientId != null) {
            try {
                TopicConnectionFactory topicConnectionFactory = this.createTopicConnectionFactory();
                username = this.getUsername();
                this.topicConnection = username == null ? topicConnectionFactory.createTopicConnection() : topicConnectionFactory.createTopicConnection(username, this.getPassword());
                this.topicConnection.setClientID(clientId);
                this.topicConnection.start();
                this.topicSession = this.topicConnection.createTopicSession(false, 1);
                ok = true;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                if (!ok) {
                    this.cleanup();
                }
            }
        }
    }

    public void cleanup() {
        try {
            if (this.session != null) {
                this.session.close();
            }
            if (this.connection != null) {
                this.connection.stop();
                this.connection.close();
            }
        }
        catch (JMSException e) {
            throw new RuntimeException(e);
        }
        try {
            if (this.topicSession != null) {
                this.topicSession.close();
            }
            if (this.topicConnection != null) {
                this.topicConnection.stop();
                this.topicConnection.close();
            }
        }
        catch (JMSException e) {
            throw new RuntimeException(e);
        }
    }
}

