/*
 * Decompiled with CFR 0.152.
 */
package org.soitoolkit.commons.mule.mail;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.internet.MimeBodyPart;
import org.soitoolkit.commons.mule.mail.Attachment;
import org.soitoolkit.commons.mule.mail.MailUtil;

public class MailMessage {
    private String from;
    private String subject;
    private String text;
    private List<String> to = new ArrayList<String>();
    private List<String> cc = new ArrayList<String>();
    private List<String> bcc = new ArrayList<String>();
    private List<Attachment> attachments = new ArrayList<Attachment>();

    public MailMessage(Message mail) {
        try {
            this.from = mail.getFrom()[0].toString();
            this.subject = mail.getSubject();
            this.text = MailUtil.getText((Part)mail);
            MailUtil.fillAddresses(mail, Message.RecipientType.TO, this.to);
            MailUtil.fillAddresses(mail, Message.RecipientType.CC, this.cc);
            MailUtil.fillAddresses(mail, Message.RecipientType.BCC, this.bcc);
            this.fillAttachments((Part)mail, this.attachments);
        }
        catch (MessagingException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void fillAttachments(Part part, List<Attachment> attachments) throws IOException, MessagingException {
        if (part.isMimeType("multipart/*")) {
            Multipart multipart = (Multipart)part.getContent();
            int n = multipart.getCount();
            for (int i = 0; i < n; ++i) {
                BodyPart bodyPart = multipart.getBodyPart(i);
                String disposition = bodyPart.getDisposition();
                if (disposition != null && (disposition.equals("attachment") || disposition.equals("inline"))) {
                    System.err.println("### Writing attachement to byte array: " + bodyPart.getFileName() + ", contentType: " + part.getContentType() + ", class: " + part.getContent().getClass().getName());
                    Attachment attachment = new Attachment(bodyPart.getFileName(), MailUtil.copy(bodyPart.getInputStream()));
                    attachments.add(attachment);
                }
                if (disposition != null) continue;
                MimeBodyPart mbp = (MimeBodyPart)bodyPart;
                if (mbp.isMimeType("text/plain")) {
                    System.err.println("### FOUND TEXT-PART IN PART WITH UNKNOWN DISPOSITION");
                    continue;
                }
                System.err.println("### FOUND NON-TEXT-PART IN PART WITH UNKNOWN DISPOSITION");
            }
        }
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public List<String> getTo() {
        return this.to;
    }

    public List<String> getCc() {
        return this.cc;
    }

    public List<String> getBcc() {
        return this.bcc;
    }

    public List<Attachment> getAttachments() {
        return this.attachments;
    }
}

