/*
 * Decompiled with CFR 0.152.
 */
package org.opensrp.api.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.opensrp.api.util.TreeNode;

public class Tree<K, T> {
    Map<K, TreeNode<K, T>> map = new HashMap<K, TreeNode<K, T>>();
    Map<K, Set<K>> parentChildren = new HashMap<K, Set<K>>();

    public Map<K, TreeNode<K, T>> getTree() {
        return Collections.unmodifiableMap(this.map);
    }

    public Map<K, Set<K>> getChildParent() {
        return Collections.unmodifiableMap(this.parentChildren);
    }

    private void addToParentChildRelation(K parent, K id) {
        Set<K> kids;
        if (this.parentChildren == null) {
            this.parentChildren = new HashMap<K, Set<K>>();
        }
        if ((kids = this.parentChildren.get(parent)) == null) {
            kids = new HashSet<K>();
        }
        kids.add(id);
        this.parentChildren.put(parent, kids);
    }

    public void addNode(K id, String label, T node, K parentId) {
        if (this.map == null) {
            this.map = new HashMap<K, TreeNode<K, T>>();
        }
        if (this.hasNode(id)) {
            throw new IllegalArgumentException("Node with ID " + id + " already exists in tree");
        }
        TreeNode<K, T> n = this.makeNode(id, label, node, parentId);
        if (parentId != null) {
            this.addToParentChildRelation(parentId, id);
            TreeNode<K, T> p = this.getNode(parentId);
            if (p != null) {
                p.addChild(n);
            } else {
                this.map.put(id, n);
            }
        } else {
            this.map.put(id, n);
        }
        Set<K> kids = this.parentChildren.get(id);
        if (kids != null) {
            for (K kid : kids) {
                TreeNode<K, T> kn = this.removeNode(kid);
                n.addChild(kn);
            }
        }
    }

    private TreeNode<K, T> makeNode(K id, String label, T node, K parentId) {
        TreeNode<K, T> n = this.getNode(id);
        if (n == null) {
            n = new TreeNode<K, T>(id, label, node, parentId);
        }
        return n;
    }

    public TreeNode<K, T> getNode(K id) {
        if (this.map.containsKey(id)) {
            return this.map.get(id);
        }
        for (TreeNode<K, T> root : this.map.values()) {
            TreeNode<K, T> n = root.findChild(id);
            if (n == null) continue;
            return n;
        }
        return null;
    }

    TreeNode<K, T> removeNode(K id) {
        if (this.map.containsKey(id)) {
            return this.map.remove(id);
        }
        for (TreeNode<K, T> root : this.map.values()) {
            TreeNode<K, T> n = root.removeChild(id);
            if (n == null) continue;
            return n;
        }
        return null;
    }

    public boolean hasNode(K id) {
        return this.getNode(id) != null;
    }
}

