/*
 * Decompiled with CFR 0.152.
 */
package org.opensrp.api.util;

import java.util.List;
import java.util.Map;
import org.opensrp.api.domain.Location;
import org.opensrp.api.util.Tree;
import org.opensrp.api.util.TreeNode;

public class LocationTree {
    Tree<String, Location> locationsHierarchy = new Tree();

    public void addLocation(Location l) {
        if (!this.locationsHierarchy.hasNode(l.getLocationId())) {
            if (l.getParentLocation() == null) {
                this.locationsHierarchy.addNode(l.getLocationId(), l.getName(), l, null);
            } else {
                this.locationsHierarchy.addNode(l.getLocationId(), l.getName(), l, l.getParentLocation().getLocationId());
            }
        }
    }

    public void buildTreeFromList(List<Location> locations) {
        for (Location location : locations) {
            this.addLocation(location);
        }
    }

    public Location findLocation(String locationId) {
        return this.locationsHierarchy.getNode(locationId).getNode();
    }

    public boolean hasLocation(String locationId) {
        return this.locationsHierarchy.hasNode(locationId);
    }

    public boolean hasChildLocation(String locationId, String childLocationId) {
        return this.locationsHierarchy.getNode(locationId).findChild(childLocationId) != null;
    }

    public Map<String, TreeNode<String, Location>> getLocationsHierarchy() {
        return this.locationsHierarchy.getTree();
    }
}

