/*
 * Decompiled with CFR 0.152.
 */
package org.opensrp.api.domain;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.joda.time.DateTime;
import org.opensrp.api.domain.BaseDataObject;
import org.opensrp.api.domain.Obs;
import org.opensrp.api.domain.Photo;

public class Event
extends BaseDataObject {
    private Map<String, String> identifiers;
    private String baseEntityId;
    private String locationId;
    private DateTime eventDate;
    private String eventType;
    private String formSubmissionId;
    private String providerId;
    private String status;
    private Map<String, DateTime> statusHistory;
    private String priority;
    private List<String> episodeOfCare;
    private List<String> referrals;
    private String category;
    private int duration;
    private String reason;
    private List<Obs> obs;
    private String entityType;
    private Map<String, String> details;
    private long version;
    private List<Photo> photos;

    public Event() {
        this.version = System.currentTimeMillis();
    }

    public Event(String baseEntityId, String eventType, DateTime eventDate, String entityType, String providerId, String locationId, String formSubmissionId) {
        this.baseEntityId = baseEntityId;
        this.eventType = eventType;
        this.eventDate = eventDate;
        this.entityType = entityType;
        this.providerId = providerId;
        this.locationId = locationId;
        this.formSubmissionId = formSubmissionId;
        this.version = System.currentTimeMillis();
    }

    public List<Obs> getObs() {
        return this.obs;
    }

    public void setObs(List<Obs> obs) {
        this.obs = obs;
    }

    public void addObs(Obs observation) {
        if (this.obs == null) {
            this.obs = new ArrayList<Obs>();
        }
        this.obs.add(observation);
    }

    public String getBaseEntityId() {
        return this.baseEntityId;
    }

    public void setBaseEntityId(String baseEntityId) {
        this.baseEntityId = baseEntityId;
    }

    public Map<String, String> getIdentifiers() {
        if (this.identifiers == null) {
            this.identifiers = new HashMap<String, String>();
        }
        return this.identifiers;
    }

    public String getIdentifier(String identifierType) {
        if (this.identifiers == null) {
            return null;
        }
        for (String k : this.identifiers.keySet()) {
            if (!k.equalsIgnoreCase(identifierType)) continue;
            return this.identifiers.get(k);
        }
        return null;
    }

    public String getIdentifierMatchingRegex(String regex) {
        for (Map.Entry<String, String> a : this.getIdentifiers().entrySet()) {
            if (!a.getKey().matches(regex)) continue;
            return a.getValue();
        }
        return null;
    }

    public void setIdentifiers(Map<String, String> identifiers) {
        this.identifiers = identifiers;
    }

    public void addIdentifier(String identifierType, String identifier) {
        if (this.identifiers == null) {
            this.identifiers = new HashMap<String, String>();
        }
        this.identifiers.put(identifierType, identifier);
    }

    public void removeIdentifier(String identifierType) {
        this.identifiers.remove(identifierType);
    }

    public String getLocationId() {
        return this.locationId;
    }

    public void setLocationId(String locationId) {
        this.locationId = locationId;
    }

    public DateTime getEventDate() {
        return this.eventDate;
    }

    public void setEventDate(DateTime eventDate) {
        this.eventDate = eventDate;
    }

    public String getEventType() {
        return this.eventType;
    }

    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    public String getFormSubmissionId() {
        return this.formSubmissionId;
    }

    public void setFormSubmissionId(String formSubmissionId) {
        this.formSubmissionId = formSubmissionId;
    }

    public String getProviderId() {
        return this.providerId;
    }

    public void setProviderId(String providerId) {
        this.providerId = providerId;
    }

    public String getEntityType() {
        return this.entityType;
    }

    public void setEntityType(String entityType) {
        this.entityType = entityType;
    }

    public Map<String, String> getDetails() {
        return this.details;
    }

    public void setDetails(Map<String, String> details) {
        this.details = details;
    }

    public void addDetails(String key, String val) {
        if (this.details == null) {
            this.details = new HashMap<String, String>();
        }
        this.details.put(key, val);
    }

    public long getVersion() {
        return this.version;
    }

    public void setVersion(long version) {
        this.version = version;
    }

    public Event withBaseEntityId(String baseEntityId) {
        this.baseEntityId = baseEntityId;
        return this;
    }

    public Event withIdentifiers(Map<String, String> identifiers) {
        this.identifiers = identifiers;
        return this;
    }

    public Event withIdentifier(String identifierType, String identifier) {
        if (this.identifiers == null) {
            this.identifiers = new HashMap<String, String>();
        }
        this.identifiers.put(identifierType, identifier);
        return this;
    }

    public Event withLocationId(String locationId) {
        this.locationId = locationId;
        return this;
    }

    public Event withEventDate(DateTime eventDate) {
        this.eventDate = eventDate;
        return this;
    }

    public Event withEventType(String eventType) {
        this.eventType = eventType;
        return this;
    }

    public Event withFormSubmissionId(String formSubmissionId) {
        this.formSubmissionId = formSubmissionId;
        return this;
    }

    public Event withProviderId(String providerId) {
        this.providerId = providerId;
        return this;
    }

    public Event withEntityType(String entityType) {
        this.entityType = entityType;
        return this;
    }

    public Event withObs(List<Obs> obs) {
        this.obs = obs;
        return this;
    }

    public Event withObs(Obs observation) {
        if (this.obs == null) {
            this.obs = new ArrayList<Obs>();
        }
        this.obs.add(observation);
        return this;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

