/*
 * Decompiled with CFR 0.152.
 */
package org.opensrp.api.domain;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.opensrp.common.AddressField;

public class Address {
    private String addressType;
    private Date startDate;
    private Date endDate;
    private Map<String, String> addressFields;
    private String latitude;
    private String longitute;
    private String postalCode;
    private String state;
    private String country;

    public Address() {
    }

    public Address(String addressType, Date startDate, Date endDate, Map<String, String> addressFields, String latitude, String longitute, String postalCode, String state, String country) {
        this.addressType = addressType;
        this.startDate = startDate;
        this.endDate = endDate;
        this.addressFields = addressFields;
        this.latitude = latitude;
        this.longitute = longitute;
        this.postalCode = postalCode;
        this.state = state;
        this.country = country;
    }

    public String getAddressType() {
        return this.addressType;
    }

    public void setAddressType(String addressType) {
        this.addressType = addressType;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public Map<String, String> getAddressFields() {
        return this.addressFields;
    }

    public String getAddressField(String addressField) {
        for (Map.Entry<String, String> a : this.addressFields.entrySet()) {
            if (!a.getKey().equalsIgnoreCase(addressField)) continue;
            return a.getValue();
        }
        return null;
    }

    public String getAddressFieldMatchingRegex(String regex) {
        for (Map.Entry<String, String> a : this.addressFields.entrySet()) {
            if (!a.getKey().matches(regex)) continue;
            return a.getValue();
        }
        return null;
    }

    public String getAddressField(AddressField addressField) {
        for (Map.Entry<String, String> a : this.addressFields.entrySet()) {
            if (!a.getKey().equalsIgnoreCase(addressField.name())) continue;
            return a.getValue();
        }
        return null;
    }

    public void setAddressFields(Map<String, String> addressFields) {
        this.addressFields = addressFields;
    }

    public void addAddressField(String field, String value) {
        if (this.addressFields == null) {
            this.addressFields = new HashMap<String, String>();
        }
        this.addressFields.put(field, value);
    }

    public void addAddressField(AddressField field, String value) {
        if (this.addressFields == null) {
            this.addressFields = new HashMap<String, String>();
        }
        this.addressFields.put(field.name(), value);
    }

    public void removeAddressField(AddressField field) {
        for (Map.Entry<String, String> a : this.addressFields.entrySet()) {
            if (!a.getKey().equalsIgnoreCase(field.name())) continue;
            this.addressFields.remove(a.getKey());
        }
    }

    public void removeAddressField(String field) {
        for (Map.Entry<String, String> a : this.addressFields.entrySet()) {
            if (!a.getKey().equalsIgnoreCase(field)) continue;
            this.addressFields.remove(a.getKey());
        }
    }

    public String getLatitude() {
        return this.latitude;
    }

    public void setLatitude(String latitude) {
        this.latitude = latitude;
    }

    public String getLongitute() {
        return this.longitute;
    }

    public void setLongitute(String longitute) {
        this.longitute = longitute;
    }

    public String getPostalCode() {
        return this.postalCode;
    }

    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public boolean isActive() {
        return this.endDate == null || this.endDate.after(new Date());
    }

    private long durationInMillis() {
        if (this.startDate == null) {
            return -1L;
        }
        if (this.endDate == null) {
            return new Date().getTime() - this.startDate.getTime();
        }
        return this.endDate.getTime() - this.startDate.getTime();
    }

    public int durationInDays() {
        return (int)(this.durationInMillis() == -1L ? this.durationInMillis() : this.durationInMillis() / 86400000L);
    }

    public int durationInWeeks() {
        return this.durationInDays() == -1 ? this.durationInDays() : this.durationInDays() / 7;
    }

    public int durationInMonths() {
        return this.durationInDays() == -1 ? this.durationInDays() : this.durationInDays() / 30;
    }

    public int durationInYears() {
        return this.durationInDays() == -1 ? this.durationInDays() : this.durationInDays() / 365;
    }

    public Address withAddressType(String addressType) {
        this.addressType = addressType;
        return this;
    }

    public Address withStartDate(Date startDate) {
        this.startDate = startDate;
        return this;
    }

    public Address withEndDate(Date endDate) {
        this.endDate = endDate;
        return this;
    }

    public Address withAddressFields(Map<String, String> addressFields) {
        this.addressFields = addressFields;
        return this;
    }

    public Address withAddressField(String field, String value) {
        if (this.addressFields == null) {
            this.addressFields = new HashMap<String, String>();
        }
        this.addressFields.put(field, value);
        return this;
    }

    public Address withAddressField(AddressField field, String value) {
        if (this.addressFields == null) {
            this.addressFields = new HashMap<String, String>();
        }
        this.addressFields.put(field.name(), value);
        return this;
    }

    public Address withLatitude(String latitude) {
        this.latitude = latitude;
        return this;
    }

    public Address withLongitute(String longitute) {
        this.longitute = longitute;
        return this;
    }

    public Address withPostalCode(String postalCode) {
        this.postalCode = postalCode;
        return this;
    }

    public Address withState(String state) {
        this.state = state;
        return this;
    }

    public Address withCountry(String country) {
        this.country = country;
        return this;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

