/*
 * Decompiled with CFR 0.152.
 */
package org.siouan.frontendgradleplugin.infrastructure.gradle;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.Set;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.Task;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.siouan.frontendgradleplugin.domain.FrontendException;
import org.siouan.frontendgradleplugin.domain.Platform;
import org.siouan.frontendgradleplugin.domain.installer.Credentials;
import org.siouan.frontendgradleplugin.domain.installer.InstallNodeDistribution;
import org.siouan.frontendgradleplugin.domain.installer.InstallNodeDistributionCommand;
import org.siouan.frontendgradleplugin.domain.installer.ProxySettings;
import org.siouan.frontendgradleplugin.domain.installer.ResolveProxySettingsByUrl;
import org.siouan.frontendgradleplugin.domain.installer.ResolveProxySettingsByUrlCommand;
import org.siouan.frontendgradleplugin.domain.installer.RetrySettings;
import org.siouan.frontendgradleplugin.infrastructure.bean.BeanRegistry;
import org.siouan.frontendgradleplugin.infrastructure.bean.BeanRegistryException;
import org.siouan.frontendgradleplugin.infrastructure.gradle.BeanRegistryBuildService;
import org.siouan.frontendgradleplugin.infrastructure.gradle.GradleLoggerAdapter;
import org.siouan.frontendgradleplugin.infrastructure.gradle.GradleSettings;
import org.siouan.frontendgradleplugin.infrastructure.gradle.TaskLoggerInitializer;

public class InstallNodeTask
extends DefaultTask {
    protected final Property<BeanRegistryBuildService> beanRegistryBuildService;
    private final Property<String> nodeVersion;
    private final Property<File> nodeInstallDirectory;
    private final Property<String> nodeDistributionUrlRoot;
    private final Property<String> nodeDistributionUrlPathPattern;
    private final Property<String> nodeDistributionServerUsername;
    private final Property<String> nodeDistributionServerPassword;
    private final RegularFileProperty nodeExecutableFile;
    private final Property<String> httpProxyHost;
    private final Property<Integer> httpProxyPort;
    private final Property<String> httpProxyUsername;
    private final Property<String> httpProxyPassword;
    private final Property<String> httpsProxyHost;
    private final Property<Integer> httpsProxyPort;
    private final Property<String> httpsProxyUsername;
    private final Property<String> httpsProxyPassword;
    private final Property<Integer> maxDownloadAttempts;
    private final SetProperty<Integer> retryHttpStatuses;
    private final Property<Integer> retryInitialIntervalMs;
    private final Property<Double> retryIntervalMultiplier;
    private final Property<Boolean> verboseModeEnabled;
    private final Property<Integer> retryMaxIntervalMs;
    private final Property<String> systemHttpProxyHost;
    private final Property<Integer> systemHttpProxyPort;
    private final Property<String> systemHttpsProxyHost;
    private final Property<Integer> systemHttpsProxyPort;
    private final SetProperty<String> systemNonProxyHosts;
    private final Property<String> systemJvmArch;
    private final Property<String> systemOsName;

    @Inject
    public InstallNodeTask(ObjectFactory objectFactory) {
        this.beanRegistryBuildService = objectFactory.property(BeanRegistryBuildService.class);
        this.nodeVersion = objectFactory.property(String.class);
        this.nodeInstallDirectory = objectFactory.property(File.class);
        this.nodeDistributionUrlRoot = objectFactory.property(String.class);
        this.nodeDistributionUrlPathPattern = objectFactory.property(String.class);
        this.nodeDistributionServerUsername = objectFactory.property(String.class);
        this.nodeDistributionServerPassword = objectFactory.property(String.class);
        this.nodeExecutableFile = objectFactory.fileProperty();
        this.httpProxyHost = objectFactory.property(String.class);
        this.httpProxyPort = objectFactory.property(Integer.class);
        this.httpProxyUsername = objectFactory.property(String.class);
        this.httpProxyPassword = objectFactory.property(String.class);
        this.httpsProxyHost = objectFactory.property(String.class);
        this.httpsProxyPort = objectFactory.property(Integer.class);
        this.httpsProxyUsername = objectFactory.property(String.class);
        this.httpsProxyPassword = objectFactory.property(String.class);
        this.maxDownloadAttempts = objectFactory.property(Integer.class);
        this.retryHttpStatuses = objectFactory.setProperty(Integer.class);
        this.retryInitialIntervalMs = objectFactory.property(Integer.class);
        this.retryIntervalMultiplier = objectFactory.property(Double.class);
        this.retryMaxIntervalMs = objectFactory.property(Integer.class);
        this.verboseModeEnabled = objectFactory.property(Boolean.class);
        this.systemHttpProxyHost = objectFactory.property(String.class);
        this.systemHttpProxyPort = objectFactory.property(Integer.class);
        this.systemHttpsProxyHost = objectFactory.property(String.class);
        this.systemHttpsProxyPort = objectFactory.property(Integer.class);
        this.systemNonProxyHosts = objectFactory.setProperty(String.class);
        this.systemJvmArch = objectFactory.property(String.class);
        this.systemOsName = objectFactory.property(String.class);
    }

    @Internal
    public Property<BeanRegistryBuildService> getBeanRegistryBuildService() {
        return this.beanRegistryBuildService;
    }

    @Input
    public Property<String> getNodeVersion() {
        return this.nodeVersion;
    }

    @Input
    public Property<String> getNodeDistributionUrlRoot() {
        return this.nodeDistributionUrlRoot;
    }

    @Input
    public Property<String> getNodeDistributionUrlPathPattern() {
        return this.nodeDistributionUrlPathPattern;
    }

    @Input
    public Property<File> getNodeInstallDirectory() {
        return this.nodeInstallDirectory;
    }

    @Internal
    public Property<String> getNodeDistributionServerUsername() {
        return this.nodeDistributionServerUsername;
    }

    @Internal
    public Property<String> getNodeDistributionServerPassword() {
        return this.nodeDistributionServerPassword;
    }

    @Internal
    public Property<String> getHttpProxyHost() {
        return this.httpProxyHost;
    }

    @Internal
    public Property<Integer> getHttpProxyPort() {
        return this.httpProxyPort;
    }

    @Internal
    public Property<String> getHttpProxyUsername() {
        return this.httpProxyUsername;
    }

    @Internal
    public Property<String> getHttpProxyPassword() {
        return this.httpProxyPassword;
    }

    @Internal
    public Property<String> getHttpsProxyHost() {
        return this.httpsProxyHost;
    }

    @Internal
    public Property<Integer> getHttpsProxyPort() {
        return this.httpsProxyPort;
    }

    @Internal
    public Property<String> getHttpsProxyUsername() {
        return this.httpsProxyUsername;
    }

    @Internal
    public Property<String> getHttpsProxyPassword() {
        return this.httpsProxyPassword;
    }

    @Internal
    public Property<Integer> getMaxDownloadAttempts() {
        return this.maxDownloadAttempts;
    }

    @Internal
    public SetProperty<Integer> getRetryHttpStatuses() {
        return this.retryHttpStatuses;
    }

    @Internal
    public Property<Integer> getRetryInitialIntervalMs() {
        return this.retryInitialIntervalMs;
    }

    @Internal
    public Property<Double> getRetryIntervalMultiplier() {
        return this.retryIntervalMultiplier;
    }

    @Internal
    public Property<Integer> getRetryMaxIntervalMs() {
        return this.retryMaxIntervalMs;
    }

    @Internal
    public Property<Boolean> getVerboseModeEnabled() {
        return this.verboseModeEnabled;
    }

    @Internal
    public Property<String> getSystemHttpProxyHost() {
        return this.systemHttpProxyHost;
    }

    @Internal
    public Property<Integer> getSystemHttpProxyPort() {
        return this.systemHttpProxyPort;
    }

    @Internal
    public Property<String> getSystemHttpsProxyHost() {
        return this.systemHttpsProxyHost;
    }

    @Internal
    public Property<Integer> getSystemHttpsProxyPort() {
        return this.systemHttpsProxyPort;
    }

    @Internal
    public SetProperty<String> getSystemNonProxyHosts() {
        return this.systemNonProxyHosts;
    }

    @Internal
    public Property<String> getSystemJvmArch() {
        return this.systemJvmArch;
    }

    @Internal
    public Property<String> getSystemOsName() {
        return this.systemOsName;
    }

    @OutputFile
    public RegularFileProperty getNodeExecutableFile() {
        return this.nodeExecutableFile;
    }

    @TaskAction
    public void execute() throws BeanRegistryException, FrontendException, IOException, URISyntaxException {
        BeanRegistry beanRegistry = ((BeanRegistryBuildService)this.beanRegistryBuildService.get()).getBeanRegistry();
        TaskLoggerInitializer.initAdapter((Task)this, (Boolean)this.verboseModeEnabled.get(), beanRegistry.getBean(GradleLoggerAdapter.class), beanRegistry.getBean(GradleSettings.class));
        Credentials distributionServerCredentials = (Credentials)this.nodeDistributionServerUsername.map(username -> Credentials.builder().username((String)this.nodeDistributionServerUsername.get()).password((String)this.nodeDistributionServerPassword.get()).build()).getOrNull();
        Credentials httpProxyCredentials = (Credentials)this.httpProxyUsername.map(username -> Credentials.builder().username((String)username).password((String)this.httpProxyPassword.get()).build()).getOrNull();
        Credentials httpsProxyCredentials = (Credentials)this.httpsProxyUsername.map(username -> Credentials.builder().username((String)username).password((String)this.httpsProxyPassword.get()).build()).getOrNull();
        Platform platform = Platform.builder().jvmArch((String)this.systemJvmArch.get()).osName((String)this.systemOsName.get()).build();
        this.getLogger().debug("Platform: {}", (Object)platform);
        ProxySettings proxySettings = beanRegistry.getBean(ResolveProxySettingsByUrl.class).execute(ResolveProxySettingsByUrlCommand.builder().httpsProxyHost((String)this.httpsProxyHost.getOrNull()).httpsProxyPort((Integer)this.httpsProxyPort.get()).httpsProxyCredentials(httpsProxyCredentials).httpProxyHost((String)this.httpProxyHost.getOrNull()).httpProxyPort((Integer)this.httpProxyPort.get()).httpProxyCredentials(httpProxyCredentials).resourceUrl(URI.create((String)this.nodeDistributionUrlRoot.get()).toURL()).systemHttpProxyHost((String)this.systemHttpProxyHost.getOrNull()).systemHttpProxyPort((Integer)this.systemHttpProxyPort.get()).systemHttpsProxyHost((String)this.systemHttpsProxyHost.getOrNull()).systemHttpsProxyPort((Integer)this.systemHttpsProxyPort.get()).systemNonProxyHosts((Set)this.systemNonProxyHosts.get()).build());
        beanRegistry.getBean(InstallNodeDistribution.class).execute(InstallNodeDistributionCommand.builder().platform(platform).version((String)this.nodeVersion.get()).distributionUrlRoot((String)this.nodeDistributionUrlRoot.get()).distributionUrlPathPattern((String)this.nodeDistributionUrlPathPattern.get()).distributionServerCredentials(distributionServerCredentials).proxySettings(proxySettings).retrySettings(RetrySettings.builder().maxDownloadAttempts((Integer)this.maxDownloadAttempts.get()).retryHttpStatuses((Set)this.retryHttpStatuses.get()).retryInitialIntervalMs((Integer)this.retryInitialIntervalMs.get()).retryIntervalMultiplier((Double)this.retryIntervalMultiplier.get()).retryMaxIntervalMs((Integer)this.retryMaxIntervalMs.get()).build()).temporaryDirectoryPath(this.getTemporaryDir().toPath()).installDirectoryPath((Path)this.nodeInstallDirectory.map(File::toPath).get()).build());
    }
}

