/*
 * Decompiled with CFR 0.152.
 */
package org.siouan.frontendgradleplugin.infrastructure.gradle;

import java.io.File;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.gradle.api.Action;
import org.gradle.process.ExecSpec;
import org.siouan.frontendgradleplugin.domain.ExecutionSettings;

public class ExecSpecAction
implements Action<ExecSpec> {
    public static final String PATH_VARIABLE_NAME = "PATH";
    private final ExecutionSettings executionSettings;
    private final Consumer<ExecSpec> afterConfiguredConsumer;

    public void execute(ExecSpec execSpec) {
        execSpec.setWorkingDir((Object)this.executionSettings.getWorkingDirectoryPath().toString());
        execSpec.setExecutable(this.executionSettings.getExecutablePath().toString());
        execSpec.setArgs(this.executionSettings.getArguments());
        HashMap<String, String> userEnvironmentVariables = new HashMap<String, String>(this.executionSettings.getEnvironmentVariables());
        Map currentEnvironmentVariables = execSpec.getEnvironment();
        Optional<Map.Entry> userPathVariable = userEnvironmentVariables.entrySet().stream().filter(entry -> ((String)entry.getKey()).equalsIgnoreCase(PATH_VARIABLE_NAME)).findAny();
        userPathVariable.map(Map.Entry::getKey).ifPresent(userEnvironmentVariables::remove);
        if (!userEnvironmentVariables.isEmpty()) {
            execSpec.environment(userEnvironmentVariables);
        }
        Optional<Map.Entry> systemPathVariable = currentEnvironmentVariables.entrySet().stream().filter(entry -> ((String)entry.getKey()).equalsIgnoreCase(PATH_VARIABLE_NAME)).findAny();
        Optional<String> basePathVariableValue = userPathVariable.map(Map.Entry::getValue).or(() -> systemPathVariable.map(Map.Entry::getValue).map(Objects::toString));
        Stream.Builder pathVariableBuilder = Stream.builder();
        Set<Path> additionalExecutablePaths = this.executionSettings.getAdditionalExecutablePaths();
        if (!additionalExecutablePaths.isEmpty() || basePathVariableValue.isPresent()) {
            additionalExecutablePaths.forEach(additionalExecutablePath -> pathVariableBuilder.accept(additionalExecutablePath.toString()));
            basePathVariableValue.ifPresent(pathVariableBuilder);
            execSpec.environment(PATH_VARIABLE_NAME, (Object)pathVariableBuilder.build().collect(Collectors.joining(File.pathSeparator)));
        }
        this.afterConfiguredConsumer.accept(execSpec);
    }

    @Generated
    ExecSpecAction(ExecutionSettings executionSettings, Consumer<ExecSpec> afterConfiguredConsumer) {
        this.executionSettings = executionSettings;
        this.afterConfiguredConsumer = afterConfiguredConsumer;
    }

    @Generated
    public static ExecSpecActionBuilder builder() {
        return new ExecSpecActionBuilder();
    }

    @Generated
    public ExecutionSettings getExecutionSettings() {
        return this.executionSettings;
    }

    @Generated
    public Consumer<ExecSpec> getAfterConfiguredConsumer() {
        return this.afterConfiguredConsumer;
    }

    @Generated
    public static class ExecSpecActionBuilder {
        @Generated
        private ExecutionSettings executionSettings;
        @Generated
        private Consumer<ExecSpec> afterConfiguredConsumer;

        @Generated
        ExecSpecActionBuilder() {
        }

        @Generated
        public ExecSpecActionBuilder executionSettings(ExecutionSettings executionSettings) {
            this.executionSettings = executionSettings;
            return this;
        }

        @Generated
        public ExecSpecActionBuilder afterConfiguredConsumer(Consumer<ExecSpec> afterConfiguredConsumer) {
            this.afterConfiguredConsumer = afterConfiguredConsumer;
            return this;
        }

        @Generated
        public ExecSpecAction build() {
            return new ExecSpecAction(this.executionSettings, this.afterConfiguredConsumer);
        }

        @Generated
        public String toString() {
            return "ExecSpecAction.ExecSpecActionBuilder(executionSettings=" + this.executionSettings + ", afterConfiguredConsumer=" + this.afterConfiguredConsumer + ")";
        }
    }
}

