/*
 * Decompiled with CFR 0.152.
 */
package org.siouan.frontendgradleplugin.infrastructure.gradle;

import java.io.File;
import java.nio.file.Path;
import java.util.Map;
import org.gradle.api.DefaultTask;
import org.gradle.api.Task;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.TaskAction;
import org.gradle.process.ExecOperations;
import org.siouan.frontendgradleplugin.domain.ExecutableType;
import org.siouan.frontendgradleplugin.domain.Platform;
import org.siouan.frontendgradleplugin.infrastructure.bean.BeanRegistry;
import org.siouan.frontendgradleplugin.infrastructure.bean.BeanRegistryException;
import org.siouan.frontendgradleplugin.infrastructure.gradle.BeanRegistryBuildService;
import org.siouan.frontendgradleplugin.infrastructure.gradle.GradleLoggerAdapter;
import org.siouan.frontendgradleplugin.infrastructure.gradle.GradleScriptRunnerAdapter;
import org.siouan.frontendgradleplugin.infrastructure.gradle.GradleSettings;
import org.siouan.frontendgradleplugin.infrastructure.gradle.NonRunnableTaskException;
import org.siouan.frontendgradleplugin.infrastructure.gradle.ScriptProperties;
import org.siouan.frontendgradleplugin.infrastructure.gradle.TaskLoggerInitializer;

public abstract class AbstractRunCommandTask
extends DefaultTask {
    protected final ExecOperations execOperations;
    protected final Property<BeanRegistryBuildService> beanRegistryBuildService;
    protected final Property<File> packageJsonDirectory;
    protected final Property<File> nodeInstallDirectory;
    protected final Property<ExecutableType> executableType;
    protected final Property<String> executableArgs;
    protected final Property<Boolean> verboseModeEnabled;
    protected final Property<String> systemJvmArch;
    protected final Property<String> systemOsName;
    protected final MapProperty<String, String> environmentVariables;

    AbstractRunCommandTask(ObjectFactory objectFactory, ExecOperations execOperations) {
        this.execOperations = execOperations;
        this.beanRegistryBuildService = objectFactory.property(BeanRegistryBuildService.class);
        this.packageJsonDirectory = objectFactory.property(File.class);
        this.nodeInstallDirectory = objectFactory.property(File.class);
        this.executableType = objectFactory.property(ExecutableType.class);
        this.executableArgs = objectFactory.property(String.class);
        this.verboseModeEnabled = objectFactory.property(Boolean.class);
        this.systemJvmArch = objectFactory.property(String.class);
        this.systemOsName = objectFactory.property(String.class);
        this.environmentVariables = objectFactory.mapProperty(String.class, String.class);
    }

    @Internal
    public Property<BeanRegistryBuildService> getBeanRegistryBuildService() {
        return this.beanRegistryBuildService;
    }

    @Internal
    public Property<ExecutableType> getExecutableType() {
        return this.executableType;
    }

    @Internal
    public Property<Boolean> getVerboseModeEnabled() {
        return this.verboseModeEnabled;
    }

    @Internal
    public Property<String> getSystemJvmArch() {
        return this.systemJvmArch;
    }

    @Internal
    public Property<String> getSystemOsName() {
        return this.systemOsName;
    }

    @Internal
    public MapProperty<String, String> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    @Input
    public Property<File> getPackageJsonDirectory() {
        return this.packageJsonDirectory;
    }

    @Input
    public Property<File> getNodeInstallDirectory() {
        return this.nodeInstallDirectory;
    }

    protected void assertThatTaskIsRunnable() throws NonRunnableTaskException {
        if (!this.executableArgs.isPresent()) {
            throw new NonRunnableTaskException("No arguments provided");
        }
    }

    @TaskAction
    public void execute() throws NonRunnableTaskException, BeanRegistryException {
        this.assertThatTaskIsRunnable();
        BeanRegistry beanRegistry = ((BeanRegistryBuildService)this.beanRegistryBuildService.get()).getBeanRegistry();
        TaskLoggerInitializer.initAdapter((Task)this, (Boolean)this.verboseModeEnabled.get(), beanRegistry.getBean(GradleLoggerAdapter.class), beanRegistry.getBean(GradleSettings.class));
        Platform platform = Platform.builder().jvmArch((String)this.systemJvmArch.get()).osName((String)this.systemOsName.get()).build();
        this.getLogger().debug("Platform: {}", (Object)platform);
        beanRegistry.getBean(GradleScriptRunnerAdapter.class).execute(ScriptProperties.builder().execOperations(this.execOperations).packageJsonDirectoryPath((Path)this.packageJsonDirectory.map(File::toPath).get()).executableType((ExecutableType)((Object)this.executableType.get())).nodeInstallDirectoryPath((Path)this.nodeInstallDirectory.map(File::toPath).get()).executableArgs((String)this.executableArgs.get()).platform(platform).environmentVariables((Map)this.environmentVariables.getOrElse(Map.of())).build());
    }
}

