/*
 * Decompiled with CFR 0.152.
 */
package org.siouan.frontendgradleplugin.infrastructure.bean;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import lombok.Generated;
import org.siouan.frontendgradleplugin.infrastructure.bean.BeanInstanciationException;
import org.siouan.frontendgradleplugin.infrastructure.bean.TooManyCandidateBeansException;
import org.siouan.frontendgradleplugin.infrastructure.bean.ZeroOrMultiplePublicConstructorsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanRegistry
implements Serializable {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(BeanRegistry.class);
    private static final long serialVersionUID = 8882478289468756368L;
    private final Set<Class<?>> registeredBeanTypes = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Map<Class<?>, Object> singletons = new ConcurrentHashMap();

    public BeanRegistry() {
        this.init();
    }

    public void clear() {
        this.registeredBeanTypes.clear();
        this.singletons.clear();
    }

    public void init() {
        this.clear();
        this.registerBean(BeanRegistry.class, this);
    }

    public <T> T getBean(Class<T> beanClass) throws BeanInstanciationException, TooManyCandidateBeansException, ZeroOrMultiplePublicConstructorsException {
        LOGGER.debug("Requesting: {}", (Object)beanClass.getSimpleName());
        return this.getBean(beanClass, 0);
    }

    private <T> T getBean(Class<T> beanClass, int nestedLevel) throws BeanInstanciationException, TooManyCandidateBeansException, ZeroOrMultiplePublicConstructorsException {
        String logEnteringPrefix = "  ".repeat(nestedLevel + 1);
        Object existingBean = this.singletons.get(beanClass);
        if (existingBean != null) {
            LOGGER.debug("{}< Found: {}", (Object)logEnteringPrefix, (Object)beanClass.getSimpleName());
            return (T)existingBean;
        }
        Class assignableClass = this.getAssignableClass(beanClass);
        if (assignableClass != null) {
            return (T)this.getBean(assignableClass, nestedLevel);
        }
        LOGGER.debug("{}+ Instantiating: {}", (Object)logEnteringPrefix, (Object)beanClass.getSimpleName());
        this.assertBeanClassIsInstanciable(beanClass);
        T newBean = this.createInstance(beanClass, nestedLevel);
        this.registerBean(beanClass, newBean);
        return newBean;
    }

    public <T> void registerBeanClass(Class<T> beanClass) {
        LOGGER.debug("Registering class: {}", (Object)beanClass.getSimpleName());
        if (this.isBeanClassRegistered(beanClass)) {
            return;
        }
        this.assertBeanClassIsInstanciable(beanClass);
        this.registerBean(beanClass, null);
    }

    public <T> void registerBean(T bean) {
        Class<?> beanClass = bean.getClass();
        LOGGER.debug("Registering bean: {}", (Object)beanClass.getSimpleName());
        if (this.isBeanClassRegistered(beanClass)) {
            return;
        }
        this.registerBean(beanClass, bean);
    }

    private <T> void registerBean(Class<T> beanClass, T bean) {
        this.registeredBeanTypes.add(beanClass);
        if (bean != null) {
            this.singletons.put(beanClass, bean);
        }
    }

    private <T> boolean isBeanClassRegistered(Class<T> beanClass) {
        return this.getClass().isAssignableFrom(beanClass) || this.registeredBeanTypes.contains(beanClass);
    }

    private void assertBeanClassIsInstanciable(Class<?> beanClass) {
        if (beanClass.isInterface() || beanClass.isEnum() || (beanClass.getModifiers() & 0x400) != 0) {
            throw new IllegalArgumentException("An interface, an enumeration, or an abstract class can not be registered or instanciated: " + beanClass.getName());
        }
    }

    private <T, C extends T> Class<C> getAssignableClass(Class<T> beanClass) throws TooManyCandidateBeansException {
        Set assignableBeanClasses = this.registeredBeanTypes.stream().filter(clazz -> !clazz.equals(beanClass)).filter(beanClass::isAssignableFrom).map(clazz -> clazz).collect(Collectors.toSet());
        if (assignableBeanClasses.isEmpty()) {
            return null;
        }
        if (assignableBeanClasses.size() > 1) {
            throw new TooManyCandidateBeansException(beanClass, assignableBeanClasses);
        }
        return (Class)assignableBeanClasses.iterator().next();
    }

    private <T> T createInstance(Class<T> beanClass, int nestedLevel) throws BeanInstanciationException, ZeroOrMultiplePublicConstructorsException, TooManyCandidateBeansException {
        Constructor<?>[] constructors = beanClass.getConstructors();
        if (constructors.length != 1) {
            throw new ZeroOrMultiplePublicConstructorsException(beanClass);
        }
        Class<?>[] parameterTypes = constructors[0].getParameterTypes();
        Object[] parameters = new Object[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            parameters[i] = this.getBean(parameterTypes[i], nestedLevel + 1);
        }
        try {
            return (T)beanClass.getConstructors()[0].newInstance(parameters);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new BeanInstanciationException(beanClass, (Throwable)e);
        }
    }

    public String toString() {
        return BeanRegistry.class.getName() + " {\nregisteredBeanTypes=" + Arrays.toString(this.registeredBeanTypes.stream().map(Class::getSimpleName).toArray()) + ", singletons=" + Arrays.toString(this.singletons.keySet().stream().map(Class::getSimpleName).toArray()) + "}";
    }
}

