/*
 * Decompiled with CFR 0.152.
 */
package org.siouan.frontendgradleplugin.infrastructure.archiver;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.util.Optional;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.siouan.frontendgradleplugin.domain.FileManager;
import org.siouan.frontendgradleplugin.domain.installer.archiver.AbstractArchiver;
import org.siouan.frontendgradleplugin.domain.installer.archiver.ExplodeCommand;
import org.siouan.frontendgradleplugin.infrastructure.archiver.ZipArchiverContext;
import org.siouan.frontendgradleplugin.infrastructure.archiver.ZipEntry;

public class ZipArchiver
extends AbstractArchiver<ZipArchiverContext, ZipEntry> {
    private static final long serialVersionUID = -6879163434284590850L;

    public ZipArchiver(FileManager fileManager) {
        super(fileManager);
    }

    @Override
    protected ZipArchiverContext initializeContext(ExplodeCommand explodeCommand) throws IOException {
        return new ZipArchiverContext(explodeCommand, ((ZipFile.Builder)ZipFile.builder().setFile(explodeCommand.getArchiveFilePath().toFile())).get());
    }

    @Override
    protected Optional<ZipEntry> getNextEntry(ZipArchiverContext context) {
        return Optional.ofNullable(context.getEntries().hasMoreElements() ? context.getEntries().nextElement() : null).map(ZipEntry::new);
    }

    @Override
    protected String getSymbolicLinkTarget(ZipArchiverContext context, ZipEntry entry) throws IOException {
        return this.readSymbolicLinkTarget(context.getZipFile(), entry.lowLevelEntry());
    }

    @Override
    protected void writeRegularFile(ZipArchiverContext context, ZipEntry entry, Path filePath) throws IOException {
        try (InputStream entryInputStream = context.getZipFile().getInputStream(entry.lowLevelEntry());){
            this.fileManager.copy(entryInputStream, filePath);
        }
    }

    String readSymbolicLinkTarget(ZipFile zipFile, ZipArchiveEntry entry) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(zipFile.getInputStream(entry)));){
            String string = reader.readLine();
            return string;
        }
    }
}

