/*
 * Decompiled with CFR 0.152.
 */
package org.siouan.frontendgradleplugin.domain.installer;

import io.github.resilience4j.core.IntervalFunction;
import io.github.resilience4j.retry.Retry;
import io.github.resilience4j.retry.RetryConfig;
import io.github.resilience4j.retry.event.RetryEvent;
import java.io.IOException;
import java.net.Proxy;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import lombok.Generated;
import org.siouan.frontendgradleplugin.domain.ChannelProvider;
import org.siouan.frontendgradleplugin.domain.FileManager;
import org.siouan.frontendgradleplugin.domain.Logger;
import org.siouan.frontendgradleplugin.domain.installer.DownloadResourceCommand;
import org.siouan.frontendgradleplugin.domain.installer.HttpClient;
import org.siouan.frontendgradleplugin.domain.installer.HttpClientProvider;
import org.siouan.frontendgradleplugin.domain.installer.HttpResponse;
import org.siouan.frontendgradleplugin.domain.installer.ProxySettings;
import org.siouan.frontendgradleplugin.domain.installer.ResourceDownloadException;
import org.siouan.frontendgradleplugin.domain.installer.RetrySettings;
import org.siouan.frontendgradleplugin.domain.installer.RetryableResourceDownloadException;

public class DownloadResource {
    private static final String RETRY_ID = DownloadResource.class.getSimpleName();
    private final FileManager fileManager;
    private final ChannelProvider channelProvider;
    private final HttpClientProvider httpClientProvider;
    private final Logger logger;

    public void execute(DownloadResourceCommand command) throws IOException, ResourceDownloadException {
        RetrySettings retrySettings = command.getRetrySettings();
        RetryConfig retryConfig = RetryConfig.custom().maxAttempts(retrySettings.getMaxDownloadAttempts()).intervalFunction(IntervalFunction.ofExponentialBackoff((long)retrySettings.getRetryInitialIntervalMs(), (double)retrySettings.getRetryIntervalMultiplier(), (long)retrySettings.getRetryMaxIntervalMs())).retryExceptions(new Class[]{RetryableResourceDownloadException.class}).build();
        Retry retry = Retry.of((String)RETRY_ID, (RetryConfig)retryConfig);
        retry.getEventPublisher().onRetry(event -> this.logAttemptFailure(retrySettings, (RetryEvent)event)).onError(event -> this.logAttemptFailure(retrySettings, (RetryEvent)event));
        try {
            Retry.decorateCheckedRunnable((Retry)retry, () -> this.attemptDownload(command)).run();
        }
        catch (Throwable e) {
            this.logger.debug("All download attempts failed", e);
            throw (ResourceDownloadException)e;
        }
        this.fileManager.move(command.getTemporaryFilePath(), command.getDestinationFilePath(), StandardCopyOption.REPLACE_EXISTING);
    }

    private void attemptDownload(DownloadResourceCommand command) throws ResourceDownloadException {
        block25: {
            ProxySettings proxySettings = command.getProxySettings();
            if (proxySettings.getProxyType() == Proxy.Type.DIRECT) {
                this.logger.info("Downloading resource at '{}' (proxy: DIRECT)", command.getResourceUrl());
            } else {
                this.logger.info("Downloading resource at '{}' (proxy: {}/{}:{})", new Object[]{command.getResourceUrl(), proxySettings.getProxyType(), proxySettings.getProxyHost(), proxySettings.getProxyPort()});
            }
            HttpClient httpClient = this.httpClientProvider.getInstance();
            try (HttpResponse response = httpClient.sendGetRequest(command.getResourceUrl(), command.getServerCredentials(), command.getProxySettings());
                 ReadableByteChannel resourceInputChannel = this.channelProvider.getReadableByteChannel(response.getInputStream());
                 FileChannel resourceOutputChannel = this.channelProvider.getWritableFileChannelForNewFile(command.getTemporaryFilePath(), StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
                int statusCode = response.getStatusCode();
                this.logger.debug("---> {}/{} {} {}", response.getProtocol(), response.getVersion(), statusCode, response.getReasonPhrase());
                if (statusCode == 200) {
                    resourceOutputChannel.transferFrom(resourceInputChannel, 0L, Long.MAX_VALUE);
                    break block25;
                }
                String errorMessage = "Unexpected HTTP response: " + response.getProtocol() + "/" + response.getVersion() + " " + statusCode + " " + response.getReasonPhrase();
                if (command.getRetrySettings().getRetryHttpStatuses().contains(statusCode)) {
                    throw new RetryableResourceDownloadException(errorMessage);
                }
                throw new ResourceDownloadException(errorMessage);
            }
            catch (ResourceDownloadException e) {
                this.deleteTemporaryFileOrWarn(command.getTemporaryFilePath());
                throw e;
            }
            catch (IOException e) {
                this.deleteTemporaryFileOrWarn(command.getTemporaryFilePath());
                throw new RetryableResourceDownloadException(e);
            }
        }
    }

    private void logAttemptFailure(RetrySettings retrySettings, RetryEvent retryEvent) {
        int maxDownloadAttempts = retrySettings.getMaxDownloadAttempts();
        if (maxDownloadAttempts > 1) {
            this.logger.info("Attempt {} of {}: {}", retryEvent.getNumberOfRetryAttempts(), maxDownloadAttempts, retryEvent.getLastThrowable().getMessage());
        }
    }

    public void deleteTemporaryFileOrWarn(Path temporaryFilePath) {
        try {
            this.fileManager.deleteIfExists(temporaryFilePath);
        }
        catch (IOException e) {
            this.logger.warn("Unexpected error while deleting file after error: {}", temporaryFilePath);
        }
    }

    @Generated
    public DownloadResource(FileManager fileManager, ChannelProvider channelProvider, HttpClientProvider httpClientProvider, Logger logger) {
        this.fileManager = fileManager;
        this.channelProvider = channelProvider;
        this.httpClientProvider = httpClientProvider;
        this.logger = logger;
    }
}

