/*
 * Decompiled with CFR 0.152.
 */
package org.siouan.frontendgradleplugin.domain;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.StandardOpenOption;
import lombok.Generated;
import org.siouan.frontendgradleplugin.domain.FileManager;
import org.siouan.frontendgradleplugin.domain.GetExecutablePath;
import org.siouan.frontendgradleplugin.domain.GetExecutablePathCommand;
import org.siouan.frontendgradleplugin.domain.InvalidJsonFileException;
import org.siouan.frontendgradleplugin.domain.MalformedPackageManagerSpecification;
import org.siouan.frontendgradleplugin.domain.PackageManager;
import org.siouan.frontendgradleplugin.domain.ParsePackageManagerFromPackageJsonFile;
import org.siouan.frontendgradleplugin.domain.ResolvePackageManagerCommand;
import org.siouan.frontendgradleplugin.domain.UnsupportedPackageManagerException;

public class ResolvePackageManager {
    private final FileManager fileManager;
    private final GetExecutablePath getExecutablePath;
    private final ParsePackageManagerFromPackageJsonFile parsePackageManagerFromPackageJsonFile;

    public void execute(ResolvePackageManagerCommand command) throws InvalidJsonFileException, UnsupportedPackageManagerException, IOException, MalformedPackageManagerSpecification {
        if (command.packageJsonFilePath() == null) {
            this.fileManager.deleteIfExists(command.packageManagerSpecificationFilePath());
            this.fileManager.deleteIfExists(command.packageManagerExecutablePathFilePath());
        } else {
            PackageManager packageManager = this.parsePackageManagerFromPackageJsonFile.execute(command.packageJsonFilePath());
            this.fileManager.writeString(command.packageManagerSpecificationFilePath(), packageManager.type().getPackageManagerName() + "@" + packageManager.version(), StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            this.fileManager.writeString(command.packageManagerExecutablePathFilePath(), this.getExecutablePath.execute(GetExecutablePathCommand.builder().executableType(packageManager.type().getExecutableType()).nodeInstallDirectoryPath(command.nodeInstallDirectoryPath()).platform(command.platform()).build()).toString(), StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
    }

    @Generated
    public ResolvePackageManager(FileManager fileManager, GetExecutablePath getExecutablePath, ParsePackageManagerFromPackageJsonFile parsePackageManagerFromPackageJsonFile) {
        this.fileManager = fileManager;
        this.getExecutablePath = getExecutablePath;
        this.parsePackageManagerFromPackageJsonFile = parsePackageManagerFromPackageJsonFile;
    }
}

