/*
 * Decompiled with CFR 0.152.
 */
package org.siouan.frontendgradleplugin.domain;

import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;

public class Platform {
    private static final Set<String> SUPPORTED_AIX_OS_IDS = Set.of("aix");
    private static final Set<String> SUPPORTED_JVM_ARM_32_BITS_ARCH_IDS = Set.of("arm");
    private static final Set<String> SUPPORTED_JVM_ARM_64_BITS_ARCH_IDS = Set.of("aarch64");
    private static final Set<String> SUPPORTED_JVM_PPC_64_BITS_LE_ARCH_IDS = Set.of("ppc64le");
    private static final Set<String> SUPPORTED_JVM_S390X_64_BITS_ARCH_IDS = Set.of("s390x");
    private static final Set<String> SUPPORTED_JVM_64_BITS_ARCH_IDS = Stream.of(Stream.of("x64", "x86_64", "amd64", "ppc64", "sparc"), SUPPORTED_JVM_ARM_64_BITS_ARCH_IDS.stream(), SUPPORTED_JVM_PPC_64_BITS_LE_ARCH_IDS.stream(), SUPPORTED_JVM_S390X_64_BITS_ARCH_IDS.stream()).flatMap(Function.identity()).collect(Collectors.toUnmodifiableSet());
    private static final Set<String> SUPPORTED_LINUX_OS_IDS = Set.of("linux");
    private static final Set<String> SUPPORTED_MAC_OS_IDS = Set.of("mac os");
    private static final Set<String> SUPPORTED_WINDOWS_OS_IDS = Set.of("windows");
    private final String jvmArch;
    private final String osName;

    public boolean is64BitsArch() {
        return this.matchesAnyIdPart(this.jvmArch, SUPPORTED_JVM_64_BITS_ARCH_IDS);
    }

    public boolean isArm64BitsArch() {
        return this.matchesAnyIdPart(this.jvmArch, SUPPORTED_JVM_ARM_64_BITS_ARCH_IDS);
    }

    public boolean isArm32BitsArch() {
        return this.matchesAnyIdPart(this.jvmArch, SUPPORTED_JVM_ARM_32_BITS_ARCH_IDS);
    }

    public boolean isPpc64BitsLeArch() {
        return this.matchesAnyIdPart(this.jvmArch, SUPPORTED_JVM_PPC_64_BITS_LE_ARCH_IDS);
    }

    public boolean isS390X64BitsArch() {
        return this.matchesAnyIdPart(this.jvmArch, SUPPORTED_JVM_S390X_64_BITS_ARCH_IDS);
    }

    public boolean isAixOs() {
        return this.matchesAnyIdPart(this.osName, SUPPORTED_AIX_OS_IDS);
    }

    public boolean isLinuxOs() {
        return this.matchesAnyIdPart(this.osName, SUPPORTED_LINUX_OS_IDS);
    }

    public boolean isMacOs() {
        return this.matchesAnyIdPart(this.osName, SUPPORTED_MAC_OS_IDS);
    }

    public boolean isWindowsOs() {
        return this.matchesAnyIdPart(this.osName, SUPPORTED_WINDOWS_OS_IDS);
    }

    private boolean matchesAnyIdPart(String id, Set<String> parts) {
        String lowerCaseId = id.toLowerCase();
        return parts.stream().anyMatch(lowerCaseId::contains);
    }

    @Generated
    Platform(String jvmArch, String osName) {
        this.jvmArch = jvmArch;
        this.osName = osName;
    }

    @Generated
    public static PlatformBuilder builder() {
        return new PlatformBuilder();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Platform)) {
            return false;
        }
        Platform other = (Platform)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$jvmArch = this.jvmArch;
        String other$jvmArch = other.jvmArch;
        if (this$jvmArch == null ? other$jvmArch != null : !this$jvmArch.equals(other$jvmArch)) {
            return false;
        }
        String this$osName = this.osName;
        String other$osName = other.osName;
        return !(this$osName == null ? other$osName != null : !this$osName.equals(other$osName));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Platform;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $jvmArch = this.jvmArch;
        result = result * 59 + ($jvmArch == null ? 43 : $jvmArch.hashCode());
        String $osName = this.osName;
        result = result * 59 + ($osName == null ? 43 : $osName.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Platform(jvmArch=" + this.jvmArch + ", osName=" + this.osName + ")";
    }

    @Generated
    public static class PlatformBuilder {
        @Generated
        private String jvmArch;
        @Generated
        private String osName;

        @Generated
        PlatformBuilder() {
        }

        @Generated
        public PlatformBuilder jvmArch(String jvmArch) {
            this.jvmArch = jvmArch;
            return this;
        }

        @Generated
        public PlatformBuilder osName(String osName) {
            this.osName = osName;
            return this;
        }

        @Generated
        public Platform build() {
            return new Platform(this.jvmArch, this.osName);
        }

        @Generated
        public String toString() {
            return "Platform.PlatformBuilder(jvmArch=" + this.jvmArch + ", osName=" + this.osName + ")";
        }
    }
}

