/*
 * Decompiled with CFR 0.152.
 */
package org.siouan.frontendgradleplugin.domain;

import java.nio.file.Path;
import lombok.Generated;
import org.siouan.frontendgradleplugin.domain.Logger;
import org.siouan.frontendgradleplugin.domain.ResolveExecutablePathCommand;

public abstract class AbstractResolveExecutablePath {
    private final Logger logger;

    public Path execute(ResolveExecutablePathCommand command) {
        Path relativeExecutablePath = command.getPlatform().isWindowsOs() ? this.getWindowsRelativeExecutablePath() : this.getNonWindowsRelativeExecutablePath();
        Path executablePath = command.getNodeInstallDirectoryPath().resolve(relativeExecutablePath);
        this.logger.debug("Resolved executable path: '{}'", executablePath);
        return executablePath;
    }

    protected abstract Path getWindowsRelativeExecutablePath();

    protected abstract Path getNonWindowsRelativeExecutablePath();

    protected abstract String getWindowsExecutableFileName();

    protected abstract String getNonWindowsExecutableFileName();

    @Generated
    protected AbstractResolveExecutablePath(Logger logger) {
        this.logger = logger;
    }
}

