/*
 * Decompiled with CFR 0.152.
 */
package org.siouan.frontendgradleplugin;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Set;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.RegularFile;
import org.gradle.api.plugins.BasePlugin;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.publish.plugins.PublishingPlugin;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.siouan.frontendgradleplugin.domain.ExecutableType;
import org.siouan.frontendgradleplugin.domain.FileManager;
import org.siouan.frontendgradleplugin.domain.MalformedPackageManagerSpecification;
import org.siouan.frontendgradleplugin.domain.ParsePackageManagerSpecification;
import org.siouan.frontendgradleplugin.domain.Platform;
import org.siouan.frontendgradleplugin.domain.ResolveExecutablePathCommand;
import org.siouan.frontendgradleplugin.domain.ResolveNodeExecutablePath;
import org.siouan.frontendgradleplugin.domain.SystemProperties;
import org.siouan.frontendgradleplugin.domain.UnsupportedPackageManagerException;
import org.siouan.frontendgradleplugin.infrastructure.archiver.ArchiverProviderImpl;
import org.siouan.frontendgradleplugin.infrastructure.bean.BeanInstanciationException;
import org.siouan.frontendgradleplugin.infrastructure.bean.BeanRegistry;
import org.siouan.frontendgradleplugin.infrastructure.bean.TooManyCandidateBeansException;
import org.siouan.frontendgradleplugin.infrastructure.bean.ZeroOrMultiplePublicConstructorsException;
import org.siouan.frontendgradleplugin.infrastructure.gradle.AssembleTask;
import org.siouan.frontendgradleplugin.infrastructure.gradle.BeanRegistryBuildService;
import org.siouan.frontendgradleplugin.infrastructure.gradle.CheckTask;
import org.siouan.frontendgradleplugin.infrastructure.gradle.FrontendExtension;
import org.siouan.frontendgradleplugin.infrastructure.gradle.GradleLoggerAdapter;
import org.siouan.frontendgradleplugin.infrastructure.gradle.GradleSettings;
import org.siouan.frontendgradleplugin.infrastructure.gradle.InstallCorepackTask;
import org.siouan.frontendgradleplugin.infrastructure.gradle.InstallFrontendTask;
import org.siouan.frontendgradleplugin.infrastructure.gradle.InstallNodeTask;
import org.siouan.frontendgradleplugin.infrastructure.gradle.InstallPackageManagerTask;
import org.siouan.frontendgradleplugin.infrastructure.gradle.PublishTask;
import org.siouan.frontendgradleplugin.infrastructure.gradle.ResolvePackageManagerTask;
import org.siouan.frontendgradleplugin.infrastructure.gradle.RunCorepackTask;
import org.siouan.frontendgradleplugin.infrastructure.gradle.RunNodeTask;
import org.siouan.frontendgradleplugin.infrastructure.gradle.RunNpmTask;
import org.siouan.frontendgradleplugin.infrastructure.gradle.RunPnpmTask;
import org.siouan.frontendgradleplugin.infrastructure.gradle.RunYarnTask;
import org.siouan.frontendgradleplugin.infrastructure.gradle.SystemProviders;
import org.siouan.frontendgradleplugin.infrastructure.httpclient.HttpClientProviderImpl;
import org.siouan.frontendgradleplugin.infrastructure.system.ChannelProviderImpl;
import org.siouan.frontendgradleplugin.infrastructure.system.FileManagerImpl;

public class FrontendGradlePlugin
implements Plugin<Project> {
    public static final String ASSEMBLE_TASK_NAME = "assembleFrontend";
    public static final String CHECK_TASK_NAME = "checkFrontend";
    public static final String PUBLISH_TASK_NAME = "publishFrontend";
    public static final String DEFAULT_CACHE_DIRECTORY_NAME = ".frontend-gradle-plugin";
    public static final int DEFAULT_HTTP_PROXY_PORT = 80;
    public static final int DEFAULT_HTTPS_PROXY_PORT = 443;
    public static final String DEFAULT_INSTALL_SCRIPT = "install";
    public static final int DEFAULT_MAX_DOWNLOAD_ATTEMPTS = 1;
    public static final String DEFAULT_NODE_INSTALL_DIRECTORY_NAME = "node";
    public static final String DEFAULT_NODE_DISTRIBUTION_URL_PATH_PATTERN = "vVERSION/node-vVERSION-ARCH.TYPE";
    public static final String DEFAULT_NODE_DISTRIBUTION_URL_ROOT = "https://nodejs.org/dist/";
    public static final Set<Integer> DEFAULT_RETRY_HTTP_STATUSES = Set.of(Integer.valueOf(408), Integer.valueOf(429), Integer.valueOf(500), Integer.valueOf(502), Integer.valueOf(503), Integer.valueOf(504));
    public static final int DEFAULT_RETRY_INITIAL_INTERVAL_MS = 1000;
    public static final double DEFAULT_RETRY_INTERVAL_MULTIPLIER = 2.0;
    public static final int DEFAULT_RETRY_MAX_INTERVAL_MS = 30000;
    private static final String EXTENSION_NAME = "frontend";
    public static final String GRADLE_ASSEMBLE_TASK_NAME = "assemble";
    public static final String GRADLE_CHECK_TASK_NAME = "check";
    public static final String GRADLE_PUBLISH_TASK_NAME = "publish";
    public static final String INSTALL_COREPACK_TASK_NAME = "installCorepack";
    public static final String INSTALL_FRONTEND_TASK_NAME = "installFrontend";
    public static final String INSTALL_NODE_TASK_NAME = "installNode";
    public static final String INSTALL_PACKAGE_MANAGER_TASK_NAME = "installPackageManager";
    public static final String PACKAGE_JSON_FILE_NAME = "package.json";
    public static final String PACKAGE_MANAGER_SPECIFICATION_FILE_NAME = "package-manager-specification.txt";
    public static final String PACKAGE_MANAGER_EXECUTABLE_PATH_FILE_NAME = "package-manager-executable-path.txt";
    public static final String RESOLVE_PACKAGE_MANAGER_TASK_NAME = "resolvePackageManager";
    public static final String RUN_COREPACK_TASK_NAME = "runCorepack";
    public static final String RUN_NODE_TASK_NAME = "runNode";
    public static final String RUN_NPM_TASK_NAME = "runNpm";
    public static final String RUN_PNPM_TASK_NAME = "runPnpm";
    public static final String RUN_YARN_TASK_NAME = "runYarn";
    private static final String TASK_GROUP = "Frontend";

    public void apply(Project project) {
        project.getPluginManager().apply(BasePlugin.class);
        project.getPluginManager().apply(PublishingPlugin.class);
        FrontendExtension frontendExtension = (FrontendExtension)project.getExtensions().create(EXTENSION_NAME, FrontendExtension.class, new Object[]{project.getObjects()});
        frontendExtension.getNodeDistributionProvided().convention((Object)false);
        frontendExtension.getNodeDistributionUrlRoot().convention((Object)DEFAULT_NODE_DISTRIBUTION_URL_ROOT);
        frontendExtension.getNodeDistributionUrlPathPattern().convention((Object)DEFAULT_NODE_DISTRIBUTION_URL_PATH_PATTERN);
        frontendExtension.getNodeInstallDirectory().convention(project.getLayout().getProjectDirectory().dir(DEFAULT_NODE_INSTALL_DIRECTORY_NAME));
        frontendExtension.getInstallScript().convention((Object)DEFAULT_INSTALL_SCRIPT);
        frontendExtension.getPackageJsonDirectory().convention(project.getLayout().getProjectDirectory());
        frontendExtension.getHttpProxyPort().convention((Object)80);
        frontendExtension.getHttpsProxyPort().convention((Object)443);
        frontendExtension.getMaxDownloadAttempts().convention((Object)1);
        frontendExtension.getRetryHttpStatuses().convention(DEFAULT_RETRY_HTTP_STATUSES);
        frontendExtension.getRetryInitialIntervalMs().convention((Object)1000);
        frontendExtension.getRetryIntervalMultiplier().convention((Object)2.0);
        frontendExtension.getRetryMaxIntervalMs().convention((Object)30000);
        frontendExtension.getCacheDirectory().convention(project.getLayout().getProjectDirectory().dir(DEFAULT_CACHE_DIRECTORY_NAME));
        frontendExtension.getVerboseModeEnabled().convention((Object)false);
        Provider<BeanRegistryBuildService> beanRegistryBuildServiceProvider = this.configureBeanRegistry(project, Set.of(GradleSettings.ofProject(project), GradleLoggerAdapter.class, FileManagerImpl.class, ChannelProviderImpl.class, ArchiverProviderImpl.class, HttpClientProviderImpl.class));
        this.configureTasks(project, beanRegistryBuildServiceProvider, frontendExtension, new SystemProviders(project.getProviders()));
    }

    protected Provider<BeanRegistryBuildService> configureBeanRegistry(Project project, Set<?> beanClassesOrInstances) {
        BeanRegistry beanRegistry = new BeanRegistry();
        beanClassesOrInstances.forEach(beanClassOrInstance -> {
            if (beanClassOrInstance instanceof Class) {
                Class beanClass = (Class)beanClassOrInstance;
                beanRegistry.registerBeanClass(beanClass);
            } else {
                beanRegistry.registerBean(beanClassOrInstance);
            }
        });
        return project.getGradle().getSharedServices().registerIfAbsent(BeanRegistryBuildService.buildName(project), BeanRegistryBuildService.class, buildServiceSpec -> ((BeanRegistryBuildService.Params)buildServiceSpec.getParameters()).getBeanRegistry().set((Object)beanRegistry));
    }

    protected void configureTasks(Project project, Provider<BeanRegistryBuildService> beanRegistryBuildServiceProvider, FrontendExtension frontendExtension, SystemProviders systemProviders) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.register(INSTALL_NODE_TASK_NAME, InstallNodeTask.class, task -> this.configureInstallNodeTask((InstallNodeTask)((Object)task), beanRegistryBuildServiceProvider, frontendExtension, systemProviders));
        taskContainer.register(INSTALL_COREPACK_TASK_NAME, InstallCorepackTask.class, task -> this.configureInstallCorepackTask((InstallCorepackTask)((Object)task), taskContainer, beanRegistryBuildServiceProvider, frontendExtension, systemProviders));
        taskContainer.register(RESOLVE_PACKAGE_MANAGER_TASK_NAME, ResolvePackageManagerTask.class, task -> this.configureResolvePackageManagerTask((ResolvePackageManagerTask)((Object)task), taskContainer, beanRegistryBuildServiceProvider, frontendExtension, systemProviders));
        taskContainer.register(INSTALL_PACKAGE_MANAGER_TASK_NAME, InstallPackageManagerTask.class, task -> this.configureInstallPackageManagerTask((InstallPackageManagerTask)((Object)task), taskContainer, beanRegistryBuildServiceProvider, frontendExtension, systemProviders));
        taskContainer.register(RUN_NODE_TASK_NAME, RunNodeTask.class, task -> this.configureRunNodeTask((RunNodeTask)((Object)task), taskContainer, beanRegistryBuildServiceProvider, frontendExtension, systemProviders));
        taskContainer.register(RUN_COREPACK_TASK_NAME, RunCorepackTask.class, task -> this.configureRunCorepackTask((RunCorepackTask)((Object)task), taskContainer, beanRegistryBuildServiceProvider, frontendExtension, systemProviders));
        taskContainer.register(RUN_NPM_TASK_NAME, RunNpmTask.class, task -> this.configureRunNpmTask((RunNpmTask)((Object)task), taskContainer, beanRegistryBuildServiceProvider, frontendExtension, systemProviders));
        taskContainer.register(RUN_PNPM_TASK_NAME, RunPnpmTask.class, task -> this.configureRunPnpmTask((RunPnpmTask)((Object)task), taskContainer, beanRegistryBuildServiceProvider, frontendExtension, systemProviders));
        taskContainer.register(RUN_YARN_TASK_NAME, RunYarnTask.class, task -> this.configureRunYarnTask((RunYarnTask)((Object)task), taskContainer, beanRegistryBuildServiceProvider, frontendExtension, systemProviders));
        taskContainer.register(INSTALL_FRONTEND_TASK_NAME, InstallFrontendTask.class, task -> this.configureInstallFrontendTask((InstallFrontendTask)((Object)task), taskContainer, beanRegistryBuildServiceProvider, frontendExtension, systemProviders));
        taskContainer.register(CHECK_TASK_NAME, CheckTask.class, task -> this.configureCheckFrontendTask((CheckTask)((Object)task), taskContainer, beanRegistryBuildServiceProvider, frontendExtension, systemProviders));
        taskContainer.register(ASSEMBLE_TASK_NAME, AssembleTask.class, task -> this.configureAssembleFrontendTask((AssembleTask)((Object)task), taskContainer, beanRegistryBuildServiceProvider, frontendExtension, systemProviders));
        taskContainer.register(PUBLISH_TASK_NAME, PublishTask.class, task -> this.configurePublishFrontendTask((PublishTask)((Object)task), taskContainer, beanRegistryBuildServiceProvider, frontendExtension, systemProviders));
        this.configureDependency(taskContainer, (Task)GRADLE_ASSEMBLE_TASK_NAME, ASSEMBLE_TASK_NAME, (Class)AssembleTask.class);
        this.configureDependency(taskContainer, (Task)GRADLE_CHECK_TASK_NAME, CHECK_TASK_NAME, (Class)CheckTask.class);
        this.configureDependency(taskContainer, (Task)GRADLE_PUBLISH_TASK_NAME, PUBLISH_TASK_NAME, (Class)PublishTask.class);
    }

    protected void configureInstallNodeTask(InstallNodeTask task, Provider<BeanRegistryBuildService> beanRegistryBuildServiceProvider, FrontendExtension frontendExtension, SystemProviders systemProviders) {
        task.setGroup(TASK_GROUP);
        task.setDescription("Downloads and installs a Node.js distribution.");
        task.getBeanRegistryBuildService().set(beanRegistryBuildServiceProvider);
        task.usesService(beanRegistryBuildServiceProvider);
        task.getNodeVersion().set(frontendExtension.getNodeVersion());
        task.getNodeDistributionUrlRoot().set(frontendExtension.getNodeDistributionUrlRoot());
        task.getNodeDistributionUrlPathPattern().set(frontendExtension.getNodeDistributionUrlPathPattern());
        task.getNodeDistributionServerUsername().set(frontendExtension.getNodeDistributionServerUsername());
        task.getNodeDistributionServerPassword().set(frontendExtension.getNodeDistributionServerPassword());
        task.getNodeInstallDirectory().set(frontendExtension.getNodeInstallDirectory().getAsFile());
        task.getHttpProxyHost().set(frontendExtension.getHttpProxyHost());
        task.getHttpProxyPort().set(frontendExtension.getHttpProxyPort());
        task.getHttpProxyUsername().set(frontendExtension.getHttpProxyUsername());
        task.getHttpProxyPassword().set(frontendExtension.getHttpProxyPassword());
        task.getHttpsProxyHost().set(frontendExtension.getHttpsProxyHost());
        task.getHttpsProxyPort().set(frontendExtension.getHttpsProxyPort());
        task.getHttpsProxyUsername().set(frontendExtension.getHttpsProxyUsername());
        task.getHttpsProxyPassword().set(frontendExtension.getHttpsProxyPassword());
        task.getNodeExecutableFile().fileProvider(frontendExtension.getNodeInstallDirectory().flatMap(directory -> beanRegistryBuildServiceProvider.map(beanRegistryBuildService -> {
            BeanRegistry beanRegistry = beanRegistryBuildService.getBeanRegistry();
            return this.getBeanOrFail(beanRegistry, ResolveNodeExecutablePath.class).execute(ResolveExecutablePathCommand.builder().nodeInstallDirectoryPath(directory.getAsFile().toPath()).platform(Platform.builder().jvmArch((String)systemProviders.getJvmArch().get()).osName((String)systemProviders.getOsName().get()).build()).build()).toFile();
        })));
        task.getMaxDownloadAttempts().set(frontendExtension.getMaxDownloadAttempts());
        task.getRetryHttpStatuses().set(frontendExtension.getRetryHttpStatuses());
        task.getRetryInitialIntervalMs().set(frontendExtension.getRetryInitialIntervalMs());
        task.getRetryIntervalMultiplier().set(frontendExtension.getRetryIntervalMultiplier());
        task.getRetryMaxIntervalMs().set(frontendExtension.getRetryMaxIntervalMs());
        task.getVerboseModeEnabled().set(frontendExtension.getVerboseModeEnabled());
        task.getSystemHttpProxyHost().set(systemProviders.getHttpProxyHost());
        task.getSystemHttpProxyPort().set(systemProviders.getHttpProxyPort().filter(port -> !port.isBlank()).map(Integer::parseInt).orElse((Object)80));
        task.getSystemHttpsProxyHost().set(systemProviders.getHttpsProxyHost());
        task.getSystemHttpsProxyPort().set(systemProviders.getHttpsProxyPort().filter(port -> !port.isBlank()).map(Integer::parseInt).orElse((Object)443));
        task.getSystemNonProxyHosts().set(systemProviders.getNonProxyHosts().filter(nonProxyHosts -> !nonProxyHosts.isBlank()).map(nonProxyHosts -> nonProxyHosts.split(SystemProperties.NON_PROXY_HOSTS_SPLIT_PATTERN)).map(Set::of).orElse(Collections.emptySet()));
        this.bindSystemArchPropertiesToTaskInputs(systemProviders, task.getSystemJvmArch(), task.getSystemOsName());
        task.setOnlyIf(t -> (Boolean)frontendExtension.getNodeDistributionProvided().get() == false);
    }

    protected void configureInstallCorepackTask(InstallCorepackTask task, TaskContainer taskContainer, Provider<BeanRegistryBuildService> beanRegistryBuildServiceProvider, FrontendExtension frontendExtension, SystemProviders systemProviders) {
        task.setGroup(TASK_GROUP);
        task.setDescription("Installs a specific version of Corepack, overriding the one provided by default in Node.js distribution.");
        task.getBeanRegistryBuildService().set(beanRegistryBuildServiceProvider);
        task.usesService(beanRegistryBuildServiceProvider);
        task.getPackageJsonDirectory().set(frontendExtension.getPackageJsonDirectory().getAsFile());
        task.getNodeInstallDirectory().set(frontendExtension.getNodeInstallDirectory().getAsFile());
        task.getCorepackVersion().set(frontendExtension.getCorepackVersion());
        task.getVerboseModeEnabled().set(frontendExtension.getVerboseModeEnabled());
        this.bindSystemArchPropertiesToTaskInputs(systemProviders, task.getSystemJvmArch(), task.getSystemOsName());
        task.setOnlyIf(t -> frontendExtension.getCorepackVersion().isPresent());
        this.configureDependency(taskContainer, task, INSTALL_NODE_TASK_NAME, InstallNodeTask.class);
    }

    protected void configureResolvePackageManagerTask(ResolvePackageManagerTask task, TaskContainer taskContainer, Provider<BeanRegistryBuildService> beanRegistryBuildServiceProvider, FrontendExtension frontendExtension, SystemProviders systemProviders) {
        task.setGroup(TASK_GROUP);
        task.setDescription("Resolves the package manager.");
        task.getBeanRegistryBuildService().set(beanRegistryBuildServiceProvider);
        task.usesService(beanRegistryBuildServiceProvider);
        task.getPackageJsonFile().fileProvider(frontendExtension.getPackageJsonDirectory().file(PACKAGE_JSON_FILE_NAME).map(RegularFile::getAsFile).filter(packageJsonFile -> Files.isRegularFile(packageJsonFile.toPath(), new LinkOption[0])));
        task.getNodeInstallDirectory().set(frontendExtension.getNodeInstallDirectory().getAsFile());
        task.getPackageManagerSpecificationFile().set(frontendExtension.getCacheDirectory().dir(RESOLVE_PACKAGE_MANAGER_TASK_NAME).map(directory -> directory.file(PACKAGE_MANAGER_SPECIFICATION_FILE_NAME)));
        task.getPackageManagerExecutablePathFile().set(frontendExtension.getCacheDirectory().dir(RESOLVE_PACKAGE_MANAGER_TASK_NAME).map(directory -> directory.file(PACKAGE_MANAGER_EXECUTABLE_PATH_FILE_NAME)));
        task.getVerboseModeEnabled().set(frontendExtension.getVerboseModeEnabled());
        this.bindSystemArchPropertiesToTaskInputs(systemProviders, task.getSystemJvmArch(), task.getSystemOsName());
        this.configureDependency(taskContainer, task, INSTALL_NODE_TASK_NAME, InstallNodeTask.class);
    }

    protected void configureInstallPackageManagerTask(InstallPackageManagerTask task, TaskContainer taskContainer, Provider<BeanRegistryBuildService> beanRegistryBuildServiceProvider, FrontendExtension frontendExtension, SystemProviders systemProviders) {
        task.setGroup(TASK_GROUP);
        task.setDescription("Installs the package manager.");
        task.getBeanRegistryBuildService().set(beanRegistryBuildServiceProvider);
        task.usesService(beanRegistryBuildServiceProvider);
        task.getPackageJsonDirectory().set(frontendExtension.getPackageJsonDirectory().getAsFile());
        task.getNodeInstallDirectory().set(frontendExtension.getNodeInstallDirectory().getAsFile());
        TaskProvider resolvePackageManagerTaskProvider = taskContainer.named(RESOLVE_PACKAGE_MANAGER_TASK_NAME, ResolvePackageManagerTask.class);
        task.getPackageManagerSpecificationFile().set(resolvePackageManagerTaskProvider.flatMap(ResolvePackageManagerTask::getPackageManagerSpecificationFile));
        task.getPackageManagerExecutableFile().fileProvider(resolvePackageManagerTaskProvider.flatMap(ResolvePackageManagerTask::getPackageManagerExecutablePathFile).map(f -> {
            Path filePath = f.getAsFile().toPath();
            if (!Files.exists(filePath, new LinkOption[0])) {
                return null;
            }
            BeanRegistry beanRegistry = ((BeanRegistryBuildService)beanRegistryBuildServiceProvider.get()).getBeanRegistry();
            try {
                return Paths.get(this.getBeanOrFail(beanRegistry, FileManager.class).readString(filePath, StandardCharsets.UTF_8), new String[0]).toFile();
            }
            catch (IOException e) {
                throw new GradleException("Cannot read path to package manager executable from file: " + filePath, (Throwable)e);
            }
        }));
        task.getVerboseModeEnabled().set(frontendExtension.getVerboseModeEnabled());
        this.bindSystemArchPropertiesToTaskInputs(systemProviders, task.getSystemJvmArch(), task.getSystemOsName());
        task.setOnlyIf(t -> this.packageJsonFileExists(frontendExtension));
        this.configureDependency(taskContainer, task, INSTALL_COREPACK_TASK_NAME, InstallCorepackTask.class);
    }

    protected void configureRunNodeTask(RunNodeTask task, TaskContainer taskContainer, Provider<BeanRegistryBuildService> beanRegistryBuildServiceProvider, FrontendExtension frontendExtension, SystemProviders systemProviders) {
        task.setGroup(TASK_GROUP);
        task.setDescription("Runs a command with node executable.");
        task.getBeanRegistryBuildService().set(beanRegistryBuildServiceProvider);
        task.usesService(beanRegistryBuildServiceProvider);
        task.getPackageJsonDirectory().set(frontendExtension.getPackageJsonDirectory().getAsFile());
        task.getNodeInstallDirectory().set(frontendExtension.getNodeInstallDirectory().getAsFile());
        task.getVerboseModeEnabled().set(frontendExtension.getVerboseModeEnabled());
        this.bindSystemArchPropertiesToTaskInputs(systemProviders, task.getSystemJvmArch(), task.getSystemOsName());
        this.configureDependency(taskContainer, task, INSTALL_NODE_TASK_NAME, InstallNodeTask.class);
    }

    protected void configureRunCorepackTask(RunCorepackTask task, TaskContainer taskContainer, Provider<BeanRegistryBuildService> beanRegistryBuildServiceProvider, FrontendExtension frontendExtension, SystemProviders systemProviders) {
        task.setGroup(TASK_GROUP);
        task.setDescription("Runs a command with corepack executable.");
        task.getBeanRegistryBuildService().set(beanRegistryBuildServiceProvider);
        task.usesService(beanRegistryBuildServiceProvider);
        task.getPackageJsonDirectory().set(frontendExtension.getPackageJsonDirectory().getAsFile());
        task.getNodeInstallDirectory().set(frontendExtension.getNodeInstallDirectory().getAsFile());
        task.getVerboseModeEnabled().set(frontendExtension.getVerboseModeEnabled());
        this.bindSystemArchPropertiesToTaskInputs(systemProviders, task.getSystemJvmArch(), task.getSystemOsName());
        this.configureDependency(taskContainer, task, INSTALL_COREPACK_TASK_NAME, InstallCorepackTask.class);
    }

    protected void configureRunNpmTask(RunNpmTask task, TaskContainer taskContainer, Provider<BeanRegistryBuildService> beanRegistryBuildServiceProvider, FrontendExtension frontendExtension, SystemProviders systemProviders) {
        task.setGroup(TASK_GROUP);
        task.setDescription("Runs a command with npm executable.");
        task.getBeanRegistryBuildService().set(beanRegistryBuildServiceProvider);
        task.usesService(beanRegistryBuildServiceProvider);
        task.getPackageJsonDirectory().set(frontendExtension.getPackageJsonDirectory().getAsFile());
        task.getNodeInstallDirectory().set(frontendExtension.getNodeInstallDirectory().getAsFile());
        task.getVerboseModeEnabled().set(frontendExtension.getVerboseModeEnabled());
        this.bindSystemArchPropertiesToTaskInputs(systemProviders, task.getSystemJvmArch(), task.getSystemOsName());
        this.configureDependency(taskContainer, task, INSTALL_PACKAGE_MANAGER_TASK_NAME, InstallPackageManagerTask.class);
    }

    protected void configureRunPnpmTask(RunPnpmTask task, TaskContainer taskContainer, Provider<BeanRegistryBuildService> beanRegistryBuildServiceProvider, FrontendExtension frontendExtension, SystemProviders systemProviders) {
        task.setGroup(TASK_GROUP);
        task.setDescription("Runs a command with pnpm executable.");
        task.getBeanRegistryBuildService().set(beanRegistryBuildServiceProvider);
        task.usesService(beanRegistryBuildServiceProvider);
        task.getPackageJsonDirectory().set(frontendExtension.getPackageJsonDirectory().getAsFile());
        task.getNodeInstallDirectory().set(frontendExtension.getNodeInstallDirectory().getAsFile());
        task.getVerboseModeEnabled().set(frontendExtension.getVerboseModeEnabled());
        this.bindSystemArchPropertiesToTaskInputs(systemProviders, task.getSystemJvmArch(), task.getSystemOsName());
        this.configureDependency(taskContainer, task, INSTALL_PACKAGE_MANAGER_TASK_NAME, InstallPackageManagerTask.class);
    }

    protected void configureRunYarnTask(RunYarnTask task, TaskContainer taskContainer, Provider<BeanRegistryBuildService> beanRegistryBuildServiceProvider, FrontendExtension frontendExtension, SystemProviders systemProviders) {
        task.setGroup(TASK_GROUP);
        task.setDescription("Runs a command with yarn executable.");
        task.getBeanRegistryBuildService().set(beanRegistryBuildServiceProvider);
        task.usesService(beanRegistryBuildServiceProvider);
        task.getPackageJsonDirectory().set(frontendExtension.getPackageJsonDirectory().getAsFile());
        task.getNodeInstallDirectory().set(frontendExtension.getNodeInstallDirectory().getAsFile());
        task.getVerboseModeEnabled().set(frontendExtension.getVerboseModeEnabled());
        this.bindSystemArchPropertiesToTaskInputs(systemProviders, task.getSystemJvmArch(), task.getSystemOsName());
        this.configureDependency(taskContainer, task, INSTALL_PACKAGE_MANAGER_TASK_NAME, InstallPackageManagerTask.class);
    }

    protected void configureInstallFrontendTask(InstallFrontendTask task, TaskContainer taskContainer, Provider<BeanRegistryBuildService> beanRegistryBuildServiceProvider, FrontendExtension frontendExtension, SystemProviders systemProviders) {
        task.setGroup(TASK_GROUP);
        task.setDescription("Installs frontend dependencies.");
        task.getBeanRegistryBuildService().set(beanRegistryBuildServiceProvider);
        task.usesService(beanRegistryBuildServiceProvider);
        BeanRegistry beanRegistry = ((BeanRegistryBuildService)beanRegistryBuildServiceProvider.get()).getBeanRegistry();
        task.getPackageJsonDirectory().set(frontendExtension.getPackageJsonDirectory().getAsFile());
        task.getNodeInstallDirectory().set(frontendExtension.getNodeInstallDirectory().getAsFile());
        task.getExecutableType().set(this.getExecutableType(taskContainer, beanRegistry));
        task.getInstallScript().set(frontendExtension.getInstallScript());
        task.getVerboseModeEnabled().set(frontendExtension.getVerboseModeEnabled());
        this.bindSystemArchPropertiesToTaskInputs(systemProviders, task.getSystemJvmArch(), task.getSystemOsName());
        task.setOnlyIf(t -> this.packageJsonFileExists(frontendExtension));
        this.configureDependency(taskContainer, task, INSTALL_PACKAGE_MANAGER_TASK_NAME, InstallPackageManagerTask.class);
    }

    protected void configureCheckFrontendTask(CheckTask task, TaskContainer taskContainer, Provider<BeanRegistryBuildService> beanRegistryBuildServiceProvider, FrontendExtension frontendExtension, SystemProviders systemProviders) {
        task.setGroup(TASK_GROUP);
        task.setDescription("Checks frontend by running a specific script.");
        task.getBeanRegistryBuildService().set(beanRegistryBuildServiceProvider);
        task.usesService(beanRegistryBuildServiceProvider);
        BeanRegistry beanRegistry = ((BeanRegistryBuildService)beanRegistryBuildServiceProvider.get()).getBeanRegistry();
        task.getPackageJsonDirectory().set(frontendExtension.getPackageJsonDirectory().getAsFile());
        task.getNodeInstallDirectory().set(frontendExtension.getNodeInstallDirectory().getAsFile());
        task.getExecutableType().set(this.getExecutableType(taskContainer, beanRegistry));
        task.getCheckScript().set(frontendExtension.getCheckScript());
        task.getVerboseModeEnabled().set(frontendExtension.getVerboseModeEnabled());
        this.bindSystemArchPropertiesToTaskInputs(systemProviders, task.getSystemJvmArch(), task.getSystemOsName());
        task.setOnlyIf(t -> this.packageJsonFileExists(frontendExtension) && frontendExtension.getCheckScript().isPresent());
        this.configureDependency(taskContainer, task, INSTALL_FRONTEND_TASK_NAME, InstallFrontendTask.class);
    }

    protected void configureAssembleFrontendTask(AssembleTask task, TaskContainer taskContainer, Provider<BeanRegistryBuildService> beanRegistryBuildServiceProvider, FrontendExtension frontendExtension, SystemProviders systemProviders) {
        task.setGroup(TASK_GROUP);
        task.setDescription("Assembles frontend artifacts by running a specific script.");
        task.getBeanRegistryBuildService().set(beanRegistryBuildServiceProvider);
        task.usesService(beanRegistryBuildServiceProvider);
        BeanRegistry beanRegistry = ((BeanRegistryBuildService)beanRegistryBuildServiceProvider.get()).getBeanRegistry();
        task.getPackageJsonDirectory().set(frontendExtension.getPackageJsonDirectory().getAsFile());
        task.getNodeInstallDirectory().set(frontendExtension.getNodeInstallDirectory().getAsFile());
        task.getExecutableType().set(this.getExecutableType(taskContainer, beanRegistry));
        task.getAssembleScript().set(frontendExtension.getAssembleScript());
        task.getVerboseModeEnabled().set(frontendExtension.getVerboseModeEnabled());
        this.bindSystemArchPropertiesToTaskInputs(systemProviders, task.getSystemJvmArch(), task.getSystemOsName());
        task.setOnlyIf(t -> this.packageJsonFileExists(frontendExtension) && frontendExtension.getAssembleScript().isPresent());
        this.configureDependency(taskContainer, task, INSTALL_FRONTEND_TASK_NAME, InstallFrontendTask.class);
    }

    protected void configurePublishFrontendTask(PublishTask task, TaskContainer taskContainer, Provider<BeanRegistryBuildService> beanRegistryBuildServiceProvider, FrontendExtension frontendExtension, SystemProviders systemProviders) {
        task.setGroup(TASK_GROUP);
        task.setDescription("Publishes frontend artifacts by running a specific script.");
        task.getBeanRegistryBuildService().set(beanRegistryBuildServiceProvider);
        task.usesService(beanRegistryBuildServiceProvider);
        BeanRegistry beanRegistry = ((BeanRegistryBuildService)beanRegistryBuildServiceProvider.get()).getBeanRegistry();
        task.getPackageJsonDirectory().set(frontendExtension.getPackageJsonDirectory().getAsFile());
        task.getNodeInstallDirectory().set(frontendExtension.getNodeInstallDirectory().getAsFile());
        task.getExecutableType().set(this.getExecutableType(taskContainer, beanRegistry));
        task.getPublishScript().set(frontendExtension.getPublishScript());
        task.getVerboseModeEnabled().set(frontendExtension.getVerboseModeEnabled());
        this.bindSystemArchPropertiesToTaskInputs(systemProviders, task.getSystemJvmArch(), task.getSystemOsName());
        task.setOnlyIf(t -> this.packageJsonFileExists(frontendExtension) && frontendExtension.getAssembleScript().isPresent() && frontendExtension.getPublishScript().isPresent());
        this.configureDependency(taskContainer, task, ASSEMBLE_TASK_NAME, AssembleTask.class);
    }

    private Provider<ExecutableType> getExecutableType(TaskContainer taskContainer, BeanRegistry beanRegistry) {
        return taskContainer.named(RESOLVE_PACKAGE_MANAGER_TASK_NAME, ResolvePackageManagerTask.class).flatMap(ResolvePackageManagerTask::getPackageManagerSpecificationFile).map(f -> {
            Path packageManagerSpecificationFilePath = f.getAsFile().toPath();
            try {
                return this.getBeanOrFail(beanRegistry, ParsePackageManagerSpecification.class).execute(this.getBeanOrFail(beanRegistry, FileManager.class).readString(packageManagerSpecificationFilePath, StandardCharsets.UTF_8)).type().getExecutableType();
            }
            catch (IOException | MalformedPackageManagerSpecification | UnsupportedPackageManagerException e) {
                throw new GradleException("Cannot read package manager specification from file: " + packageManagerSpecificationFilePath, (Throwable)e);
            }
        });
    }

    private <D extends Task> void configureDependency(TaskContainer taskContainer, String taskName, String dependsOnTaskName, Class<D> dependsOnTaskClass) {
        taskContainer.named(taskName, Task.class, task -> this.configureDependency(taskContainer, task, dependsOnTaskName, dependsOnTaskClass));
    }

    private <T extends Task, D extends Task> void configureDependency(TaskContainer taskContainer, T task, String dependsOnTaskName, Class<D> dependsOnTaskClass) {
        task.dependsOn(new Object[]{taskContainer.named(dependsOnTaskName, dependsOnTaskClass).getName()});
    }

    private <T> T getBeanOrFail(BeanRegistry beanRegistry, Class<T> beanClass) {
        try {
            return beanRegistry.getBean(beanClass);
        }
        catch (BeanInstanciationException | TooManyCandidateBeansException | ZeroOrMultiplePublicConstructorsException e) {
            throw new GradleException(e.getClass().getName() + ": " + e.getMessage(), (Throwable)e);
        }
    }

    private void bindSystemArchPropertiesToTaskInputs(SystemProviders systemProviders, Property<String> systemJvmArch, Property<String> systemOsName) {
        systemJvmArch.set(systemProviders.getJvmArch());
        systemOsName.set(systemProviders.getOsName());
    }

    private boolean packageJsonFileExists(FrontendExtension frontendExtension) {
        return (Boolean)frontendExtension.getPackageJsonDirectory().file(PACKAGE_JSON_FILE_NAME).map(RegularFile::getAsFile).map(File::toPath).map(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).get();
    }
}

