/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.outlookmessageparser.model;

import jakarta.activation.MimetypesFileTypeMap;
import java.io.IOException;
import java.io.InputStream;

class MimeType {
    private static final MimetypesFileTypeMap MIMETYPES_FILE_TYPE_MAP = MimeType.createMap();

    MimeType() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static MimetypesFileTypeMap createMap() {
        try (InputStream is = MimeType.class.getClassLoader().getResourceAsStream("mimetypes.txt");){
            MimetypesFileTypeMap mimetypesFileTypeMap = new MimetypesFileTypeMap(is);
            return mimetypesFileTypeMap;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String getContentType(String fileName) {
        return MimeType.getContentType(fileName, null);
    }

    public static String getContentType(String fileName, String charset) {
        String mimeType = MIMETYPES_FILE_TYPE_MAP.getContentType(fileName.toLowerCase());
        if (charset != null && (mimeType.startsWith("text/") || mimeType.contains("javascript"))) {
            mimeType = mimeType + ";charset=" + charset.toLowerCase();
        }
        return mimeType;
    }
}

