/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.util;

import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class FactoryClassLoader
extends ClassLoader {
    private final Map<String, ClassInfo> classes = new HashMap<String, ClassInfo>();
    private final WeakReference<ClassLoader> delegateClassLoader;
    private final Lock lock = new ReentrantLock();

    public FactoryClassLoader(ClassLoader parent) {
        super(null);
        if (parent == null) {
            throw new NullPointerException();
        }
        this.delegateClassLoader = new WeakReference<ClassLoader>(parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?> registerClass(String name, byte[] bytes) {
        this.lock.lock();
        try {
            ClassInfo info = this.classes.get(name);
            if (info != null) {
                if (!Arrays.equals(info.bytes, bytes)) {
                    throw new LinkageError("Class " + name + " is defined with different bytecodes");
                }
            } else {
                Class<?> clazz = this.defineClass(name, bytes, 0, bytes.length);
                info = new ClassInfo(bytes, clazz);
                this.classes.put(name, info);
            }
            Class<?> clazz = info.clazz;
            return clazz;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        try {
            return super.findClass(name);
        }
        catch (ClassNotFoundException e) {
            ClassLoader classLoader = (ClassLoader)this.delegateClassLoader.get();
            if (classLoader != null) {
                return classLoader.loadClass(name);
            }
            throw e;
        }
    }

    private class ClassInfo {
        private final byte[] bytes;
        private final Class<?> clazz;

        private ClassInfo(byte[] bytes, Class<?> clazz) {
            this.bytes = bytes;
            this.clazz = clazz;
        }
    }
}

