/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.map.impl.getter.time;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import org.sfm.reflect.Getter;

public class JavaLocalDateFromObjectGetter<S>
implements Getter<S, LocalDate> {
    private final Getter<S, ?> getter;
    private final ZoneId zone;

    public JavaLocalDateFromObjectGetter(Getter<S, ?> getter, ZoneId zoneId) {
        this.getter = getter;
        this.zone = zoneId;
    }

    @Override
    public LocalDate get(S target) throws Exception {
        Object o = this.getter.get(target);
        if (o == null) {
            return null;
        }
        if (o instanceof Date) {
            return Instant.ofEpochMilli(((Date)o).getTime()).atZone(this.zone).toLocalDate();
        }
        if (o instanceof LocalDate) {
            return (LocalDate)o;
        }
        if (o instanceof LocalDateTime) {
            return ((LocalDateTime)o).toLocalDate();
        }
        if (o instanceof TemporalAccessor) {
            return LocalDate.from((TemporalAccessor)o);
        }
        throw new IllegalArgumentException("Cannot convert " + o + " to LocalDate");
    }

    public String toString() {
        return "JavaLocalDateFromObjectGetter{getter=" + this.getter + '}';
    }
}

