/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.csv;

import java.lang.reflect.Type;
import org.sfm.csv.CellValueReader;
import org.sfm.csv.CellValueReaderFactory;
import org.sfm.csv.CsvColumnDefinition;
import org.sfm.csv.CsvColumnKey;
import org.sfm.csv.CsvMapper;
import org.sfm.csv.CsvMapperBuilder;
import org.sfm.csv.impl.CellValueReaderFactoryImpl;
import org.sfm.csv.impl.CsvColumnDefinitionProviderImpl;
import org.sfm.csv.impl.DynamicCsvMapper;
import org.sfm.map.ColumnDefinition;
import org.sfm.map.MapperBuildingException;
import org.sfm.map.impl.AbstractColumnDefinitionProvider;
import org.sfm.map.impl.AbstractMapperFactory;
import org.sfm.map.impl.MapperConfig;
import org.sfm.reflect.TypeReference;
import org.sfm.reflect.meta.ClassMeta;

public final class CsvMapperFactory
extends AbstractMapperFactory<CsvColumnKey, CsvColumnDefinition, CsvMapperFactory> {
    private CellValueReaderFactory cellValueReaderFactory = new CellValueReaderFactoryImpl();
    private String defaultDateFormat = "yyyy-MM-dd HH:mm:ss";

    public static CsvMapperFactory newInstance() {
        return new CsvMapperFactory();
    }

    private CsvMapperFactory() {
        super((AbstractColumnDefinitionProvider)new CsvColumnDefinitionProviderImpl(), (ColumnDefinition)CsvColumnDefinition.IDENTITY);
    }

    public CsvMapperFactory defaultDateFormat(String defaultDateFormat) {
        this.defaultDateFormat = defaultDateFormat;
        return this;
    }

    public CsvMapperFactory cellValueReaderFactory(CellValueReaderFactory cellValueReaderFactory) {
        this.cellValueReaderFactory = cellValueReaderFactory;
        return this;
    }

    public CsvMapperFactory addCustomValueReader(String key, CellValueReader<?> cellValueReader) {
        return (CsvMapperFactory)this.addColumnDefinition(key, CsvColumnDefinition.customReaderDefinition(cellValueReader));
    }

    public <T> CsvMapper<T> newMapper(Class<T> target) throws MapperBuildingException {
        return this.newMapper((Type)target);
    }

    public <T> CsvMapper<T> newMapper(TypeReference<T> target) throws MapperBuildingException {
        return this.newMapper(target.getType());
    }

    public <T> CsvMapper<T> newMapper(Type target) throws MapperBuildingException {
        ClassMeta classMeta = this.getClassMeta(target);
        return new DynamicCsvMapper(target, classMeta, this.defaultDateFormat, this.cellValueReaderFactory, this.mapperConfig());
    }

    public <T> CsvMapperBuilder<T> newBuilder(Class<T> target) {
        return this.newBuilder((Type)target);
    }

    public <T> CsvMapperBuilder<T> newBuilder(TypeReference<T> target) {
        return this.newBuilder(target.getType());
    }

    public <T> CsvMapperBuilder<T> newBuilder(Type target) {
        ClassMeta classMeta = this.getClassMeta(target);
        CsvMapperBuilder builder = new CsvMapperBuilder(target, classMeta, 0, this.cellValueReaderFactory, (MapperConfig<CsvColumnKey, CsvColumnDefinition>)this.mapperConfig());
        builder.setDefaultDateFormat(this.defaultDateFormat);
        return builder;
    }
}

