/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.map.mapper;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.simpleflatmapper.converter.Context;
import org.simpleflatmapper.converter.ConverterService;
import org.simpleflatmapper.map.FieldKey;
import org.simpleflatmapper.map.FieldMapper;
import org.simpleflatmapper.map.FieldMapperErrorHandler;
import org.simpleflatmapper.map.MapperBuildingException;
import org.simpleflatmapper.map.MapperConfig;
import org.simpleflatmapper.map.MappingContext;
import org.simpleflatmapper.map.SourceFieldMapper;
import org.simpleflatmapper.map.SourceMapper;
import org.simpleflatmapper.map.asm.MapperAsmFactory;
import org.simpleflatmapper.map.context.KeyAndPredicate;
import org.simpleflatmapper.map.context.KeySourceGetter;
import org.simpleflatmapper.map.context.MappingContextFactory;
import org.simpleflatmapper.map.context.MappingContextFactoryBuilder;
import org.simpleflatmapper.map.fieldmapper.ConstantSourceFieldMapperFactory;
import org.simpleflatmapper.map.fieldmapper.ConstantSourceFieldMapperFactoryImpl;
import org.simpleflatmapper.map.fieldmapper.MapperFieldMapper;
import org.simpleflatmapper.map.getter.ContextualGetter;
import org.simpleflatmapper.map.getter.ContextualGetterFactory;
import org.simpleflatmapper.map.getter.NullContextualGetter;
import org.simpleflatmapper.map.impl.DiscriminatorPropertyFinder;
import org.simpleflatmapper.map.impl.GetterMapper;
import org.simpleflatmapper.map.impl.JoinUtils;
import org.simpleflatmapper.map.mapper.AbstractMapper;
import org.simpleflatmapper.map.mapper.ColumnDefinition;
import org.simpleflatmapper.map.mapper.ConstantSourceMapperBuilder;
import org.simpleflatmapper.map.mapper.ContextualSourceFieldMapperImpl;
import org.simpleflatmapper.map.mapper.FieldErrorHandlerGetter;
import org.simpleflatmapper.map.mapper.FieldErrorHandlerMapper;
import org.simpleflatmapper.map.mapper.GenericBuilder;
import org.simpleflatmapper.map.mapper.KeyFactory;
import org.simpleflatmapper.map.mapper.MapperBiInstantiatorFactory;
import org.simpleflatmapper.map.mapper.MapperFieldMapperGetterAdapter;
import org.simpleflatmapper.map.mapper.MapperImpl;
import org.simpleflatmapper.map.mapper.MapperSource;
import org.simpleflatmapper.map.mapper.MissingPropertyException;
import org.simpleflatmapper.map.mapper.PropertyMapping;
import org.simpleflatmapper.map.mapper.PropertyMappingsBuilder;
import org.simpleflatmapper.map.mapper.PropertyWithSetterOrConstructor;
import org.simpleflatmapper.map.mapper.TransformSourceFieldMapper;
import org.simpleflatmapper.map.property.DefaultValueProperty;
import org.simpleflatmapper.map.property.DiscriminatorColumnProperty;
import org.simpleflatmapper.map.property.FieldMapperColumnDefinition;
import org.simpleflatmapper.map.property.FieldMapperProperty;
import org.simpleflatmapper.map.property.GetterProperty;
import org.simpleflatmapper.map.property.MandatoryProperty;
import org.simpleflatmapper.reflect.BiInstantiator;
import org.simpleflatmapper.reflect.BuilderBiInstantiator;
import org.simpleflatmapper.reflect.BuilderInstantiatorDefinition;
import org.simpleflatmapper.reflect.Getter;
import org.simpleflatmapper.reflect.InstantiatorDefinition;
import org.simpleflatmapper.reflect.InstantiatorFactory;
import org.simpleflatmapper.reflect.Parameter;
import org.simpleflatmapper.reflect.ReflectionService;
import org.simpleflatmapper.reflect.Setter;
import org.simpleflatmapper.reflect.asm.AsmFactory;
import org.simpleflatmapper.reflect.getter.ConstantGetter;
import org.simpleflatmapper.reflect.meta.ClassMeta;
import org.simpleflatmapper.reflect.meta.ConstructorPropertyMeta;
import org.simpleflatmapper.reflect.meta.PropertyFinder;
import org.simpleflatmapper.reflect.meta.PropertyMeta;
import org.simpleflatmapper.reflect.meta.SelfPropertyMeta;
import org.simpleflatmapper.reflect.meta.SubPropertyMeta;
import org.simpleflatmapper.reflect.setter.NullSetter;
import org.simpleflatmapper.util.Asserts;
import org.simpleflatmapper.util.BiConsumer;
import org.simpleflatmapper.util.BiFunction;
import org.simpleflatmapper.util.ErrorDoc;
import org.simpleflatmapper.util.ErrorHelper;
import org.simpleflatmapper.util.ForEachCallBack;
import org.simpleflatmapper.util.Function;
import org.simpleflatmapper.util.Named;
import org.simpleflatmapper.util.Predicate;
import org.simpleflatmapper.util.Supplier;
import org.simpleflatmapper.util.TypeHelper;
import org.simpleflatmapper.util.UnaryFactory;

public final class DefaultConstantSourceMapperBuilder<S, T, K extends FieldKey<K>>
extends ConstantSourceMapperBuilder<S, T, K> {
    private static final FieldKey[] FIELD_KEYS = new FieldKey[0];
    public static final FieldMapper[] EMPTY_FIELD_MAPPERS = new FieldMapper[0];
    private final Type target;
    private final ConstantSourceFieldMapperFactory<S, K> fieldMapperFactory;
    protected final PropertyMappingsBuilder<T, K> propertyMappingsBuilder;
    protected final ReflectionService reflectionService;
    private final List<FieldMapper<S, T>> additionalMappers = new ArrayList<FieldMapper<S, T>>();
    private final MapperSource<? super S, K> mapperSource;
    private final MapperConfig<K, ? extends S> mapperConfig;
    protected final MappingContextFactoryBuilder<S, K> mappingContextFactoryBuilder;
    private final KeyFactory<K> keyFactory;

    public DefaultConstantSourceMapperBuilder(MapperSource<? super S, K> mapperSource, ClassMeta<T> classMeta, final MapperConfig<K, ? extends S> mapperConfig, MappingContextFactoryBuilder<S, K> mappingContextFactoryBuilder, KeyFactory<K> keyFactory, PropertyFinder<T> propertyFinder) throws MapperBuildingException {
        ContextualGetterFactory<? super S, K> getterFactory = mapperSource.getterFactory();
        this.mapperSource = (MapperSource)Asserts.requireNonNull((String)"fieldMapperSource", mapperSource);
        this.mapperConfig = (MapperConfig)Asserts.requireNonNull((String)"mapperConfig", mapperConfig);
        this.mappingContextFactoryBuilder = mappingContextFactoryBuilder;
        this.fieldMapperFactory = new ConstantSourceFieldMapperFactoryImpl<S, K>(getterFactory, ConverterService.getInstance(), mapperSource.source());
        this.keyFactory = keyFactory;
        this.propertyMappingsBuilder = PropertyMappingsBuilder.of(classMeta, mapperConfig, new PropertyMappingsBuilder.PropertyPredicateFactory<K>(){

            @Override
            public PropertyFinder.PropertyFilter predicate(K k, Object[] properties, final List<PropertyMappingsBuilder.AccessorNotFound> accessorNotFounds) {
                if (k != null) {
                    MappingContextFactoryBuilder mappingContextFactoryBuilder1 = new MappingContextFactoryBuilder(new KeySourceGetter<K, Object>(){

                        @Override
                        public Object getValue(K key, Object source) throws Exception {
                            return null;
                        }
                    }, !mapperConfig.unorderedJoin());
                    Predicate propertyMetaPredicate = new Predicate<PropertyMeta<?, ?>>((FieldKey)k, properties, mappingContextFactoryBuilder1){
                        final /* synthetic */ FieldKey val$k;
                        final /* synthetic */ Object[] val$properties;
                        final /* synthetic */ MappingContextFactoryBuilder val$mappingContextFactoryBuilder1;
                        {
                            this.val$k = fieldKey;
                            this.val$properties = objectArray;
                            this.val$mappingContextFactoryBuilder1 = mappingContextFactoryBuilder;
                        }

                        public boolean test(PropertyMeta<?, ?> propertyMeta) {
                            if (!PropertyWithSetterOrConstructor.INSTANCE.test(propertyMeta)) {
                                return false;
                            }
                            try {
                                ContextualGetter getterFromSource = this.getContextualGetter(propertyMeta);
                                if (NullContextualGetter.isNull(getterFromSource)) {
                                    accessorNotFounds.add(new PropertyMappingsBuilder.AccessorNotFound(this.val$k, propertyMeta.getPath(), propertyMeta.getPropertyType(), ErrorDoc.CSFM_GETTER_NOT_FOUND, propertyMeta));
                                    return false;
                                }
                                return true;
                            }
                            catch (Exception e) {
                                return false;
                            }
                        }

                        public <O, P> ContextualGetter<? super S, ? extends P> getContextualGetter(PropertyMeta<O, P> propertyMeta) {
                            return DefaultConstantSourceMapperBuilder.this.fieldMapperFactory.getGetterFromSource(this.val$k, propertyMeta.getPropertyType(), FieldMapperColumnDefinition.of(this.val$properties), propertyMeta.getPropertyClassMetaSupplier(), this.val$mappingContextFactoryBuilder1);
                        }
                    };
                    return new PropertyFinder.PropertyFilter(propertyMetaPredicate, (Predicate)PropertyWithSetterOrConstructor.INSTANCE);
                }
                return new PropertyFinder.PropertyFilter((Predicate)PropertyWithSetterOrConstructor.INSTANCE);
            }
        }, propertyFinder);
        this.target = ((ClassMeta)Asserts.requireNonNull((String)"classMeta", classMeta)).getType();
        this.reflectionService = ((ClassMeta)Asserts.requireNonNull((String)"classMeta", classMeta)).getReflectionService();
    }

    @Override
    public final ConstantSourceMapperBuilder<S, T, K> addMapping(K key, ColumnDefinition<K, ?> columnDefinition) {
        Object composedDefinition = columnDefinition.compose(this.mapperConfig.columnDefinitions().getColumnDefinition(key));
        K mappedColumnKey = ((ColumnDefinition)composedDefinition).rename(key);
        FieldMapperProperty prop = columnDefinition.lookFor(FieldMapperProperty.class);
        if (prop != null) {
            this.addMapper(prop.getFieldMapper());
        } else {
            PropertyMapping propertyMapping = this.propertyMappingsBuilder.addProperty(mappedColumnKey, (ColumnDefinition<K, ?>)composedDefinition);
            if (propertyMapping != null) {
                ColumnDefinition<K, ?> effectiveColumnDefinition = propertyMapping.getColumnDefinition();
                if (effectiveColumnDefinition.isKey() && effectiveColumnDefinition.keyAppliesTo().test(propertyMapping.getPropertyMeta())) {
                    Predicate<S> predicate = this.buildKeyPredicate(propertyMapping.getPropertyMeta(), effectiveColumnDefinition.keyAppliesTo());
                    this.mappingContextFactoryBuilder.addKey(new KeyAndPredicate<S, K>(mappedColumnKey, predicate));
                } else if (effectiveColumnDefinition.isInferNull() && effectiveColumnDefinition.inferNullsAppliesTo().test(propertyMapping.getPropertyMeta())) {
                    Predicate<S> predicate = this.buildKeyPredicate(propertyMapping.getPropertyMeta(), effectiveColumnDefinition.inferNullsAppliesTo());
                    this.mappingContextFactoryBuilder.addInferNull(new KeyAndPredicate<S, K>(mappedColumnKey, predicate));
                }
            }
        }
        return this;
    }

    @Override
    public ContextualSourceFieldMapperImpl<S, T> mapper() {
        SourceFieldMapper<S, T> mapper = this.sourceFieldMapper();
        return new ContextualSourceFieldMapperImpl<S, T>(this.mappingContextFactoryBuilder.build(), mapper);
    }

    @Override
    public SourceFieldMapper<S, T> sourceFieldMapper() {
        SourceFieldMapper<Object, T> mapper;
        this.mapperConfig.columnDefinitions().forEach(DefaultValueProperty.class, new BiConsumer<Predicate<? super K>, DefaultValueProperty>(){

            public void accept(Predicate<? super K> predicate, DefaultValueProperty columnProperty) {
                if (DefaultConstantSourceMapperBuilder.this.propertyMappingsBuilder.hasKey(predicate)) {
                    return;
                }
                if (predicate instanceof Named) {
                    String name = ((Named)predicate).getName();
                    GetterProperty getterProperty = new GetterProperty((Getter<?, ?>)new ConstantGetter(columnProperty.getValue()), DefaultConstantSourceMapperBuilder.this.mapperSource.source(), columnProperty.getValue().getClass());
                    FieldMapperColumnDefinition columnDefinition = (FieldMapperColumnDefinition)FieldMapperColumnDefinition.identity().add(columnProperty, getterProperty);
                    DefaultConstantSourceMapperBuilder.this.propertyMappingsBuilder.addPropertyIfPresent(DefaultConstantSourceMapperBuilder.this.keyFactory.newKey(name, DefaultConstantSourceMapperBuilder.this.propertyMappingsBuilder.maxIndex() + 1), columnDefinition);
                }
            }
        });
        final ArrayList<String> missingProperties = new ArrayList<String>();
        this.mapperConfig.columnDefinitions().forEach(MandatoryProperty.class, new BiConsumer<Predicate<? super K>, MandatoryProperty>(){

            public void accept(Predicate<? super K> predicate, MandatoryProperty columnProperty) {
                if (!DefaultConstantSourceMapperBuilder.this.propertyMappingsBuilder.hasKey(predicate)) {
                    if (predicate instanceof Named) {
                        missingProperties.add(((Named)predicate).getName());
                    } else {
                        missingProperties.add(predicate.toString());
                    }
                }
            }
        });
        if (!missingProperties.isEmpty()) {
            throw new MissingPropertyException(missingProperties);
        }
        List<InjectionParam> injectionParams = this.constructorInjections();
        if (this.isTargetForTransformer(injectionParams)) {
            mapper = this.buildMapperWithTransformer(injectionParams);
        } else {
            ConstructorInjections<S, T> constructorInjections = this.toConstructorInjections(injectionParams);
            InstantiatorAndFieldMappers<S, T> constructorFieldMappersAndInstantiator = this.getConstructorFieldMappersAndInstantiator(constructorInjections);
            mapper = DefaultConstantSourceMapperBuilder.buildMapper(this.targetFieldMappers(), constructorFieldMappersAndInstantiator, this.getKeys().toArray(FIELD_KEYS), this.getTargetClass(), this.reflectionService, this.mapperSource, this.mapperConfig);
        }
        return mapper;
    }

    private boolean isTargetForTransformer(List<InjectionParam> injectionParams) {
        return this.propertyMappingsBuilder.getClassMeta().needTransformer() || this.needGenericBuilder(injectionParams) || this.mapperConfig.assumeInjectionModifiesValues() && !this.mappingContextFactoryBuilder.hasNoDependentKeys() && !injectionParams.isEmpty();
    }

    private SourceFieldMapper<S, T> buildMapperWithTransformer(List<InjectionParam> injections) {
        boolean forceGenericBuilder = this.needGenericBuilder(injections);
        BuilderInstantiatorDefinition mutableBuilder = this.getMutableBuilder();
        if (!forceGenericBuilder && mutableBuilder != null) {
            return this.builderWithTransformer(injections, mutableBuilder);
        }
        return this.buildWithGenericBuilder(injections, this.fields(), this.getKeys().toArray(FIELD_KEYS));
    }

    private boolean needGenericBuilder(List<InjectionParam> injections) {
        boolean forceGenericBuilder = false;
        for (InjectionParam ip : injections) {
            if (!ip.needTransformer()) continue;
            forceGenericBuilder = true;
            break;
        }
        return forceGenericBuilder;
    }

    private BuilderInstantiatorDefinition getMutableBuilder() {
        List eligibleInstantiatorDefinitions = this.propertyMappingsBuilder.getPropertyFinder().getEligibleInstantiatorDefinitions();
        for (int i = 0; i < eligibleInstantiatorDefinitions.size(); ++i) {
            BuilderInstantiatorDefinition bid;
            InstantiatorDefinition instantiatorDefinition = (InstantiatorDefinition)eligibleInstantiatorDefinitions.get(i);
            if (instantiatorDefinition.getType() != InstantiatorDefinition.Type.BUILDER || !(bid = (BuilderInstantiatorDefinition)instantiatorDefinition).isMutable()) continue;
            return bid;
        }
        return null;
    }

    private SourceFieldMapper<S, T> buildWithGenericBuilder(List<InjectionParam> params, List<FieldMeta> fields, FieldKey<K>[] keys) {
        GenericBuilderMapping<S, T, K> gbm = this.getGenericBuilderMapping(params, fields, keys);
        return this.buildWithGenericBuilder(gbm);
    }

    public GenericBuilderMapping<S, T, K> getGenericBuilderMapping() {
        return this.getGenericBuilderMapping(this.constructorInjections(), this.fields(), this.getKeys().toArray(FIELD_KEYS));
    }

    private GenericBuilderMapping<S, T, K> getGenericBuilderMapping(List<InjectionParam> params, List<FieldMeta> fields, FieldKey<K>[] keys) {
        int nbParams = params.size();
        Parameter[] indexMapping = new Parameter[nbParams];
        Function[] transformers = new Function[nbParams];
        ArrayList genericBuilderFieldMappers = new ArrayList();
        ArrayList targetConstructorFieldMapper = new ArrayList();
        ArrayList targetFieldMappers = new ArrayList();
        ArrayList targetFieldSetters = new ArrayList();
        int i = 0;
        for (InjectionParam p : params) {
            GenericBuilderGetterAndFieldMapper getterAndFieldMapper = p.getterAndfieldMapperGenericBuilder(i);
            if (getterAndFieldMapper == null) continue;
            if (getterAndFieldMapper.fieldMapper == null) {
                throw new IllegalStateException();
            }
            genericBuilderFieldMappers.add(getterAndFieldMapper.fieldMapper);
            if (getterAndFieldMapper.fieldMapperAfterConstruct != null) {
                targetConstructorFieldMapper.add(getterAndFieldMapper.fieldMapperAfterConstruct);
            }
            indexMapping[i] = p.parameter;
            transformers[i] = getterAndFieldMapper.transform;
            ++i;
        }
        for (FieldMeta fm : fields) {
            FieldGenericBuilderInfo fieldGenericBuilderInfo = fm.fieldGenericBuilderInfo(i);
            targetFieldMappers.add(fieldGenericBuilderInfo.targetFieldMapper);
            genericBuilderFieldMappers.add(fieldGenericBuilderInfo.fieldMapperGeneric);
            targetFieldSetters.add(fieldGenericBuilderInfo.fieldSetter);
            ++i;
        }
        BiInstantiator<Object[], Object, T> targetInstantiatorFromGenericBuilder = this.targetInstantiatorFromGenericBuilder(indexMapping, transformers);
        GenericBuildBiInstantiator genericBuilderInstantiator = new GenericBuildBiInstantiator(genericBuilderFieldMappers.toArray(EMPTY_FIELD_MAPPERS), targetInstantiatorFromGenericBuilder, targetFieldSetters.toArray(new Setter[0]));
        InstantiatorAndFieldMappers instantiatorAndFieldMappers = new InstantiatorAndFieldMappers(new ConstructorInjections(Collections.emptyMap(), new FieldMapper[0]), genericBuilderInstantiator);
        FieldMapper<S, T>[] targetFMappers = this.merge(targetConstructorFieldMapper.toArray(EMPTY_FIELD_MAPPERS), targetFieldMappers.toArray(EMPTY_FIELD_MAPPERS));
        return new GenericBuilderMapping(genericBuilderInstantiator, instantiatorAndFieldMappers, genericBuilderFieldMappers.toArray(EMPTY_FIELD_MAPPERS), targetFMappers, keys);
    }

    private SourceFieldMapper<S, T> buildWithGenericBuilder(GenericBuilderMapping<S, T, K> gbm) {
        SourceFieldMapper<? extends S, GenericBuilder> delegate = DefaultConstantSourceMapperBuilder.buildMapper(gbm.genericBuilderFieldMappers, gbm.instantiatorAndFieldMappers, gbm.keys, GenericBuilder.class, this.reflectionService, this.mapperSource, this.mapperConfig);
        return new TransformSourceFieldMapper(delegate, gbm.targetFieldMappers, GenericBuilder.buildFunction());
    }

    public Type getTargetType() {
        return this.propertyMappingsBuilder.getClassMeta().getType();
    }

    public List<K> findAllDiscriminatorKeys() {
        final ArrayList keys = new ArrayList();
        this.propertyMappingsBuilder.forEachProperties(new ForEachCallBack<PropertyMapping<T, ?, K>>(){

            public void handle(PropertyMapping<T, ?, K> tkPropertyMapping) {
                ColumnDefinition columnDefinition = tkPropertyMapping.getColumnDefinition();
                if (columnDefinition.has(DiscriminatorColumnProperty.class)) {
                    DiscriminatorColumnProperty[] properties;
                    for (DiscriminatorColumnProperty p : properties = columnDefinition.lookForAll(DiscriminatorColumnProperty.class)) {
                        if (!p.test(DefaultConstantSourceMapperBuilder.this.getTargetType())) continue;
                        keys.add(tkPropertyMapping.getColumnKey());
                        return;
                    }
                }
            }
        });
        return keys;
    }

    private FieldMapper<S, T>[] merge(FieldMapper<S, T>[] fieldMappers, FieldMapper<S, T>[] fields) {
        FieldMapper[] f = new FieldMapper[fieldMappers.length + fields.length];
        System.arraycopy(fieldMappers, 0, f, 0, fieldMappers.length);
        System.arraycopy(fields, 0, f, fieldMappers.length, fields.length);
        return f;
    }

    private BiInstantiator<Object[], Object, T> targetInstantiatorFromGenericBuilder(Parameter[] indexMapping, Function[] transformers) {
        InstantiatorFactory instantiatorFactory = this.reflectionService.getInstantiatorFactory();
        HashMap<Parameter, Object> params = new HashMap<Parameter, Object>();
        for (int i = 0; i < indexMapping.length; ++i) {
            Parameter parameter = indexMapping[i];
            int builderIndex = i;
            Function transformer = transformers[i];
            if (transformer == null) {
                params.put(parameter, new TargetFromBuilderParamBiFunction(builderIndex));
                continue;
            }
            params.put(parameter, new TargetFromBuilderWithTransformBiFunction(transformer, builderIndex));
        }
        BiInstantiator targetInstantiator = instantiatorFactory.getBiInstantiator(this.getTargetClass(), Object[].class, Object.class, this.propertyMappingsBuilder.getPropertyFinder().getEligibleInstantiatorDefinitions(), params, this.reflectionService.isAsmActivated(), this.reflectionService.builderIgnoresNullValues());
        return targetInstantiator;
    }

    private SourceFieldMapper<S, T> builderWithTransformer(List<InjectionParam> params, BuilderInstantiatorDefinition builder) {
        FieldMapper<S, T>[] fields = this.targetFieldMappers();
        Method buildMethod = builder.getBuildMethod();
        Class<?> targetClass = buildMethod.getDeclaringClass();
        Object f = Modifier.isStatic(buildMethod.getModifiers()) ? new StaticMethodFunction(buildMethod) : new MethodFunction(buildMethod);
        ConstructorInjections<S, T> constructorInjections = this.toConstructorInjections(params);
        InstantiatorFactory instantiatorFactory = this.reflectionService.getInstantiatorFactory();
        final BuilderBiInstantiator builderBiInstantiator = instantiatorFactory.builderBiInstantiator(builder, MapperBiInstantiatorFactory.convertToBiInstantiator(((ConstructorInjections)constructorInjections).parameterGetterMap), this.reflectionService.isAsmActivated(), this.reflectionService.builderIgnoresNullValues());
        InstantiatorAndFieldMappers newConstantSourceMapperBuilder = new InstantiatorAndFieldMappers(constructorInjections, new BiInstantiator(){

            public Object newInstance(Object o, Object o2) throws Exception {
                return builderBiInstantiator.newInitialisedBuilderInstace(o, o2);
            }
        });
        SourceFieldMapper<? extends S, T> delegate = DefaultConstantSourceMapperBuilder.buildMapper(fields, newConstantSourceMapperBuilder, this.getKeys().toArray(FIELD_KEYS), targetClass, this.reflectionService, this.mapperSource, this.mapperConfig);
        return new TransformSourceFieldMapper<S, T, T>(delegate, (FieldMapper<S, O>[])fields, f);
    }

    public static <S, T, K extends FieldKey<K>> SourceFieldMapper<S, T> buildMapper(FieldMapper<S, T>[] fields, InstantiatorAndFieldMappers<S, T> constructorFieldMappersAndInstantiator, FieldKey<?>[] keys, Class<T> target, ReflectionService reflectionService, MapperSource<? super S, K> mapperSource, MapperConfig<K, ? extends S> mapperConfig) {
        AbstractMapper mapper;
        if (reflectionService.isAsmActivated() && fields.length + constructorFieldMappersAndInstantiator.constructorInjections.parameterGetterMap.size() < mapperConfig.asmMapperNbFieldsLimit()) {
            try {
                MapperAsmFactory mapperAsmFactory = (MapperAsmFactory)reflectionService.getAsmFactory(target.getClassLoader()).registerOrCreate(MapperAsmFactory.class, (UnaryFactory)new UnaryFactory<AsmFactory, MapperAsmFactory>(){

                    public MapperAsmFactory newInstance(AsmFactory asmFactory) {
                        return new MapperAsmFactory(asmFactory);
                    }
                });
                mapper = mapperAsmFactory.createMapper(keys, fields, constructorFieldMappersAndInstantiator.constructorInjections.fieldMappers, constructorFieldMappersAndInstantiator.instantiator, mapperSource.source(), target);
            }
            catch (Throwable e) {
                if (mapperConfig.failOnAsm()) {
                    return (SourceFieldMapper)ErrorHelper.rethrow((Throwable)e);
                }
                mapper = new MapperImpl(fields, constructorFieldMappersAndInstantiator.constructorInjections.fieldMappers, constructorFieldMappersAndInstantiator.instantiator);
            }
        } else {
            mapper = new MapperImpl(fields, constructorFieldMappersAndInstantiator.constructorInjections.fieldMappers, constructorFieldMappersAndInstantiator.instantiator);
        }
        return mapper;
    }

    @Override
    public boolean isRootAggregate() {
        return this.mappingContextFactoryBuilder.isRoot() && !this.mappingContextFactoryBuilder.hasNoDependentKeys();
    }

    private Class<T> getTargetClass() {
        return TypeHelper.toClass((Type)this.target);
    }

    private <T> ConstructorInjections<S, T> toConstructorInjections(List<InjectionParam> params) throws MapperBuildingException {
        HashMap injections = new HashMap();
        ArrayList fieldMappers = new ArrayList();
        for (int i = 0; i < params.size(); ++i) {
            InjectionParam p = params.get(i);
            GetterAndFieldMapper getterAndFieldMapper = p.getterAndfieldMapper();
            injections.put(p.parameter, getterAndFieldMapper.getter);
            if (getterAndFieldMapper.fieldMapper == null) continue;
            fieldMappers.add(getterAndFieldMapper.fieldMapper);
        }
        return new ConstructorInjections(injections, fieldMappers.toArray(EMPTY_FIELD_MAPPERS));
    }

    private InstantiatorAndFieldMappers<S, T> getConstructorFieldMappersAndInstantiator(ConstructorInjections<S, T> constructorInjections) throws MapperBuildingException {
        InstantiatorFactory instantiatorFactory = this.reflectionService.getInstantiatorFactory();
        try {
            Map injections = ((ConstructorInjections)constructorInjections).parameterGetterMap;
            MapperBiInstantiatorFactory mapperBiInstantiatorFactory = new MapperBiInstantiatorFactory(instantiatorFactory);
            ContextualGetterFactory<S, K> getterFactory = this.fieldMapperAsGetterFactory();
            BiInstantiator<S, MappingContext<?>, T> instantiator = mapperBiInstantiatorFactory.getBiInstantiator(this.mapperSource.source(), this.target, this.propertyMappingsBuilder, injections, getterFactory, this.reflectionService.builderIgnoresNullValues(), this.mappingContextFactoryBuilder);
            return new InstantiatorAndFieldMappers<S, T>(constructorInjections, instantiator);
        }
        catch (Exception e) {
            return (InstantiatorAndFieldMappers)ErrorHelper.rethrow((Throwable)e);
        }
    }

    private ContextualGetterFactory<? super S, K> fieldMapperAsGetterFactory() {
        return new FieldMapperFactoryGetterFactoryAdapter(this.mapperConfig.fieldMapperErrorHandler());
    }

    private List<InjectionParam> constructorInjections() {
        final ArrayList<InjectionParam> injectionParams = new ArrayList<InjectionParam>();
        final HashSet<Parameter> parameters = new HashSet<Parameter>();
        this.propertyMappingsBuilder.forEachConstructorProperties(new ForEachCallBack<PropertyMapping<T, ?, K>>(){

            public void handle(PropertyMapping<T, ?, K> propertyMapping) {
                if (!DefaultConstantSourceMapperBuilder.this.isTargetForMapperFieldMapper(propertyMapping)) {
                    PropertyMeta pm = propertyMapping.getPropertyMeta();
                    ConstructorPropertyMeta cProp = (ConstructorPropertyMeta)pm;
                    injectionParams.add(new ConstructorParam(cProp.getParameter(), cProp, propertyMapping));
                    parameters.add(cProp.getParameter());
                }
            }
        });
        for (PropertyPerOwner e : this.getSubPropertyPerOwner()) {
            if (!e.owner.isConstructorProperty()) continue;
            ConstructorPropertyMeta meta = (ConstructorPropertyMeta)e.owner;
            injectionParams.add(new SubPropertyParam(meta.getParameter(), meta, e.propertyMappings, this));
            parameters.add(meta.getParameter());
        }
        this.addContextParam(injectionParams, parameters);
        return injectionParams;
    }

    private void addContextParam(List<InjectionParam> injectionParams, Set<Parameter> parameters) {
        Parameter mappingContext = null;
        for (InstantiatorDefinition id : this.propertyMappingsBuilder.getPropertyFinder().getEligibleInstantiatorDefinitions()) {
            for (Parameter p : id.getParameters()) {
                if (!TypeHelper.areEquals((Type)p.getType(), Context.class) || parameters.contains(p)) continue;
                if (mappingContext != null && !p.equals((Object)mappingContext)) {
                    return;
                }
                mappingContext = p;
            }
        }
        if (mappingContext != null) {
            injectionParams.add(new ContextParam(mappingContext, null));
        }
    }

    private <P> SourceMapper<S, P> getterPropertyMapper(PropertyMeta<T, P> owner, PropertyMapping<T, ?, K> propertyMapping) {
        PropertyMeta<T, ?> pm = propertyMapping.getPropertyMeta();
        ContextualGetter getter = this.fieldMapperFactory.getGetterFromSource(propertyMapping.getColumnKey(), pm.getPropertyType(), propertyMapping.getColumnDefinition(), pm.getPropertyClassMetaSupplier(), this.mappingContextFactoryBuilder);
        return new GetterMapper(getter);
    }

    private MappingContextFactoryBuilder getMapperContextFactoryBuilder(PropertyMeta<?, ?> owner, List<PropertyMapping<T, ?, K>> properties) {
        List<KeyAndPredicate<S, K>> subKeys = this.getSubKeys(properties);
        List<KeyAndPredicate<S, K>> inferNullColumns = this.getInferNulls(properties);
        return this.mappingContextFactoryBuilder.newBuilder(subKeys, inferNullColumns, owner);
    }

    private <P> FieldMapper<S, T> newMapperFieldMapper(List<PropertyMapping<T, ?, K>> properties, PropertyMeta<T, ?> meta, SourceMapper<S, ?> mapper, MappingContextFactoryBuilder<S, K> mappingContextFactoryBuilder) {
        return this.newMapperFieldMapper(properties, meta.getSetter(), mapper, mappingContextFactoryBuilder);
    }

    private <P> FieldMapper<S, T> newMapperFieldMapper(List<PropertyMapping<T, ?, K>> properties, Setter<T, P> setter, SourceMapper<S, ?> mapper, MappingContextFactoryBuilder<S, K> mappingContextFactoryBuilder) {
        MapperFieldMapper fieldMapper = new MapperFieldMapper(mapper, setter, mappingContextFactoryBuilder.nullChecker(), mappingContextFactoryBuilder.currentIndex());
        return this.wrapFieldMapperWithErrorHandler(properties.get(0).getColumnKey(), fieldMapper);
    }

    private <P> ContextualGetter<S, P> newMapperGetterAdapter(SourceMapper<S, ?> mapper, MappingContextFactoryBuilder<S, K> builder) {
        return new MapperFieldMapperGetterAdapter(mapper, builder.nullChecker(), builder.currentIndex());
    }

    @Override
    protected <P> void addMapping(K columnKey, ColumnDefinition<K, ?> columnDefinition, PropertyMeta<T, P> prop) {
        this.propertyMappingsBuilder.addProperty(columnKey, columnDefinition, prop);
    }

    private FieldMapper<S, T>[] targetFieldMappers() {
        List<FieldMeta> fields = this.fields();
        FieldMapper[] fieldMappers = new FieldMapper[fields.size()];
        for (int i = 0; i < fields.size(); ++i) {
            fieldMappers[i] = fields.get(i).targetFieldMapper();
        }
        return fieldMappers;
    }

    private List<FieldMeta> fields() {
        final ArrayList<FieldMeta> fields = new ArrayList<FieldMeta>();
        this.propertyMappingsBuilder.forEachProperties(new ForEachCallBack<PropertyMapping<T, ?, K>>(){

            public void handle(PropertyMapping<T, ?, K> t) {
                if (t == null || DefaultConstantSourceMapperBuilder.this.isTargetForMapperFieldMapper(t)) {
                    return;
                }
                PropertyMeta meta = t.getPropertyMeta();
                if (meta == null || meta instanceof SelfPropertyMeta) {
                    return;
                }
                if (!(meta.isConstructorProperty() || DefaultConstantSourceMapperBuilder.this.isTargetForMapperFieldMapper(t) || meta.isNonMapped())) {
                    fields.add(new PropertyFieldMeta(t));
                }
            }
        });
        List<PropertyPerOwner> subPropertyPerOwner = this.getSubPropertyPerOwner();
        for (PropertyPerOwner propertyPerOwner : subPropertyPerOwner) {
            List<PropertyMapping<T, ?, K>> propertyMappings;
            if (propertyPerOwner.owner.isConstructorProperty() || (propertyMappings = this.filterNonMappedAndCompress(propertyPerOwner.propertyMappings)).isEmpty()) continue;
            MappingContextFactoryBuilder currentBuilder = this.getMapperContextFactoryBuilder(propertyPerOwner.owner, propertyPerOwner.propertyMappings);
            SourceMapper mapper = propertyMappings.size() == 1 && JoinUtils.isArrayElement(propertyMappings.get(0).getPropertyMeta()) ? this.getterPropertyMapper(propertyPerOwner.owner, propertyMappings.get(0)) : this.subPropertyMapper(propertyPerOwner.owner, propertyPerOwner.propertyMappings, currentBuilder);
            fields.add(new SubPropertyFieldMeta(mapper, propertyPerOwner.propertyMappings, propertyPerOwner.owner, currentBuilder));
        }
        for (FieldMapper fieldMapper : this.additionalMappers) {
            fields.add(new FieldMapperFieldMeta(fieldMapper));
        }
        return fields;
    }

    private List<PropertyMapping<T, ?, K>> filterNonMappedAndCompress(List<PropertyMapping<T, ?, K>> propertyMappings) {
        ArrayList filtered = new ArrayList(propertyMappings);
        ListIterator<PropertyMapping<T, ?, K>> iterator = filtered.listIterator();
        while (iterator.hasNext()) {
            PropertyMapping<T, ?, K> pm = iterator.next();
            if (pm.getPropertyMeta().isNonMapped()) {
                iterator.remove();
                continue;
            }
            iterator.set(pm.compressSubSelf());
        }
        return filtered;
    }

    @Override
    public MappingContextFactory<? super S> contextFactory() {
        return this.mappingContextFactoryBuilder.build();
    }

    private boolean isTargetForMapperFieldMapper(PropertyMapping pm) {
        return pm.getPropertyMeta().isSubProperty() || JoinUtils.isArrayElement(pm.getPropertyMeta()) && this.isKeyOrHasKey(pm);
    }

    private boolean isKeyOrHasKey(final PropertyMapping pm) {
        if (pm.getColumnDefinition().isInferNull()) {
            return true;
        }
        return this.propertyMappingsBuilder.forEachProperties(new ForEachCallBack<PropertyMapping<T, ?, K>>(){
            boolean hasKey;

            public void handle(PropertyMapping<T, ?, K> tkPropertyMapping) {
                SubPropertyMeta subPropertyMeta;
                if (tkPropertyMapping.getPropertyMeta().isSubProperty() && (subPropertyMeta = (SubPropertyMeta)tkPropertyMapping.getPropertyMeta()).getOwnerProperty().equals(pm.getPropertyMeta())) {
                    this.hasKey |= tkPropertyMapping.getColumnDefinition().isInferNull();
                }
            }
        }).hasKey;
    }

    private List<PropertyPerOwner> getSubPropertyPerOwner() {
        final ArrayList<PropertyPerOwner> subPropertiesList = new ArrayList<PropertyPerOwner>();
        this.propertyMappingsBuilder.forEachProperties(new ForEachCallBack<PropertyMapping<T, ?, K>>(){

            public void handle(PropertyMapping<T, ?, K> t) {
                if (t == null) {
                    return;
                }
                PropertyMeta meta = t.getPropertyMeta();
                if (meta == null) {
                    return;
                }
                if (DefaultConstantSourceMapperBuilder.this.isTargetForMapperFieldMapper(t)) {
                    this.addSubProperty(t, meta, t.getColumnKey());
                }
            }

            private <P> void addSubProperty(PropertyMapping<T, ?, K> pm, PropertyMeta<T, ?> propertyMeta, K key) {
                PropertyMeta propertyOwner = this.getOwner(propertyMeta);
                List props = this.getList(propertyOwner);
                if (props == null) {
                    props = new ArrayList();
                    subPropertiesList.add(new PropertyPerOwner(propertyOwner, props));
                }
                props.add(pm);
            }

            private PropertyMeta<T, ?> getOwner(PropertyMeta<T, ?> propertyMeta) {
                if (propertyMeta.isSubProperty()) {
                    return ((SubPropertyMeta)propertyMeta).getOwnerProperty();
                }
                return propertyMeta;
            }

            private List<PropertyMapping<T, ?, K>> getList(PropertyMeta<?, ?> owner) {
                for (PropertyPerOwner tuple : subPropertiesList) {
                    if (!tuple.owner.equals(owner)) continue;
                    return tuple.propertyMappings;
                }
                return null;
            }
        });
        return subPropertiesList;
    }

    private <P> SourceMapper<S, P> subPropertyMapper(PropertyMeta<T, P> owner, List<PropertyMapping<T, ?, K>> properties, MappingContextFactoryBuilder<S, K> mappingContextFactoryBuilder) {
        ConstantSourceMapperBuilder builder = this.newSubBuilder(owner.getPropertyClassMeta(), mappingContextFactoryBuilder, this.propertyMappingsBuilder.getPropertyFinder().getSubPropertyFinder(owner));
        for (PropertyMapping<T, ?, K> pm : properties) {
            SubPropertyMeta propertyMeta = (SubPropertyMeta)pm.getPropertyMeta();
            PropertyMeta subProperty = propertyMeta.getSubProperty();
            builder.addMapping(pm.getColumnKey(), pm.getColumnDefinition(), subProperty);
        }
        return builder.sourceFieldMapper();
    }

    protected <P> FieldMapper<S, T> newFieldMapper(PropertyMapping<T, P, K> t) {
        ColumnDefinition<K, FieldMapperProperty> columnDefinition = t.getColumnDefinition();
        FieldMapper<Object, Object> fieldMapper = null;
        if (columnDefinition.has(FieldMapperProperty.class)) {
            fieldMapper = columnDefinition.lookFor(FieldMapperProperty.class).getFieldMapper();
        }
        if (fieldMapper == null) {
            fieldMapper = this.fieldMapperFactory.newFieldMapper(t, this.mappingContextFactoryBuilder, this.mapperConfig.mapperBuilderErrorHandler());
        }
        return this.wrapFieldMapperWithErrorHandler(t.getColumnKey(), fieldMapper);
    }

    private <T> FieldMapper<S, T> wrapFieldMapperWithErrorHandler(K columnKey, FieldMapper<S, T> fieldMapper) {
        if (fieldMapper != null && this.mapperConfig.hasFieldMapperErrorHandler()) {
            return FieldErrorHandlerMapper.of(columnKey, fieldMapper, this.mapperConfig.fieldMapperErrorHandler());
        }
        return fieldMapper;
    }

    private <T> ContextualGetter<S, T> wrapGetterWithErrorHandler(K columnKey, ContextualGetter<S, T> getter) {
        if (getter != null && this.mapperConfig.hasFieldMapperErrorHandler()) {
            return FieldErrorHandlerGetter.of(columnKey, getter, this.mapperConfig.fieldMapperErrorHandler());
        }
        return getter;
    }

    @Override
    public void addMapper(FieldMapper<S, T> mapper) {
        this.additionalMappers.add(mapper);
    }

    private <ST> ConstantSourceMapperBuilder<S, ST, K> newSubBuilder(ClassMeta<ST> classMeta, MappingContextFactoryBuilder<S, K> mappingContextFactoryBuilder, PropertyFinder<ST> propertyFinder) {
        return ConstantSourceMapperBuilder.newConstantSourceMapperBuilder(this.mapperSource, classMeta, this.mapperConfig, mappingContextFactoryBuilder, this.keyFactory, propertyFinder);
    }

    @Override
    public List<K> getKeys() {
        return this.propertyMappingsBuilder.getKeys();
    }

    @Override
    public <H extends ForEachCallBack<PropertyMapping<T, ?, K>>> H forEachProperties(H handler) {
        return this.propertyMappingsBuilder.forEachProperties(handler);
    }

    private List<KeyAndPredicate<S, K>> getSubKeys(List<PropertyMapping<T, ?, K>> properties) {
        ArrayList<KeyAndPredicate<S, K>> keys = new ArrayList<KeyAndPredicate<S, K>>();
        for (PropertyMapping<T, ?, K> pm : properties) {
            Predicate<PropertyMeta<?, ?>> propertyMetaKeyPredicate = pm.getColumnDefinition().keyAppliesTo();
            if (pm.getPropertyMeta().isSubProperty()) {
                SubPropertyMeta subPropertyMeta = (SubPropertyMeta)pm.getPropertyMeta();
                if (JoinUtils.isArrayElement(subPropertyMeta.getSubProperty()) || !pm.getColumnDefinition().isKey() || !propertyMetaKeyPredicate.test((Object)subPropertyMeta.getSubProperty())) continue;
                Predicate<S> predicate = this.buildKeyPredicate(subPropertyMeta.getSubProperty(), propertyMetaKeyPredicate);
                keys.add(new KeyAndPredicate<S, K>(pm.getColumnKey(), predicate));
                continue;
            }
            if (!pm.getColumnDefinition().isKey() || !propertyMetaKeyPredicate.test(pm.getPropertyMeta())) continue;
            keys.add(new KeyAndPredicate(pm.getColumnKey(), null));
        }
        return keys;
    }

    private List<KeyAndPredicate<S, K>> getInferNulls(List<PropertyMapping<T, ?, K>> properties) {
        ArrayList<KeyAndPredicate<S, K>> keys = new ArrayList<KeyAndPredicate<S, K>>();
        for (PropertyMapping<T, ?, K> pm : properties) {
            Predicate<PropertyMeta<?, ?>> propertyMetaKeyPredicate = pm.getColumnDefinition().inferNullsAppliesTo();
            if (pm.getPropertyMeta().isSubProperty()) {
                SubPropertyMeta subPropertyMeta = (SubPropertyMeta)pm.getPropertyMeta();
                if (JoinUtils.isArrayElement(subPropertyMeta.getSubProperty()) || !pm.getColumnDefinition().isInferNull() || !propertyMetaKeyPredicate.test((Object)subPropertyMeta.getSubProperty())) continue;
                Predicate<S> predicate = this.buildKeyPredicate(subPropertyMeta.getSubProperty(), propertyMetaKeyPredicate);
                keys.add(new KeyAndPredicate<S, K>(pm.getColumnKey(), predicate));
                continue;
            }
            if (!pm.getColumnDefinition().isInferNull() || !propertyMetaKeyPredicate.test(pm.getPropertyMeta())) continue;
            keys.add(new KeyAndPredicate(pm.getColumnKey(), null));
        }
        return keys;
    }

    private Predicate<S> buildKeyPredicate(PropertyMeta<?, ?> propertyMeta, final Predicate<PropertyMeta<?, ?>> propertyMetaPredicate) {
        Predicate<S> predicate = null;
        if (propertyMeta instanceof DiscriminatorPropertyFinder.DiscriminatorPropertyMeta) {
            final DiscriminatorPropertyFinder.DiscriminatorPropertyMeta dpm = (DiscriminatorPropertyFinder.DiscriminatorPropertyMeta)propertyMeta;
            List not = dpm.forEachProperty(new BiConsumer<Type, PropertyMeta<?, ?>>(){
                List<Predicate<? super S>> not = new ArrayList();

                public void accept(Type type, PropertyMeta<?, ?> propertyMeta) {
                    if (!propertyMetaPredicate.test(propertyMeta)) {
                        MapperConfig.Discriminator<S, K, T>[] discriminators;
                        for (MapperConfig.Discriminator discriminator : discriminators = DefaultConstantSourceMapperBuilder.this.mapperConfig.getDiscriminators(dpm.getOwnerType())) {
                            this.not.add((Predicate)discriminator.getCase((Type)type).predicateFactory.apply(DefaultConstantSourceMapperBuilder.this.findAllDiscriminatorKeys()));
                        }
                    } else {
                        Predicate p = DefaultConstantSourceMapperBuilder.this.buildKeyPredicate(propertyMeta, propertyMetaPredicate);
                        if (p != null) {
                            this.not.add(p);
                        }
                    }
                }
            }).not;
            if (not.isEmpty()) {
                return null;
            }
            return new DiscriminatorKeyPredicate(not);
        }
        if (propertyMeta.isSubProperty()) {
            SubPropertyMeta subPropertyMeta = (SubPropertyMeta)propertyMeta;
            predicate = this.buildKeyPredicate(subPropertyMeta.getSubProperty(), propertyMetaPredicate);
        }
        return predicate;
    }

    public static String getterNotFoundErrorMessage(PropertyMapping propertyMapping) {
        String currentPath = propertyMapping.getPropertyMeta().getPath();
        return "Could not find getter for " + propertyMapping.getColumnKey() + " type " + propertyMapping.getPropertyMeta().getPropertyType() + " path " + currentPath + ". See " + ErrorDoc.CSFM_GETTER_NOT_FOUND.toUrl();
    }

    private static class DiscriminatorKeyPredicate<S>
    implements Predicate<S> {
        private final List<Predicate<? super S>> not;

        public DiscriminatorKeyPredicate(List<Predicate<? super S>> not) {
            this.not = not;
        }

        public boolean test(S s) {
            for (Predicate<? super S> predicate : this.not) {
                if (!predicate.test(s)) continue;
                return false;
            }
            return true;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DiscriminatorKeyPredicate that = (DiscriminatorKeyPredicate)o;
            return this.not != null ? this.not.equals(that.not) : that.not == null;
        }

        public int hashCode() {
            return this.not != null ? this.not.hashCode() : 0;
        }
    }

    private class ClassMetaSupplier<P>
    implements Supplier<ClassMeta<P>> {
        private final Type target;

        public ClassMetaSupplier(Type target) {
            this.target = target;
        }

        public ClassMeta<P> get() {
            return DefaultConstantSourceMapperBuilder.this.reflectionService.getClassMeta(this.target);
        }
    }

    private class FieldMapperFactoryGetterFactoryAdapter
    implements ContextualGetterFactory<S, K> {
        private final FieldMapperErrorHandler<? super K> fieldMapperErrorHandler;

        public FieldMapperFactoryGetterFactoryAdapter(FieldMapperErrorHandler<? super K> fieldMapperErrorHandler) {
            this.fieldMapperErrorHandler = fieldMapperErrorHandler;
        }

        @Override
        public <P> ContextualGetter<S, P> newGetter(Type target, K key, MappingContextFactoryBuilder<?, K> mappingContextFactoryBuilder, Object ... properties) {
            FieldMapperColumnDefinition columnDefinition = (FieldMapperColumnDefinition)FieldMapperColumnDefinition.identity().add(properties);
            ContextualGetter getterFromSource = DefaultConstantSourceMapperBuilder.this.fieldMapperFactory.getGetterFromSource(key, target, columnDefinition, new ClassMetaSupplier(target), mappingContextFactoryBuilder);
            if (this.fieldMapperErrorHandler != null) {
                return FieldErrorHandlerGetter.of(key, getterFromSource, this.fieldMapperErrorHandler);
            }
            return getterFromSource;
        }
    }

    private class PropertyPerOwner {
        private final PropertyMeta<T, ?> owner;
        private final List<PropertyMapping<T, ?, K>> propertyMappings;

        private PropertyPerOwner(PropertyMeta<T, ?> owner, List<PropertyMapping<T, ?, K>> propertyMappings) {
            this.owner = owner;
            this.propertyMappings = propertyMappings;
        }
    }

    public static class GenericBuilderGetterAndFieldMapper<S, T> {
        final ContextualGetter<S, Object> getter;
        final FieldMapper<S, T> fieldMapper;
        final Function<?, T> transform;
        final FieldMapper<S, T> fieldMapperAfterConstruct;

        private GenericBuilderGetterAndFieldMapper(ContextualGetter<S, Object> getter, FieldMapper<S, T> fieldMapper, Function<?, T> transform, FieldMapper<S, T> fieldMapperAfterConstruct) {
            this.getter = getter;
            this.fieldMapper = fieldMapper;
            this.transform = transform;
            this.fieldMapperAfterConstruct = fieldMapperAfterConstruct;
        }
    }

    public static class GetterAndFieldMapper<S, T> {
        final ContextualGetter<S, ?> getter;
        final FieldMapper<S, T> fieldMapper;

        private GetterAndFieldMapper(ContextualGetter<S, ?> getter, FieldMapper<S, T> fieldMapper) {
            this.getter = getter;
            this.fieldMapper = fieldMapper;
        }
    }

    public static class SubPropertyParam<S, T, K extends FieldKey<K>>
    extends InjectionParam<T> {
        final List<PropertyMapping<T, ?, K>> propertyMappings;
        final DefaultConstantSourceMapperBuilder<S, T, K> builder;

        private SubPropertyParam(Parameter parameter, ConstructorPropertyMeta<T, ?> propertyMeta, List<PropertyMapping<T, ?, K>> propertyMappings, DefaultConstantSourceMapperBuilder<S, T, K> builder) {
            super(parameter, (PropertyMeta)propertyMeta);
            this.propertyMappings = propertyMappings;
            this.builder = builder;
        }

        @Override
        public GetterAndFieldMapper getterAndfieldMapper() {
            MappingContextFactoryBuilder currentBuilder = ((DefaultConstantSourceMapperBuilder)this.builder).getMapperContextFactoryBuilder(this.propertyMeta, this.propertyMappings);
            SourceMapper<S, ?> mapper = this.getsSourceMapper(currentBuilder);
            ContextualGetter biFunction = ((DefaultConstantSourceMapperBuilder)this.builder).newMapperGetterAdapter(mapper, currentBuilder);
            FieldMapper fieldMapper = ((DefaultConstantSourceMapperBuilder)this.builder).newMapperFieldMapper(this.propertyMappings, this.propertyMeta, mapper, currentBuilder);
            return new GetterAndFieldMapper(biFunction, fieldMapper);
        }

        @Override
        GenericBuilderGetterAndFieldMapper getterAndfieldMapperGenericBuilder(int i) {
            MappingContextFactoryBuilder currentBuilder = ((DefaultConstantSourceMapperBuilder)this.builder).getMapperContextFactoryBuilder(this.propertyMeta, this.propertyMappings);
            SourceMapper<S, ?> mapper = this.getsSourceMapper(currentBuilder);
            Function transform = null;
            if (mapper instanceof TransformSourceFieldMapper) {
                transform = ((TransformSourceFieldMapper)mapper).transform;
                mapper = ((TransformSourceFieldMapper)mapper).delegate;
            }
            ContextualGetter biFunction = ((DefaultConstantSourceMapperBuilder)this.builder).newMapperGetterAdapter(mapper, currentBuilder);
            FieldMapper fieldMapper = ((DefaultConstantSourceMapperBuilder)this.builder).newMapperFieldMapper(this.propertyMappings, new GenericBuilderSetter(i), mapper, currentBuilder);
            FieldMapper fieldMapperAfterConstruct = ((DefaultConstantSourceMapperBuilder)this.builder).newMapperFieldMapper(this.propertyMappings, this.propertyMeta, mapper, currentBuilder);
            return new GenericBuilderGetterAndFieldMapper(biFunction, fieldMapper, transform, fieldMapperAfterConstruct);
        }

        @Override
        public boolean needTransformer() {
            if (this.needTransformer(this.propertyMeta)) {
                return true;
            }
            for (PropertyMapping<T, ?, K> pm : this.propertyMappings) {
                if (!this.needTransformer(pm.getPropertyMeta())) continue;
                return true;
            }
            return false;
        }

        private SourceMapper<S, ?> getsSourceMapper(MappingContextFactoryBuilder currentBuilder) {
            SourceMapper mapper = this.propertyMappings.size() == 1 && JoinUtils.isArrayElement(this.propertyMappings.get(0).getPropertyMeta()) ? ((DefaultConstantSourceMapperBuilder)this.builder).getterPropertyMapper(this.propertyMeta, this.propertyMappings.get(0)) : ((DefaultConstantSourceMapperBuilder)this.builder).subPropertyMapper(this.propertyMeta, this.propertyMappings, currentBuilder);
            return mapper;
        }

        private class GenericBuilderSetter<S, T>
        implements Setter<GenericBuilder<S, T>, Object> {
            private final int index;

            public GenericBuilderSetter(int index) {
                this.index = index;
            }

            public void set(GenericBuilder<S, T> target, Object value) throws Exception {
                target.objects[this.index] = value;
            }
        }
    }

    private class ContextParam
    extends InjectionParam {
        private ContextParam(Parameter parameter, ConstructorPropertyMeta<T, ?> propertyMeta) {
            super(parameter, (PropertyMeta)propertyMeta);
        }

        @Override
        public GetterAndFieldMapper getterAndfieldMapper() {
            ContextualGetter getter = this.getGetter();
            return new GetterAndFieldMapper(getter, null);
        }

        private ContextualGetter<S, Object> getGetter() {
            return new ContextualGetter<S, Object>(){

                @Override
                public Object get(S s, Context context) throws Exception {
                    return context;
                }
            };
        }

        @Override
        GenericBuilderGetterAndFieldMapper getterAndfieldMapperGenericBuilder(int index) {
            ContextualGetter getter = this.getGetter();
            GenericBuilderFieldMapper fieldMapper = new GenericBuilderFieldMapper(index, getter);
            return new GenericBuilderGetterAndFieldMapper(getter, fieldMapper, null, null);
        }

        @Override
        public boolean needTransformer() {
            return false;
        }
    }

    private static class GenericBuilderFieldMapper<S, T>
    implements FieldMapper<S, GenericBuilder<S, T>> {
        private final int index;
        private final ContextualGetter<? super S, ?> getter;

        public GenericBuilderFieldMapper(int index, ContextualGetter<? super S, ?> getter) {
            this.index = index;
            this.getter = getter;
        }

        @Override
        public void mapTo(S source, GenericBuilder<S, T> target, MappingContext<? super S> context) throws Exception {
            target.objects[this.index] = this.getter.get(source, context);
        }
    }

    private class ConstructorParam
    extends InjectionParam {
        private final PropertyMapping<T, ?, K> propertyMapping;

        private ConstructorParam(Parameter parameter, ConstructorPropertyMeta<T, ?> propertyMeta, PropertyMapping<T, ?, K> propertyMapping) {
            super(parameter, (PropertyMeta)propertyMeta);
            this.propertyMapping = propertyMapping;
        }

        @Override
        public GetterAndFieldMapper getterAndfieldMapper() {
            ContextualGetter getter = DefaultConstantSourceMapperBuilder.this.wrapGetterWithErrorHandler(this.propertyMapping.getColumnKey(), this.getGetter());
            FieldMapper fieldMapper = NullSetter.isNull((Setter)this.propertyMeta.getSetter()) ? null : DefaultConstantSourceMapperBuilder.this.wrapFieldMapperWithErrorHandler(this.propertyMapping.getColumnKey(), DefaultConstantSourceMapperBuilder.this.fieldMapperFactory.newFieldMapper(this.propertyMapping, DefaultConstantSourceMapperBuilder.this.mappingContextFactoryBuilder, DefaultConstantSourceMapperBuilder.this.mapperConfig.mapperBuilderErrorHandler()));
            return new GetterAndFieldMapper(getter, fieldMapper);
        }

        private ContextualGetter<? super S, ?> getGetter() {
            ContextualGetter getter = DefaultConstantSourceMapperBuilder.this.fieldMapperFactory.getGetterFromSource(this.propertyMapping.getColumnKey(), this.propertyMeta.getPropertyType(), this.propertyMapping.getColumnDefinition(), this.propertyMeta.getPropertyClassMetaSupplier(), DefaultConstantSourceMapperBuilder.this.mappingContextFactoryBuilder);
            if (NullContextualGetter.isNull(getter)) {
                PropertyMapping propertyMapping = this.propertyMapping;
                DefaultConstantSourceMapperBuilder.this.mapperConfig.mapperBuilderErrorHandler().accessorNotFound(DefaultConstantSourceMapperBuilder.getterNotFoundErrorMessage(propertyMapping));
            }
            return getter;
        }

        @Override
        GenericBuilderGetterAndFieldMapper getterAndfieldMapperGenericBuilder(int index) {
            ContextualGetter getter = this.getGetter();
            if (NullContextualGetter.isNull(getter)) {
                PropertyMapping propertyMapping = this.propertyMapping;
                DefaultConstantSourceMapperBuilder.this.mapperConfig.mapperBuilderErrorHandler().accessorNotFound(DefaultConstantSourceMapperBuilder.getterNotFoundErrorMessage(propertyMapping));
                return null;
            }
            FieldMapper fieldMapper = DefaultConstantSourceMapperBuilder.this.wrapFieldMapperWithErrorHandler(this.propertyMapping.getColumnKey(), new GenericBuilderFieldMapper(index, getter));
            FieldMapper fieldMapperAfterConstruct = NullSetter.isNull((Setter)this.propertyMeta.getSetter()) ? null : DefaultConstantSourceMapperBuilder.this.wrapFieldMapperWithErrorHandler(this.propertyMapping.getColumnKey(), DefaultConstantSourceMapperBuilder.this.fieldMapperFactory.newFieldMapper(this.propertyMapping, DefaultConstantSourceMapperBuilder.this.mappingContextFactoryBuilder, DefaultConstantSourceMapperBuilder.this.mapperConfig.mapperBuilderErrorHandler()));
            return new GenericBuilderGetterAndFieldMapper(getter, fieldMapper, null, fieldMapperAfterConstruct);
        }

        @Override
        public boolean needTransformer() {
            return this.needTransformer(this.propertyMeta);
        }
    }

    public static abstract class InjectionParam<T> {
        final Parameter parameter;
        final PropertyMeta<T, ?> propertyMeta;

        private InjectionParam(Parameter parameter, PropertyMeta<T, ?> propertyMeta) {
            this.parameter = parameter;
            this.propertyMeta = propertyMeta;
        }

        abstract GetterAndFieldMapper getterAndfieldMapper();

        abstract GenericBuilderGetterAndFieldMapper getterAndfieldMapperGenericBuilder(int var1);

        public abstract boolean needTransformer();

        boolean needTransformer(PropertyMeta<T, ?> propertyMeta) {
            if (propertyMeta.isSubProperty()) {
                SubPropertyMeta sb = (SubPropertyMeta)propertyMeta;
                return this.needTransformer(sb.getOwnerProperty()) || this.needTransformer(sb.getSubProperty());
            }
            return !propertyMeta.isSelf() && propertyMeta.getPropertyClassMeta().needTransformer();
        }
    }

    public static class ConstructorInjections<S, T> {
        private final Map<Parameter, ContextualGetter<? super S, ?>> parameterGetterMap;
        private final FieldMapper<S, T>[] fieldMappers;

        public ConstructorInjections(Map<Parameter, ContextualGetter<? super S, ?>> parameterGetterMap, FieldMapper<S, T>[] fieldMappers) {
            this.parameterGetterMap = parameterGetterMap;
            this.fieldMappers = fieldMappers;
        }
    }

    public static class InstantiatorAndFieldMappers<S, T> {
        public final ConstructorInjections<S, T> constructorInjections;
        public final BiInstantiator<S, MappingContext<? super S>, T> instantiator;

        public InstantiatorAndFieldMappers(ConstructorInjections constructorInjections, BiInstantiator<S, MappingContext<? super S>, T> instantiator) {
            this.constructorInjections = constructorInjections;
            this.instantiator = instantiator;
        }
    }

    public static class TargetFromBuilderWithTransformBiFunction
    implements BiFunction<Object[], Object, Object> {
        private final Function transformer;
        private final int builderIndex;

        public TargetFromBuilderWithTransformBiFunction(Function transformer, int builderIndex) {
            this.transformer = transformer;
            this.builderIndex = builderIndex;
        }

        public Object apply(Object[] objects, Object o) {
            return this.transformer.apply(objects[this.builderIndex]);
        }
    }

    public static class TargetFromBuilderParamBiFunction
    implements BiFunction<Object[], Object, Object> {
        private final int builderIndex;

        public TargetFromBuilderParamBiFunction(int builderIndex) {
            this.builderIndex = builderIndex;
        }

        public Object apply(Object[] objects, Object o) {
            return objects[this.builderIndex];
        }
    }

    class FieldMapperFieldMeta
    extends FieldMeta {
        final FieldMapper<S, T> fieldMapper;

        FieldMapperFieldMeta(FieldMapper<S, T> fieldMapper) {
            this.fieldMapper = fieldMapper;
        }

        @Override
        FieldMapper<S, T> targetFieldMapper() {
            return this.fieldMapper;
        }

        @Override
        public FieldGenericBuilderInfo fieldGenericBuilderInfo(int index) {
            throw new UnsupportedOperationException();
        }
    }

    class SubPropertyFieldMeta
    extends FieldMeta {
        final SourceMapper<S, ?> mapper;
        final List<PropertyMapping<T, ?, K>> propertyMappings;
        final PropertyMeta<T, ?> owner;
        final MappingContextFactoryBuilder<S, K> currentBuilder;

        SubPropertyFieldMeta(SourceMapper<S, ?> mapper, List<PropertyMapping<T, ?, K>> propertyMappings, PropertyMeta<T, ?> owner, MappingContextFactoryBuilder<S, K> currentBuilder) {
            this.mapper = mapper;
            this.propertyMappings = propertyMappings;
            this.owner = owner;
            this.currentBuilder = currentBuilder;
        }

        @Override
        FieldMapper<S, T> targetFieldMapper() {
            return DefaultConstantSourceMapperBuilder.this.newMapperFieldMapper(this.propertyMappings, this.owner, this.mapper, this.currentBuilder);
        }

        @Override
        public FieldGenericBuilderInfo fieldGenericBuilderInfo(final int index) {
            final Setter setter = this.owner.getSetter();
            return new FieldGenericBuilderInfo(this.targetFieldMapper(), DefaultConstantSourceMapperBuilder.this.newMapperFieldMapper(this.propertyMappings, new Setter(){

                public void set(Object target, Object value) throws Exception {
                    GenericBuilder genericBuilder = (GenericBuilder)target;
                    genericBuilder.objects[index] = value;
                }
            }, this.mapper, this.currentBuilder), new Setter<T, GenericBuilder<S, T>>(){

                public void set(T target, GenericBuilder<S, T> value) throws Exception {
                    setter.set(target, value.objects[index]);
                }
            });
        }
    }

    class PropertyFieldMeta
    extends FieldMeta {
        final PropertyMapping<T, ?, K> propertyMapping;

        PropertyFieldMeta(PropertyMapping<T, ?, K> propertyMapping) {
            this.propertyMapping = propertyMapping;
        }

        @Override
        public FieldMapper<S, T> targetFieldMapper() {
            return DefaultConstantSourceMapperBuilder.this.newFieldMapper(this.propertyMapping);
        }

        @Override
        public FieldGenericBuilderInfo fieldGenericBuilderInfo(final int index) {
            final Setter setter = this.propertyMapping.getPropertyMeta().getSetter();
            final ContextualGetter getter = DefaultConstantSourceMapperBuilder.this.fieldMapperFactory.getGetterFromSource(this.propertyMapping.getColumnKey(), this.propertyMapping.getPropertyMeta().getPropertyType(), this.propertyMapping.getColumnDefinition(), this.propertyMapping.getPropertyMeta().getPropertyClassMetaSupplier(), DefaultConstantSourceMapperBuilder.this.mappingContextFactoryBuilder);
            return new FieldGenericBuilderInfo(this.targetFieldMapper(), new FieldMapper<S, GenericBuilder<S, T>>(){

                @Override
                public void mapTo(S source, GenericBuilder<S, T> target, MappingContext<? super S> context) throws Exception {
                    target.objects[index] = getter.get(source, context);
                }
            }, new Setter<T, GenericBuilder<S, T>>(){

                public void set(T target, GenericBuilder<S, T> value) throws Exception {
                    setter.set(target, value.objects[index]);
                }
            });
        }
    }

    abstract class FieldMeta {
        FieldMeta() {
        }

        abstract FieldMapper<S, T> targetFieldMapper();

        public abstract FieldGenericBuilderInfo fieldGenericBuilderInfo(int var1);
    }

    class FieldGenericBuilderInfo {
        final FieldMapper<S, T> targetFieldMapper;
        final FieldMapper<S, GenericBuilder<S, T>> fieldMapperGeneric;
        final Setter<T, GenericBuilder<S, T>> fieldSetter;

        FieldGenericBuilderInfo(FieldMapper<S, T> targetFieldMapper, FieldMapper<S, GenericBuilder<S, T>> fieldMapperGeneric, Setter<T, GenericBuilder<S, T>> fieldSetter) {
            this.targetFieldMapper = targetFieldMapper;
            this.fieldMapperGeneric = fieldMapperGeneric;
            this.fieldSetter = fieldSetter;
        }
    }

    private static class StaticMethodFunction
    implements Function {
        private final Method buildMethod;

        public StaticMethodFunction(Method buildMethod) {
            this.buildMethod = buildMethod;
        }

        public Object apply(Object o) {
            try {
                return this.buildMethod.invoke(null, o);
            }
            catch (Exception e) {
                return ErrorHelper.rethrow((Throwable)e);
            }
        }
    }

    private static class MethodFunction
    implements Function {
        private final Method buildMethod;

        public MethodFunction(Method buildMethod) {
            this.buildMethod = buildMethod;
        }

        public Object apply(Object o) {
            try {
                return this.buildMethod.invoke(o, new Object[0]);
            }
            catch (Exception e) {
                return ErrorHelper.rethrow((Throwable)e);
            }
        }
    }

    public static class GenericBuildBiInstantiator<S, T>
    implements BiInstantiator<S, MappingContext<? super S>, GenericBuilder<S, T>> {
        private final BiInstantiator<Object[], Object, T> targetInstantiatorFromGenericBuilder;
        private final Setter<T, GenericBuilder<S, T>>[] targetFieldSetters;
        private final FieldMapper<S, GenericBuilder<S, T>>[] genericBuilderFieldMappers;

        public GenericBuildBiInstantiator(FieldMapper<S, GenericBuilder<S, T>>[] genericBuilderFieldMappers, BiInstantiator<Object[], Object, T> targetInstantiatorFromGenericBuilder, Setter<T, GenericBuilder<S, T>>[] targetFieldSetters) {
            this.genericBuilderFieldMappers = genericBuilderFieldMappers;
            this.targetInstantiatorFromGenericBuilder = targetInstantiatorFromGenericBuilder;
            this.targetFieldSetters = targetFieldSetters;
        }

        public GenericBuilder<S, T> newInstance(S o, MappingContext<? super S> o2) {
            return new GenericBuilder<S, T>(this.genericBuilderFieldMappers, this.targetInstantiatorFromGenericBuilder, this.targetFieldSetters);
        }
    }

    public static class GenericBuilderMapping<S, T, K extends FieldKey<K>> {
        public final GenericBuildBiInstantiator<S, T> genericBuilderInstantiator;
        public final InstantiatorAndFieldMappers<S, GenericBuilder<S, T>> instantiatorAndFieldMappers;
        public final FieldMapper<S, GenericBuilder<S, T>>[] genericBuilderFieldMappers;
        public final FieldMapper<S, T>[] targetFieldMappers;
        public final FieldKey<K>[] keys;

        public GenericBuilderMapping(GenericBuildBiInstantiator<S, T> genericBuilderInstantiator, InstantiatorAndFieldMappers<S, GenericBuilder<S, T>> instantiatorAndFieldMappers, FieldMapper<S, GenericBuilder<S, T>>[] genericBuilderFieldMappers, FieldMapper<S, T>[] targetFieldMappers, FieldKey<K>[] keys) {
            this.genericBuilderInstantiator = genericBuilderInstantiator;
            this.instantiatorAndFieldMappers = instantiatorAndFieldMappers;
            this.genericBuilderFieldMappers = genericBuilderFieldMappers;
            this.targetFieldMappers = targetFieldMappers;
            this.keys = keys;
        }
    }
}

