/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.map.fieldmapper;

import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.simpleflatmapper.converter.ContextualConverter;
import org.simpleflatmapper.converter.ConverterService;
import org.simpleflatmapper.map.FieldKey;
import org.simpleflatmapper.map.FieldMapper;
import org.simpleflatmapper.map.MapperBuilderErrorHandler;
import org.simpleflatmapper.map.context.MappingContextFactoryBuilder;
import org.simpleflatmapper.map.fieldmapper.BooleanConstantSourceFieldMapper;
import org.simpleflatmapper.map.fieldmapper.ByteConstantSourceFieldMapper;
import org.simpleflatmapper.map.fieldmapper.CharacterConstantSourceFieldMapper;
import org.simpleflatmapper.map.fieldmapper.ConstantSourceFieldMapper;
import org.simpleflatmapper.map.fieldmapper.ConstantSourceFieldMapperFactory;
import org.simpleflatmapper.map.fieldmapper.DoubleConstantSourceFieldMapper;
import org.simpleflatmapper.map.fieldmapper.FieldMapperGetterWithConverter;
import org.simpleflatmapper.map.fieldmapper.FloatConstantSourceFieldMapper;
import org.simpleflatmapper.map.fieldmapper.IntConstantSourceFieldMapper;
import org.simpleflatmapper.map.fieldmapper.LongConstantSourceFieldMapper;
import org.simpleflatmapper.map.fieldmapper.NullValueFilterSetter;
import org.simpleflatmapper.map.fieldmapper.ShortConstantSourceFieldMapper;
import org.simpleflatmapper.map.getter.BooleanContextualGetter;
import org.simpleflatmapper.map.getter.BoxedBooleanContextualGetter;
import org.simpleflatmapper.map.getter.BoxedByteContextualGetter;
import org.simpleflatmapper.map.getter.BoxedCharacterContextualGetter;
import org.simpleflatmapper.map.getter.BoxedDoubleContextualGetter;
import org.simpleflatmapper.map.getter.BoxedFloatContextualGetter;
import org.simpleflatmapper.map.getter.BoxedIntContextualGetter;
import org.simpleflatmapper.map.getter.BoxedLongContextualGetter;
import org.simpleflatmapper.map.getter.BoxedShortContextualGetter;
import org.simpleflatmapper.map.getter.ByteContextualGetter;
import org.simpleflatmapper.map.getter.CharacterContextualGetter;
import org.simpleflatmapper.map.getter.ContextualGetter;
import org.simpleflatmapper.map.getter.ContextualGetterAdapter;
import org.simpleflatmapper.map.getter.ContextualGetterFactory;
import org.simpleflatmapper.map.getter.ContextualGetterWithDefaultValue;
import org.simpleflatmapper.map.getter.DoubleContextualGetter;
import org.simpleflatmapper.map.getter.FloatContextualGetter;
import org.simpleflatmapper.map.getter.InstantiatorContextualGetter;
import org.simpleflatmapper.map.getter.IntContextualGetter;
import org.simpleflatmapper.map.getter.LongContextualGetter;
import org.simpleflatmapper.map.getter.ShortContextualGetter;
import org.simpleflatmapper.map.impl.JoinUtils;
import org.simpleflatmapper.map.mapper.ColumnDefinition;
import org.simpleflatmapper.map.mapper.DefaultConstantSourceMapperBuilder;
import org.simpleflatmapper.map.mapper.PropertyMapping;
import org.simpleflatmapper.map.property.ConverterProperty;
import org.simpleflatmapper.map.property.DefaultValueProperty;
import org.simpleflatmapper.reflect.Instantiator;
import org.simpleflatmapper.reflect.InstantiatorDefinition;
import org.simpleflatmapper.reflect.ObjectSetterFactory;
import org.simpleflatmapper.reflect.Setter;
import org.simpleflatmapper.reflect.instantiator.InstantiatorDefinitions;
import org.simpleflatmapper.reflect.meta.ClassMeta;
import org.simpleflatmapper.reflect.meta.PropertyMeta;
import org.simpleflatmapper.util.Supplier;
import org.simpleflatmapper.util.TypeHelper;

public final class ConstantSourceFieldMapperFactoryImpl<S, K extends FieldKey<K>>
implements ConstantSourceFieldMapperFactory<S, K> {
    private final ContextualGetterFactory<? super S, K> getterFactory;
    private final ConverterService converterService;
    private final Type sourceType;

    public ConstantSourceFieldMapperFactoryImpl(ContextualGetterFactory<? super S, K> getterFactory, ConverterService converterService, Type sourceType) {
        this.getterFactory = getterFactory;
        this.converterService = converterService;
        this.sourceType = sourceType;
    }

    private <T, P> FieldMapper<S, T> primitiveIndexedFieldMapper(Class<P> type, Setter<? super T, ? super P> setter, ContextualGetter<? super S, ? extends P> getter) {
        if (type.equals(Boolean.TYPE)) {
            return new BooleanConstantSourceFieldMapper(ConstantSourceFieldMapperFactoryImpl.toBooleanGetter(getter), ObjectSetterFactory.toBooleanSetter(setter));
        }
        if (type.equals(Integer.TYPE)) {
            return new IntConstantSourceFieldMapper(ConstantSourceFieldMapperFactoryImpl.toIntGetter(getter), ObjectSetterFactory.toIntSetter(setter));
        }
        if (type.equals(Long.TYPE)) {
            return new LongConstantSourceFieldMapper(ConstantSourceFieldMapperFactoryImpl.toLongGetter(getter), ObjectSetterFactory.toLongSetter(setter));
        }
        if (type.equals(Float.TYPE)) {
            return new FloatConstantSourceFieldMapper(ConstantSourceFieldMapperFactoryImpl.toFloatGetter(getter), ObjectSetterFactory.toFloatSetter(setter));
        }
        if (type.equals(Double.TYPE)) {
            return new DoubleConstantSourceFieldMapper(ConstantSourceFieldMapperFactoryImpl.toDoubleGetter(getter), ObjectSetterFactory.toDoubleSetter(setter));
        }
        if (type.equals(Byte.TYPE)) {
            return new ByteConstantSourceFieldMapper(ConstantSourceFieldMapperFactoryImpl.toByteGetter(getter), ObjectSetterFactory.toByteSetter(setter));
        }
        if (type.equals(Character.TYPE)) {
            return new CharacterConstantSourceFieldMapper(ConstantSourceFieldMapperFactoryImpl.toCharGetter(getter), ObjectSetterFactory.toCharacterSetter(setter));
        }
        if (type.equals(Short.TYPE)) {
            return new ShortConstantSourceFieldMapper(ConstantSourceFieldMapperFactoryImpl.toShortGetter(getter), ObjectSetterFactory.toShortSetter(setter));
        }
        throw new UnsupportedOperationException("Type " + type + " is not primitive");
    }

    public static <T> BooleanContextualGetter<T> toBooleanGetter(ContextualGetter<T, ? extends Boolean> getter) {
        if (getter instanceof BooleanContextualGetter) {
            return (BooleanContextualGetter)((Object)getter);
        }
        return new BoxedBooleanContextualGetter<T>(getter);
    }

    public static <T> IntContextualGetter<T> toIntGetter(ContextualGetter<T, ? extends Integer> getter) {
        if (getter instanceof IntContextualGetter) {
            return (IntContextualGetter)((Object)getter);
        }
        return new BoxedIntContextualGetter<T>(getter);
    }

    public static <T> LongContextualGetter<T> toLongGetter(ContextualGetter<T, ? extends Long> getter) {
        if (getter instanceof LongContextualGetter) {
            return (LongContextualGetter)((Object)getter);
        }
        return new BoxedLongContextualGetter<T>(getter);
    }

    public static <T> FloatContextualGetter<T> toFloatGetter(ContextualGetter<T, ? extends Float> getter) {
        if (getter instanceof FloatContextualGetter) {
            return (FloatContextualGetter)((Object)getter);
        }
        return new BoxedFloatContextualGetter<T>(getter);
    }

    public static <T> DoubleContextualGetter<T> toDoubleGetter(ContextualGetter<T, ? extends Double> getter) {
        if (getter instanceof DoubleContextualGetter) {
            return (DoubleContextualGetter)((Object)getter);
        }
        return new BoxedDoubleContextualGetter<T>(getter);
    }

    public static <T> ByteContextualGetter<T> toByteGetter(ContextualGetter<T, ? extends Byte> getter) {
        if (getter instanceof ByteContextualGetter) {
            return (ByteContextualGetter)((Object)getter);
        }
        return new BoxedByteContextualGetter<T>(getter);
    }

    public static <T> ShortContextualGetter<T> toShortGetter(ContextualGetter<T, ? extends Short> getter) {
        if (getter instanceof ShortContextualGetter) {
            return (ShortContextualGetter)((Object)getter);
        }
        return new BoxedShortContextualGetter<T>(getter);
    }

    public static <T> CharacterContextualGetter<T> toCharGetter(ContextualGetter<T, ? extends Character> getter) {
        if (getter instanceof CharacterContextualGetter) {
            return (CharacterContextualGetter)((Object)getter);
        }
        return new BoxedCharacterContextualGetter<T>(getter);
    }

    @Override
    public <T, P> FieldMapper<S, T> newFieldMapper(PropertyMapping<T, P, K> propertyMapping, MappingContextFactoryBuilder contextFactoryBuilder, MapperBuilderErrorHandler mappingErrorHandler) {
        PropertyMeta<T, P> propertyMeta = propertyMapping.getPropertyMeta();
        Type propertyType = propertyMeta.getPropertyType();
        Setter setter = propertyMeta.getSetter();
        K key = propertyMapping.getColumnKey();
        Class type = TypeHelper.toClass((Type)propertyType);
        ContextualGetter<S, P> getter = this.getGetterFromSource(key, propertyMapping.getPropertyMeta().getPropertyType(), propertyMapping.getColumnDefinition(), propertyMeta.getPropertyClassMetaSupplier(), contextFactoryBuilder);
        if (getter == null) {
            mappingErrorHandler.accessorNotFound(DefaultConstantSourceMapperBuilder.getterNotFoundErrorMessage(propertyMapping));
            return null;
        }
        if (type.isPrimitive()) {
            return this.primitiveIndexedFieldMapper(type, setter, getter);
        }
        if (propertyMapping.getColumnDefinition().isInferNull() && JoinUtils.isArrayElement(propertyMapping.getPropertyMeta())) {
            return new ConstantSourceFieldMapper(getter, new NullValueFilterSetter(setter));
        }
        return new ConstantSourceFieldMapper(getter, setter);
    }

    @Override
    public <P> ContextualGetter<? super S, ? extends P> getGetterFromSource(K columnKey, Type propertyType, ColumnDefinition<K, ?> columnDefinition, Supplier<ClassMeta<P>> propertyClassMetaSupplier, MappingContextFactoryBuilder<?, K> mappingContextFactoryBuilder) {
        Object value;
        DefaultValueProperty defaultValueProperty;
        ConverterProperty converterProperty;
        ContextualGetterFactory<?, K> customGetterFactory;
        ContextualGetter<Object, Object> getter = ContextualGetterAdapter.of(columnDefinition.getCustomGetterFrom(this.sourceType));
        if (getter == null && (customGetterFactory = columnDefinition.getCustomGetterFactoryFrom(this.sourceType)) != null) {
            getter = customGetterFactory.newGetter(propertyType, columnKey, mappingContextFactoryBuilder, columnDefinition.properties());
        }
        if ((converterProperty = columnDefinition.lookFor(ConverterProperty.class)) != null) {
            Type t = converterProperty.inType;
            if (Object.class.equals((Object)t)) {
                t = ((FieldKey)columnKey).getType(t);
            }
            if ((getter = this.getterFactory.newGetter(t, columnKey, mappingContextFactoryBuilder, columnDefinition.properties())) == null) {
                return null;
            }
            return new FieldMapperGetterWithConverter(converterProperty.function, getter);
        }
        if (getter == null) {
            getter = this.getterFactory.newGetter(propertyType, columnKey, mappingContextFactoryBuilder, columnDefinition.properties());
        }
        if (getter == null) {
            getter = this.lookForAlternativeGetter((ClassMeta)propertyClassMetaSupplier.get(), columnKey, columnDefinition, new HashSet<Type>(), mappingContextFactoryBuilder);
        }
        if ((defaultValueProperty = columnDefinition.lookFor(DefaultValueProperty.class)) != null && (value = defaultValueProperty.getValue()) != null) {
            if (TypeHelper.isAssignable((Type)propertyType, value.getClass())) {
                getter = new ContextualGetterWithDefaultValue(getter, value);
            } else {
                throw new IllegalArgumentException("Incompatible default value " + value + " type " + value.getClass() + " with property " + columnKey + " of type " + propertyType);
            }
        }
        return getter;
    }

    private <P, J> ContextualGetter<? super S, ? extends P> lookForAlternativeGetter(ClassMeta<P> classMeta, K key, ColumnDefinition<K, ?> columnDefinition, Collection<Type> types, MappingContextFactoryBuilder<?, K> mappingContextFactoryBuilder) {
        Object[] properties;
        Type propertyType = classMeta.getType();
        Type sourceType = ((FieldKey)key).getType(propertyType);
        ContextualConverter converter = this.converterService.findConverter(sourceType, propertyType, mappingContextFactoryBuilder, properties = columnDefinition.properties());
        if (converter != null) {
            ContextualGetter getter = this.getterFactory.newGetter(sourceType, key, mappingContextFactoryBuilder, properties);
            return new FieldMapperGetterWithConverter(converter, getter);
        }
        return this.lookForInstantiatorGetter(classMeta, key, columnDefinition, types, mappingContextFactoryBuilder);
    }

    public <P> ContextualGetter<? super S, ? extends P> lookForInstantiatorGetter(ClassMeta<P> classMeta, K key, ColumnDefinition<K, ?> columnDefinition, Collection<Type> types, MappingContextFactoryBuilder<?, K> mappingContextFactoryBuilder) {
        InstantiatorDefinitions.CompatibilityScorer scorer = InstantiatorDefinitions.getCompatibilityScorer(key);
        List instantiatorDefinitions = classMeta.getInstantiatorDefinitions();
        InstantiatorDefinition id = InstantiatorDefinitions.lookForCompatibleOneArgument((List)instantiatorDefinitions, (InstantiatorDefinitions.CompatibilityScorer)scorer);
        if (id != null) {
            return this.getGetterInstantiator(classMeta, id, key, columnDefinition, types, mappingContextFactoryBuilder);
        }
        return null;
    }

    private <T, P> ContextualGetter<? super S, ? extends P> getGetterInstantiator(ClassMeta<P> classMeta, InstantiatorDefinition id, K key, ColumnDefinition<K, ?> columnDefinition, Collection<Type> types, MappingContextFactoryBuilder<?, K> mappingContextFactoryBuilder) {
        Instantiator instantiator = classMeta.getReflectionService().getInstantiatorFactory().getOneArgIdentityInstantiator(id, classMeta.getReflectionService().builderIgnoresNullValues());
        Type paramType = id.getParameters()[0].getGenericType();
        ContextualGetter subGetter = this.getterFactory.newGetter(paramType, key, mappingContextFactoryBuilder, columnDefinition);
        if (subGetter == null) {
            if (types.contains(paramType)) {
                return null;
            }
            types.add(paramType);
            Type sourceType = ((FieldKey)key).getType(paramType);
            ContextualConverter converter = this.converterService.findConverter(sourceType, paramType, mappingContextFactoryBuilder, columnDefinition.properties());
            if (converter != null) {
                ContextualGetter sourceTypeGetter = this.getterFactory.newGetter(sourceType, key, mappingContextFactoryBuilder, columnDefinition);
                subGetter = new FieldMapperGetterWithConverter(converter, sourceTypeGetter);
            } else {
                subGetter = this.lookForInstantiatorGetter(classMeta.getReflectionService().getClassMeta(paramType), key, columnDefinition, types, mappingContextFactoryBuilder);
            }
        }
        if (subGetter != null) {
            return new InstantiatorContextualGetter(instantiator, subGetter);
        }
        return null;
    }
}

