/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.map.mapper;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.simpleflatmapper.map.CaseInsensitiveFieldKeyNamePredicate;
import org.simpleflatmapper.map.FieldKey;
import org.simpleflatmapper.map.MapperBuilderErrorHandler;
import org.simpleflatmapper.map.MapperBuildingException;
import org.simpleflatmapper.map.MapperConfig;
import org.simpleflatmapper.map.PropertyNameMatcherFactory;
import org.simpleflatmapper.map.impl.ExtendPropertyFinder;
import org.simpleflatmapper.map.mapper.ColumnDefinition;
import org.simpleflatmapper.map.mapper.PropertyMapping;
import org.simpleflatmapper.map.property.GetterProperty;
import org.simpleflatmapper.map.property.SetterProperty;
import org.simpleflatmapper.reflect.Setter;
import org.simpleflatmapper.reflect.TypeAffinity;
import org.simpleflatmapper.reflect.getter.NullGetter;
import org.simpleflatmapper.reflect.meta.ClassMeta;
import org.simpleflatmapper.reflect.meta.PropertyFinder;
import org.simpleflatmapper.reflect.meta.PropertyMeta;
import org.simpleflatmapper.reflect.meta.PropertyNameMatcher;
import org.simpleflatmapper.reflect.meta.SelfPropertyMeta;
import org.simpleflatmapper.reflect.setter.NullSetter;
import org.simpleflatmapper.util.BiConsumer;
import org.simpleflatmapper.util.Consumer;
import org.simpleflatmapper.util.ForEachCallBack;
import org.simpleflatmapper.util.Function;
import org.simpleflatmapper.util.NullConsumer;
import org.simpleflatmapper.util.Predicate;
import org.simpleflatmapper.util.TypeHelper;

public final class PropertyMappingsBuilder<T, K extends FieldKey<K>> {
    protected final PropertyFinder<T> propertyFinder;
    protected final List<PropertyMapping<T, ?, K>> properties = new ArrayList();
    protected final PropertyNameMatcherFactory propertyNameMatcherFactory;
    private final MapperBuilderErrorHandler mapperBuilderErrorHandler;
    private final ClassMeta<T> classMeta;
    private final PropertyMappingsBuilderProbe propertyMappingsBuilderProbe;
    protected boolean modifiable = true;
    private Consumer<K> propertyNotFoundConsumer;
    private List<ExtendPropertyFinder.CustomProperty<?, ?>> customProperties;

    private PropertyMappingsBuilder(final ClassMeta<T> classMeta, PropertyNameMatcherFactory propertyNameMatcherFactory, final MapperBuilderErrorHandler mapperBuilderErrorHandler, Predicate<PropertyMeta<?, ?>> isValidPropertyMeta, PropertyFinder<T> propertyFinder, List<ExtendPropertyFinder.CustomProperty<?, ?>> customProperties, PropertyMappingsBuilderProbe propertyMappingsBuilderProbe) throws MapperBuildingException {
        this.mapperBuilderErrorHandler = mapperBuilderErrorHandler;
        this.customProperties = customProperties;
        this.propertyMappingsBuilderProbe = propertyMappingsBuilderProbe;
        this.propertyFinder = propertyFinder != null ? propertyFinder : classMeta.newPropertyFinder(isValidPropertyMeta);
        this.propertyNameMatcherFactory = propertyNameMatcherFactory;
        this.classMeta = classMeta;
        this.propertyNotFoundConsumer = new Consumer<K>(){

            public void accept(K k) {
                mapperBuilderErrorHandler.propertyNotFound(classMeta.getType(), ((FieldKey)k).getName());
            }
        };
    }

    public <P> PropertyMapping<T, P, K> addProperty(K key, ColumnDefinition<K, ?> columnDefinition) {
        return this._addProperty(key, columnDefinition, this.propertyNotFoundConsumer);
    }

    public <P> PropertyMapping<T, P, K> addPropertyIfPresent(K key, ColumnDefinition<K, ?> columnDefinition) {
        return this._addProperty(key, columnDefinition, (Consumer<? super K>)NullConsumer.INSTANCE);
    }

    private <P> PropertyMapping<T, P, K> _addProperty(K key, ColumnDefinition<K, ?> columnDefinition, Consumer<? super K> propertyNotFound) {
        PropertyNameMatcher propertyNameMatcher;
        if (!this.modifiable) {
            throw new IllegalStateException("Builder not modifiable");
        }
        if (columnDefinition.ignore()) {
            this.propertyMappingsBuilderProbe.ignore((FieldKey)key, columnDefinition);
            this.properties.add(null);
            return null;
        }
        PropertyFinder<T> effectivePropertyFinder = this.wrapPropertyFinder(this.propertyFinder);
        PropertyMeta prop = effectivePropertyFinder.findProperty(propertyNameMatcher = this.propertyNameMatcherFactory.newInstance((FieldKey<?>)key), columnDefinition.properties(), this.toTypeAffinity(key), this.propertyMappingsBuilderProbe.propertyFinderProbe(propertyNameMatcher));
        if (prop == null) {
            propertyNotFound.accept(key);
            this.properties.add(null);
            return null;
        }
        PropertyMapping<T, P, K> propertyMapping = this.addProperty(key, columnDefinition, prop);
        this.propertyMappingsBuilderProbe.map((FieldKey)key, columnDefinition, (PropertyMeta<?, ?>)prop);
        this.handleSelfPropertyMetaInvalidation(propertyNotFound);
        return propertyMapping;
    }

    private TypeAffinity toTypeAffinity(K key) {
        if (key instanceof TypeAffinity) {
            return (TypeAffinity)key;
        }
        return null;
    }

    private <T> PropertyFinder<T> wrapPropertyFinder(PropertyFinder<T> propertyFinder) {
        if (!this.customProperties.isEmpty()) {
            return new ExtendPropertyFinder<T>(propertyFinder, this.customProperties, new Function<PropertyFinder.PropertyFinderTransformer, PropertyFinder.PropertyFinderTransformer>(){

                public PropertyFinder.PropertyFinderTransformer apply(PropertyFinder.PropertyFinderTransformer propertyFinderTransformer) {
                    return new ExtendPropertyFinder.ExtendPropertyFinderTransformer(propertyFinderTransformer, PropertyMappingsBuilder.this.customProperties);
                }
            });
        }
        return propertyFinder;
    }

    private void handleSelfPropertyMetaInvalidation(Consumer<? super K> propertyNotFound) {
        ArrayList<K> invalidateKeys = new ArrayList<K>();
        ListIterator<PropertyMapping<T, ?, K>> iterator = this.properties.listIterator();
        while (iterator.hasNext()) {
            PropertyMapping<T, ?, K> propertyMapping = iterator.next();
            if (propertyMapping == null || propertyMapping.getPropertyMeta().isValid()) continue;
            iterator.set(null);
            invalidateKeys.add(propertyMapping.getColumnKey());
        }
        for (FieldKey k : invalidateKeys) {
            propertyNotFound.accept((Object)k);
        }
    }

    public <P> PropertyMapping<T, P, K> addProperty(K key, ColumnDefinition<K, ?> columnDefinition, PropertyMeta<T, P> prop) {
        Object[] definedProperties;
        if (columnDefinition.hasCustomSourceFrom(prop.getOwnerType())) {
            Type type = prop.getPropertyType();
            if (!this.checkTypeCompatibility(key, columnDefinition.getCustomSourceReturnTypeFrom(prop.getOwnerType()), type)) {
                this.properties.add(null);
                return null;
            }
        }
        ColumnDefinition<K, ?> mergeColumnDefinition = (definedProperties = prop.getDefinedProperties()) != null ? columnDefinition.add(definedProperties) : columnDefinition;
        PropertyMapping<T, P, K> propertyMapping = new PropertyMapping<T, P, K>(prop, key, mergeColumnDefinition);
        this.properties.add(propertyMapping);
        this.propertyFinder.manualMatch(prop);
        return propertyMapping;
    }

    private boolean checkTypeCompatibility(K key, Type customSourceReturnType, Type propertyMetaType) {
        if (customSourceReturnType == null) {
            return true;
        }
        if (!this.areCompatible(propertyMetaType, customSourceReturnType)) {
            this.mapperBuilderErrorHandler.customFieldError((FieldKey<?>)key, "Incompatible customReader on '" + ((FieldKey)key).getName() + "' type " + customSourceReturnType + " expected " + propertyMetaType);
            return false;
        }
        return true;
    }

    private boolean areCompatible(Type propertyMetaType, Type customSourceReturnType) {
        Class propertyMetaClass = TypeHelper.toBoxedClass((Class)TypeHelper.toClass((Type)propertyMetaType));
        Class customSourceReturnClass = TypeHelper.toBoxedClass((Class)TypeHelper.toClass((Type)customSourceReturnType));
        return propertyMetaClass.isAssignableFrom(customSourceReturnClass);
    }

    public List<K> getKeys() {
        this.modifiable = false;
        ArrayList<K> keys = new ArrayList<K>(this.properties.size());
        for (PropertyMapping<T, ?, K> propMapping : this.properties) {
            if (propMapping != null) {
                keys.add(propMapping.getColumnKey());
                continue;
            }
            keys.add(null);
        }
        return keys;
    }

    public void forEachConstructorProperties(ForEachCallBack<PropertyMapping<T, ?, K>> handler) {
        this.modifiable = false;
        for (PropertyMapping<T, ?, K> property : this.properties) {
            PropertyMeta<T, ?> propertyMeta;
            if (property == null || (propertyMeta = property.getPropertyMeta()) == null || !propertyMeta.isConstructorProperty() || propertyMeta.isSubProperty()) continue;
            handler.handle(property);
        }
    }

    public List<PropertyMapping<T, ?, K>> currentProperties() {
        return new ArrayList(this.properties);
    }

    public <H extends ForEachCallBack<PropertyMapping<T, ?, K>>> H forEachProperties(H handler) {
        return this.forEachProperties(handler, -1);
    }

    public <F extends ForEachCallBack<PropertyMapping<T, ?, K>>> F forEachProperties(F handler, int start) {
        return this.forEachProperties(handler, start, -1);
    }

    public <F extends ForEachCallBack<PropertyMapping<T, ?, K>>> F forEachProperties(F handler, int start, int end) {
        this.modifiable = false;
        for (PropertyMapping<T, ?, K> prop : this.properties) {
            if (prop == null || ((FieldKey)prop.getColumnKey()).getIndex() < start && start != -1 || ((FieldKey)prop.getColumnKey()).getIndex() >= end && end != -1) continue;
            handler.handle(prop);
        }
        return handler;
    }

    public PropertyFinder<T> getPropertyFinder() {
        this.modifiable = false;
        return this.propertyFinder;
    }

    public int size() {
        return this.properties.size();
    }

    public boolean isSelfProperty() {
        return this.properties.size() == 1 && this.properties.get(0) != null && this.properties.get(0).getPropertyMeta() instanceof SelfPropertyMeta;
    }

    public int maxIndex() {
        int i = -1;
        for (PropertyMapping<T, ?, K> prop : this.properties) {
            if (prop == null) continue;
            i = Math.max(i, ((FieldKey)prop.getColumnKey()).getIndex());
        }
        return i;
    }

    public boolean hasKey(Predicate<? super K> predicate) {
        for (PropertyMapping<T, ?, K> propMapping : this.properties) {
            if (propMapping == null || !predicate.test(propMapping.getColumnKey())) continue;
            return true;
        }
        return false;
    }

    public ClassMeta<T> getClassMeta() {
        return this.classMeta;
    }

    public static <T, K extends FieldKey<K>> PropertyMappingsBuilder<T, K> of(ClassMeta<T> classMeta, MapperConfig<K> mapperConfig, Predicate<PropertyMeta<?, ?>> propertyPredicate) {
        return PropertyMappingsBuilder.of(classMeta, mapperConfig, propertyPredicate, null);
    }

    public static <T, K extends FieldKey<K>> PropertyMappingsBuilder<T, K> of(final ClassMeta<T> classMeta, MapperConfig<K> mapperConfig, final Predicate<PropertyMeta<?, ?>> propertyPredicate, PropertyFinder<T> propertyFinder) {
        final ArrayList customProperties = new ArrayList();
        mapperConfig.columnDefinitions().forEach(SetterProperty.class, new BiConsumer<Predicate<? super K>, SetterProperty>(){

            public void accept(Predicate<? super K> predicate, SetterProperty setterProperty) {
                if (predicate instanceof CaseInsensitiveFieldKeyNamePredicate) {
                    CaseInsensitiveFieldKeyNamePredicate p = (CaseInsensitiveFieldKeyNamePredicate)predicate;
                    ExtendPropertyFinder.CustomProperty cp = new ExtendPropertyFinder.CustomProperty(setterProperty.getTargetType(), classMeta.getReflectionService(), p.getName(), setterProperty.getPropertyType(), setterProperty.getSetter(), NullGetter.getter());
                    if (propertyPredicate.test(cp)) {
                        customProperties.add(cp);
                    }
                }
            }
        });
        mapperConfig.columnDefinitions().forEach(GetterProperty.class, new BiConsumer<Predicate<? super K>, GetterProperty>(){

            public void accept(Predicate<? super K> predicate, GetterProperty getterProperty) {
                if (predicate instanceof CaseInsensitiveFieldKeyNamePredicate) {
                    CaseInsensitiveFieldKeyNamePredicate p = (CaseInsensitiveFieldKeyNamePredicate)predicate;
                    ExtendPropertyFinder.CustomProperty cp = new ExtendPropertyFinder.CustomProperty(getterProperty.getSourceType(), classMeta.getReflectionService(), p.getName(), getterProperty.getReturnType(), (Setter<?, ?>)NullSetter.NULL_SETTER, getterProperty.getGetter());
                    if (propertyPredicate.test(cp)) {
                        customProperties.add(cp);
                    }
                }
            }
        });
        return new PropertyMappingsBuilder<T, K>(classMeta, mapperConfig.propertyNameMatcherFactory(), mapperConfig.mapperBuilderErrorHandler(), propertyPredicate, propertyFinder, customProperties, DefaultPropertyMappingsBuilderProbe.INSTANCE);
    }

    private static class DefaultPropertyMappingsBuilderProbe
    implements PropertyMappingsBuilderProbe {
        static final DefaultPropertyMappingsBuilderProbe INSTANCE = new DefaultPropertyMappingsBuilderProbe();
        private static final boolean DEBUG = Boolean.getBoolean("org.simpleflatmapper.probe.propertyMappingsBuilder");

        private DefaultPropertyMappingsBuilderProbe() {
        }

        @Override
        public void ignore(FieldKey key, ColumnDefinition columnDefinition) {
            if (DEBUG) {
                System.out.println("PropertyMappingsBuilder - ignore " + key);
            }
        }

        @Override
        public void map(FieldKey key, ColumnDefinition columnDefinition, PropertyMeta<?, ?> prop) {
            if (DEBUG) {
                String path = prop.getPath();
                System.out.println("PropertyMappingsBuilder - map " + key.getName() + " to " + path);
            }
        }

        @Override
        public PropertyFinder.PropertyFinderProbe propertyFinderProbe(PropertyNameMatcher matcher) {
            return new PropertyFinder.DefaultPropertyFinderProbe(matcher);
        }
    }

    public static interface PropertyMappingsBuilderProbe {
        public void ignore(FieldKey var1, ColumnDefinition var2);

        public void map(FieldKey var1, ColumnDefinition var2, PropertyMeta<?, ?> var3);

        public PropertyFinder.PropertyFinderProbe propertyFinderProbe(PropertyNameMatcher var1);
    }
}

