/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.map.mapper;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.simpleflatmapper.converter.Context;
import org.simpleflatmapper.converter.ConverterService;
import org.simpleflatmapper.map.FieldKey;
import org.simpleflatmapper.map.FieldMapper;
import org.simpleflatmapper.map.FieldMapperErrorHandler;
import org.simpleflatmapper.map.MapperBuildingException;
import org.simpleflatmapper.map.MapperConfig;
import org.simpleflatmapper.map.MappingContext;
import org.simpleflatmapper.map.SourceFieldMapper;
import org.simpleflatmapper.map.SourceMapper;
import org.simpleflatmapper.map.asm.MapperAsmFactory;
import org.simpleflatmapper.map.context.MappingContextFactory;
import org.simpleflatmapper.map.context.MappingContextFactoryBuilder;
import org.simpleflatmapper.map.fieldmapper.ConstantSourceFieldMapperFactory;
import org.simpleflatmapper.map.fieldmapper.ConstantSourceFieldMapperFactoryImpl;
import org.simpleflatmapper.map.fieldmapper.MapperFieldMapper;
import org.simpleflatmapper.map.getter.ContextualGetter;
import org.simpleflatmapper.map.getter.ContextualGetterFactory;
import org.simpleflatmapper.map.getter.NullContextualGetter;
import org.simpleflatmapper.map.impl.FieldErrorHandlerGetter;
import org.simpleflatmapper.map.impl.FieldErrorHandlerMapper;
import org.simpleflatmapper.map.impl.GenericBuilder;
import org.simpleflatmapper.map.impl.GetterMapper;
import org.simpleflatmapper.map.impl.JoinUtils;
import org.simpleflatmapper.map.mapper.AbstractMapper;
import org.simpleflatmapper.map.mapper.ColumnDefinition;
import org.simpleflatmapper.map.mapper.ContextualSourceFieldMapperImpl;
import org.simpleflatmapper.map.mapper.KeyFactory;
import org.simpleflatmapper.map.mapper.MapperBiInstantiatorFactory;
import org.simpleflatmapper.map.mapper.MapperFieldMapperGetterAdapter;
import org.simpleflatmapper.map.mapper.MapperImpl;
import org.simpleflatmapper.map.mapper.MapperSource;
import org.simpleflatmapper.map.mapper.MissingPropertyException;
import org.simpleflatmapper.map.mapper.PropertyMapping;
import org.simpleflatmapper.map.mapper.PropertyMappingsBuilder;
import org.simpleflatmapper.map.mapper.PropertyWithSetterOrConstructor;
import org.simpleflatmapper.map.mapper.TransformSourceFieldMapper;
import org.simpleflatmapper.map.property.DefaultValueProperty;
import org.simpleflatmapper.map.property.FieldMapperColumnDefinition;
import org.simpleflatmapper.map.property.FieldMapperProperty;
import org.simpleflatmapper.map.property.GetterProperty;
import org.simpleflatmapper.map.property.MandatoryProperty;
import org.simpleflatmapper.reflect.BiInstantiator;
import org.simpleflatmapper.reflect.BuilderBiInstantiator;
import org.simpleflatmapper.reflect.BuilderInstantiatorDefinition;
import org.simpleflatmapper.reflect.Getter;
import org.simpleflatmapper.reflect.InstantiatorDefinition;
import org.simpleflatmapper.reflect.InstantiatorFactory;
import org.simpleflatmapper.reflect.Parameter;
import org.simpleflatmapper.reflect.ReflectionService;
import org.simpleflatmapper.reflect.Setter;
import org.simpleflatmapper.reflect.asm.AsmFactory;
import org.simpleflatmapper.reflect.getter.ConstantGetter;
import org.simpleflatmapper.reflect.meta.ArrayClassMeta;
import org.simpleflatmapper.reflect.meta.ClassMeta;
import org.simpleflatmapper.reflect.meta.ConstructorPropertyMeta;
import org.simpleflatmapper.reflect.meta.ObjectClassMeta;
import org.simpleflatmapper.reflect.meta.PropertyFinder;
import org.simpleflatmapper.reflect.meta.PropertyMeta;
import org.simpleflatmapper.reflect.meta.SelfPropertyMeta;
import org.simpleflatmapper.reflect.meta.SubPropertyMeta;
import org.simpleflatmapper.reflect.setter.NullSetter;
import org.simpleflatmapper.util.Asserts;
import org.simpleflatmapper.util.BiConsumer;
import org.simpleflatmapper.util.BiFunction;
import org.simpleflatmapper.util.ErrorDoc;
import org.simpleflatmapper.util.ErrorHelper;
import org.simpleflatmapper.util.ForEachCallBack;
import org.simpleflatmapper.util.Function;
import org.simpleflatmapper.util.Named;
import org.simpleflatmapper.util.Predicate;
import org.simpleflatmapper.util.Supplier;
import org.simpleflatmapper.util.TypeHelper;
import org.simpleflatmapper.util.UnaryFactory;

public final class ConstantSourceMapperBuilder<S, T, K extends FieldKey<K>> {
    private static final FieldKey[] FIELD_KEYS = new FieldKey[0];
    public static final FieldMapper[] EMPTY_FIELD_MAPPERS = new FieldMapper[0];
    private final Type target;
    private final ConstantSourceFieldMapperFactory<S, K> fieldMapperFactory;
    protected final PropertyMappingsBuilder<T, K> propertyMappingsBuilder;
    protected final ReflectionService reflectionService;
    private final List<FieldMapper<S, T>> additionalMappers = new ArrayList<FieldMapper<S, T>>();
    private final MapperSource<? super S, K> mapperSource;
    private final MapperConfig<K> mapperConfig;
    protected final MappingContextFactoryBuilder<? super S, K> mappingContextFactoryBuilder;
    private final KeyFactory<K> keyFactory;

    public ConstantSourceMapperBuilder(MapperSource<? super S, K> mapperSource, ClassMeta<T> classMeta, MapperConfig<K> mapperConfig, MappingContextFactoryBuilder<? super S, K> mappingContextFactoryBuilder, KeyFactory<K> keyFactory) throws MapperBuildingException {
        this(mapperSource, classMeta, mapperConfig, mappingContextFactoryBuilder, keyFactory, null);
    }

    public ConstantSourceMapperBuilder(MapperSource<? super S, K> mapperSource, ClassMeta<T> classMeta, MapperConfig<K> mapperConfig, MappingContextFactoryBuilder<? super S, K> mappingContextFactoryBuilder, KeyFactory<K> keyFactory, PropertyFinder<T> propertyFinder) throws MapperBuildingException {
        this.mapperSource = (MapperSource)Asserts.requireNonNull((String)"fieldMapperSource", mapperSource);
        this.mapperConfig = (MapperConfig)Asserts.requireNonNull((String)"mapperConfig", mapperConfig);
        this.mappingContextFactoryBuilder = mappingContextFactoryBuilder;
        this.fieldMapperFactory = new ConstantSourceFieldMapperFactoryImpl<S, K>(mapperSource.getterFactory(), ConverterService.getInstance(), mapperSource.source());
        this.keyFactory = keyFactory;
        this.propertyMappingsBuilder = PropertyMappingsBuilder.of(classMeta, mapperConfig, PropertyWithSetterOrConstructor.INSTANCE, propertyFinder);
        this.target = ((ClassMeta)Asserts.requireNonNull((String)"classMeta", classMeta)).getType();
        this.reflectionService = ((ClassMeta)Asserts.requireNonNull((String)"classMeta", classMeta)).getReflectionService();
    }

    public final ConstantSourceMapperBuilder<S, T, K> addMapping(K key, ColumnDefinition<K, ?> columnDefinition) {
        Object composedDefinition = columnDefinition.compose(this.mapperConfig.columnDefinitions().getColumnDefinition(key));
        K mappedColumnKey = ((ColumnDefinition)composedDefinition).rename(key);
        FieldMapperProperty prop = columnDefinition.lookFor(FieldMapperProperty.class);
        if (prop != null) {
            this.addMapper(prop.getFieldMapper());
        } else {
            ColumnDefinition<K, ?> effectiveColumnDefinition;
            PropertyMapping propertyMapping = this.propertyMappingsBuilder.addProperty(mappedColumnKey, (ColumnDefinition<K, ?>)composedDefinition);
            if (propertyMapping != null && (effectiveColumnDefinition = propertyMapping.getColumnDefinition()).isKey() && effectiveColumnDefinition.keyAppliesTo().test(propertyMapping.getPropertyMeta())) {
                this.mappingContextFactoryBuilder.addKey(key);
            }
        }
        return this;
    }

    public ContextualSourceFieldMapperImpl<S, T> mapper() {
        SourceFieldMapper<S, T> mapper = this.sourceFieldMapper();
        return new ContextualSourceFieldMapperImpl<S, T>(this.mappingContextFactoryBuilder.build(), mapper);
    }

    public SourceFieldMapper<S, T> sourceFieldMapper() {
        SourceFieldMapper<S, T> mapper;
        this.mapperConfig.columnDefinitions().forEach(DefaultValueProperty.class, new BiConsumer<Predicate<? super K>, DefaultValueProperty>(){

            public void accept(Predicate<? super K> predicate, DefaultValueProperty columnProperty) {
                if (ConstantSourceMapperBuilder.this.propertyMappingsBuilder.hasKey(predicate)) {
                    return;
                }
                if (predicate instanceof Named) {
                    String name = ((Named)predicate).getName();
                    GetterProperty getterProperty = new GetterProperty((Getter<?, ?>)new ConstantGetter(columnProperty.getValue()), ConstantSourceMapperBuilder.this.mapperSource.source(), columnProperty.getValue().getClass());
                    FieldMapperColumnDefinition columnDefinition = (FieldMapperColumnDefinition)FieldMapperColumnDefinition.identity().add(columnProperty, getterProperty);
                    ConstantSourceMapperBuilder.this.propertyMappingsBuilder.addPropertyIfPresent(ConstantSourceMapperBuilder.this.keyFactory.newKey(name, ConstantSourceMapperBuilder.this.propertyMappingsBuilder.maxIndex() + 1), columnDefinition);
                }
            }
        });
        final ArrayList<String> missingProperties = new ArrayList<String>();
        this.mapperConfig.columnDefinitions().forEach(MandatoryProperty.class, new BiConsumer<Predicate<? super K>, MandatoryProperty>(){

            public void accept(Predicate<? super K> predicate, MandatoryProperty columnProperty) {
                if (!ConstantSourceMapperBuilder.this.propertyMappingsBuilder.hasKey(predicate)) {
                    if (predicate instanceof Named) {
                        missingProperties.add(((Named)predicate).getName());
                    } else {
                        missingProperties.add(predicate.toString());
                    }
                }
            }
        });
        if (!missingProperties.isEmpty()) {
            throw new MissingPropertyException(missingProperties);
        }
        List<InjectionParam> injectionParams = this.constructorInjections();
        if (this.isTargetForTransformer(injectionParams)) {
            mapper = this.buildMapperWithTransformer(injectionParams);
        } else {
            ConstructorInjections<T> constructorInjections = this.toConstructorInjections(injectionParams);
            InstantiatorAndFieldMappers<T> constructorFieldMappersAndInstantiator = this.getConstructorFieldMappersAndInstantiator(constructorInjections);
            mapper = this.buildMapper(this.targetFieldMappers(), constructorFieldMappersAndInstantiator, this.getTargetClass());
        }
        return mapper;
    }

    private boolean isTargetForTransformer(List<InjectionParam> injectionParams) {
        return this.propertyMappingsBuilder.getClassMeta().needTransformer() || this.needGenericBuilder(injectionParams) || this.mapperConfig.assumeInjectionModifiesValues() && !this.mappingContextFactoryBuilder.hasNoDependentKeys() && !injectionParams.isEmpty();
    }

    private SourceFieldMapper<S, T> buildMapperWithTransformer(List<InjectionParam> injections) {
        boolean forceGenericBuilder = this.needGenericBuilder(injections);
        BuilderInstantiatorDefinition mutableBuilder = this.getMutableBuilder();
        if (!forceGenericBuilder && mutableBuilder != null) {
            return this.builderWithTransformer(injections, mutableBuilder);
        }
        return this.buildWithGenericBuilder(injections);
    }

    private boolean needGenericBuilder(List<InjectionParam> injections) {
        boolean forceGenericBuilder = false;
        for (InjectionParam ip : injections) {
            if (!ip.needTransformer()) continue;
            forceGenericBuilder = true;
            break;
        }
        return forceGenericBuilder;
    }

    private BuilderInstantiatorDefinition getMutableBuilder() {
        List eligibleInstantiatorDefinitions = this.propertyMappingsBuilder.getPropertyFinder().getEligibleInstantiatorDefinitions();
        for (int i = 0; i < eligibleInstantiatorDefinitions.size(); ++i) {
            BuilderInstantiatorDefinition bid;
            InstantiatorDefinition instantiatorDefinition = (InstantiatorDefinition)eligibleInstantiatorDefinitions.get(i);
            if (instantiatorDefinition.getType() != InstantiatorDefinition.Type.BUILDER || !(bid = (BuilderInstantiatorDefinition)instantiatorDefinition).isMutable()) continue;
            return bid;
        }
        return null;
    }

    private SourceFieldMapper<S, T> buildWithGenericBuilder(List<InjectionParam> params) {
        List<FieldMeta> fields = this.fields();
        Class<GenericBuilder> targetClass = GenericBuilder.class;
        int nbParams = params.size();
        ContextualGetter[] biFunctions = new ContextualGetter[nbParams];
        Parameter[] indexMapping = new Parameter[nbParams];
        Function[] transformers = new Function[nbParams];
        HashMap parameterGetterMap = new HashMap();
        ArrayList constructorFieldMapperGeneric = new ArrayList();
        ArrayList constructFieldMapperTarget = new ArrayList();
        ArrayList targetFieldMappers = new ArrayList();
        ArrayList fieldMapperGeneric = new ArrayList();
        ArrayList fieldSetters = new ArrayList();
        int i = 0;
        for (InjectionParam p : params) {
            ContextualGetter biFunction;
            GenericBuilderGetterAndFieldMapper getterAndFieldMapper = p.getterAndfieldMapperGenericBuilder(i);
            parameterGetterMap.put(p.parameter, getterAndFieldMapper.getter);
            if (getterAndFieldMapper.fieldMapper != null) {
                constructorFieldMapperGeneric.add(getterAndFieldMapper.fieldMapper);
                constructFieldMapperTarget.add(getterAndFieldMapper.fieldMapperAfterConstruct);
            }
            biFunctions[i] = biFunction = getterAndFieldMapper.getter;
            indexMapping[i] = p.parameter;
            transformers[i] = getterAndFieldMapper.transform;
            ++i;
        }
        for (FieldMeta fm : fields) {
            FieldGenericBuilderInfo fieldGenericBuilderInfo = fm.fieldGenericBuilderInfo(i);
            targetFieldMappers.add(fieldGenericBuilderInfo.targetFieldMapper);
            fieldMapperGeneric.add(fieldGenericBuilderInfo.fieldMapperGeneric);
            fieldSetters.add(fieldGenericBuilderInfo.fieldSetter);
        }
        GenericBuilderTransformFunction transformFunction = new GenericBuilderTransformFunction(fieldSetters.toArray(new Setter[0]));
        ConstructorInjections constructorInjections = new ConstructorInjections(parameterGetterMap, constructorFieldMapperGeneric.toArray(new FieldMapper[0]));
        BiInstantiator<Object[], Object, Object> targetInstantiatorFromGenericBuilder = this.targetInstantiatorFromGenericBuilder(indexMapping, transformers);
        GenericBuildBiInstantiator genericBuilderInstantiator = new GenericBuildBiInstantiator(biFunctions, targetInstantiatorFromGenericBuilder, fields.size());
        InstantiatorAndFieldMappers newConstantSourceMapperBuilder = new InstantiatorAndFieldMappers(constructorInjections, genericBuilderInstantiator);
        SourceFieldMapper<S, GenericBuilder> delegate = this.buildMapper(fieldMapperGeneric.toArray(EMPTY_FIELD_MAPPERS), newConstantSourceMapperBuilder, targetClass);
        return new TransformSourceFieldMapper<S, GenericBuilder, T>(delegate, this.merge(constructFieldMapperTarget.toArray(EMPTY_FIELD_MAPPERS), targetFieldMappers.toArray(EMPTY_FIELD_MAPPERS)), transformFunction);
    }

    private FieldMapper<S, T>[] merge(FieldMapper<S, T>[] fieldMappers, FieldMapper<S, T>[] fields) {
        FieldMapper[] f = new FieldMapper[fieldMappers.length + fields.length];
        System.arraycopy(fieldMappers, 0, f, 0, fieldMappers.length);
        System.arraycopy(fields, 0, f, fieldMappers.length, fields.length);
        return f;
    }

    private BiInstantiator<Object[], Object, Object> targetInstantiatorFromGenericBuilder(Parameter[] indexMapping, Function[] transformers) {
        InstantiatorFactory instantiatorFactory = this.reflectionService.getInstantiatorFactory();
        HashMap<Parameter, Object> params = new HashMap<Parameter, Object>();
        for (int i = 0; i < indexMapping.length; ++i) {
            Parameter parameter = indexMapping[i];
            int builderIndex = i;
            Function transformer = transformers[i];
            if (transformer == null) {
                params.put(parameter, new TargetFromBuilderParamBiFunction(builderIndex));
                continue;
            }
            params.put(parameter, new TargetFromBuilderWithTransformBiFunction(transformer, builderIndex));
        }
        BiInstantiator targetInstantiator = instantiatorFactory.getBiInstantiator(this.getTargetClass(), Object[].class, Object.class, this.propertyMappingsBuilder.getPropertyFinder().getEligibleInstantiatorDefinitions(), params, this.reflectionService.isAsmActivated(), this.reflectionService.builderIgnoresNullValues());
        return targetInstantiator;
    }

    private SourceFieldMapper<S, T> builderWithTransformer(List<InjectionParam> params, BuilderInstantiatorDefinition builder) {
        FieldMapper<S, T>[] fields = this.targetFieldMappers();
        Method buildMethod = builder.getBuildMethod();
        Class<?> targetClass = buildMethod.getDeclaringClass();
        Object f = Modifier.isStatic(buildMethod.getModifiers()) ? new StaticMethodFunction(buildMethod) : new MethodFunction(buildMethod);
        ConstructorInjections<T> constructorInjections = this.toConstructorInjections(params);
        InstantiatorFactory instantiatorFactory = this.reflectionService.getInstantiatorFactory();
        final BuilderBiInstantiator builderBiInstantiator = instantiatorFactory.builderBiInstantiator(builder, MapperBiInstantiatorFactory.convertToBiInstantiator(((ConstructorInjections)constructorInjections).parameterGetterMap), this.reflectionService.isAsmActivated(), this.reflectionService.builderIgnoresNullValues());
        InstantiatorAndFieldMappers newConstantSourceMapperBuilder = new InstantiatorAndFieldMappers(constructorInjections, new BiInstantiator(){

            public Object newInstance(Object o, Object o2) throws Exception {
                return builderBiInstantiator.newInitialisedBuilderInstace(o, o2);
            }
        });
        SourceFieldMapper<S, T> delegate = this.buildMapper(fields, newConstantSourceMapperBuilder, targetClass);
        return new TransformSourceFieldMapper<S, T, T>(delegate, (FieldMapper<S, O>[])fields, f);
    }

    private <T> SourceFieldMapper<S, T> buildMapper(FieldMapper<S, T>[] fields, InstantiatorAndFieldMappers<T> constructorFieldMappersAndInstantiator, Class<T> target) {
        AbstractMapper mapper;
        if (this.isEligibleForAsmMapper()) {
            try {
                MapperAsmFactory mapperAsmFactory = (MapperAsmFactory)this.reflectionService.getAsmFactory().registerOrCreate(MapperAsmFactory.class, (UnaryFactory)new UnaryFactory<AsmFactory, MapperAsmFactory>(){

                    public MapperAsmFactory newInstance(AsmFactory asmFactory) {
                        return new MapperAsmFactory(asmFactory);
                    }
                });
                mapper = mapperAsmFactory.createMapper(this.getKeys(), fields, ((InstantiatorAndFieldMappers)constructorFieldMappersAndInstantiator).constructorInjections.fieldMappers, ((InstantiatorAndFieldMappers)constructorFieldMappersAndInstantiator).instantiator, this.mapperSource.source(), target);
            }
            catch (Throwable e) {
                if (this.mapperConfig.failOnAsm()) {
                    return (SourceFieldMapper)ErrorHelper.rethrow((Throwable)e);
                }
                mapper = new MapperImpl<S, T>(fields, ((InstantiatorAndFieldMappers)constructorFieldMappersAndInstantiator).constructorInjections.fieldMappers, ((InstantiatorAndFieldMappers)constructorFieldMappersAndInstantiator).instantiator);
            }
        } else {
            mapper = new MapperImpl<S, T>(fields, ((InstantiatorAndFieldMappers)constructorFieldMappersAndInstantiator).constructorInjections.fieldMappers, ((InstantiatorAndFieldMappers)constructorFieldMappersAndInstantiator).instantiator);
        }
        return mapper;
    }

    public boolean isRootAggregate() {
        return this.mappingContextFactoryBuilder.isRoot() && !this.mappingContextFactoryBuilder.hasNoDependentKeys();
    }

    private Class<T> getTargetClass() {
        return TypeHelper.toClass((Type)this.target);
    }

    private <T> ConstructorInjections<T> toConstructorInjections(List<InjectionParam> params) throws MapperBuildingException {
        HashMap injections = new HashMap();
        ArrayList fieldMappers = new ArrayList();
        for (int i = 0; i < params.size(); ++i) {
            InjectionParam p = params.get(i);
            GetterAndFieldMapper getterAndFieldMapper = p.getterAndfieldMapper();
            injections.put(p.parameter, getterAndFieldMapper.getter);
            if (getterAndFieldMapper.fieldMapper == null) continue;
            fieldMappers.add(getterAndFieldMapper.fieldMapper);
        }
        return new ConstructorInjections(injections, fieldMappers.toArray(new FieldMapper[0]));
    }

    private InstantiatorAndFieldMappers<T> getConstructorFieldMappersAndInstantiator(ConstructorInjections<T> constructorInjections) throws MapperBuildingException {
        InstantiatorFactory instantiatorFactory = this.reflectionService.getInstantiatorFactory();
        try {
            Map injections = ((ConstructorInjections)constructorInjections).parameterGetterMap;
            MapperBiInstantiatorFactory mapperBiInstantiatorFactory = new MapperBiInstantiatorFactory(instantiatorFactory);
            ContextualGetterFactory<S, K> getterFactory = this.fieldMapperAsGetterFactory();
            BiInstantiator<? super S, MappingContext<?>, T> instantiator = mapperBiInstantiatorFactory.getBiInstantiator(this.mapperSource.source(), this.target, this.propertyMappingsBuilder, injections, getterFactory, this.reflectionService.builderIgnoresNullValues(), this.mappingContextFactoryBuilder);
            return new InstantiatorAndFieldMappers(constructorInjections, instantiator);
        }
        catch (Exception e) {
            return (InstantiatorAndFieldMappers)ErrorHelper.rethrow((Throwable)e);
        }
    }

    private ContextualGetterFactory<? super S, K> fieldMapperAsGetterFactory() {
        return new FieldMapperFactoryGetterFactoryAdapter(this.mapperConfig.fieldMapperErrorHandler());
    }

    private List<InjectionParam> constructorInjections() {
        final ArrayList<InjectionParam> injectionParams = new ArrayList<InjectionParam>();
        final HashSet<Parameter> parameters = new HashSet<Parameter>();
        this.propertyMappingsBuilder.forEachConstructorProperties(new ForEachCallBack<PropertyMapping<T, ?, K>>(){

            public void handle(PropertyMapping<T, ?, K> propertyMapping) {
                if (!ConstantSourceMapperBuilder.this.isTargetForMapperFieldMapper(propertyMapping)) {
                    PropertyMeta pm = propertyMapping.getPropertyMeta();
                    ConstructorPropertyMeta cProp = (ConstructorPropertyMeta)pm;
                    injectionParams.add(new ConstructorParam(cProp.getParameter(), cProp, propertyMapping));
                    parameters.add(cProp.getParameter());
                }
            }
        });
        for (PropertyPerOwner e : this.getSubPropertyPerOwner()) {
            if (!e.owner.isConstructorProperty()) continue;
            ConstructorPropertyMeta meta = (ConstructorPropertyMeta)e.owner;
            injectionParams.add(new SubPropertyParam(meta.getParameter(), meta, e.propertyMappings));
            parameters.add(meta.getParameter());
        }
        this.addContextParam(injectionParams, parameters);
        return injectionParams;
    }

    private void addContextParam(List<InjectionParam> injectionParams, Set<Parameter> parameters) {
        Parameter mappingContext = null;
        for (InstantiatorDefinition id : this.propertyMappingsBuilder.getPropertyFinder().getEligibleInstantiatorDefinitions()) {
            for (Parameter p : id.getParameters()) {
                if (!TypeHelper.areEquals((Type)p.getType(), Context.class) || parameters.contains(p)) continue;
                if (mappingContext != null && !p.equals((Object)mappingContext)) {
                    return;
                }
                mappingContext = p;
            }
        }
        if (mappingContext != null) {
            injectionParams.add(new ContextParam(mappingContext, null));
        }
    }

    private <P> SourceMapper<S, P> getterPropertyMapper(PropertyMeta<T, P> owner, PropertyMapping<T, ?, K> propertyMapping) {
        PropertyMeta<T, ?> pm = propertyMapping.getPropertyMeta();
        ContextualGetter getter = this.fieldMapperFactory.getGetterFromSource(propertyMapping.getColumnKey(), pm.getPropertyType(), propertyMapping.getColumnDefinition(), pm.getPropertyClassMetaSupplier(), this.mappingContextFactoryBuilder);
        return new GetterMapper(getter);
    }

    private MappingContextFactoryBuilder getMapperContextFactoryBuilder(PropertyMeta<?, ?> owner, List<PropertyMapping<T, ?, K>> properties) {
        List<K> subKeys = this.getSubKeys(properties);
        return this.mappingContextFactoryBuilder.newBuilder(subKeys, owner);
    }

    private <P> FieldMapper<S, T> newMapperFieldMapper(List<PropertyMapping<T, ?, K>> properties, PropertyMeta<T, ?> meta, SourceMapper<S, ?> mapper, MappingContextFactoryBuilder<S, K> mappingContextFactoryBuilder) {
        return this.newMapperFieldMapper(properties, meta.getSetter(), mapper, mappingContextFactoryBuilder);
    }

    private <P> FieldMapper<S, T> newMapperFieldMapper(List<PropertyMapping<T, ?, K>> properties, Setter<T, P> setter, SourceMapper<S, ?> mapper, MappingContextFactoryBuilder<S, K> mappingContextFactoryBuilder) {
        MapperFieldMapper fieldMapper = new MapperFieldMapper(mapper, setter, mappingContextFactoryBuilder.nullChecker(), mappingContextFactoryBuilder.currentIndex());
        return this.wrapFieldMapperWithErrorHandler(properties.get(0).getColumnKey(), fieldMapper);
    }

    private <P> ContextualGetter<S, P> newMapperGetterAdapter(SourceMapper<S, ?> mapper, MappingContextFactoryBuilder<S, K> builder) {
        return new MapperFieldMapperGetterAdapter(mapper, builder.nullChecker(), builder.currentIndex());
    }

    private <P> void addMapping(K columnKey, ColumnDefinition<K, ?> columnDefinition, PropertyMeta<T, P> prop) {
        this.propertyMappingsBuilder.addProperty(columnKey, columnDefinition, prop);
    }

    private FieldMapper<S, T>[] targetFieldMappers() {
        List<FieldMeta> fields = this.fields();
        FieldMapper[] fieldMappers = new FieldMapper[fields.size()];
        for (int i = 0; i < fields.size(); ++i) {
            fieldMappers[i] = fields.get(i).targetFieldMapper();
        }
        return fieldMappers;
    }

    private List<FieldMeta> fields() {
        final ArrayList<FieldMeta> fields = new ArrayList<FieldMeta>();
        this.propertyMappingsBuilder.forEachProperties(new ForEachCallBack<PropertyMapping<T, ?, K>>(){

            public void handle(PropertyMapping<T, ?, K> t) {
                if (t == null || ConstantSourceMapperBuilder.this.isTargetForMapperFieldMapper(t)) {
                    return;
                }
                PropertyMeta meta = t.getPropertyMeta();
                if (meta == null || meta instanceof SelfPropertyMeta) {
                    return;
                }
                if (!meta.isConstructorProperty() && !ConstantSourceMapperBuilder.this.isTargetForMapperFieldMapper(t)) {
                    fields.add(new PropertyFieldMeta(t));
                }
            }
        });
        for (PropertyPerOwner propertyPerOwner : this.getSubPropertyPerOwner()) {
            if (propertyPerOwner.owner.isConstructorProperty()) continue;
            MappingContextFactoryBuilder currentBuilder = this.getMapperContextFactoryBuilder(propertyPerOwner.owner, propertyPerOwner.propertyMappings);
            SourceMapper mapper = propertyPerOwner.propertyMappings.size() == 1 && JoinUtils.isArrayElement(((PropertyMapping)propertyPerOwner.propertyMappings.get(0)).getPropertyMeta()) ? this.getterPropertyMapper(propertyPerOwner.owner, (PropertyMapping)propertyPerOwner.propertyMappings.get(0)) : this.subPropertyMapper(propertyPerOwner.owner, propertyPerOwner.propertyMappings, currentBuilder);
            fields.add(new SubPropertyFieldMeta(mapper, propertyPerOwner.propertyMappings, propertyPerOwner.owner, currentBuilder));
        }
        for (FieldMapper fieldMapper : this.additionalMappers) {
            fields.add(new FieldMapperFieldMeta(fieldMapper));
        }
        return fields;
    }

    public MappingContextFactory<? super S> contextFactory() {
        return this.mappingContextFactoryBuilder.build();
    }

    private boolean isTargetForMapperFieldMapper(PropertyMapping pm) {
        return pm.getPropertyMeta().isSubProperty() || JoinUtils.isArrayElement(pm.getPropertyMeta()) && pm.getColumnDefinition().isKey();
    }

    private List<PropertyPerOwner> getSubPropertyPerOwner() {
        final ArrayList<PropertyPerOwner> subPropertiesList = new ArrayList<PropertyPerOwner>();
        this.propertyMappingsBuilder.forEachProperties(new ForEachCallBack<PropertyMapping<T, ?, K>>(){

            public void handle(PropertyMapping<T, ?, K> t) {
                if (t == null) {
                    return;
                }
                PropertyMeta meta = t.getPropertyMeta();
                if (meta == null) {
                    return;
                }
                if (ConstantSourceMapperBuilder.this.isTargetForMapperFieldMapper(t)) {
                    this.addSubProperty(t, meta, t.getColumnKey());
                }
            }

            private <P> void addSubProperty(PropertyMapping<T, ?, K> pm, PropertyMeta<T, ?> propertyMeta, K key) {
                PropertyMeta propertyOwner = this.getOwner(propertyMeta);
                List props = this.getList(propertyOwner);
                if (props == null) {
                    props = new ArrayList();
                    subPropertiesList.add(new PropertyPerOwner(propertyOwner, props));
                }
                props.add(pm);
            }

            private PropertyMeta<T, ?> getOwner(PropertyMeta<T, ?> propertyMeta) {
                if (propertyMeta.isSubProperty()) {
                    return ((SubPropertyMeta)propertyMeta).getOwnerProperty();
                }
                return propertyMeta;
            }

            private List<PropertyMapping<T, ?, K>> getList(PropertyMeta<?, ?> owner) {
                for (PropertyPerOwner tuple : subPropertiesList) {
                    if (!tuple.owner.equals(owner)) continue;
                    return tuple.propertyMappings;
                }
                return null;
            }
        });
        return subPropertiesList;
    }

    private <P> SourceMapper<S, P> subPropertyMapper(PropertyMeta<T, P> owner, List<PropertyMapping<T, ?, K>> properties, MappingContextFactoryBuilder<S, K> mappingContextFactoryBuilder) {
        ConstantSourceMapperBuilder builder = this.newSubBuilder(owner.getPropertyClassMeta(), mappingContextFactoryBuilder, this.propertyMappingsBuilder.getPropertyFinder().getSubPropertyFinder(owner));
        for (PropertyMapping<T, ?, K> pm : properties) {
            SubPropertyMeta propertyMeta = (SubPropertyMeta)pm.getPropertyMeta();
            PropertyMeta subProperty = propertyMeta.getSubProperty();
            super.addMapping(pm.getColumnKey(), pm.getColumnDefinition(), subProperty);
        }
        return builder.sourceFieldMapper();
    }

    protected <P> FieldMapper<S, T> newFieldMapper(PropertyMapping<T, P, K> t) {
        ColumnDefinition<K, FieldMapperProperty> columnDefinition = t.getColumnDefinition();
        FieldMapper<Object, Object> fieldMapper = null;
        if (columnDefinition.has(FieldMapperProperty.class)) {
            fieldMapper = columnDefinition.lookFor(FieldMapperProperty.class).getFieldMapper();
        }
        if (fieldMapper == null) {
            fieldMapper = this.fieldMapperFactory.newFieldMapper(t, this.mappingContextFactoryBuilder, this.mapperConfig.mapperBuilderErrorHandler());
        }
        return this.wrapFieldMapperWithErrorHandler(t.getColumnKey(), fieldMapper);
    }

    private <T> FieldMapper<S, T> wrapFieldMapperWithErrorHandler(K columnKey, FieldMapper<S, T> fieldMapper) {
        if (fieldMapper != null && this.mapperConfig.hasFieldMapperErrorHandler()) {
            return FieldErrorHandlerMapper.of(columnKey, fieldMapper, this.mapperConfig.fieldMapperErrorHandler());
        }
        return fieldMapper;
    }

    private <T> ContextualGetter<S, T> wrapGetterWithErrorHandler(K columnKey, ContextualGetter<S, T> getter) {
        if (getter != null && this.mapperConfig.hasFieldMapperErrorHandler()) {
            return FieldErrorHandlerGetter.of(columnKey, getter, this.mapperConfig.fieldMapperErrorHandler());
        }
        return getter;
    }

    public void addMapper(FieldMapper<S, T> mapper) {
        this.additionalMappers.add(mapper);
    }

    private <ST> ConstantSourceMapperBuilder<S, ST, K> newSubBuilder(ClassMeta<ST> classMeta, MappingContextFactoryBuilder<S, K> mappingContextFactoryBuilder, PropertyFinder<ST> propertyFinder) {
        return new ConstantSourceMapperBuilder<S, ST, K>(this.mapperSource, classMeta, this.mapperConfig, mappingContextFactoryBuilder, this.keyFactory, propertyFinder);
    }

    private FieldKey<?>[] getKeys() {
        return this.propertyMappingsBuilder.getKeys().toArray(FIELD_KEYS);
    }

    private boolean isEligibleForAsmMapper() {
        return this.reflectionService.isAsmActivated() && this.propertyMappingsBuilder.size() < this.mapperConfig.asmMapperNbFieldsLimit();
    }

    private List<K> getSubKeys(List<PropertyMapping<T, ?, K>> properties) {
        ArrayList<K> keys = new ArrayList<K>();
        for (PropertyMapping<T, ?, K> pm : properties) {
            if (pm.getPropertyMeta().isSubProperty()) {
                SubPropertyMeta subPropertyMeta = (SubPropertyMeta)pm.getPropertyMeta();
                if (JoinUtils.isArrayElement(subPropertyMeta.getSubProperty()) || !pm.getColumnDefinition().isKey() || !pm.getColumnDefinition().keyAppliesTo().test((Object)subPropertyMeta.getSubProperty())) continue;
                keys.add(pm.getColumnKey());
                continue;
            }
            if (!pm.getColumnDefinition().isKey() || !pm.getColumnDefinition().keyAppliesTo().test(pm.getPropertyMeta())) continue;
            keys.add(pm.getColumnKey());
        }
        return keys;
    }

    public static String getterNotFoundErrorMessage(PropertyMapping propertyMapping) {
        ArrayClassMeta arrayClassMeta;
        ClassMeta elementClassMeta;
        ClassMeta propertyClassMeta = propertyMapping.getPropertyMeta().getPropertyClassMeta();
        String currentPath = propertyMapping.getPropertyMeta().getPath();
        if (propertyClassMeta instanceof ArrayClassMeta && (elementClassMeta = (arrayClassMeta = (ArrayClassMeta)propertyClassMeta).getElementClassMeta()).getNumberOfProperties() <= 1) {
            String actualProp = "val";
            if (elementClassMeta.getNumberOfProperties() == 1 && elementClassMeta instanceof ObjectClassMeta) {
                ObjectClassMeta objectClassMeta = (ObjectClassMeta)elementClassMeta;
                actualProp = objectClassMeta.getFirstProperty().getPath();
            }
            String expectedName = currentPath + "_" + actualProp;
            return "Could not find getter for " + propertyMapping.getColumnKey() + " type " + propertyMapping.getPropertyMeta().getPropertyType() + ". If you meant to map to the element of the List you will need to rename the column to '" + expectedName + "' or call addAlias(\"" + currentPath + "\", \"" + expectedName + "\") on the Factory. See " + ErrorDoc.CSFM_GETTER_NOT_FOUND.toUrl();
        }
        return "Could not find getter for " + propertyMapping.getColumnKey() + " type " + propertyMapping.getPropertyMeta().getPropertyType() + " path " + currentPath + ". See " + ErrorDoc.CSFM_GETTER_NOT_FOUND.toUrl();
    }

    private class ClassMetaSupplier<P>
    implements Supplier<ClassMeta<P>> {
        private final Type target;

        public ClassMetaSupplier(Type target) {
            this.target = target;
        }

        public ClassMeta<P> get() {
            return ConstantSourceMapperBuilder.this.reflectionService.getClassMeta(this.target);
        }
    }

    private class FieldMapperFactoryGetterFactoryAdapter
    implements ContextualGetterFactory<S, K> {
        private final FieldMapperErrorHandler<? super K> fieldMapperErrorHandler;

        public FieldMapperFactoryGetterFactoryAdapter(FieldMapperErrorHandler<? super K> fieldMapperErrorHandler) {
            this.fieldMapperErrorHandler = fieldMapperErrorHandler;
        }

        @Override
        public <P> ContextualGetter<S, P> newGetter(Type target, K key, MappingContextFactoryBuilder<?, K> mappingContextFactoryBuilder, Object ... properties) {
            FieldMapperColumnDefinition columnDefinition = (FieldMapperColumnDefinition)FieldMapperColumnDefinition.identity().add(properties);
            ContextualGetter getterFromSource = ConstantSourceMapperBuilder.this.fieldMapperFactory.getGetterFromSource(key, target, columnDefinition, new ClassMetaSupplier(target), mappingContextFactoryBuilder);
            if (this.fieldMapperErrorHandler != null) {
                return FieldErrorHandlerGetter.of(key, getterFromSource, this.fieldMapperErrorHandler);
            }
            return getterFromSource;
        }
    }

    private class PropertyPerOwner {
        private final PropertyMeta<T, ?> owner;
        private final List<PropertyMapping<T, ?, K>> propertyMappings;

        private PropertyPerOwner(PropertyMeta<T, ?> owner, List<PropertyMapping<T, ?, K>> propertyMappings) {
            this.owner = owner;
            this.propertyMappings = propertyMappings;
        }
    }

    private class GenericBuilderGetterAndFieldMapper {
        final ContextualGetter<S, Object> getter;
        final FieldMapper<S, T> fieldMapper;
        final Function<?, T> transform;
        final FieldMapper<S, T> fieldMapperAfterConstruct;

        private GenericBuilderGetterAndFieldMapper(ContextualGetter<S, Object> getter, FieldMapper<S, T> fieldMapper, Function<?, T> transform, FieldMapper<S, T> fieldMapperAfterConstruct) {
            this.getter = getter;
            this.fieldMapper = fieldMapper;
            this.transform = transform;
            this.fieldMapperAfterConstruct = fieldMapperAfterConstruct;
        }
    }

    private class GetterAndFieldMapper {
        final ContextualGetter<S, ?> getter;
        final FieldMapper<S, T> fieldMapper;

        private GetterAndFieldMapper(ContextualGetter<S, ?> getter, FieldMapper<S, T> fieldMapper) {
            this.getter = getter;
            this.fieldMapper = fieldMapper;
        }
    }

    private class SubPropertyParam
    extends InjectionParam {
        final List<PropertyMapping<T, ?, K>> propertyMappings;

        private SubPropertyParam(Parameter parameter, ConstructorPropertyMeta<T, ?> propertyMeta, List<PropertyMapping<T, ?, K>> propertyMappings) {
            super(parameter, (PropertyMeta)propertyMeta);
            this.propertyMappings = propertyMappings;
        }

        @Override
        public GetterAndFieldMapper getterAndfieldMapper() {
            MappingContextFactoryBuilder currentBuilder = ConstantSourceMapperBuilder.this.getMapperContextFactoryBuilder(this.propertyMeta, this.propertyMappings);
            SourceMapper mapper = this.getsSourceMapper(currentBuilder);
            ContextualGetter biFunction = ConstantSourceMapperBuilder.this.newMapperGetterAdapter(mapper, currentBuilder);
            FieldMapper fieldMapper = ConstantSourceMapperBuilder.this.newMapperFieldMapper(this.propertyMappings, this.propertyMeta, mapper, currentBuilder);
            return new GetterAndFieldMapper(biFunction, fieldMapper);
        }

        @Override
        GenericBuilderGetterAndFieldMapper getterAndfieldMapperGenericBuilder(int i) {
            MappingContextFactoryBuilder currentBuilder = ConstantSourceMapperBuilder.this.getMapperContextFactoryBuilder(this.propertyMeta, this.propertyMappings);
            SourceMapper mapper = this.getsSourceMapper(currentBuilder);
            Function transform = null;
            if (mapper instanceof TransformSourceFieldMapper) {
                transform = ((TransformSourceFieldMapper)mapper).transform;
                mapper = ((TransformSourceFieldMapper)mapper).delegate;
            }
            ContextualGetter biFunction = ConstantSourceMapperBuilder.this.newMapperGetterAdapter(mapper, currentBuilder);
            FieldMapper fieldMapper = ConstantSourceMapperBuilder.this.newMapperFieldMapper(this.propertyMappings, new GenericBuilderSetter(i), mapper, currentBuilder);
            FieldMapper fieldMapperAfterConstruct = ConstantSourceMapperBuilder.this.newMapperFieldMapper(this.propertyMappings, this.propertyMeta, mapper, currentBuilder);
            return new GenericBuilderGetterAndFieldMapper(biFunction, fieldMapper, transform, fieldMapperAfterConstruct);
        }

        @Override
        public boolean needTransformer() {
            if (this.needTransformer(this.propertyMeta)) {
                return true;
            }
            for (PropertyMapping pm : this.propertyMappings) {
                if (!this.needTransformer(pm.getPropertyMeta())) continue;
                return true;
            }
            return false;
        }

        private SourceMapper<S, ?> getsSourceMapper(MappingContextFactoryBuilder currentBuilder) {
            SourceMapper mapper = this.propertyMappings.size() == 1 && JoinUtils.isArrayElement(this.propertyMappings.get(0).getPropertyMeta()) ? ConstantSourceMapperBuilder.this.getterPropertyMapper(this.propertyMeta, this.propertyMappings.get(0)) : ConstantSourceMapperBuilder.this.subPropertyMapper(this.propertyMeta, this.propertyMappings, currentBuilder);
            return mapper;
        }

        private class GenericBuilderSetter
        implements Setter {
            private final int index;

            public GenericBuilderSetter(int index) {
                this.index = index;
            }

            public void set(Object target, Object value) throws Exception {
                ((GenericBuilder)target).objects[this.index] = value;
            }
        }
    }

    private class ContextParam
    extends InjectionParam {
        private ContextParam(Parameter parameter, ConstructorPropertyMeta<T, ?> propertyMeta) {
            super(parameter, (PropertyMeta)propertyMeta);
        }

        @Override
        public GetterAndFieldMapper getterAndfieldMapper() {
            ContextualGetter getter = this.getGetter();
            return new GetterAndFieldMapper(getter, null);
        }

        private ContextualGetter<S, Object> getGetter() {
            return new ContextualGetter<S, Object>(){

                @Override
                public Object get(S s, Context context) throws Exception {
                    return context;
                }
            };
        }

        @Override
        GenericBuilderGetterAndFieldMapper getterAndfieldMapperGenericBuilder(int index) {
            ContextualGetter getter = this.getGetter();
            return new GenericBuilderGetterAndFieldMapper(getter, null, null, null);
        }

        @Override
        public boolean needTransformer() {
            return false;
        }
    }

    private class ConstructorParam
    extends InjectionParam {
        private final PropertyMapping<T, ?, K> propertyMapping;

        private ConstructorParam(Parameter parameter, ConstructorPropertyMeta<T, ?> propertyMeta, PropertyMapping<T, ?, K> propertyMapping) {
            super(parameter, (PropertyMeta)propertyMeta);
            this.propertyMapping = propertyMapping;
        }

        @Override
        public GetterAndFieldMapper getterAndfieldMapper() {
            ContextualGetter getter = ConstantSourceMapperBuilder.this.wrapGetterWithErrorHandler(this.propertyMapping.getColumnKey(), this.getGetter());
            FieldMapper fieldMapper = NullSetter.isNull((Setter)this.propertyMeta.getSetter()) ? null : ConstantSourceMapperBuilder.this.wrapFieldMapperWithErrorHandler(this.propertyMapping.getColumnKey(), ConstantSourceMapperBuilder.this.fieldMapperFactory.newFieldMapper(this.propertyMapping, ConstantSourceMapperBuilder.this.mappingContextFactoryBuilder, ConstantSourceMapperBuilder.this.mapperConfig.mapperBuilderErrorHandler()));
            return new GetterAndFieldMapper(getter, fieldMapper);
        }

        private ContextualGetter<? super S, ?> getGetter() {
            ContextualGetter getter = ConstantSourceMapperBuilder.this.fieldMapperFactory.getGetterFromSource(this.propertyMapping.getColumnKey(), this.propertyMeta.getPropertyType(), this.propertyMapping.getColumnDefinition(), this.propertyMeta.getPropertyClassMetaSupplier(), ConstantSourceMapperBuilder.this.mappingContextFactoryBuilder);
            if (NullContextualGetter.isNull(getter)) {
                PropertyMapping propertyMapping = this.propertyMapping;
                ConstantSourceMapperBuilder.this.mapperConfig.mapperBuilderErrorHandler().accessorNotFound(ConstantSourceMapperBuilder.getterNotFoundErrorMessage(propertyMapping));
            }
            return getter;
        }

        @Override
        GenericBuilderGetterAndFieldMapper getterAndfieldMapperGenericBuilder(int index) {
            FieldMapper fieldMapperAfterConstruct;
            FieldMapper fieldMapper;
            ContextualGetter getter = this.getGetter();
            if (NullSetter.isNull((Setter)this.propertyMeta.getSetter())) {
                fieldMapper = null;
                fieldMapperAfterConstruct = null;
            } else {
                fieldMapper = ConstantSourceMapperBuilder.this.wrapFieldMapperWithErrorHandler(this.propertyMapping.getColumnKey(), new GenericBuilderFieldMapper(index, getter));
                fieldMapperAfterConstruct = ConstantSourceMapperBuilder.this.wrapFieldMapperWithErrorHandler(this.propertyMapping.getColumnKey(), ConstantSourceMapperBuilder.this.fieldMapperFactory.newFieldMapper(this.propertyMapping, ConstantSourceMapperBuilder.this.mappingContextFactoryBuilder, ConstantSourceMapperBuilder.this.mapperConfig.mapperBuilderErrorHandler()));
            }
            return new GenericBuilderGetterAndFieldMapper(getter, fieldMapper, null, fieldMapperAfterConstruct);
        }

        @Override
        public boolean needTransformer() {
            return this.needTransformer(this.propertyMeta);
        }

        private class GenericBuilderFieldMapper<S, T>
        implements FieldMapper<S, T> {
            private final int index;
            private final ContextualGetter<? super S, ?> getter;

            public GenericBuilderFieldMapper(int index, ContextualGetter<? super S, ?> getter) {
                this.index = index;
                this.getter = getter;
            }

            @Override
            public void mapTo(S source, T target, MappingContext<? super S> context) throws Exception {
                ((GenericBuilder)target).objects[this.index] = this.getter.get(source, context);
            }
        }
    }

    private abstract class InjectionParam {
        final Parameter parameter;
        final PropertyMeta<T, ?> propertyMeta;

        private InjectionParam(Parameter parameter, PropertyMeta<T, ?> propertyMeta) {
            this.parameter = parameter;
            this.propertyMeta = propertyMeta;
        }

        abstract GetterAndFieldMapper getterAndfieldMapper();

        abstract GenericBuilderGetterAndFieldMapper getterAndfieldMapperGenericBuilder(int var1);

        public abstract boolean needTransformer();

        boolean needTransformer(PropertyMeta<T, ?> propertyMeta) {
            if (propertyMeta.isSubProperty()) {
                SubPropertyMeta sb = (SubPropertyMeta)propertyMeta;
                return this.needTransformer(sb.getOwnerProperty()) || this.needTransformer(sb.getSubProperty());
            }
            return !propertyMeta.isSelf() && propertyMeta.getPropertyClassMeta().needTransformer();
        }
    }

    private class ConstructorInjections<T> {
        private final Map<Parameter, ContextualGetter<? super S, ?>> parameterGetterMap;
        private final FieldMapper<S, T>[] fieldMappers;

        private ConstructorInjections(Map<Parameter, ContextualGetter<? super S, ?>> parameterGetterMap, FieldMapper<S, T>[] fieldMappers) {
            this.parameterGetterMap = parameterGetterMap;
            this.fieldMappers = fieldMappers;
        }
    }

    private class InstantiatorAndFieldMappers<T> {
        private final ConstructorInjections<T> constructorInjections;
        private final BiInstantiator<S, MappingContext<? super S>, T> instantiator;

        private InstantiatorAndFieldMappers(ConstructorInjections constructorInjections, BiInstantiator<S, MappingContext<? super S>, T> instantiator) {
            this.constructorInjections = constructorInjections;
            this.instantiator = instantiator;
        }
    }

    private static class TargetFromBuilderWithTransformBiFunction
    implements BiFunction<Object[], Object, Object> {
        private final Function transformer;
        private final int builderIndex;

        public TargetFromBuilderWithTransformBiFunction(Function transformer, int builderIndex) {
            this.transformer = transformer;
            this.builderIndex = builderIndex;
        }

        public Object apply(Object[] objects, Object o) {
            return this.transformer.apply(objects[this.builderIndex]);
        }
    }

    private static class TargetFromBuilderParamBiFunction
    implements BiFunction<Object[], Object, Object> {
        private final int builderIndex;

        public TargetFromBuilderParamBiFunction(int builderIndex) {
            this.builderIndex = builderIndex;
        }

        public Object apply(Object[] objects, Object o) {
            return objects[this.builderIndex];
        }
    }

    private static class GenericBuildBiInstantiator
    implements BiInstantiator {
        private final ContextualGetter[] biFunctions;
        private final BiInstantiator<Object[], Object, Object> targetInstantiatorFromGenericBuilder;
        private final int nbFields;

        public GenericBuildBiInstantiator(ContextualGetter[] biFunctions, BiInstantiator<Object[], Object, Object> targetInstantiatorFromGenericBuilder, int nbFields) {
            this.biFunctions = biFunctions;
            this.targetInstantiatorFromGenericBuilder = targetInstantiatorFromGenericBuilder;
            this.nbFields = nbFields;
        }

        public Object newInstance(Object o, Object o2) throws Exception {
            GenericBuilder<Object> genericBuilder = new GenericBuilder<Object>(this.biFunctions.length + this.nbFields, this.targetInstantiatorFromGenericBuilder);
            for (int i = 0; i < this.biFunctions.length; ++i) {
                genericBuilder.objects[i] = this.biFunctions[i].get(o, (MappingContext)o2);
            }
            return genericBuilder;
        }
    }

    private static class GenericBuilderTransformFunction<T>
    implements Function<GenericBuilder<T>, T> {
        private final Setter<T, GenericBuilder<T>>[] fieldSetters;

        public GenericBuilderTransformFunction(Setter<T, GenericBuilder<T>>[] fieldSetters) {
            this.fieldSetters = fieldSetters;
        }

        public T apply(GenericBuilder<T> o) {
            try {
                if (o == null) {
                    return null;
                }
                T t = o.build();
                for (Setter<T, GenericBuilder<T>> setter : this.fieldSetters) {
                    setter.set(t, o);
                }
                return t;
            }
            catch (Exception e) {
                return (T)ErrorHelper.rethrow((Throwable)e);
            }
        }
    }

    class FieldMapperFieldMeta
    extends FieldMeta {
        final FieldMapper<S, T> fieldMapper;

        FieldMapperFieldMeta(FieldMapper<S, T> fieldMapper) {
            this.fieldMapper = fieldMapper;
        }

        @Override
        FieldMapper<S, T> targetFieldMapper() {
            return this.fieldMapper;
        }

        @Override
        public FieldGenericBuilderInfo fieldGenericBuilderInfo(int index) {
            throw new UnsupportedOperationException();
        }
    }

    class SubPropertyFieldMeta
    extends FieldMeta {
        final SourceMapper<S, ?> mapper;
        final List<PropertyMapping<T, ?, K>> propertyMappings;
        final PropertyMeta<T, ?> owner;
        final MappingContextFactoryBuilder<S, K> currentBuilder;

        SubPropertyFieldMeta(SourceMapper<S, ?> mapper, List<PropertyMapping<T, ?, K>> propertyMappings, PropertyMeta<T, ?> owner, MappingContextFactoryBuilder<S, K> currentBuilder) {
            this.mapper = mapper;
            this.propertyMappings = propertyMappings;
            this.owner = owner;
            this.currentBuilder = currentBuilder;
        }

        @Override
        FieldMapper<S, T> targetFieldMapper() {
            return ConstantSourceMapperBuilder.this.newMapperFieldMapper(this.propertyMappings, this.owner, this.mapper, this.currentBuilder);
        }

        @Override
        public FieldGenericBuilderInfo fieldGenericBuilderInfo(final int index) {
            final Setter setter = this.owner.getSetter();
            return new FieldGenericBuilderInfo(this.targetFieldMapper(), ConstantSourceMapperBuilder.this.newMapperFieldMapper(this.propertyMappings, new Setter(){

                public void set(Object target, Object value) throws Exception {
                    GenericBuilder genericBuilder = (GenericBuilder)target;
                    genericBuilder.objects[index] = value;
                }
            }, this.mapper, this.currentBuilder), new Setter<T, GenericBuilder<T>>(){

                public void set(T target, GenericBuilder<T> value) throws Exception {
                    setter.set(target, value.objects[index]);
                }
            });
        }
    }

    class PropertyFieldMeta
    extends FieldMeta {
        final PropertyMapping<T, ?, K> propertyMapping;

        PropertyFieldMeta(PropertyMapping<T, ?, K> propertyMapping) {
            this.propertyMapping = propertyMapping;
        }

        @Override
        public FieldMapper<S, T> targetFieldMapper() {
            return ConstantSourceMapperBuilder.this.newFieldMapper(this.propertyMapping);
        }

        @Override
        public FieldGenericBuilderInfo fieldGenericBuilderInfo(final int index) {
            final Setter setter = this.propertyMapping.getPropertyMeta().getSetter();
            final ContextualGetter getter = ConstantSourceMapperBuilder.this.fieldMapperFactory.getGetterFromSource(this.propertyMapping.getColumnKey(), this.propertyMapping.getPropertyMeta().getPropertyType(), this.propertyMapping.getColumnDefinition(), this.propertyMapping.getPropertyMeta().getPropertyClassMetaSupplier(), ConstantSourceMapperBuilder.this.mappingContextFactoryBuilder);
            return new FieldGenericBuilderInfo(this.targetFieldMapper(), new FieldMapper<S, GenericBuilder<T>>(){

                @Override
                public void mapTo(S source, GenericBuilder<T> target, MappingContext<? super S> context) throws Exception {
                    target.objects[index] = getter.get(source, context);
                }
            }, new Setter<T, GenericBuilder<T>>(){

                public void set(T target, GenericBuilder<T> value) throws Exception {
                    setter.set(target, value.objects[index]);
                }
            });
        }
    }

    abstract class FieldMeta {
        FieldMeta() {
        }

        abstract FieldMapper<S, T> targetFieldMapper();

        public abstract FieldGenericBuilderInfo fieldGenericBuilderInfo(int var1);
    }

    class FieldGenericBuilderInfo {
        final FieldMapper<S, T> targetFieldMapper;
        final FieldMapper<S, GenericBuilder<T>> fieldMapperGeneric;
        final Setter<T, GenericBuilder<T>> fieldSetter;

        FieldGenericBuilderInfo(FieldMapper<S, T> targetFieldMapper, FieldMapper<S, GenericBuilder<T>> fieldMapperGeneric, Setter<T, GenericBuilder<T>> fieldSetter) {
            this.targetFieldMapper = targetFieldMapper;
            this.fieldMapperGeneric = fieldMapperGeneric;
            this.fieldSetter = fieldSetter;
        }
    }

    private static class StaticMethodFunction
    implements Function {
        private final Method buildMethod;

        public StaticMethodFunction(Method buildMethod) {
            this.buildMethod = buildMethod;
        }

        public Object apply(Object o) {
            try {
                return this.buildMethod.invoke(null, o);
            }
            catch (Exception e) {
                return ErrorHelper.rethrow((Throwable)e);
            }
        }
    }

    private static class MethodFunction
    implements Function {
        private final Method buildMethod;

        public MethodFunction(Method buildMethod) {
            this.buildMethod = buildMethod;
        }

        public Object apply(Object o) {
            try {
                return this.buildMethod.invoke(o, new Object[0]);
            }
            catch (Exception e) {
                return ErrorHelper.rethrow((Throwable)e);
            }
        }
    }
}

