/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.map.mapper;

import java.util.Iterator;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.simpleflatmapper.map.ConsumerErrorHandler;
import org.simpleflatmapper.map.EnumarableMapper;
import org.simpleflatmapper.map.MappingException;
import org.simpleflatmapper.util.CheckedConsumer;
import org.simpleflatmapper.util.Enumarable;
import org.simpleflatmapper.util.EnumarableIterator;
import org.simpleflatmapper.util.EnumarableSpliterator;

public abstract class AbstractEnumarableMapper<S, T, E extends Exception>
implements EnumarableMapper<S, T, E> {
    protected final ConsumerErrorHandler errorHandler;

    public AbstractEnumarableMapper(ConsumerErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    @Override
    public final <H extends CheckedConsumer<? super T>> H forEach(S source, H handler) throws E, MappingException {
        Enumarable<T> enumarable = this.newEnumarableOfT(source);
        while (enumarable.next()) {
            Object t = enumarable.currentValue();
            this.handleT(handler, t);
        }
        return handler;
    }

    private <H extends CheckedConsumer<? super T>> void handleT(H handler, T t) {
        try {
            handler.accept(t);
        }
        catch (Throwable e) {
            this.errorHandler.handlerError(e, t);
        }
    }

    @Override
    public final Iterator<T> iterator(S source) throws MappingException, E {
        return new EnumarableIterator(this.newEnumarableOfT(source));
    }

    @Override
    public final Stream<T> stream(S source) throws MappingException, E {
        return StreamSupport.stream(new EnumarableSpliterator(this.newEnumarableOfT(source)), false);
    }

    protected abstract Enumarable<T> newEnumarableOfT(S var1) throws E;
}

