/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.map.fieldmapper;

import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashSet;
import org.simpleflatmapper.converter.Converter;
import org.simpleflatmapper.converter.ConverterService;
import org.simpleflatmapper.map.FieldKey;
import org.simpleflatmapper.map.FieldMapper;
import org.simpleflatmapper.map.MapperBuilderErrorHandler;
import org.simpleflatmapper.map.context.MappingContextFactoryBuilder;
import org.simpleflatmapper.map.fieldmapper.BooleanFieldMapper;
import org.simpleflatmapper.map.fieldmapper.ByteFieldMapper;
import org.simpleflatmapper.map.fieldmapper.CharacterFieldMapper;
import org.simpleflatmapper.map.fieldmapper.ConstantSourceFieldMapperFactory;
import org.simpleflatmapper.map.fieldmapper.DoubleFieldMapper;
import org.simpleflatmapper.map.fieldmapper.FieldMapperImpl;
import org.simpleflatmapper.map.fieldmapper.FloatFieldMapper;
import org.simpleflatmapper.map.fieldmapper.IntFieldMapper;
import org.simpleflatmapper.map.fieldmapper.LongFieldMapper;
import org.simpleflatmapper.map.fieldmapper.NullValueFilterSetter;
import org.simpleflatmapper.map.fieldmapper.ShortFieldMapper;
import org.simpleflatmapper.map.impl.JoinUtils;
import org.simpleflatmapper.map.mapper.PropertyMapping;
import org.simpleflatmapper.map.property.FieldMapperColumnDefinition;
import org.simpleflatmapper.reflect.Getter;
import org.simpleflatmapper.reflect.Instantiator;
import org.simpleflatmapper.reflect.InstantiatorDefinition;
import org.simpleflatmapper.reflect.ObjectGetterFactory;
import org.simpleflatmapper.reflect.ObjectSetterFactory;
import org.simpleflatmapper.reflect.Setter;
import org.simpleflatmapper.reflect.getter.GetterFactory;
import org.simpleflatmapper.reflect.getter.GetterWithConverter;
import org.simpleflatmapper.reflect.getter.InstantiatorGetter;
import org.simpleflatmapper.reflect.instantiator.InstantiatorDefinitions;
import org.simpleflatmapper.reflect.meta.ClassMeta;
import org.simpleflatmapper.reflect.meta.PropertyMeta;
import org.simpleflatmapper.util.ErrorDoc;
import org.simpleflatmapper.util.Supplier;
import org.simpleflatmapper.util.TypeHelper;

public final class ConstantSourceFieldMapperFactoryImpl<S, K extends FieldKey<K>>
implements ConstantSourceFieldMapperFactory<S, K> {
    private final GetterFactory<? super S, ? super K> getterFactory;
    private final ConverterService converterService;
    private final Type sourceType;

    public ConstantSourceFieldMapperFactoryImpl(GetterFactory<? super S, ? super K> getterFactory, ConverterService converterService, Type sourceType) {
        this.getterFactory = getterFactory;
        this.converterService = converterService;
        this.sourceType = sourceType;
    }

    private <T, P> FieldMapper<S, T> primitiveIndexedFieldMapper(Class<P> type, Setter<? super T, ? super P> setter, Getter<? super S, ? extends P> getter) {
        if (type.equals(Boolean.TYPE)) {
            return new BooleanFieldMapper(ObjectGetterFactory.toBooleanGetter(getter), ObjectSetterFactory.toBooleanSetter(setter));
        }
        if (type.equals(Integer.TYPE)) {
            return new IntFieldMapper(ObjectGetterFactory.toIntGetter(getter), ObjectSetterFactory.toIntSetter(setter));
        }
        if (type.equals(Long.TYPE)) {
            return new LongFieldMapper(ObjectGetterFactory.toLongGetter(getter), ObjectSetterFactory.toLongSetter(setter));
        }
        if (type.equals(Float.TYPE)) {
            return new FloatFieldMapper(ObjectGetterFactory.toFloatGetter(getter), ObjectSetterFactory.toFloatSetter(setter));
        }
        if (type.equals(Double.TYPE)) {
            return new DoubleFieldMapper(ObjectGetterFactory.toDoubleGetter(getter), ObjectSetterFactory.toDoubleSetter(setter));
        }
        if (type.equals(Byte.TYPE)) {
            return new ByteFieldMapper(ObjectGetterFactory.toByteGetter(getter), ObjectSetterFactory.toByteSetter(setter));
        }
        if (type.equals(Character.TYPE)) {
            return new CharacterFieldMapper(ObjectGetterFactory.toCharGetter(getter), ObjectSetterFactory.toCharacterSetter(setter));
        }
        if (type.equals(Short.TYPE)) {
            return new ShortFieldMapper(ObjectGetterFactory.toShortGetter(getter), ObjectSetterFactory.toShortSetter(setter));
        }
        throw new UnsupportedOperationException("Type " + type + " is not primitive");
    }

    @Override
    public <T, P> FieldMapper<S, T> newFieldMapper(PropertyMapping<T, P, K, FieldMapperColumnDefinition<K>> propertyMapping, MappingContextFactoryBuilder contextFactoryBuilder, MapperBuilderErrorHandler mappingErrorHandler) {
        PropertyMeta<T, P> propertyMeta = propertyMapping.getPropertyMeta();
        Type propertyType = propertyMeta.getPropertyType();
        Setter setter = propertyMeta.getSetter();
        K key = propertyMapping.getColumnKey();
        Class type = TypeHelper.toClass((Type)propertyType);
        Getter<S, P> getter = this.getGetterFromSource(key, propertyMapping.getPropertyMeta().getPropertyType(), propertyMapping.getColumnDefinition(), propertyMeta.getPropertyClassMetaSupplier());
        if (getter == null) {
            mappingErrorHandler.accessorNotFound("Could not find getter for " + key + " type " + propertyType + " path " + propertyMapping.getPropertyMeta().getPath() + " See " + ErrorDoc.toUrl((String)"CSFM_GETTER_NOT_FOUND"));
            return null;
        }
        if (type.isPrimitive()) {
            return this.primitiveIndexedFieldMapper(type, setter, getter);
        }
        if (propertyMapping.getColumnDefinition().isKey() && JoinUtils.isArrayElement(propertyMapping.getPropertyMeta())) {
            return new FieldMapperImpl(getter, new NullValueFilterSetter(setter));
        }
        return new FieldMapperImpl(getter, setter);
    }

    @Override
    public <P> Getter<? super S, ? extends P> getGetterFromSource(K columnKey, Type propertyType, FieldMapperColumnDefinition<K> columnDefinition, Supplier<ClassMeta<P>> propertyClassMetaSupplier) {
        GetterFactory customGetterFactory;
        Getter<S, P> getter = columnDefinition.getCustomGetterFrom(this.sourceType);
        if (getter == null && (customGetterFactory = columnDefinition.getCustomGetterFactoryFrom(this.sourceType)) != null) {
            getter = customGetterFactory.newGetter(propertyType, columnKey, columnDefinition.properties());
        }
        if (getter == null) {
            getter = this.getterFactory.newGetter(propertyType, columnKey, columnDefinition.properties());
        }
        if (getter == null) {
            getter = this.lookForAlternativeGetter((ClassMeta)propertyClassMetaSupplier.get(), columnKey, columnDefinition, new HashSet<Type>());
        }
        return getter;
    }

    private <P, J> Getter<? super S, ? extends P> lookForAlternativeGetter(ClassMeta<P> classMeta, K key, FieldMapperColumnDefinition<K> columnDefinition, Collection<Type> types) {
        Object[] properties;
        Type propertyType = classMeta.getType();
        Type sourceType = ((FieldKey)key).getType(propertyType);
        Converter converter = this.converterService.findConverter(sourceType, propertyType, properties = columnDefinition.properties());
        if (converter != null) {
            Getter getter = this.getterFactory.newGetter(sourceType, key, properties);
            return new GetterWithConverter(converter, getter);
        }
        return this.lookForInstantiatorGetter(classMeta, key, columnDefinition, types);
    }

    public <P> Getter<? super S, ? extends P> lookForInstantiatorGetter(ClassMeta<P> classMeta, K key, FieldMapperColumnDefinition<K> columnDefinition, Collection<Type> types) {
        InstantiatorDefinitions.CompatibilityScorer scorer = InstantiatorDefinitions.getCompatibilityScorer(key);
        InstantiatorDefinition id = InstantiatorDefinitions.lookForCompatibleOneArgument((Collection)classMeta.getInstantiatorDefinitions(), (InstantiatorDefinitions.CompatibilityScorer)scorer);
        if (id != null) {
            return this.getGettetInstantiator(classMeta, id, key, columnDefinition, types);
        }
        return null;
    }

    private <T, P> Getter<? super S, ? extends P> getGettetInstantiator(ClassMeta<P> classMeta, InstantiatorDefinition id, K key, FieldMapperColumnDefinition<K> columnDefinition, Collection<Type> types) {
        Instantiator instantiator = classMeta.getReflectionService().getInstantiatorFactory().getOneArgIdentityInstantiator(id, classMeta.getReflectionService().builderIgnoresNullValues());
        Type sourceType = id.getParameters()[0].getGenericType();
        Getter<S, P> subGetter = this.getterFactory.newGetter(sourceType, key, new Object[]{columnDefinition});
        if (subGetter == null) {
            if (types.contains(sourceType)) {
                return null;
            }
            types.add(sourceType);
            subGetter = this.lookForInstantiatorGetter(classMeta.getReflectionService().getClassMeta(sourceType), key, columnDefinition, types);
        }
        if (subGetter != null) {
            return new InstantiatorGetter(instantiator, (Getter)subGetter);
        }
        return null;
    }
}

