/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.map.context;

import java.util.ArrayList;
import java.util.List;
import org.simpleflatmapper.map.MappingContext;
import org.simpleflatmapper.map.context.KeySourceGetter;
import org.simpleflatmapper.map.context.KeysDefinition;
import org.simpleflatmapper.map.context.MappingContextFactory;
import org.simpleflatmapper.map.context.impl.BreakDetectorMappingContextFactory;
import org.simpleflatmapper.map.context.impl.BreakGetter;
import org.simpleflatmapper.map.context.impl.NullChecker;
import org.simpleflatmapper.map.context.impl.RootBreakGetterProvider;
import org.simpleflatmapper.map.context.impl.ValuedMappingContextFactory;
import org.simpleflatmapper.reflect.Getter;
import org.simpleflatmapper.reflect.getter.ConstantGetter;
import org.simpleflatmapper.reflect.meta.ArrayElementPropertyMeta;
import org.simpleflatmapper.reflect.meta.MapElementPropertyMeta;
import org.simpleflatmapper.reflect.meta.PropertyMeta;
import org.simpleflatmapper.reflect.setter.AppendCollectionSetter;
import org.simpleflatmapper.util.BooleanProvider;
import org.simpleflatmapper.util.Predicate;
import org.simpleflatmapper.util.Supplier;
import org.simpleflatmapper.util.TrueBooleanProvider;

public class MappingContextFactoryBuilder<S, K> {
    private final Counter counter;
    private final int currentIndex;
    private final MappingContextFactoryBuilder<S, K> parent;
    private final List<K> keys;
    private final KeySourceGetter<K, S> keySourceGetter;
    private final List<MappingContextFactoryBuilder<S, K>> children = new ArrayList<MappingContextFactoryBuilder<S, K>>();
    private final List<Supplier<?>> suppliers = new ArrayList();
    private final PropertyMeta<?, ?> owner;

    public MappingContextFactoryBuilder(KeySourceGetter<K, S> keySourceGetter) {
        this(new Counter(), new ArrayList(), keySourceGetter, null, null);
    }

    protected MappingContextFactoryBuilder(Counter counter, List<K> keys, KeySourceGetter<K, S> keySourceGetter, MappingContextFactoryBuilder<S, K> parent, PropertyMeta<?, ?> owner) {
        this.counter = counter;
        this.currentIndex = counter.value;
        this.keys = keys;
        this.keySourceGetter = keySourceGetter;
        this.parent = parent;
        ++this.counter.value;
        this.owner = owner;
    }

    public void addKey(K key) {
        if (!this.keys.contains(key)) {
            this.keys.add(key);
        }
    }

    public void addSupplier(int index, Supplier<?> supplier) {
        while (this.suppliers.size() <= index) {
            this.suppliers.add(null);
        }
        this.suppliers.set(index, supplier);
    }

    public Predicate<S> nullChecker() {
        return new NullChecker<S, K>(this.keys, this.keySourceGetter);
    }

    public Getter<MappingContext<? super S>, BooleanProvider> breakDetectorGetter() {
        if (this.hasNoKeys()) {
            ArrayElementPropertyMeta elementPropertyMeta;
            if (this.owner instanceof ArrayElementPropertyMeta && (elementPropertyMeta = (ArrayElementPropertyMeta)this.owner).getSetter() instanceof AppendCollectionSetter) {
                return new ConstantGetter((Object)TrueBooleanProvider.INSTANCE);
            }
            if (this.parent != null) {
                return this.parent.breakDetectorGetter();
            }
            return new RootBreakGetterProvider();
        }
        return new BreakGetter(this.currentIndex);
    }

    public MappingContextFactoryBuilder<S, K> newBuilder(List<K> subKeys, PropertyMeta<?, ?> owner) {
        MappingContextFactoryBuilder<S, K> subBuilder = new MappingContextFactoryBuilder<S, K>(this.counter, subKeys, this.keySourceGetter, this, owner);
        this.children.add(subBuilder);
        return subBuilder;
    }

    public MappingContextFactory<S> newFactory() {
        if (this.parent != null) {
            throw new IllegalStateException();
        }
        List<MappingContextFactoryBuilder<S, K>> builders = this.getAllBuilders();
        MappingContextFactory context = this.suppliers.isEmpty() ? MappingContext.EMPTY_FACTORY : new ValuedMappingContextFactory(this.suppliers);
        if (!builders.isEmpty()) {
            KeysDefinition[] keyDefinions = new KeysDefinition[builders.get((int)(builders.size() - 1)).currentIndex + 1];
            int rootDetector = this.getRootDetector(builders);
            for (int i = 0; i < builders.size(); ++i) {
                KeysDefinition<S, K> keyDefinition;
                MappingContextFactoryBuilder<S, K> builder = builders.get(i);
                int parentIndex = super.getParentNonEmptyIndex();
                if (parentIndex == -1 && rootDetector != builder.currentIndex()) {
                    parentIndex = rootDetector;
                }
                keyDefinions[builder.currentIndex] = keyDefinition = super.newKeysDefinition(builder.currentIndex, parentIndex);
            }
            context = new BreakDetectorMappingContextFactory(keyDefinions, rootDetector, context, this.counter.value);
        }
        return context;
    }

    private int getRootDetector(List<MappingContextFactoryBuilder<S, K>> builders) {
        int rootDetector = -1;
        for (int i = 0; i < builders.size(); ++i) {
            MappingContextFactoryBuilder<S, K> builder = builders.get(i);
            if (builder.currentIndex != 0 && (rootDetector != -1 || !super.isEligibleAsRootKey())) continue;
            rootDetector = builder.currentIndex;
        }
        return rootDetector;
    }

    private boolean isEligibleAsRootKey() {
        return !(this.owner instanceof ArrayElementPropertyMeta) && !(this.owner instanceof MapElementPropertyMeta) && (this.parent == null || super.isEligibleAsRootKey());
    }

    private int getParentNonEmptyIndex() {
        if (this.parent == null) {
            return -1;
        }
        if (this.parent.hasNoKeys()) {
            return super.getParentNonEmptyIndex();
        }
        return this.parent.currentIndex;
    }

    private KeysDefinition<S, K> newKeysDefinition(int currentIndex, int parent) {
        return new KeysDefinition<S, K>(this.keys, this.keySourceGetter, currentIndex, parent);
    }

    private List<MappingContextFactoryBuilder<S, K>> getAllBuilders() {
        ArrayList<MappingContextFactoryBuilder<S, K>> list = new ArrayList<MappingContextFactoryBuilder<S, K>>();
        if (!this.hasNoKeys()) {
            list.add(this);
        }
        for (MappingContextFactoryBuilder<S, K> child : this.children) {
            list.addAll(super.getAllBuilders());
        }
        return list;
    }

    public boolean hasNoKeys() {
        return this.keys.isEmpty();
    }

    public boolean hasNoDependentKeys() {
        if (!this.hasNoKeys()) {
            return false;
        }
        for (MappingContextFactoryBuilder<S, K> builder : this.children) {
            if (builder.hasNoDependentKeys()) continue;
            return false;
        }
        return true;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public int currentIndex() {
        return this.currentIndex;
    }

    public String toString() {
        return "MappingContextFactoryBuilder{currentIndex=" + this.currentIndex + ", keys=" + this.keys + ", children=" + this.children + '}';
    }

    private static class Counter {
        int value;

        private Counter() {
        }
    }
}

