/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.datastax;

import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.ColumnMetadata;
import com.datastax.driver.core.DataType;
import java.lang.reflect.Type;
import org.simpleflatmapper.datastax.DataTypeHelper;
import org.simpleflatmapper.map.FieldKey;
import org.simpleflatmapper.map.mapper.MapperKey;
import org.simpleflatmapper.reflect.TypeAffinity;

public final class DatastaxColumnKey
extends FieldKey<DatastaxColumnKey>
implements TypeAffinity {
    private final DataType dataType;
    private final DatastaxColumnKey parent;

    public DatastaxColumnKey(String name, int index) {
        super(name, index);
        this.dataType = null;
        this.parent = null;
    }

    public DatastaxColumnKey(String name, int index, DataType dataType) {
        super(name, index);
        this.dataType = dataType;
        this.parent = null;
    }

    public DatastaxColumnKey(String name, int index, DataType dataType, DatastaxColumnKey parent) {
        super(name, index);
        this.dataType = dataType;
        this.parent = parent;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public String toString() {
        return "DatastaxColumnKey{name='" + this.name + '\'' + ", index=" + this.index + ", dataType=" + this.dataType + ", parent=" + (Object)((Object)this.parent) + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DatastaxColumnKey that = (DatastaxColumnKey)((Object)o);
        return this.dataType != null ? this.dataType.equals(that.dataType) : that.dataType == null;
    }

    public Type getType(Type targetType) {
        return DataTypeHelper.asJavaClass(this.dataType, targetType);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.dataType != null ? this.dataType.hashCode() : 0);
        return result;
    }

    public DatastaxColumnKey alias(String alias) {
        return new DatastaxColumnKey(alias, this.index, this.dataType, this);
    }

    public static DatastaxColumnKey of(ColumnDefinitions metaData, int column) {
        return new DatastaxColumnKey(metaData.getName(column), column, metaData.getType(column));
    }

    public static DatastaxColumnKey of(ColumnMetadata metaData, int column) {
        return new DatastaxColumnKey(metaData.getName(), column, metaData.getType());
    }

    public static MapperKey<DatastaxColumnKey> mapperKey(ColumnDefinitions metaData) {
        FieldKey[] keys = new DatastaxColumnKey[metaData.size()];
        for (int i = 0; i < metaData.size(); ++i) {
            keys[i] = DatastaxColumnKey.of(metaData, i);
        }
        return new MapperKey(keys);
    }

    public Class<?>[] getAffinities() {
        if (this.dataType != null) {
            Class<?> aClass = DataTypeHelper.asJavaClass(this.dataType);
            if (Number.class.isAssignableFrom(aClass)) {
                return new Class[]{aClass, Number.class};
            }
            return new Class[]{aClass};
        }
        return null;
    }

    public DatastaxColumnKey datatype(DataType datatype) {
        return new DatastaxColumnKey(this.getName(), this.index, datatype, this.parent);
    }
}

