/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.datastax.impl.converter;

import java.time.LocalDate;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.Year;
import java.time.YearMonth;
import java.util.Calendar;
import java.util.Date;
import org.simpleflatmapper.converter.AbstractContextualConverterFactoryProducer;
import org.simpleflatmapper.converter.Context;
import org.simpleflatmapper.converter.ContextualConverter;
import org.simpleflatmapper.converter.ContextualConverterFactory;
import org.simpleflatmapper.util.Consumer;

public class DatastaxConverterFactoryProducer
extends AbstractContextualConverterFactoryProducer {
    public void produce(Consumer<? super ContextualConverterFactory<?, ?>> consumer) {
        this.constantConverter(consumer, Year.class, com.datastax.driver.core.LocalDate.class, (ContextualConverter)new ContextualConverter<Year, com.datastax.driver.core.LocalDate>(){

            public com.datastax.driver.core.LocalDate convert(Year in, Context context) throws Exception {
                if (in == null) {
                    return null;
                }
                return com.datastax.driver.core.LocalDate.fromYearMonthDay((int)in.getValue(), (int)1, (int)1);
            }
        });
        this.constantConverter(consumer, YearMonth.class, com.datastax.driver.core.LocalDate.class, (ContextualConverter)new ContextualConverter<YearMonth, com.datastax.driver.core.LocalDate>(){

            public com.datastax.driver.core.LocalDate convert(YearMonth in, Context context) throws Exception {
                if (in == null) {
                    return null;
                }
                return com.datastax.driver.core.LocalDate.fromYearMonthDay((int)in.getYear(), (int)in.getMonthValue(), (int)1);
            }
        });
        this.constantConverter(consumer, LocalDate.class, com.datastax.driver.core.LocalDate.class, (ContextualConverter)new ContextualConverter<LocalDate, com.datastax.driver.core.LocalDate>(){

            public com.datastax.driver.core.LocalDate convert(LocalDate in, Context context) throws Exception {
                if (in == null) {
                    return null;
                }
                return com.datastax.driver.core.LocalDate.fromYearMonthDay((int)in.getYear(), (int)in.getMonthValue(), (int)in.getDayOfMonth());
            }
        });
        this.constantConverter(consumer, LocalTime.class, Long.class, (ContextualConverter)new ContextualConverter<LocalTime, Long>(){

            public Long convert(LocalTime in, Context context) throws Exception {
                if (in == null) {
                    return null;
                }
                return in.toNanoOfDay();
            }
        });
        this.constantConverter(consumer, OffsetTime.class, Long.class, (ContextualConverter)new ContextualConverter<OffsetTime, Long>(){

            public Long convert(OffsetTime in, Context context) throws Exception {
                if (in == null) {
                    return null;
                }
                return in.toLocalTime().toNanoOfDay();
            }
        });
        this.constantConverter(consumer, Date.class, com.datastax.driver.core.LocalDate.class, (ContextualConverter)new ContextualConverter<Date, com.datastax.driver.core.LocalDate>(){

            public com.datastax.driver.core.LocalDate convert(Date in, Context context) throws Exception {
                if (in == null) {
                    return null;
                }
                Calendar cal = Calendar.getInstance();
                cal.setTime(in);
                return com.datastax.driver.core.LocalDate.fromYearMonthDay((int)cal.get(1), (int)(cal.get(2) + 1), (int)cal.get(5));
            }
        });
    }
}

