/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.datastax.impl.setter;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.SettableByIndexData;
import com.datastax.driver.core.TupleType;
import com.datastax.driver.core.TupleValue;
import java.lang.reflect.Type;
import java.util.List;
import org.sfm.datastax.DatastaxColumnKey;
import org.sfm.datastax.SettableDataMapperBuilder;
import org.sfm.datastax.impl.SettableDataSetterFactory;
import org.sfm.map.Mapper;
import org.sfm.map.MapperConfig;
import org.sfm.map.column.ColumnProperty;
import org.sfm.map.column.FieldMapperColumnDefinition;
import org.sfm.map.mapper.ConstantTargetFieldMapperFactorImpl;
import org.sfm.map.mapper.ConstantTargetFieldMapperFactory;
import org.sfm.reflect.ReflectionService;
import org.sfm.reflect.Setter;
import org.sfm.reflect.SetterFactory;
import org.sfm.reflect.meta.ClassMeta;
import org.sfm.tuples.Tuple2;

public class TupleValueSettableDataSetter
implements Setter<SettableByIndexData, TupleValue> {
    private final int index;

    public TupleValueSettableDataSetter(int index) {
        this.index = index;
    }

    public void set(SettableByIndexData target, TupleValue value) throws Exception {
        if (value == null) {
            target.setToNull(this.index);
        } else {
            target.setTupleValue(this.index, value);
        }
    }

    public static <T extends Tuple2<?, ?>> Mapper<T, SettableByIndexData> newTupleMapper(Type target, TupleType tt, MapperConfig<DatastaxColumnKey, FieldMapperColumnDefinition<DatastaxColumnKey>> config, ReflectionService reflectionService) {
        SettableDataMapperBuilder<T> builder = TupleValueSettableDataSetter.newFieldMapperBuilder(config, reflectionService, target);
        List componentTypes = tt.getComponentTypes();
        for (int i = 0; i < componentTypes.size(); ++i) {
            builder.addColumn(new DatastaxColumnKey("elt" + i, i, (DataType)componentTypes.get(i)), new ColumnProperty[0]);
        }
        return builder.mapper();
    }

    public static <T> SettableDataMapperBuilder<T> newFieldMapperBuilder(MapperConfig<DatastaxColumnKey, FieldMapperColumnDefinition<DatastaxColumnKey>> config, ReflectionService reflectionService, Type target) {
        ClassMeta classMeta = reflectionService.getClassMeta(target);
        return new SettableDataMapperBuilder(classMeta, config, (ConstantTargetFieldMapperFactory<SettableByIndexData, DatastaxColumnKey>)ConstantTargetFieldMapperFactorImpl.instance((SetterFactory)new SettableDataSetterFactory(config, reflectionService)));
    }
}

