/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.datastax.impl.getter;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.GettableByIndexData;
import org.sfm.reflect.Getter;
import org.sfm.reflect.primitive.ShortGetter;

public class DatastaxGenericShortGetter
implements ShortGetter<GettableByIndexData>,
Getter<GettableByIndexData, Short> {
    private final int index;
    private final DataType.Name dataTypeName;

    public DatastaxGenericShortGetter(int index, DataType dataType) {
        this.index = index;
        this.dataTypeName = this.validateName(dataType);
    }

    private DataType.Name validateName(DataType dataType) {
        DataType.Name name = dataType.getName();
        switch (name) {
            case BIGINT: 
            case VARINT: 
            case INT: 
            case DECIMAL: 
            case FLOAT: 
            case DOUBLE: 
            case COUNTER: {
                return name;
            }
        }
        throw new IllegalArgumentException("Datatype " + dataType + " not a number");
    }

    public Short get(GettableByIndexData target) throws Exception {
        if (target.isNull(this.index)) {
            return null;
        }
        return this.getShort(target);
    }

    public short getShort(GettableByIndexData target) throws Exception {
        switch (this.dataTypeName) {
            case BIGINT: 
            case COUNTER: {
                return (short)target.getLong(this.index);
            }
            case VARINT: {
                return target.getVarint(this.index).shortValue();
            }
            case INT: {
                return (short)target.getInt(this.index);
            }
            case DECIMAL: {
                return target.getDecimal(this.index).shortValue();
            }
            case FLOAT: {
                return (short)target.getFloat(this.index);
            }
            case DOUBLE: {
                return (short)target.getDouble(this.index);
            }
        }
        return 0;
    }
}

