/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.datastax.impl.getter;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.GettableByIndexData;
import org.sfm.datastax.DataHelper;
import org.sfm.datastax.DataTypeHelper;
import org.sfm.reflect.Getter;
import org.sfm.reflect.primitive.FloatGetter;

public class DatastaxGenericFloatGetter
implements FloatGetter<GettableByIndexData>,
Getter<GettableByIndexData, Float> {
    private final int index;
    private final DataType.Name dataTypeName;

    public DatastaxGenericFloatGetter(int index, DataType dataType) {
        this.index = index;
        this.dataTypeName = this.validateName(dataType);
    }

    private DataType.Name validateName(DataType dataType) {
        DataType.Name name = dataType.getName();
        if (DataTypeHelper.isNumber(name)) {
            return name;
        }
        throw new IllegalArgumentException("Datatype " + dataType + " not a number");
    }

    public Float get(GettableByIndexData target) throws Exception {
        if (target.isNull(this.index)) {
            return null;
        }
        return Float.valueOf(this.getFloat(target));
    }

    public float getFloat(GettableByIndexData target) throws Exception {
        switch (this.dataTypeName) {
            case BIGINT: 
            case COUNTER: {
                return target.getLong(this.index);
            }
            case VARINT: {
                return target.getVarint(this.index).floatValue();
            }
            case INT: {
                return target.getInt(this.index);
            }
            case DECIMAL: {
                return target.getDecimal(this.index).floatValue();
            }
            case FLOAT: {
                return target.getFloat(this.index);
            }
            case DOUBLE: {
                return (float)target.getDouble(this.index);
            }
        }
        if (DataTypeHelper.isSmallInt(this.dataTypeName)) {
            return DataHelper.getShort(this.index, target);
        }
        if (DataTypeHelper.isTinyInt(this.dataTypeName)) {
            return DataHelper.getByte(this.index, target);
        }
        if (DataTypeHelper.isTime(this.dataTypeName)) {
            return DataHelper.getTime(this.index, target);
        }
        return 0.0f;
    }
}

