/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.csv;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.UUID;
import org.simpleflatmapper.csv.CellValueReader;
import org.simpleflatmapper.csv.CsvColumnKey;
import org.simpleflatmapper.lightningcsv.parser.CharBuffer;

public final class CsvRow {
    private final CsvColumnKey[] keys;
    private final int nbColumns;
    private final CharBuffer charBuffer;
    private int[] fieldsBoundaries;
    private int currentIndex;
    protected int rowStartMark;

    public CsvRow(CsvColumnKey[] keys, int maxIndex, CharBuffer charBuffer) {
        this.nbColumns = maxIndex + 1;
        this.keys = keys;
        this.charBuffer = charBuffer;
        this.fieldsBoundaries = new int[this.nbColumns * 2];
    }

    public int getIndex(String column) {
        for (CsvColumnKey key : this.keys) {
            if (!key.getName().equals(column)) continue;
            return key.getIndex();
        }
        return -1;
    }

    public CsvColumnKey[] getKeys() {
        return this.keys;
    }

    public void reset() {
        Arrays.fill(this.fieldsBoundaries, 0);
        this.currentIndex = 0;
    }

    public void addValue(int offset, int length) {
        int index = this.currentIndex;
        if (index < this.fieldsBoundaries.length) {
            this.fieldsBoundaries[index] = offset;
            this.fieldsBoundaries[index + 1] = length;
            this.currentIndex = index + 2;
        }
    }

    public <T> T read(CellValueReader<T> cellValueReader, int i) {
        int rowOffset = this.fieldsBoundaries[i * 2];
        int length = this.fieldsBoundaries[i * 2 + 1];
        return cellValueReader.read(this.charBuffer.buffer, this.rowStartMark + rowOffset, length, null);
    }

    public CharSequence getCharSequence(int i) {
        int rowOffset = this.fieldsBoundaries[i * 2];
        int length = this.fieldsBoundaries[i * 2 + 1];
        return new CharSequenceImpl(this.charBuffer.buffer, this.rowStartMark + rowOffset, this.rowStartMark + rowOffset + length);
    }

    public String getString(int i) {
        int length = this.fieldsBoundaries[i * 2 + 1];
        if (length == 0) {
            return null;
        }
        int rowOffset = this.fieldsBoundaries[i * 2];
        return String.valueOf(this.charBuffer.buffer, this.rowStartMark + rowOffset, length);
    }

    public int length(int i) {
        return this.fieldsBoundaries[i * 2 + 1];
    }

    private boolean isEmpty(int i) {
        return this.length(i) == 0;
    }

    public byte getByte(int i) {
        if (this.isEmpty(i)) {
            return 0;
        }
        return Byte.parseByte(this.getString(i));
    }

    public char getChar(int i) {
        if (this.isEmpty(i)) {
            return '\u0000';
        }
        return (char)Integer.parseInt(this.getString(i));
    }

    public short getShort(int i) {
        if (this.isEmpty(i)) {
            return 0;
        }
        return Short.parseShort(this.getString(i));
    }

    public int getInt(int i) {
        if (this.isEmpty(i)) {
            return 0;
        }
        return Integer.parseInt(this.getString(i));
    }

    public long getLong(int i) {
        if (this.isEmpty(i)) {
            return 0L;
        }
        return Long.parseLong(this.getString(i));
    }

    public float getFloat(int i) {
        if (this.isEmpty(i)) {
            return 0.0f;
        }
        return Float.parseFloat(this.getString(i));
    }

    public double getDouble(int i) {
        if (this.isEmpty(i)) {
            return 0.0;
        }
        return Double.parseDouble(this.getString(i));
    }

    public boolean getBoolean(int i) {
        if (this.isEmpty(i)) {
            return false;
        }
        int rowOffset = this.fieldsBoundaries[i * 2];
        int length = this.fieldsBoundaries[i * 2 + 1];
        return CsvRow.parseBoolean(this.charBuffer.buffer, this.rowStartMark + rowOffset, length);
    }

    public static boolean parseBoolean(char[] chars, int offset, int length) {
        switch (length) {
            case 0: {
                return false;
            }
            case 1: {
                switch (chars[offset]) {
                    case '\u0000': 
                    case '0': 
                    case 'F': 
                    case 'N': 
                    case 'f': 
                    case 'n': {
                        return false;
                    }
                }
                return true;
            }
            case 2: {
                if (!(chars[offset] != 'N' && chars[offset] != 'n' || chars[offset + 1] != 'O' && chars[offset + 1] != 'o')) {
                    return false;
                }
            }
            case 5: {
                if (chars[offset] != 'F' && chars[offset] != 'f' || chars[offset + 1] != 'A' && chars[offset + 1] != 'a' || chars[offset + 2] != 'L' && chars[offset + 2] != 'l' || chars[offset + 3] != 'S' && chars[offset + 3] != 's' || chars[offset + 4] != 'E' && chars[offset + 4] != 'e') break;
                return false;
            }
        }
        return true;
    }

    public Byte getBoxedByte(int i) {
        if (this.isEmpty(i)) {
            return null;
        }
        return this.getByte(i);
    }

    public Short getBoxedShort(int i) {
        if (this.isEmpty(i)) {
            return null;
        }
        return this.getShort(i);
    }

    public Character getBoxedChar(int i) {
        if (this.isEmpty(i)) {
            return null;
        }
        return Character.valueOf(this.getChar(i));
    }

    public Integer getBoxedInt(int i) {
        if (this.isEmpty(i)) {
            return null;
        }
        return this.getInt(i);
    }

    public Long getBoxedLong(int i) {
        if (this.isEmpty(i)) {
            return null;
        }
        return this.getLong(i);
    }

    public Float getBoxedFloat(int i) {
        if (this.isEmpty(i)) {
            return null;
        }
        return Float.valueOf(this.getFloat(i));
    }

    public Double getBoxedDouble(int i) {
        if (this.isEmpty(i)) {
            return null;
        }
        return this.getDouble(i);
    }

    public Boolean getBoxedBoolean(int i) {
        if (this.isEmpty(i)) {
            return null;
        }
        return this.getBoolean(i);
    }

    public BigDecimal getBigDecimal(int i) {
        if (this.isEmpty(i)) {
            return null;
        }
        return new BigDecimal(this.getString(i));
    }

    public BigInteger getBigInteger(int i) {
        if (this.isEmpty(i)) {
            return null;
        }
        return new BigInteger(this.getString(i));
    }

    public UUID getUUID(int i) {
        if (this.isEmpty(i)) {
            return null;
        }
        return UUID.fromString(this.getString(i));
    }

    public int getNbColumns() {
        return this.nbColumns;
    }

    public boolean hasData() {
        return this.currentIndex > 0;
    }

    public boolean containsOnly(char c) {
        for (int column = 0; column < this.nbColumns; ++column) {
            int start = this.fieldsBoundaries[column * 2];
            int end = start + this.fieldsBoundaries[column * 2 + 1];
            for (int i = start; i < end; ++i) {
                if (this.charBuffer.buffer[this.rowStartMark + i] == c) continue;
                return false;
            }
        }
        return true;
    }

    private static class CharSequenceImpl
    implements CharSequence {
        private final char[] buffer;
        private final int start;
        private final int end;

        public CharSequenceImpl(char[] buffer, int start, int end) {
            this.buffer = buffer;
            this.start = start;
            this.end = end;
        }

        @Override
        public int length() {
            return this.end - this.start;
        }

        @Override
        public char charAt(int index) {
            return this.buffer[this.start + index];
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return new CharSequenceImpl(this.buffer, this.start + start, this.start + end);
        }

        public boolean equals(Object o) {
            if (!(o instanceof CharSequence)) {
                return false;
            }
            CharSequence cs = (CharSequence)o;
            if (cs.length() != this.length()) {
                return false;
            }
            for (int i = 0; i < this.length(); ++i) {
                if (this.charAt(i) == cs.charAt(i)) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            int h = 0;
            if (this.start < this.end) {
                char[] val = this.buffer;
                for (int i = this.start; i < this.end; ++i) {
                    h = 31 * h + val[i];
                }
            }
            return h;
        }

        @Override
        public String toString() {
            return String.valueOf(this.buffer, this.start, this.end - this.start);
        }
    }
}

