/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.csv;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.simpleflatmapper.csv.CellValueReader;
import org.simpleflatmapper.csv.CellValueReaderFactory;
import org.simpleflatmapper.csv.CsvColumnDefinition;
import org.simpleflatmapper.csv.CsvColumnKey;
import org.simpleflatmapper.csv.CsvMapper;
import org.simpleflatmapper.csv.ParsingContext;
import org.simpleflatmapper.csv.ParsingContextFactory;
import org.simpleflatmapper.csv.ParsingContextFactoryBuilder;
import org.simpleflatmapper.csv.impl.CellSetterFactory;
import org.simpleflatmapper.csv.impl.CellValueReaderFactoryImpl;
import org.simpleflatmapper.csv.impl.CsvMapperImpl;
import org.simpleflatmapper.csv.impl.DelayedGetter;
import org.simpleflatmapper.csv.impl.DelegateMarkerDelayedCellSetterFactory;
import org.simpleflatmapper.csv.impl.DelegateMarkerSetter;
import org.simpleflatmapper.csv.impl.IdentityCsvColumnDefinitionProvider;
import org.simpleflatmapper.csv.impl.MapperInstantiatorFactory;
import org.simpleflatmapper.csv.impl.asm.CsvAsmFactory;
import org.simpleflatmapper.csv.mapper.CellSetter;
import org.simpleflatmapper.csv.mapper.CsvMapperCellHandler;
import org.simpleflatmapper.csv.mapper.CsvMapperCellHandlerFactory;
import org.simpleflatmapper.csv.mapper.DelayedCellSetterFactory;
import org.simpleflatmapper.csv.property.CustomReaderProperty;
import org.simpleflatmapper.csv.property.MandatoryColumnProperty;
import org.simpleflatmapper.map.FieldKey;
import org.simpleflatmapper.map.FieldMapperErrorHandler;
import org.simpleflatmapper.map.MapperBuildingException;
import org.simpleflatmapper.map.MapperConfig;
import org.simpleflatmapper.map.mapper.ColumnDefinition;
import org.simpleflatmapper.map.mapper.ColumnDefinitionProvider;
import org.simpleflatmapper.map.mapper.MissingPropertyException;
import org.simpleflatmapper.map.mapper.PropertyMapping;
import org.simpleflatmapper.map.mapper.PropertyMappingsBuilder;
import org.simpleflatmapper.map.mapper.PropertyWithSetterOrConstructor;
import org.simpleflatmapper.map.property.DefaultDateFormatProperty;
import org.simpleflatmapper.map.property.DefaultValueProperty;
import org.simpleflatmapper.map.property.MandatoryProperty;
import org.simpleflatmapper.reflect.Getter;
import org.simpleflatmapper.reflect.Instantiator;
import org.simpleflatmapper.reflect.InstantiatorFactory;
import org.simpleflatmapper.reflect.Parameter;
import org.simpleflatmapper.reflect.ReflectionService;
import org.simpleflatmapper.reflect.Setter;
import org.simpleflatmapper.reflect.asm.AsmFactory;
import org.simpleflatmapper.reflect.getter.GetterFactory;
import org.simpleflatmapper.reflect.meta.ClassMeta;
import org.simpleflatmapper.reflect.meta.ConstructorPropertyMeta;
import org.simpleflatmapper.reflect.meta.PropertyMeta;
import org.simpleflatmapper.reflect.meta.SelfPropertyMeta;
import org.simpleflatmapper.reflect.meta.SubPropertyMeta;
import org.simpleflatmapper.util.BiConsumer;
import org.simpleflatmapper.util.Consumer;
import org.simpleflatmapper.util.ErrorHelper;
import org.simpleflatmapper.util.ForEachCallBack;
import org.simpleflatmapper.util.Named;
import org.simpleflatmapper.util.Predicate;
import org.simpleflatmapper.util.TypeReference;
import org.simpleflatmapper.util.UnaryFactory;

public class CsvMapperBuilder<T> {
    public static final CustomReaderProperty NONE_READER_PROPERTY = new CustomReaderProperty(new CellValueReader(){

        public Object read(char[] chars, int offset, int length, ParsingContext parsingContext) {
            throw new UnsupportedOperationException("Default value should not try to read");
        }
    });
    private final Type target;
    private final ReflectionService reflectionService;
    private final MapperConfig<CsvColumnKey, CsvColumnDefinition> mapperConfig;
    private final int minDelayedSetter;
    private final CellValueReaderFactory cellValueReaderFactory;
    private final PropertyMappingsBuilder<T, CsvColumnKey, CsvColumnDefinition> propertyMappingsBuilder;
    private String defaultDateFormat = "yyyy-MM-dd HH:mm:ss";

    public CsvMapperBuilder(Type target) {
        this(target, ReflectionService.newInstance());
    }

    public CsvMapperBuilder(Type target, ReflectionService reflectionService) {
        this(target, reflectionService.getClassMeta(target));
    }

    public CsvMapperBuilder(Type target, ClassMeta<T> classMeta) {
        this(target, classMeta, new IdentityCsvColumnDefinitionProvider());
    }

    public CsvMapperBuilder(Type target, ClassMeta<T> classMeta, ColumnDefinitionProvider<CsvColumnDefinition, CsvColumnKey> columnDefinitionProvider) {
        this(target, classMeta, 0, new CellValueReaderFactoryImpl(), (MapperConfig<CsvColumnKey, CsvColumnDefinition>)MapperConfig.config(columnDefinitionProvider));
    }

    public CsvMapperBuilder(Type target, ClassMeta<T> classMeta, int minDelayedSetter, CellValueReaderFactory cellValueReaderFactory, MapperConfig<CsvColumnKey, CsvColumnDefinition> mapperConfig) throws MapperBuildingException {
        this.target = target;
        this.minDelayedSetter = minDelayedSetter;
        this.reflectionService = classMeta.getReflectionService();
        this.propertyMappingsBuilder = PropertyMappingsBuilder.of(classMeta, mapperConfig, (Predicate)PropertyWithSetterOrConstructor.INSTANCE);
        this.cellValueReaderFactory = cellValueReaderFactory;
        this.mapperConfig = mapperConfig;
    }

    public final CsvMapperBuilder<T> addMapping(String columnKey) {
        return this.addMapping(columnKey, this.propertyMappingsBuilder.size());
    }

    public final CsvMapperBuilder<T> addMapping(String columnKey, int columnIndex) {
        return this.addMapping(new CsvColumnKey(columnKey, columnIndex), CsvColumnDefinition.identity());
    }

    public final CsvMapperBuilder<T> addMapping(String columnKey, CsvColumnDefinition columnDefinition) {
        return this.addMapping(columnKey, this.propertyMappingsBuilder.size(), columnDefinition);
    }

    public final CsvMapperBuilder<T> addMapping(String columnKey, int columnIndex, CsvColumnDefinition columnDefinition) {
        return this.addMapping(new CsvColumnKey(columnKey, columnIndex), columnDefinition);
    }

    public final CsvMapperBuilder<T> addMapping(CsvColumnKey key, CsvColumnDefinition columnDefinition) {
        CsvColumnDefinition composedDefinition = CsvColumnDefinition.compose(this.getColumnDefinition(key), columnDefinition);
        CsvColumnKey mappedColumnKey = (CsvColumnKey)composedDefinition.rename(key);
        this.propertyMappingsBuilder.addProperty((FieldKey)mappedColumnKey, (ColumnDefinition)composedDefinition);
        return this;
    }

    public final CsvMapperBuilder<T> addMapping(String columnKey, Object ... properties) {
        return this.addMapping(columnKey, this.propertyMappingsBuilder.size(), properties);
    }

    public final CsvMapperBuilder<T> addMapping(String columnKey, int columnIndex, Object ... properties) {
        return this.addMapping(new CsvColumnKey(columnKey, columnIndex), properties);
    }

    public final CsvMapperBuilder<T> addMapping(CsvColumnKey key, Object ... properties) {
        return this.addMapping(key, CsvColumnDefinition.of(properties));
    }

    private <P> void addMapping(PropertyMeta<T, P> propertyMeta, CsvColumnKey key, CsvColumnDefinition columnDefinition) {
        this.propertyMappingsBuilder.addProperty((FieldKey)key, (ColumnDefinition)columnDefinition, propertyMeta);
    }

    private CsvColumnDefinition getColumnDefinition(CsvColumnKey key) {
        CsvColumnDefinition columnDefinition = (CsvColumnDefinition)this.mapperConfig.columnDefinitions().getColumnDefinition((FieldKey)key);
        return CsvColumnDefinition.compose(CsvColumnDefinition.of(new DefaultDateFormatProperty(this.defaultDateFormat)), columnDefinition);
    }

    public void setDefaultDateFormat(String defaultDateFormat) {
        this.defaultDateFormat = defaultDateFormat;
    }

    public final CsvMapper<T> mapper() {
        this.mapperConfig.columnDefinitions().forEach(DefaultValueProperty.class, (BiConsumer)new BiConsumer<Predicate<? super CsvColumnKey>, DefaultValueProperty>(){

            public void accept(Predicate<? super CsvColumnKey> predicate, DefaultValueProperty columnProperty) {
                if (CsvMapperBuilder.this.propertyMappingsBuilder.hasKey(predicate)) {
                    return;
                }
                if (predicate instanceof Named) {
                    String name = ((Named)predicate).getName();
                    CsvColumnDefinition columnDefinition = (CsvColumnDefinition)CsvColumnDefinition.identity().add(new Object[]{columnProperty, NONE_READER_PROPERTY});
                    CsvColumnKey key = new CsvColumnKey(name, CsvMapperBuilder.this.propertyMappingsBuilder.size());
                    CsvMapperBuilder.this.propertyMappingsBuilder.addPropertyIfPresent((FieldKey)key, (ColumnDefinition)columnDefinition);
                }
            }
        });
        final ArrayList missingProperties = new ArrayList();
        this.mapperConfig.columnDefinitions().forEach(MandatoryProperty.class, (BiConsumer)new BiConsumer<Predicate<? super CsvColumnKey>, MandatoryProperty>(){

            public void accept(Predicate<? super CsvColumnKey> predicate, MandatoryProperty columnProperty) {
                if (!CsvMapperBuilder.this.propertyMappingsBuilder.hasKey(predicate)) {
                    if (predicate instanceof Named) {
                        missingProperties.add(((Named)predicate).getName());
                    } else {
                        missingProperties.add(predicate.toString());
                    }
                }
            }
        });
        if (!missingProperties.isEmpty()) {
            throw new MissingPropertyException(missingProperties);
        }
        ParsingContextFactoryBuilder parsingContextFactoryBuilder = new ParsingContextFactoryBuilder(this.propertyMappingsBuilder.maxIndex() + 1);
        ConstructorParametersDelayedCellSetter<T> constructorParams = this.buildConstructorParametersDelayedCellSetter();
        Instantiator<CsvMapperCellHandler<T>, T> instantiator = this.getInstantiator(((ConstructorParametersDelayedCellSetter)constructorParams).parameterGetterMap);
        CsvColumnKey[] keys = this.getKeys();
        CellSetter<T>[] setters = this.getSetters(parsingContextFactoryBuilder, ((ConstructorParametersDelayedCellSetter)constructorParams).index);
        DelayedCellSetterFactory<T, ?>[] delayedCellSetterFactories = this.buildDelayedSetters(parsingContextFactoryBuilder, ((ConstructorParametersDelayedCellSetter)constructorParams).index, ((ConstructorParametersDelayedCellSetter)constructorParams).hasKeys);
        CsvMapperCellHandlerFactory<T> csvMapperCellHandlerFactory = this.newCsvMapperCellHandlerFactory(parsingContextFactoryBuilder, instantiator, keys, delayedCellSetterFactories, setters);
        int maxMandatoryIndex = (this.propertyMappingsBuilder.forEachProperties((ForEachCallBack)new ForEachCallBack<PropertyMapping<T, ?, CsvColumnKey, CsvColumnDefinition>>(){
            int maxMandatoryIndex = 0;

            public void handle(PropertyMapping<T, ?, CsvColumnKey, CsvColumnDefinition> pm) {
                if (((CsvColumnDefinition)pm.getColumnDefinition()).has(MandatoryColumnProperty.class)) {
                    this.maxMandatoryIndex = Math.max(this.maxMandatoryIndex, ((CsvColumnKey)pm.getColumnKey()).getIndex());
                }
            }
        })).maxMandatoryIndex;
        return new CsvMapperImpl<T>(csvMapperCellHandlerFactory, delayedCellSetterFactories, setters, this.getJoinKeys(), this.mapperConfig.consumerErrorHandler(), maxMandatoryIndex);
    }

    private CsvMapperCellHandlerFactory<T> newCsvMapperCellHandlerFactory(ParsingContextFactoryBuilder parsingContextFactoryBuilder, Instantiator<CsvMapperCellHandler<T>, T> instantiator, CsvColumnKey[] keys, DelayedCellSetterFactory<T, ?>[] delayedCellSetterFactories, CellSetter<T>[] setters) {
        ParsingContextFactory parsingContextFactory = parsingContextFactoryBuilder.newFactory();
        if (this.isEligibleForAsmHandler()) {
            try {
                return ((CsvAsmFactory)this.reflectionService.getAsmFactory().registerOrCreate(CsvAsmFactory.class, (UnaryFactory)new UnaryFactory<AsmFactory, CsvAsmFactory>(){

                    public CsvAsmFactory newInstance(AsmFactory asmFactory) {
                        return new CsvAsmFactory(asmFactory);
                    }
                })).createCsvMapperCellHandler(this.target, delayedCellSetterFactories, setters, instantiator, keys, parsingContextFactory, (FieldMapperErrorHandler<? super CsvColumnKey>)this.mapperConfig.fieldMapperErrorHandler(), this.mapperConfig.maxMethodSize());
            }
            catch (Exception e) {
                if (this.mapperConfig.failOnAsm()) {
                    return (CsvMapperCellHandlerFactory)ErrorHelper.rethrow((Throwable)e);
                }
                return new CsvMapperCellHandlerFactory<T>(instantiator, keys, parsingContextFactory, (FieldMapperErrorHandler<? super CsvColumnKey>)this.mapperConfig.fieldMapperErrorHandler());
            }
        }
        return new CsvMapperCellHandlerFactory<T>(instantiator, keys, parsingContextFactory, (FieldMapperErrorHandler<? super CsvColumnKey>)this.mapperConfig.fieldMapperErrorHandler());
    }

    private boolean isEligibleForAsmHandler() {
        return this.reflectionService.hasAsmFactory() && this.propertyMappingsBuilder.size() < this.mapperConfig.asmMapperNbFieldsLimit();
    }

    private CsvColumnKey[] getKeys() {
        return this.propertyMappingsBuilder.getKeys().toArray(new CsvColumnKey[0]);
    }

    private CsvColumnKey[] getJoinKeys() {
        final ArrayList keys = new ArrayList();
        this.propertyMappingsBuilder.forEachProperties(new ForEachCallBack<PropertyMapping<T, ?, CsvColumnKey, CsvColumnDefinition>>(){

            public void handle(PropertyMapping<T, ?, CsvColumnKey, CsvColumnDefinition> pm) {
                if (((CsvColumnDefinition)pm.getColumnDefinition()).isKey() && ((CsvColumnDefinition)pm.getColumnDefinition()).keyAppliesTo().test((Object)pm.getPropertyMeta())) {
                    keys.add(pm.getColumnKey());
                }
            }
        });
        return keys.toArray(new CsvColumnKey[0]);
    }

    private Instantiator<CsvMapperCellHandler<T>, T> getInstantiator(Map<Parameter, Getter<? super CsvMapperCellHandler<T>, ?>> params) throws MapperBuildingException {
        InstantiatorFactory instantiatorFactory = this.reflectionService.getInstantiatorFactory();
        try {
            return new MapperInstantiatorFactory(instantiatorFactory).getInstantiator(new TypeReference<CsvMapperCellHandler<T>>(){}.getType(), this.target, this.propertyMappingsBuilder, params, new GetterFactory<CsvMapperCellHandler<T>, CsvColumnKey>(){

                public <P> Getter<CsvMapperCellHandler<T>, P> newGetter(Type target, CsvColumnKey key, Object ... properties) {
                    return CsvMapperBuilder.this.newDelayedGetter(target, key, properties);
                }
            }, this.reflectionService.builderIgnoresNullValues());
        }
        catch (Exception e) {
            return (Instantiator)ErrorHelper.rethrow((Throwable)e);
        }
    }

    private ConstructorParametersDelayedCellSetter<T> buildConstructorParametersDelayedCellSetter() {
        BuildConstructorInjections buildConstructorInjections = new BuildConstructorInjections();
        this.propertyMappingsBuilder.forEachProperties((ForEachCallBack)buildConstructorInjections);
        return new ConstructorParametersDelayedCellSetter(buildConstructorInjections.constructorInjections, buildConstructorInjections.delayedSetterEnd, buildConstructorInjections.hasKeys);
    }

    private DelayedCellSetterFactory<T, ?>[] buildDelayedSetters(final ParsingContextFactoryBuilder parsingContextFactoryBuilder, int delayedSetterEnd, boolean hasKeys) {
        final HashMap delegateMapperBuilders = new HashMap();
        final HashMap propertyToMapperIndex = new HashMap();
        final DelayedCellSetterFactory[] delayedSetters = new DelayedCellSetterFactory[delayedSetterEnd];
        final int newMinDelayedSetter = this.minDelayedSetter != 0 ? this.minDelayedSetter : (hasKeys ? delayedSetterEnd : 0);
        this.propertyMappingsBuilder.forEachProperties(new ForEachCallBack<PropertyMapping<T, ?, CsvColumnKey, CsvColumnDefinition>>(){
            final CellSetterFactory cellSetterFactory;
            {
                this.cellSetterFactory = new CellSetterFactory(CsvMapperBuilder.this.cellValueReaderFactory, CsvMapperBuilder.this.mapperConfig.mapperBuilderErrorHandler());
            }

            public void handle(PropertyMapping<T, ?, CsvColumnKey, CsvColumnDefinition> propMapping) {
                if (propMapping != null) {
                    PropertyMeta prop = propMapping.getPropertyMeta();
                    CsvColumnKey key = (CsvColumnKey)propMapping.getColumnKey();
                    if (prop != null) {
                        if (prop.isSubProperty()) {
                            this.addSubProperty(delegateMapperBuilders, prop, key, (CsvColumnDefinition)propMapping.getColumnDefinition());
                        } else {
                            delayedSetters[((CsvColumnKey)propMapping.getColumnKey()).getIndex()] = this.cellSetterFactory.getDelayedCellSetter(prop, key.getIndex(), (CsvColumnDefinition)propMapping.getColumnDefinition(), parsingContextFactoryBuilder);
                        }
                    }
                }
            }

            private <I, P> void addSubProperty(Map<String, CsvMapperBuilder<?>> delegateMapperBuilders2, PropertyMeta<T, P> prop, CsvColumnKey key, CsvColumnDefinition columnDefinition) {
                Integer currentIndex;
                SubPropertyMeta subPropertyMeta = (SubPropertyMeta)prop;
                PropertyMeta propOwner = subPropertyMeta.getOwnerProperty();
                CsvMapperBuilder<Object> delegateMapperBuilder = delegateMapperBuilders2.get(propOwner.getName());
                if (delegateMapperBuilder == null) {
                    delegateMapperBuilder = new CsvMapperBuilder(propOwner.getPropertyType(), propOwner.getPropertyClassMeta(), newMinDelayedSetter, CsvMapperBuilder.this.cellValueReaderFactory, (MapperConfig<CsvColumnKey, CsvColumnDefinition>)CsvMapperBuilder.this.mapperConfig);
                    delegateMapperBuilders2.put(propOwner.getName(), delegateMapperBuilder);
                }
                if ((currentIndex = (Integer)propertyToMapperIndex.get(propOwner.getName())) == null || currentIndex < key.getIndex()) {
                    propertyToMapperIndex.put(propOwner.getName(), key.getIndex());
                }
                ((CsvMapperBuilder)delegateMapperBuilder).addMapping(subPropertyMeta.getSubProperty(), key, columnDefinition);
            }
        }, 0, delayedSetterEnd);
        final HashMap mappers = new HashMap();
        this.propertyMappingsBuilder.forEachProperties(new ForEachCallBack<PropertyMapping<T, ?, CsvColumnKey, CsvColumnDefinition>>(){

            public void handle(PropertyMapping<T, ?, CsvColumnKey, CsvColumnDefinition> propMapping) {
                if (propMapping == null) {
                    return;
                }
                PropertyMeta prop = propMapping.getPropertyMeta();
                if (prop.isSubProperty()) {
                    this.addSubPropertyDelayedSetter(delegateMapperBuilders, delayedSetters, ((CsvColumnKey)propMapping.getColumnKey()).getIndex(), prop);
                }
            }

            private <I, P> void addSubPropertyDelayedSetter(Map<String, CsvMapperBuilder<?>> delegateMapperBuilders2, DelayedCellSetterFactory<T, ?>[] delayedSetters2, int setterIndex, PropertyMeta<T, P> prop) {
                PropertyMeta subProp = ((SubPropertyMeta)prop).getOwnerProperty();
                String propName = subProp.getName();
                CsvMapper<?> mapper = (CsvMapper<?>)mappers.get(propName);
                if (mapper == null) {
                    CsvMapperBuilder<?> delegateMapperBuilder = delegateMapperBuilders2.get(propName);
                    mapper = delegateMapperBuilder.mapper();
                    mappers.put(propName, mapper);
                }
                int indexOfMapper = (Integer)propertyToMapperIndex.get(propName);
                Setter setter = null;
                if (!subProp.isConstructorProperty()) {
                    setter = subProp.getSetter();
                }
                delayedSetters2[setterIndex] = new DelegateMarkerDelayedCellSetterFactory(mapper, setter, setterIndex, indexOfMapper);
            }
        }, 0, delayedSetterEnd);
        return delayedSetters;
    }

    private CellSetter<T>[] getSetters(final ParsingContextFactoryBuilder parsingContextFactoryBuilder, final int delayedSetterEnd) {
        final HashMap delegateMapperBuilders = new HashMap();
        final HashMap propertyToMapperIndex = new HashMap();
        int maxIndex = (this.propertyMappingsBuilder.forEachProperties((ForEachCallBack)new ForEachCallBack<PropertyMapping<T, ?, CsvColumnKey, CsvColumnDefinition>>(){
            int maxIndex;
            {
                this.maxIndex = delayedSetterEnd;
            }

            public void handle(PropertyMapping<T, ?, CsvColumnKey, CsvColumnDefinition> propMapping) {
                if (propMapping != null) {
                    this.maxIndex = Math.max(((CsvColumnKey)propMapping.getColumnKey()).getIndex(), this.maxIndex);
                    PropertyMeta prop = propMapping.getPropertyMeta();
                    if (prop != null) {
                        CsvColumnKey key = (CsvColumnKey)propMapping.getColumnKey();
                        if (prop.isConstructorProperty()) {
                            throw new IllegalStateException("Unexpected ConstructorPropertyMeta at " + key.getIndex());
                        }
                        if (prop.isSubProperty()) {
                            Integer currentIndex;
                            PropertyMeta propOwner = ((SubPropertyMeta)prop).getOwnerProperty();
                            CsvMapperBuilder delegateMapperBuilder = (CsvMapperBuilder)delegateMapperBuilders.get(propOwner.getName());
                            if (delegateMapperBuilder == null) {
                                delegateMapperBuilder = new CsvMapperBuilder(propOwner.getPropertyType(), propOwner.getPropertyClassMeta(), CsvMapperBuilder.this.minDelayedSetter, CsvMapperBuilder.this.cellValueReaderFactory, (MapperConfig<CsvColumnKey, CsvColumnDefinition>)CsvMapperBuilder.this.mapperConfig);
                                delegateMapperBuilders.put(propOwner.getName(), delegateMapperBuilder);
                            }
                            if ((currentIndex = (Integer)propertyToMapperIndex.get(propOwner.getName())) == null || currentIndex < key.getIndex()) {
                                propertyToMapperIndex.put(propOwner.getName(), key.getIndex());
                            }
                            delegateMapperBuilder.addMapping(((SubPropertyMeta)prop).getSubProperty(), key, (CsvColumnDefinition)propMapping.getColumnDefinition());
                        }
                    }
                }
            }
        }, (int)delayedSetterEnd)).maxIndex;
        final CellSetter[] setters = new CellSetter[maxIndex + 1 - delayedSetterEnd];
        this.propertyMappingsBuilder.forEachProperties(new ForEachCallBack<PropertyMapping<T, ?, CsvColumnKey, CsvColumnDefinition>>(){
            final Map<String, CsvMapperImpl<?>> mappers = new HashMap();
            final CellSetterFactory cellSetterFactory = new CellSetterFactory(CsvMapperBuilder.access$700(CsvMapperBuilder.this), CsvMapperBuilder.access$800(CsvMapperBuilder.this).mapperBuilderErrorHandler());

            public void handle(PropertyMapping<T, ?, CsvColumnKey, CsvColumnDefinition> propMapping) {
                DelegateMarkerSetter delegateMarkerSetter;
                if (propMapping == null) {
                    return;
                }
                PropertyMeta prop = propMapping.getPropertyMeta();
                if (prop == null || prop instanceof SelfPropertyMeta) {
                    return;
                }
                setters[((CsvColumnKey)propMapping.getColumnKey()).getIndex() - delayedSetterEnd] = prop instanceof SubPropertyMeta ? (delegateMarkerSetter = this.getDelegateMarkerSetter((SubPropertyMeta)prop)) : this.cellSetterFactory.getCellSetter(prop, ((CsvColumnKey)propMapping.getColumnKey()).getIndex(), (CsvColumnDefinition)propMapping.getColumnDefinition(), parsingContextFactoryBuilder);
            }

            private <I, P> DelegateMarkerSetter<T, I> getDelegateMarkerSetter(SubPropertyMeta<T, I, P> prop) {
                String propName = prop.getOwnerProperty().getName();
                CsvMapperImpl mapper = this.mappers.get(propName);
                if (mapper == null) {
                    CsvMapperBuilder delegateMapperBuilder = (CsvMapperBuilder)delegateMapperBuilders.get(propName);
                    mapper = (CsvMapperImpl)delegateMapperBuilder.mapper();
                    this.mappers.put(propName, mapper);
                }
                int indexOfMapper = (Integer)propertyToMapperIndex.get(propName);
                return new DelegateMarkerSetter(mapper, prop.getOwnerProperty().getSetter(), indexOfMapper);
            }
        }, delayedSetterEnd);
        return setters;
    }

    public void addDefaultHeaders() {
        this.addDefaultHeaders(this.propertyMappingsBuilder.getClassMeta(), "");
    }

    private <P> void addDefaultHeaders(ClassMeta<P> classMeta, final String prefix) {
        classMeta.forEachProperties(new Consumer<PropertyMeta<P, ?>>(){

            public void accept(PropertyMeta<P, ?> propertyMeta) {
                String currentName = prefix + propertyMeta.getPath();
                if (CsvMapperBuilder.this.cellValueReaderFactory.getReader(propertyMeta.getPropertyType(), 0, CsvColumnDefinition.identity(), new ParsingContextFactoryBuilder(1)) == null) {
                    CsvMapperBuilder.this.addDefaultHeaders(propertyMeta.getPropertyClassMeta(), currentName + "_");
                } else {
                    CsvMapperBuilder.this.addMapping(currentName);
                }
            }
        });
    }

    private <P> Getter<CsvMapperCellHandler<T>, P> newDelayedGetter(Type propertyType, CsvColumnKey key, Object ... properties) {
        CellSetterFactory cellSetterFactory = new CellSetterFactory(this.cellValueReaderFactory, this.mapperConfig.mapperBuilderErrorHandler());
        for (Object prop : properties) {
            if (!(prop instanceof DefaultValueProperty)) continue;
            return new DelayedGetter(key.getIndex());
        }
        return cellSetterFactory.newDelayedGetter(key, propertyType);
    }

    private static class ConstructorParametersDelayedCellSetter<T> {
        private final Map<Parameter, Getter<? super CsvMapperCellHandler<T>, ?>> parameterGetterMap;
        private final int index;
        private final boolean hasKeys;

        private ConstructorParametersDelayedCellSetter(Map<Parameter, Getter<? super CsvMapperCellHandler<T>, ?>> parameterGetterMap, int index, boolean hasKeys) {
            this.parameterGetterMap = parameterGetterMap;
            this.index = index;
            this.hasKeys = hasKeys;
        }
    }

    private class BuildConstructorInjections
    implements ForEachCallBack<PropertyMapping<T, ?, CsvColumnKey, CsvColumnDefinition>> {
        final CellSetterFactory cellSetterFactory;
        private final Map<Parameter, Getter<? super CsvMapperCellHandler<T>, ?>> constructorInjections = new HashMap();
        int delayedSetterEnd;
        boolean hasKeys;

        public BuildConstructorInjections() {
            this.cellSetterFactory = new CellSetterFactory(CsvMapperBuilder.this.cellValueReaderFactory, CsvMapperBuilder.this.mapperConfig.mapperBuilderErrorHandler());
            this.delayedSetterEnd = CsvMapperBuilder.this.minDelayedSetter;
        }

        public void handle(PropertyMapping<T, ?, CsvColumnKey, CsvColumnDefinition> propMapping) {
            SubPropertyMeta subMeta;
            if (propMapping == null) {
                return;
            }
            PropertyMeta meta = propMapping.getPropertyMeta();
            boolean bl = this.hasKeys = this.hasKeys || ((CsvColumnDefinition)propMapping.getColumnDefinition()).isKey();
            if (meta == null) {
                return;
            }
            CsvColumnKey key = (CsvColumnKey)propMapping.getColumnKey();
            if (meta.isConstructorProperty()) {
                Getter delayedGetter = CsvMapperBuilder.this.newDelayedGetter(meta.getPropertyType(), key, ((CsvColumnDefinition)propMapping.getColumnDefinition()).properties());
                this.constructorInjections.put(((ConstructorPropertyMeta)meta).getParameter(), delayedGetter);
            } else if (meta.isSubProperty() && (subMeta = (SubPropertyMeta)meta).getOwnerProperty().isConstructorProperty()) {
                ConstructorPropertyMeta constPropMeta = (ConstructorPropertyMeta)subMeta.getOwnerProperty();
                Getter delayedGetter = this.cellSetterFactory.newDelayedGetter(key, constPropMeta.getPropertyType());
                this.constructorInjections.put(constPropMeta.getParameter(), delayedGetter);
            }
            if (this.needDelayedSetter(propMapping)) {
                this.delayedSetterEnd = Math.max(this.delayedSetterEnd, key.getIndex() + 1);
            }
        }

        private boolean needDelayedSetter(PropertyMapping<T, ?, CsvColumnKey, CsvColumnDefinition> propMapping) {
            PropertyMeta meta = propMapping.getPropertyMeta();
            if (meta.isSelf()) {
                return true;
            }
            if (this.hasConstructor(meta)) {
                return true;
            }
            if (((CsvColumnDefinition)propMapping.getColumnDefinition()).isKey() && ((CsvColumnDefinition)propMapping.getColumnDefinition()).keyAppliesTo().test((Object)propMapping.getPropertyMeta())) {
                return true;
            }
            return ((CsvColumnDefinition)propMapping.getColumnDefinition()).has(DefaultValueProperty.class);
        }

        private boolean hasConstructor(PropertyMeta<?, ?> meta) {
            if (meta.isConstructorProperty()) {
                return true;
            }
            if (meta.isSubProperty()) {
                SubPropertyMeta subMeta = (SubPropertyMeta)meta;
                return this.hasConstructor(subMeta.getOwnerProperty());
            }
            return false;
        }
    }
}

