/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.csv.parser;

import org.simpleflatmapper.csv.parser.CellConsumer;
import org.simpleflatmapper.util.CheckedConsumer;
import org.simpleflatmapper.util.ErrorHelper;

public final class StringConcatCellConsumer<RH extends CheckedConsumer<? super String>>
implements CellConsumer {
    private final RH handler;
    private final char separatorChar;
    private final StringBuilder stringBuilder = new StringBuilder();
    private boolean hasData = false;

    private StringConcatCellConsumer(RH handler, char separatorChar) {
        this.handler = handler;
        this.separatorChar = separatorChar;
    }

    @Override
    public void newCell(char[] chars, int offset, int length) {
        if (this.hasData) {
            this.stringBuilder.append(this.separatorChar);
        }
        this.stringBuilder.append(chars, offset, length);
        this.hasData = true;
    }

    @Override
    public boolean endOfRow() {
        try {
            return this._endOfRow();
        }
        catch (Exception e) {
            return (Boolean)ErrorHelper.rethrow((Throwable)e);
        }
    }

    private boolean _endOfRow() throws Exception {
        if (this.hasData) {
            this.handler.accept((Object)this.stringBuilder.toString());
            this.stringBuilder.setLength(0);
        }
        return true;
    }

    public RH handler() {
        return this.handler;
    }

    @Override
    public void end() {
    }

    public static <RH extends CheckedConsumer<? super String>> StringConcatCellConsumer<RH> newInstance(RH consumer, char separatorChar) {
        return new StringConcatCellConsumer<RH>(consumer, separatorChar);
    }
}

