/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.csv.parser;

import org.simpleflatmapper.csv.parser.CellConsumer;
import org.simpleflatmapper.csv.parser.CellPreProcessor;

public abstract class AbstractUnescapeCellPreProcessor
extends CellPreProcessor {
    @Override
    public final void newCell(char[] chars, int start, int end, CellConsumer cellConsumer) {
        int strStart = start;
        int strEnd = end;
        if (strStart < strEnd && this.isEscapeChar(chars[strStart])) {
            strEnd = this.unescape(chars, ++strStart, strEnd);
        }
        cellConsumer.newCell(chars, strStart, strEnd - strStart);
    }

    private int unescape(char[] chars, int start, int end) {
        for (int i = start; i < end - 1; ++i) {
            if (!this.isEscapeChar(chars[i])) continue;
            return this.removeEscapeChars(chars, end, i);
        }
        if (start < end && this.isEscapeChar(chars[end - 1])) {
            return end - 1;
        }
        return end;
    }

    private int removeEscapeChars(char[] chars, int end, int firstEscapeChar) {
        int j = firstEscapeChar;
        boolean escaped = true;
        for (int i = firstEscapeChar + 1; i < end; ++i) {
            boolean bl = escaped = this.isEscapeChar(chars[i]) && !escaped;
            if (escaped) continue;
            chars[j++] = chars[i];
        }
        return j;
    }

    protected abstract boolean isEscapeChar(char var1);

    @Override
    public final boolean ignoreLeadingSpace() {
        return false;
    }
}

