/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.csv;

import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import org.simpleflatmapper.csv.CloseableCsvReader;
import org.simpleflatmapper.csv.CsvColumnDefinition;
import org.simpleflatmapper.csv.CsvColumnKey;
import org.simpleflatmapper.csv.CsvMapper;
import org.simpleflatmapper.csv.CsvMapperBuilder;
import org.simpleflatmapper.csv.CsvReader;
import org.simpleflatmapper.csv.impl.CsvColumnDefinitionProviderImpl;
import org.simpleflatmapper.csv.impl.DynamicCsvMapper;
import org.simpleflatmapper.csv.parser.CellConsumer;
import org.simpleflatmapper.csv.parser.CellPreProcessor;
import org.simpleflatmapper.csv.parser.CharBuffer;
import org.simpleflatmapper.csv.parser.CharConsumer;
import org.simpleflatmapper.csv.parser.CharSequenceCharBuffer;
import org.simpleflatmapper.csv.parser.ConfigurableCharConsumer;
import org.simpleflatmapper.csv.parser.CsvCharConsumer;
import org.simpleflatmapper.csv.parser.CsvUnescapeCellPreProcessor;
import org.simpleflatmapper.csv.parser.IgnoreCellConsumer;
import org.simpleflatmapper.csv.parser.NoopCellPreProcessor;
import org.simpleflatmapper.csv.parser.NoopYamlTrimeCellPreProcessor;
import org.simpleflatmapper.csv.parser.ReaderCharBuffer;
import org.simpleflatmapper.csv.parser.StringArrayCellConsumer;
import org.simpleflatmapper.csv.parser.StringConcatCellConsumer;
import org.simpleflatmapper.csv.parser.TextFormat;
import org.simpleflatmapper.csv.parser.TrimAndUnescapeCellPreProcessor;
import org.simpleflatmapper.csv.parser.UnescapeCellPreProcessor;
import org.simpleflatmapper.csv.parser.YamlCommentUnescapeContentCellConsumer;
import org.simpleflatmapper.map.CaseInsensitiveFieldKeyNamePredicate;
import org.simpleflatmapper.map.mapper.AbstractColumnDefinitionProvider;
import org.simpleflatmapper.map.mapper.ColumnDefinitionProvider;
import org.simpleflatmapper.map.property.KeyProperty;
import org.simpleflatmapper.reflect.ReflectionService;
import org.simpleflatmapper.reflect.meta.ClassMeta;
import org.simpleflatmapper.tuple.Tuple2;
import org.simpleflatmapper.tuple.Tuple3;
import org.simpleflatmapper.tuple.Tuple4;
import org.simpleflatmapper.tuple.Tuple5;
import org.simpleflatmapper.tuple.Tuple6;
import org.simpleflatmapper.tuple.Tuple7;
import org.simpleflatmapper.tuple.Tuple8;
import org.simpleflatmapper.tuple.Tuples;
import org.simpleflatmapper.util.CheckedConsumer;
import org.simpleflatmapper.util.CloseableIterator;
import org.simpleflatmapper.util.ConstantUnaryFactory;
import org.simpleflatmapper.util.Predicate;
import org.simpleflatmapper.util.TypeReference;
import org.simpleflatmapper.util.UnaryFactory;

public final class CsvParser {
    public static final int DEFAULT_MAX_BUFFER_SIZE_8M = 0x800000;
    public static final int DEFAULT_BUFFER_SIZE_4K = 4096;
    private static final OnReaderFactory<CloseableCsvReader, AbstractDSL<?>> CREATE_CLOSEABLE_CSV_READER = new OnReaderFactory<CloseableCsvReader, AbstractDSL<?>>(){

        @Override
        public CloseableCsvReader apply(Reader reader, AbstractDSL<?> dsl) throws IOException {
            return new CloseableCsvReader(dsl.reader(reader), reader);
        }
    };
    private static final OnReaderFactory<CloseableIterator<String[]>, AbstractDSL<?>> CREATE_CLOSEABLE_ITERATOR = new OnReaderFactory<CloseableIterator<String[]>, AbstractDSL<?>>(){

        @Override
        public CloseableIterator<String[]> apply(Reader reader, AbstractDSL<?> dsl) throws IOException {
            return new CloseableIterator(dsl.iterator(reader), (Closeable)reader);
        }
    };

    public static DSL separator(char c) {
        return (DSL)CsvParser.dsl().separator(c);
    }

    public static DSL bufferSize(int size) {
        return (DSL)CsvParser.dsl().bufferSize(size);
    }

    public static DSL maxBufferSize(int size) {
        return (DSL)CsvParser.dsl().maxBufferSize(size);
    }

    public static DSL quote(char c) {
        return (DSL)CsvParser.dsl().quote(c);
    }

    public static DSL skip(int skip) {
        return (DSL)CsvParser.dsl().skip(skip);
    }

    public static DSL dsl() {
        return new DSL();
    }

    public static DSL limit(int limit) {
        return (DSL)CsvParser.dsl().limit(limit);
    }

    public static <T> MapToDSL<T> mapTo(Type type) {
        return CsvParser.dsl().mapTo(type);
    }

    public static <T> MapToDSL<T> mapTo(Class<T> type) {
        return CsvParser.dsl().mapTo(type);
    }

    public static <T> MapToDSL<T> mapTo(TypeReference<T> type) {
        return CsvParser.dsl().mapTo(type);
    }

    public static <T1, T2> MapToDSL<Tuple2<T1, T2>> mapTo(Class<T1> class1, Class<T2> class2) {
        return CsvParser.dsl().mapTo(class1, class2);
    }

    public static <T1, T2, T3> MapToDSL<Tuple3<T1, T2, T3>> mapTo(Class<T1> class1, Class<T2> class2, Class<T3> class3) {
        return CsvParser.dsl().mapTo(class1, class2, class3);
    }

    public static <T1, T2, T3, T4> MapToDSL<Tuple4<T1, T2, T3, T4>> mapTo(Class<T1> class1, Class<T2> class2, Class<T3> class3, Class<T4> class4) {
        return CsvParser.dsl().mapTo(class1, class2, class3, class4);
    }

    public static <T1, T2, T3, T4, T5> MapToDSL<Tuple5<T1, T2, T3, T4, T5>> mapTo(Class<T1> class1, Class<T2> class2, Class<T3> class3, Class<T4> class4, Class<T5> class5) {
        return CsvParser.dsl().mapTo(class1, class2, class3, class4, class5);
    }

    public static <T1, T2, T3, T4, T5, T6> MapToDSL<Tuple6<T1, T2, T3, T4, T5, T6>> mapTo(Class<T1> class1, Class<T2> class2, Class<T3> class3, Class<T4> class4, Class<T5> class5, Class<T6> class6) {
        return CsvParser.dsl().mapTo(class1, class2, class3, class4, class5, class6);
    }

    public static <T1, T2, T3, T4, T5, T6, T7> MapToDSL<Tuple7<T1, T2, T3, T4, T5, T6, T7>> mapTo(Class<T1> class1, Class<T2> class2, Class<T3> class3, Class<T4> class4, Class<T5> class5, Class<T6> class6, Class<T7> class7) {
        return CsvParser.dsl().mapTo(class1, class2, class3, class4, class5, class6, class7);
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8> MapToDSL<Tuple8<T1, T2, T3, T4, T5, T6, T7, T8>> mapTo(Class<T1> class1, Class<T2> class2, Class<T3> class3, Class<T4> class4, Class<T5> class5, Class<T6> class6, Class<T7> class7, Class<T8> class8) {
        return CsvParser.dsl().mapTo(class1, class2, class3, class4, class5, class6, class7, class8);
    }

    public static <T> MapWithDSL<T> mapWith(CsvMapper<T> mapper) {
        return CsvParser.dsl().mapWith(mapper);
    }

    public static CsvReader reader(Reader reader) throws IOException {
        return CsvParser.dsl().reader(reader);
    }

    public static CsvReader reader(CharSequence content) throws IOException {
        return CsvParser.dsl().reader(content);
    }

    public static CsvReader reader(String content) throws IOException {
        return CsvParser.dsl().reader(content);
    }

    public static CloseableCsvReader reader(File file) throws IOException {
        return CsvParser.dsl().reader(file);
    }

    public static Iterator<String[]> iterator(Reader reader) throws IOException {
        return CsvParser.dsl().iterator(reader);
    }

    public static Iterator<String[]> iterator(CharSequence content) throws IOException {
        return CsvParser.dsl().iterator(content);
    }

    public static CloseableIterator<String[]> iterator(File file) throws IOException {
        return CsvParser.dsl().iterator(file);
    }

    public static <H extends CheckedConsumer<String[]>> H forEach(Reader reader, H consumer) throws IOException {
        return CsvParser.dsl().forEach(reader, consumer);
    }

    public static <H extends CheckedConsumer<String[]>> H forEach(CharSequence content, H consumer) throws IOException {
        return CsvParser.dsl().forEach(content, consumer);
    }

    public static <H extends CheckedConsumer<String[]>> H forEach(File file, H consumer) throws IOException {
        return CsvParser.dsl().forEach(file, consumer);
    }

    public static <CC extends CellConsumer> CC parse(Reader reader, CC cellConsumer) throws IOException {
        return CsvParser.dsl().parse(reader, cellConsumer);
    }

    public static <CC extends CellConsumer> CC parse(CharSequence content, CC cellConsumer) throws IOException {
        return CsvParser.dsl().parse(content, cellConsumer);
    }

    public static <CC extends CellConsumer> CC parse(String content, CC cellConsumer) throws IOException {
        return CsvParser.dsl().parse(content, cellConsumer);
    }

    public static <CC extends CellConsumer> CC parse(File file, CC cellConsumer) throws IOException {
        return CsvParser.dsl().parse(file, cellConsumer);
    }

    public static Stream<String[]> stream(Reader r) throws IOException {
        return CsvParser.dsl().stream(r);
    }

    @Deprecated
    public static Stream<String[]> stream(File file) throws IOException {
        return CsvParser.dsl().stream(file);
    }

    public static <R> R stream(File file, Function<Stream<String[]>, R> function) throws IOException {
        return CsvParser.dsl().stream(file, function);
    }

    public static Stream<String[]> stream(String content) throws IOException {
        return CsvParser.dsl().stream(content);
    }

    protected static <R, D extends AbstractDSL<?>> R onReader(File file, D dsl, OnReaderFactory<R, ? super D> factory) throws IOException {
        FileReader reader = new FileReader(file);
        try {
            return factory.apply(reader, dsl);
        }
        catch (IOException ioe) {
            try {
                ((Reader)reader).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw ioe;
        }
    }

    private static <T> CsvMapper<T> newDefaultStaticMapper(Type mapToClass, ClassMeta<T> classMeta, CsvColumnDefinitionProviderImpl columnDefinitionProvider) {
        CsvMapperBuilder<T> builder = new CsvMapperBuilder<T>(mapToClass, classMeta, (ColumnDefinitionProvider<CsvColumnDefinition, CsvColumnKey>)columnDefinitionProvider);
        builder.addDefaultHeaders();
        return builder.mapper();
    }

    private static <T> CsvMapper<T> newStaticMapper(Type mapToClass, ClassMeta<T> classMeta, List<Tuple2<String, CsvColumnDefinition>> columns, CsvColumnDefinitionProviderImpl columnDefinitionProvider) {
        CsvMapperBuilder<T> builder = new CsvMapperBuilder<T>(mapToClass, classMeta, (ColumnDefinitionProvider<CsvColumnDefinition, CsvColumnKey>)columnDefinitionProvider);
        for (Tuple2<String, CsvColumnDefinition> col : columns) {
            builder.addMapping((String)col.first(), (CsvColumnDefinition)((Object)col.second()));
        }
        return builder.mapper();
    }

    static interface OnReaderFactory<T, D extends AbstractDSL<?>> {
        public T apply(Reader var1, D var2) throws IOException;
    }

    public static class MapWithDSL<T> {
        private final AbstractDSL<?> dsl;
        private final CsvMapper<T> mapper;

        public MapWithDSL(AbstractDSL dsl, CsvMapper<T> mapper) {
            this.dsl = dsl;
            this.mapper = mapper;
        }

        protected final AbstractDSL getDsl() {
            return this.dsl;
        }

        public final Iterator<T> iterator(Reader reader) throws IOException {
            return this.mapper.iterator(this.dsl.reader(reader));
        }

        public final Iterator<T> iterator(CharSequence content) throws IOException {
            return this.mapper.iterator(this.dsl.reader(content));
        }

        public final Iterator<T> iterator(String content) throws IOException {
            return this.mapper.iterator(this.dsl.reader(content));
        }

        public final CloseableIterator<T> iterator(File file) throws IOException {
            OnReaderFactory factory = new OnReaderFactory<CloseableIterator<T>, AbstractDSL<?>>(){

                @Override
                public CloseableIterator<T> apply(Reader reader, AbstractDSL<?> dsl) throws IOException {
                    return new CloseableIterator(this.iterator(reader), (Closeable)reader);
                }
            };
            return (CloseableIterator)CsvParser.onReader(file, this.dsl, factory);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final <H extends CheckedConsumer<T>> H forEach(File file, H consumer) throws IOException {
            FileReader reader = new FileReader(file);
            H h = this.forEach(reader, consumer);
            return h;
            finally {
                try {
                    ((Reader)reader).close();
                }
                catch (IOException iOException) {}
            }
        }

        public final <H extends CheckedConsumer<T>> H forEach(Reader reader, H consumer) throws IOException {
            return this.forEach(consumer, this.dsl.reader(reader));
        }

        public final <H extends CheckedConsumer<T>> H forEach(CharSequence content, H consumer) throws IOException {
            return this.forEach(consumer, this.dsl.reader(content));
        }

        public final <H extends CheckedConsumer<T>> H forEach(String content, H consumer) throws IOException {
            return this.forEach(consumer, this.dsl.reader(content));
        }

        private <H extends CheckedConsumer<T>> H forEach(H consumer, CsvReader csvReader) throws IOException {
            if (this.dsl.limit == -1) {
                this.mapper.forEach(csvReader, consumer);
            } else {
                this.mapper.forEach(csvReader, consumer, this.dsl.limit);
            }
            return consumer;
        }

        public final Stream<T> stream(Reader reader) throws IOException {
            return this.mapper.stream(this.dsl.reader(reader));
        }

        public final Stream<T> stream(CharSequence content) throws IOException {
            return this.mapper.stream(this.dsl.reader(content));
        }

        public final Stream<T> stream(String content) throws IOException {
            return this.mapper.stream(this.dsl.reader(content));
        }

        @Deprecated
        public final Stream<T> stream(File file) throws IOException {
            OnReaderFactory factory = new OnReaderFactory<Stream<T>, AbstractDSL<?>>(){

                @Override
                public Stream<T> apply(Reader reader, AbstractDSL<?> dsl) throws IOException {
                    return (Stream)this.stream(reader).onClose(() -> {
                        try {
                            reader.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    });
                }
            };
            return (Stream)CsvParser.onReader(file, this.dsl, factory);
        }

        public final <R> R stream(File file, Function<Stream<T>, R> function) throws IOException {
            FileReader reader = new FileReader(file);
            try {
                return function.apply(this.stream(reader));
            }
            catch (IOException ioe) {
                try {
                    ((Reader)reader).close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw ioe;
            }
        }
    }

    public static final class StaticMapToDSL<T>
    extends MapWithDSL<T> {
        private final ClassMeta<T> classMeta;
        private final Type mapToClass;
        private final CsvColumnDefinitionProviderImpl columnDefinitionProvider;
        private final List<Tuple2<String, CsvColumnDefinition>> columns;

        private StaticMapToDSL(AbstractDSL dsl, ClassMeta<T> classMeta, Type mapToClass, CsvMapper<T> mapper, CsvColumnDefinitionProviderImpl columnDefinitionProvider) {
            super(dsl, mapper);
            this.classMeta = classMeta;
            this.mapToClass = mapToClass;
            this.columns = new ArrayList<Tuple2<String, CsvColumnDefinition>>();
            this.columnDefinitionProvider = columnDefinitionProvider;
        }

        private StaticMapToDSL(AbstractDSL dsl, ClassMeta<T> classMeta, Type mapToClass, List<Tuple2<String, CsvColumnDefinition>> columns, CsvColumnDefinitionProviderImpl columnDefinitionProvider) {
            super(dsl, CsvParser.newStaticMapper(mapToClass, classMeta, columns, columnDefinitionProvider));
            this.classMeta = classMeta;
            this.mapToClass = mapToClass;
            this.columns = columns;
            this.columnDefinitionProvider = columnDefinitionProvider;
        }

        public StaticMapToDSL<T> addMapping(String column) {
            return this.addMapping(column, CsvColumnDefinition.identity());
        }

        public StaticMapToDSL<T> addMapping(String column, CsvColumnDefinition columnDefinition) {
            ArrayList<Tuple2<String, CsvColumnDefinition>> newColumns = new ArrayList<Tuple2<String, CsvColumnDefinition>>(this.columns);
            newColumns.add((Tuple2<String, CsvColumnDefinition>)new Tuple2((Object)column, (Object)columnDefinition));
            return new StaticMapToDSL<T>(this.getDsl(), this.classMeta, this.mapToClass, newColumns, this.columnDefinitionProvider);
        }

        public StaticMapToDSL<T> addKey(String key) {
            return this.addMapping(key, CsvColumnDefinition.key());
        }
    }

    public static final class MapToDSL<T>
    extends MapWithDSL<T> {
        private final ClassMeta<T> classMeta;
        private final Type mapToClass;
        private final CsvColumnDefinitionProviderImpl columnDefinitionProvider;

        public MapToDSL(AbstractDSL dsl, Type mapToClass) {
            this(dsl, ReflectionService.newInstance().getClassMeta(mapToClass), mapToClass, new CsvColumnDefinitionProviderImpl());
        }

        private MapToDSL(AbstractDSL dsl, ClassMeta<T> classMeta, Type mapToClass, CsvColumnDefinitionProviderImpl columnDefinitionProvider) {
            super(dsl, new DynamicCsvMapper<T>(mapToClass, classMeta, (ColumnDefinitionProvider<CsvColumnDefinition, CsvColumnKey>)columnDefinitionProvider));
            this.mapToClass = mapToClass;
            this.classMeta = classMeta;
            this.columnDefinitionProvider = columnDefinitionProvider;
        }

        public StaticMapToDSL<T> headers(String ... headers) {
            return this.headers(headers, this.getDsl());
        }

        public StaticMapToDSL<T> overrideHeaders(String ... headers) {
            return this.headers(headers, (AbstractDSL)this.getDsl().skip(1));
        }

        private StaticMapToDSL<T> headers(String[] headers, AbstractDSL csvDsl) {
            return new StaticMapToDSL(csvDsl, this.classMeta, this.mapToClass, this.getColumnDefinitions(headers), this.columnDefinitionProvider);
        }

        public StaticMapToDSL<T> defaultHeaders() {
            return this.defaultHeaders(this.getDsl());
        }

        public StaticMapToDSL<T> overrideWithDefaultHeaders() {
            return this.defaultHeaders((AbstractDSL)this.getDsl().skip(1));
        }

        private StaticMapToDSL<T> defaultHeaders(AbstractDSL csvDsl) {
            return new StaticMapToDSL(csvDsl, this.classMeta, this.mapToClass, CsvParser.newDefaultStaticMapper(this.mapToClass, this.classMeta, this.columnDefinitionProvider), this.columnDefinitionProvider);
        }

        private List<Tuple2<String, CsvColumnDefinition>> getColumnDefinitions(String[] headers) {
            ArrayList<Tuple2<String, CsvColumnDefinition>> columns = new ArrayList<Tuple2<String, CsvColumnDefinition>>();
            for (String header : headers) {
                columns.add((Tuple2<String, CsvColumnDefinition>)new Tuple2((Object)header, (Object)CsvColumnDefinition.identity()));
            }
            return columns;
        }

        public MapToDSL<T> columnDefinition(String column, CsvColumnDefinition columnDefinition) {
            return this.columnDefinition((Predicate<CsvColumnKey>)new CaseInsensitiveFieldKeyNamePredicate(column), columnDefinition);
        }

        public MapToDSL<T> columnDefinition(Predicate<? super CsvColumnKey> predicate, CsvColumnDefinition columnDefinition) {
            return new MapToDSL<T>(this.getDsl(), this.classMeta, this.mapToClass, this.newColumnDefinitionProvider(predicate, columnDefinition));
        }

        public MapWithDSL<T> addKeys(String ... keys) {
            List properties = this.columnDefinitionProvider.getProperties();
            for (String key : keys) {
                properties.add(new AbstractColumnDefinitionProvider.PredicatedColunnPropertyFactory((Predicate)new CaseInsensitiveFieldKeyNamePredicate(key), (UnaryFactory)new ConstantUnaryFactory((Object)KeyProperty.DEFAULT)));
            }
            return new MapToDSL<T>(this.getDsl(), this.classMeta, this.mapToClass, new CsvColumnDefinitionProviderImpl(properties));
        }

        private CsvColumnDefinitionProviderImpl newColumnDefinitionProvider(Predicate<? super CsvColumnKey> predicate, CsvColumnDefinition columnDefinition) {
            List properties = this.columnDefinitionProvider.getProperties();
            for (Object property : columnDefinition.properties()) {
                properties.add(new AbstractColumnDefinitionProvider.PredicatedColunnPropertyFactory(predicate, (UnaryFactory)new ConstantUnaryFactory(property)));
            }
            return new CsvColumnDefinitionProviderImpl(properties);
        }

        public StaticMapToDSL<T> addMapping(String column) {
            return this.staticMapper().addMapping(column);
        }

        public StaticMapToDSL<T> addKey(String key) {
            return this.staticMapper().addKey(key);
        }

        public StaticMapToDSL<T> addMapping(String column, CsvColumnDefinition columnDefinition) {
            return this.staticMapper().addMapping(column, columnDefinition);
        }

        private StaticMapToDSL<T> staticMapper() {
            return this.headers(new String[0], (AbstractDSL)this.getDsl().skip(1));
        }
    }

    public static final class DSLYamlComment
    extends AbstractDSL<DSLYamlComment> {
        private static final OnReaderFactory<CloseableCsvReader, DSLYamlComment> CREATE_CLOSEABLE_CSV_RAW_READER = new OnReaderFactory<CloseableCsvReader, DSLYamlComment>(){

            @Override
            public CloseableCsvReader apply(Reader reader, DSLYamlComment dsl) throws IOException {
                return new CloseableCsvReader(dsl.rawReader(dsl.charBuffer(reader)), reader);
            }
        };

        protected DSLYamlComment(char separatorChar, char quoteChar, int bufferSize, int skip, int limit, int maxBufferSize, AbstractDSL.StringPostProcessing stringPostProcessing, org.simpleflatmapper.util.Function<? super CellConsumer, ? extends CellConsumer> cellConsumerWrapper) {
            super(separatorChar, quoteChar, bufferSize, skip, limit, maxBufferSize, stringPostProcessing, cellConsumerWrapper);
        }

        private CsvReader rawReader(CharBuffer charBuffer) throws IOException {
            CsvReader csvReader = new CsvReader(this.charConsumer(charBuffer), null);
            csvReader.skipRows(this.skip);
            return csvReader;
        }

        public void forEach(Reader reader, CheckedConsumer<String[]> rowConsumer, CheckedConsumer<String> commentConsumer) throws IOException {
            this._forEach(this.rawReader(this.charBuffer(reader)), rowConsumer, commentConsumer);
        }

        public void forEach(CharSequence content, CheckedConsumer<String[]> rowConsumer, CheckedConsumer<String> commentConsumer) throws IOException {
            this._forEach(this.rawReader(this.charBuffer(content)), rowConsumer, commentConsumer);
        }

        public void forEach(String content, CheckedConsumer<String[]> rowConsumer, CheckedConsumer<String> commentConsumer) throws IOException {
            this._forEach(this.rawReader(this.charBuffer(content)), rowConsumer, commentConsumer);
        }

        private void _forEach(CsvReader reader, CheckedConsumer<String[]> rowConsumer, CheckedConsumer<String> commentConsumer) throws IOException {
            reader.parseAll(this.newYamlCellConsumer(rowConsumer, commentConsumer));
        }

        private YamlCommentUnescapeContentCellConsumer newYamlCellConsumer(CheckedConsumer<String[]> rowConsumer, CheckedConsumer<String> commentConsumer) {
            return new YamlCommentUnescapeContentCellConsumer(this.superGetCellTransformer(this.getTextFormat(), this.stringPostProcessing), StringArrayCellConsumer.newInstance(rowConsumer), StringConcatCellConsumer.newInstance(commentConsumer, this.separatorChar));
        }

        private CellPreProcessor superGetCellTransformer(TextFormat textFormat, AbstractDSL.StringPostProcessing stringPostProcessing) {
            return super.getCellTransformer(textFormat, stringPostProcessing);
        }

        @Override
        protected CellPreProcessor getCellTransformer(TextFormat textFormat, AbstractDSL.StringPostProcessing stringPostProcessing) {
            if (stringPostProcessing == AbstractDSL.StringPostProcessing.TRIM_AND_UNESCAPE) {
                return NoopYamlTrimeCellPreProcessor.INSTANCE;
            }
            return NoopCellPreProcessor.INSTANCE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void forEach(File file, CheckedConsumer<String[]> rowConsumer, CheckedConsumer<String> commentConsumer) throws IOException {
            try (CloseableCsvReader csvReader = this.rawReader(file);){
                csvReader.parseAll(this.newYamlCellConsumer(rowConsumer, commentConsumer));
            }
        }

        private final CloseableCsvReader rawReader(File file) throws IOException {
            return CsvParser.onReader(file, this, CREATE_CLOSEABLE_CSV_RAW_READER);
        }

        @Override
        protected DSLYamlComment newDSL(char separatorChar, char quoteChar, int bufferSize, int skip, int limit, int maxBufferSize, AbstractDSL.StringPostProcessing stringPostProcessing, org.simpleflatmapper.util.Function<? super CellConsumer, ? extends CellConsumer> cellConsumerWrapper) {
            return new DSLYamlComment(separatorChar, quoteChar, bufferSize, skip, limit, maxBufferSize, stringPostProcessing, cellConsumerWrapper);
        }
    }

    public static final class DSL
    extends AbstractDSL<DSL> {
        protected DSL() {
        }

        protected DSL(char separatorChar, char quoteChar, int bufferSize, int skip, int limit, int maxBufferSize, AbstractDSL.StringPostProcessing stringPostProcessing, org.simpleflatmapper.util.Function<? super CellConsumer, ? extends CellConsumer> cellConsumerWrapper) {
            super(separatorChar, quoteChar, bufferSize, skip, limit, maxBufferSize, stringPostProcessing, cellConsumerWrapper);
        }

        public DSL trimSpaces() {
            return new DSL(this.separatorChar, this.quoteChar, this.bufferSize, this.skip, this.limit, this.maxBufferSize, AbstractDSL.StringPostProcessing.TRIM_AND_UNESCAPE, (org.simpleflatmapper.util.Function<? super CellConsumer, ? extends CellConsumer>)this.cellConsumerWrapper);
        }

        public DSLYamlComment withYamlComments() {
            return new DSLYamlComment(this.separatorChar, this.quoteChar, this.bufferSize, this.skip, this.limit, this.maxBufferSize, this.stringPostProcessing, (org.simpleflatmapper.util.Function<? super CellConsumer, ? extends CellConsumer>)new org.simpleflatmapper.util.Function<CellConsumer, CellConsumer>(){

                public CellConsumer apply(CellConsumer cellConsumer) {
                    return new YamlCommentUnescapeContentCellConsumer(this.getCellTransformer(this.getTextFormat(), stringPostProcessing), cellConsumer, IgnoreCellConsumer.INSTANCE);
                }
            });
        }

        public DSL disableUnescaping() {
            return new DSL(this.separatorChar, this.quoteChar, this.bufferSize, this.skip, this.limit, this.maxBufferSize, AbstractDSL.StringPostProcessing.NONE, (org.simpleflatmapper.util.Function<? super CellConsumer, ? extends CellConsumer>)this.cellConsumerWrapper);
        }

        @Override
        protected DSL newDSL(char separatorChar, char quoteChar, int bufferSize, int skip, int limit, int maxBufferSize, AbstractDSL.StringPostProcessing stringPostProcessing, org.simpleflatmapper.util.Function<? super CellConsumer, ? extends CellConsumer> cellConsumerWrapper) {
            return new DSL(separatorChar, quoteChar, bufferSize, skip, limit, maxBufferSize, stringPostProcessing, cellConsumerWrapper);
        }
    }

    protected static abstract class AbstractDSL<D extends AbstractDSL<D>> {
        protected final char separatorChar;
        protected final char quoteChar;
        protected final int bufferSize;
        protected final int skip;
        protected final int limit;
        protected final int maxBufferSize;
        protected final StringPostProcessing stringPostProcessing;
        protected final org.simpleflatmapper.util.Function<? super CellConsumer, ? extends CellConsumer> cellConsumerWrapper;

        protected AbstractDSL() {
            this.separatorChar = (char)44;
            this.quoteChar = (char)34;
            this.bufferSize = 4096;
            this.skip = 0;
            this.limit = -1;
            this.maxBufferSize = 0x800000;
            this.stringPostProcessing = StringPostProcessing.UNESCAPE;
            this.cellConsumerWrapper = null;
        }

        protected AbstractDSL(char separatorChar, char quoteChar, int bufferSize, int skip, int limit, int maxBufferSize, StringPostProcessing stringPostProcessing, org.simpleflatmapper.util.Function<? super CellConsumer, ? extends CellConsumer> cellConsumerWrapper) {
            this.separatorChar = separatorChar;
            this.quoteChar = quoteChar;
            this.bufferSize = bufferSize;
            this.skip = skip;
            this.limit = limit;
            this.maxBufferSize = maxBufferSize;
            this.stringPostProcessing = stringPostProcessing;
            this.cellConsumerWrapper = cellConsumerWrapper;
        }

        public final <CC extends CellConsumer> CC parse(Reader reader, CC cellConsumer) throws IOException {
            return this.parse(this.charBuffer(reader), cellConsumer);
        }

        public final <CC extends CellConsumer> CC parse(String content, CC cellConsumer) throws IOException {
            return this.parse(this.charBuffer(content), cellConsumer);
        }

        public final <CC extends CellConsumer> CC parse(CharSequence content, CC cellConsumer) throws IOException {
            return this.parse(this.charBuffer(content), cellConsumer);
        }

        private <CC extends CellConsumer> CC parse(CharBuffer charBuffer, CC cellConsumer) throws IOException {
            CsvReader csvreader = this.reader(charBuffer);
            if (this.limit == -1) {
                return csvreader.parseAll(cellConsumer);
            }
            return csvreader.parseRows(cellConsumer, this.limit);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final <CC extends CellConsumer> CC parse(File file, CC cellConsumer) throws IOException {
            FileReader reader = new FileReader(file);
            CC CC = this.parse(reader, cellConsumer);
            return CC;
            finally {
                try {
                    ((Reader)reader).close();
                }
                catch (IOException iOException) {}
            }
        }

        public final CsvReader reader(Reader reader) throws IOException {
            return this.reader(this.charBuffer(reader));
        }

        public final CsvReader reader(CharSequence content) throws IOException {
            return this.reader(this.charBuffer(content));
        }

        public final CsvReader reader(String content) throws IOException {
            return this.reader(this.charBuffer(content));
        }

        private CsvReader reader(CharBuffer charBuffer) throws IOException {
            CsvReader csvReader = new CsvReader(this.charConsumer(charBuffer), this.cellConsumerWrapper);
            csvReader.skipRows(this.skip);
            return csvReader;
        }

        protected CharBuffer charBuffer(Reader reader) throws IOException {
            return new ReaderCharBuffer(this.bufferSize, this.maxBufferSize, reader);
        }

        protected CharBuffer charBuffer(CharSequence content) throws IOException {
            return new CharSequenceCharBuffer(content);
        }

        protected CharBuffer charBuffer(String content) throws IOException {
            return new CharSequenceCharBuffer(content);
        }

        public final CloseableCsvReader reader(File file) throws IOException {
            return (CloseableCsvReader)CsvParser.onReader(file, this, CREATE_CLOSEABLE_CSV_READER);
        }

        public final Iterator<String[]> iterator(Reader reader) throws IOException {
            return this.reader(reader).iterator();
        }

        public final Iterator<String[]> iterator(CharSequence content) throws IOException {
            return this.reader(content).iterator();
        }

        public final Iterator<String[]> iterator(String content) throws IOException {
            return this.reader(content).iterator();
        }

        public final CloseableIterator<String[]> iterator(File file) throws IOException {
            return (CloseableIterator)CsvParser.onReader(file, this, CREATE_CLOSEABLE_ITERATOR);
        }

        public final <H extends CheckedConsumer<String[]>> H forEach(Reader reader, H consumer) throws IOException {
            return this.reader(reader).read(consumer);
        }

        public final <H extends CheckedConsumer<String[]>> H forEach(CharSequence content, H consumer) throws IOException {
            return this.reader(content).read(consumer);
        }

        public final <H extends CheckedConsumer<String[]>> H forEach(String content, H consumer) throws IOException {
            return this.reader(content).read(consumer);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final <H extends CheckedConsumer<String[]>> H forEach(File file, H consumer) throws IOException {
            try (CloseableCsvReader csvReader = this.reader(file);){
                csvReader.read(consumer);
            }
            return consumer;
        }

        public final <T> MapToDSL<T> mapTo(Type target) {
            return new MapToDSL(this, target);
        }

        public final <T> MapToDSL<T> mapTo(Class<T> target) {
            return this.mapTo((Type)target);
        }

        public final <T> MapToDSL<T> mapTo(TypeReference<T> target) {
            return this.mapTo(target.getType());
        }

        public final <T1, T2> MapToDSL<Tuple2<T1, T2>> mapTo(Class<T1> class1, Class<T2> class2) {
            return new MapToDSL<Tuple2<T1, T2>>(this, Tuples.typeDef((Type[])new Type[]{class1, class2}));
        }

        public final <T1, T2, T3> MapToDSL<Tuple3<T1, T2, T3>> mapTo(Class<T1> class1, Class<T2> class2, Class<T3> class3) {
            return new MapToDSL<Tuple3<T1, T2, T3>>(this, Tuples.typeDef((Type[])new Type[]{class1, class2, class3}));
        }

        public final <T1, T2, T3, T4> MapToDSL<Tuple4<T1, T2, T3, T4>> mapTo(Class<T1> class1, Class<T2> class2, Class<T3> class3, Class<T4> class4) {
            return new MapToDSL<Tuple4<T1, T2, T3, T4>>(this, Tuples.typeDef((Type[])new Type[]{class1, class2, class3, class4}));
        }

        public final <T1, T2, T3, T4, T5> MapToDSL<Tuple5<T1, T2, T3, T4, T5>> mapTo(Class<T1> class1, Class<T2> class2, Class<T3> class3, Class<T4> class4, Class<T5> class5) {
            return new MapToDSL<Tuple5<T1, T2, T3, T4, T5>>(this, Tuples.typeDef((Type[])new Type[]{class1, class2, class3, class4, class5}));
        }

        public final <T1, T2, T3, T4, T5, T6> MapToDSL<Tuple6<T1, T2, T3, T4, T5, T6>> mapTo(Class<T1> class1, Class<T2> class2, Class<T3> class3, Class<T4> class4, Class<T5> class5, Class<T6> class6) {
            return new MapToDSL<Tuple6<T1, T2, T3, T4, T5, T6>>(this, Tuples.typeDef((Type[])new Type[]{class1, class2, class3, class4, class5, class6}));
        }

        public final <T1, T2, T3, T4, T5, T6, T7> MapToDSL<Tuple7<T1, T2, T3, T4, T5, T6, T7>> mapTo(Class<T1> class1, Class<T2> class2, Class<T3> class3, Class<T4> class4, Class<T5> class5, Class<T6> class6, Class<T7> class7) {
            return new MapToDSL<Tuple7<T1, T2, T3, T4, T5, T6, T7>>(this, Tuples.typeDef((Type[])new Type[]{class1, class2, class3, class4, class5, class6, class7}));
        }

        public final <T1, T2, T3, T4, T5, T6, T7, T8> MapToDSL<Tuple8<T1, T2, T3, T4, T5, T6, T7, T8>> mapTo(Class<T1> class1, Class<T2> class2, Class<T3> class3, Class<T4> class4, Class<T5> class5, Class<T6> class6, Class<T7> class7, Class<T8> class8) {
            return new MapToDSL<Tuple8<T1, T2, T3, T4, T5, T6, T7, T8>>(this, Tuples.typeDef((Type[])new Type[]{class1, class2, class3, class4, class5, class6, class7, class8}));
        }

        public final <T> MapWithDSL<T> mapWith(CsvMapper<T> mapper) {
            return new MapWithDSL<T>(this, mapper);
        }

        public final Stream<String[]> stream(Reader reader) throws IOException {
            return this.reader(reader).stream();
        }

        public final Stream<String[]> stream(CharSequence content) throws IOException {
            return this.reader(content).stream();
        }

        public final Stream<String[]> stream(String content) throws IOException {
            return this.reader(content).stream();
        }

        @Deprecated
        public final Stream<String[]> stream(File file) throws IOException {
            return CsvParser.onReader(file, this, (reader, dsl) -> (Stream)dsl.stream(reader).onClose(() -> {
                try {
                    reader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }));
        }

        public final <R> R stream(File file, Function<Stream<String[]>, R> function) throws IOException {
            FileReader reader = new FileReader(file);
            try {
                return function.apply(this.stream(reader));
            }
            catch (IOException ioe) {
                try {
                    ((Reader)reader).close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw ioe;
            }
        }

        protected final CharConsumer charConsumer(CharBuffer charBuffer) throws IOException {
            TextFormat textFormat = this.getTextFormat();
            if (this.isCsv()) {
                return new CsvCharConsumer(charBuffer);
            }
            return new ConfigurableCharConsumer(charBuffer, textFormat, this.getCellTransformer(textFormat, this.stringPostProcessing));
        }

        private boolean isCsv() {
            return this.quoteChar == '\"' && this.separatorChar == ',' && this.stringPostProcessing == StringPostProcessing.UNESCAPE;
        }

        protected TextFormat getTextFormat() {
            return new TextFormat(this.separatorChar, this.quoteChar);
        }

        protected CellPreProcessor getCellTransformer(TextFormat textFormat, StringPostProcessing stringPostProcessing) {
            switch (stringPostProcessing) {
                case TRIM_AND_UNESCAPE: {
                    return new TrimAndUnescapeCellPreProcessor(this.getUnescapeCellTransformer(textFormat));
                }
                case UNESCAPE: {
                    return this.getUnescapeCellTransformer(textFormat);
                }
                case NONE: {
                    return NoopCellPreProcessor.INSTANCE;
                }
            }
            throw new IllegalStateException("Could not instantiate char consumer " + (Object)((Object)stringPostProcessing));
        }

        protected CellPreProcessor getUnescapeCellTransformer(TextFormat textFormat) {
            if (textFormat.getEscapeChar() == '\"') {
                return CsvUnescapeCellPreProcessor.INSTANCE;
            }
            return new UnescapeCellPreProcessor(textFormat.getEscapeChar());
        }

        public final int maxBufferSize() {
            return this.maxBufferSize;
        }

        public final int bufferSize() {
            return this.bufferSize;
        }

        public final int limit() {
            return this.limit;
        }

        public final int skip() {
            return this.skip;
        }

        public final char separator() {
            return this.separatorChar;
        }

        public final char quote() {
            return this.quoteChar;
        }

        public D separator(char c) {
            return this.newDSL(c, this.quoteChar, this.bufferSize, this.skip, this.limit, this.maxBufferSize, this.stringPostProcessing, this.cellConsumerWrapper);
        }

        public D quote(char c) {
            return this.newDSL(this.separatorChar, c, this.bufferSize, this.skip, this.limit, this.maxBufferSize, this.stringPostProcessing, this.cellConsumerWrapper);
        }

        public D bufferSize(int size) {
            return this.newDSL(this.separatorChar, this.quoteChar, size, this.skip, this.limit, this.maxBufferSize, this.stringPostProcessing, this.cellConsumerWrapper);
        }

        public D skip(int skip) {
            return this.newDSL(this.separatorChar, this.quoteChar, this.bufferSize, skip, this.limit, this.maxBufferSize, this.stringPostProcessing, this.cellConsumerWrapper);
        }

        public D limit(int limit) {
            return this.newDSL(this.separatorChar, this.quoteChar, this.bufferSize, this.skip, limit, this.maxBufferSize, this.stringPostProcessing, this.cellConsumerWrapper);
        }

        public D maxBufferSize(int maxBufferSize) {
            return this.newDSL(this.separatorChar, this.quoteChar, this.bufferSize, this.skip, this.limit, maxBufferSize, this.stringPostProcessing, this.cellConsumerWrapper);
        }

        protected abstract D newDSL(char var1, char var2, int var3, int var4, int var5, int var6, StringPostProcessing var7, org.simpleflatmapper.util.Function<? super CellConsumer, ? extends CellConsumer> var8);

        protected static enum StringPostProcessing {
            NONE,
            UNESCAPE,
            TRIM_AND_UNESCAPE;

        }
    }
}

