/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.csv;

import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class Row
implements Map<String, String> {
    public static final int SORTED_HEADERS_THRESHOLD = 10;
    private final Headers headers;
    private final String[] values;
    private Set<Map.Entry<String, String>> entrySet;
    private Collection<String> mapvalues;

    public Row(Headers headers, String[] values) {
        this.headers = headers;
        this.values = values;
    }

    @Override
    public int size() {
        return this.headers.size();
    }

    @Override
    public boolean isEmpty() {
        return this.headers.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        if (key instanceof String) {
            return this.headers.containsKey((String)key);
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        for (int i = 0; i < this.values.length; ++i) {
            if (!(value == null ? this.values[i] == null : value.equals(this.values[i]))) continue;
            return true;
        }
        return false;
    }

    @Override
    public String get(Object key) {
        if (!(key instanceof String)) {
            return null;
        }
        int i = this.headers.indexOf((String)key);
        if (i != -1) {
            return this.values[i];
        }
        return null;
    }

    @Override
    public String put(String key, String value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<String> keySet() {
        return this.headers.keySet();
    }

    @Override
    public Collection<String> values() {
        if (this.mapvalues != null) {
            this.mapvalues = Collections.unmodifiableList(Arrays.asList(this.values));
        }
        return this.mapvalues;
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        if (this.entrySet == null) {
            HashSet<AbstractMap.SimpleImmutableEntry<String, String>> set = new HashSet<AbstractMap.SimpleImmutableEntry<String, String>>();
            for (int i = 0; i < this.headers.headers.length; ++i) {
                set.add(new AbstractMap.SimpleImmutableEntry<String, String>(this.headers.headers[i], this.values[i]));
            }
            this.entrySet = Collections.unmodifiableSet(set);
        }
        return this.entrySet;
    }

    public static Headers headers(String[] headers) {
        if (headers.length > 10) {
            return new SortedHeaders(headers);
        }
        return new DefaultHeaders(headers);
    }

    private static boolean equals(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    public static class SortedHeaders
    extends Headers {
        private final String[] sortedHeader;
        private final int[] sortedHeaderIndex;

        protected SortedHeaders(String[] headers) {
            super(headers);
            int i;
            this.sortedHeader = new String[headers.length];
            this.sortedHeaderIndex = new int[headers.length];
            IndexedHeader[] indexedHeaders = new IndexedHeader[headers.length];
            for (i = 0; i < indexedHeaders.length; ++i) {
                indexedHeaders[i] = new IndexedHeader(headers[i], i);
            }
            Arrays.sort(indexedHeaders, IndexedHeader.NAME_COMPARATOR);
            for (i = 0; i < indexedHeaders.length; ++i) {
                IndexedHeader ih = indexedHeaders[i];
                this.sortedHeader[i] = ih.name;
                this.sortedHeaderIndex[i] = ih.index;
            }
        }

        @Override
        public final int indexOf(String key) {
            int i = Arrays.binarySearch(this.sortedHeader, key);
            if (i < 0) {
                return -1;
            }
            return this.sortedHeaderIndex[i];
        }

        private static class IndexedHeader {
            public static final Comparator<IndexedHeader> NAME_COMPARATOR = new Comparator<IndexedHeader>(){

                @Override
                public int compare(IndexedHeader o1, IndexedHeader o2) {
                    return o1.name.compareTo(o2.name);
                }
            };
            public final String name;
            public final int index;

            IndexedHeader(String name, int index) {
                this.name = name == null ? "" : name;
                this.index = index;
            }
        }
    }

    public static class DefaultHeaders
    extends Headers {
        protected DefaultHeaders(String[] headers) {
            super(headers);
        }

        @Override
        public final int indexOf(String key) {
            for (int i = 0; i < this.headers.length; ++i) {
                if (!Row.equals(key, this.headers[i])) continue;
                return i;
            }
            return -1;
        }
    }

    static abstract class Headers {
        protected final String[] headers;
        private Set<String> keySet;

        protected Headers(String[] headers) {
            this.headers = headers;
        }

        public final boolean containsKey(String key) {
            return this.indexOf(key) != -1;
        }

        public final int size() {
            return this.headers.length;
        }

        public final boolean isEmpty() {
            return this.headers.length > 0;
        }

        public final Set<String> keySet() {
            if (this.keySet == null) {
                this.keySet = new HashSet<String>();
                Collections.addAll(this.keySet, this.headers);
            }
            return this.keySet;
        }

        public final String get(int i) {
            return this.headers[i];
        }

        public abstract int indexOf(String var1);
    }
}

