/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.csv.parser;

import java.io.IOException;
import org.simpleflatmapper.csv.parser.CellConsumer;
import org.simpleflatmapper.csv.parser.CellPreProcessor;
import org.simpleflatmapper.csv.parser.CharBuffer;
import org.simpleflatmapper.csv.parser.TextFormat;

public final class CharConsumer {
    public static final int ESCAPED = 128;
    public static final int ROW_DATA = 64;
    public static final int COMMENTED = 32;
    public static final int CELL_DATA = 16;
    public static final int QUOTED = 8;
    public static final int LAST_CHAR_WAS_SEPARATOR = 4;
    public static final int LAST_CHAR_WAS_CR = 2;
    public static final int QUOTED_AREA = 1;
    public static final int NONE = 0;
    private static final int TURN_OFF_LAST_CHAR_MASK = -7;
    private static final int TURN_OFF_QUOTED_AREA = -2;
    private static final char LF = '\n';
    private static final char CR = '\r';
    private static final char SPACE = ' ';
    private static final char COMMENT = '#';
    private final CharBuffer csvBuffer;
    private final TextFormat textFormat;
    private final CellPreProcessor cellPreProcessor;
    private int _currentIndex = 0;
    private int _currentState = 0;

    public CharConsumer(CharBuffer csvBuffer, TextFormat textFormat, CellPreProcessor cellPreProcessor) {
        this.csvBuffer = csvBuffer;
        this.cellPreProcessor = cellPreProcessor;
        this.textFormat = textFormat;
    }

    public final void consumeAllBuffer(CellConsumer cellConsumer) {
        boolean notIgnoreLeadingSpace = !this.cellPreProcessor.ignoreLeadingSpace();
        boolean yamlComment = this.textFormat.yamlComment;
        char escapeChar = this.textFormat.escapeChar;
        char quoteChar = this.textFormat.quoteChar;
        char separatorChar = this.textFormat.separatorChar;
        int currentState = this._currentState;
        int currentIndex = this._currentIndex;
        char[] chars = this.csvBuffer.buffer;
        int bufferSize = this.csvBuffer.bufferSize;
        block0: while (currentIndex < bufferSize) {
            if ((currentState & 1) == 0) {
                if ((currentState & 0x20) == 0) {
                    while (currentIndex < bufferSize) {
                        char character = chars[currentIndex];
                        int cellEnd = currentIndex++;
                        if (character == separatorChar) {
                            this.cellPreProcessor.newCell(chars, this.csvBuffer.mark, cellEnd, cellConsumer, currentState);
                            this.csvBuffer.mark = currentIndex;
                            currentState = 68;
                            continue;
                        }
                        if (character == '\n') {
                            if ((currentState & 2) == 0) {
                                this.cellPreProcessor.newCell(chars, this.csvBuffer.mark, cellEnd, cellConsumer, currentState);
                                cellConsumer.endOfRow();
                            }
                            this.csvBuffer.mark = currentIndex;
                            currentState = 0;
                            continue;
                        }
                        if (character == '\r') {
                            this.cellPreProcessor.newCell(chars, this.csvBuffer.mark, cellEnd, cellConsumer, currentState);
                            this.csvBuffer.mark = currentIndex;
                            currentState = 2;
                            cellConsumer.endOfRow();
                            continue;
                        }
                        if (((currentState ^ 0x10) & 0x18) != 0 && character == quoteChar) {
                            currentState = 9;
                            continue block0;
                        }
                        if (yamlComment && (currentState & 0x50) == 0 && character == '#') {
                            currentState |= 0x20;
                            continue block0;
                        }
                        currentState &= 0xFFFFFFF9;
                        if (!notIgnoreLeadingSpace && character == ' ') continue;
                        currentState |= 0x10;
                    }
                    continue;
                }
                int nextEndOfLineChar = this.findNexEndOfLineChar(chars, currentIndex, bufferSize);
                if (nextEndOfLineChar != -1) {
                    this.cellPreProcessor.newCell(chars, this.csvBuffer.mark, nextEndOfLineChar, cellConsumer, currentState);
                    cellConsumer.endOfRow();
                    this.csvBuffer.mark = currentIndex = nextEndOfLineChar + 1;
                    currentState = chars[nextEndOfLineChar] == '\r' ? 2 : 0;
                    continue;
                }
                currentIndex = bufferSize;
                continue;
            }
            int endOfQuotedArea = this.findEndOfQuotedArea(chars, currentIndex, bufferSize, escapeChar, quoteChar, currentState);
            if (endOfQuotedArea != -1) {
                currentIndex = endOfQuotedArea + 1;
                currentState &= 0xFFFFFFFE;
                continue;
            }
            return;
        }
        this._currentState = currentState;
        this._currentIndex = currentIndex;
    }

    public final boolean consumeToNextRow(CellConsumer cellConsumer) {
        boolean notIgnoreLeadingSpace = !this.cellPreProcessor.ignoreLeadingSpace();
        char escapeChar = this.textFormat.escapeChar;
        char separatorChar = this.textFormat.separatorChar;
        char quoteChar = this.textFormat.quoteChar;
        boolean yamlComment = this.textFormat.yamlComment;
        int currentState = this._currentState;
        int currentIndex = this._currentIndex;
        char[] chars = this.csvBuffer.buffer;
        int bufferSize = this.csvBuffer.bufferSize;
        block0: while (currentIndex < bufferSize) {
            if ((currentState & 1) == 0) {
                if ((currentState & 0x20) == 0) {
                    while (currentIndex < bufferSize) {
                        char character = chars[currentIndex];
                        int cellEnd = currentIndex++;
                        if (character == separatorChar) {
                            this.cellPreProcessor.newCell(chars, this.csvBuffer.mark, cellEnd, cellConsumer, currentState);
                            this.csvBuffer.mark = currentIndex;
                            currentState = 68;
                            continue;
                        }
                        if (character == '\n') {
                            if ((currentState & 2) == 0) {
                                this.cellPreProcessor.newCell(chars, this.csvBuffer.mark, cellEnd, cellConsumer, currentState);
                                if (cellConsumer.endOfRow()) {
                                    this.csvBuffer.mark = currentIndex;
                                    this._currentState = 0;
                                    this._currentIndex = currentIndex;
                                    return true;
                                }
                            }
                            this.csvBuffer.mark = currentIndex;
                            currentState = 0;
                            continue;
                        }
                        if (character == '\r') {
                            this.cellPreProcessor.newCell(chars, this.csvBuffer.mark, cellEnd, cellConsumer, currentState);
                            this.csvBuffer.mark = currentIndex;
                            currentState = 2;
                            if (!cellConsumer.endOfRow()) continue;
                            this._currentState = currentState;
                            this._currentIndex = currentIndex;
                            return true;
                        }
                        if (((currentState ^ 0x10) & 0x18) != 0 && character == quoteChar) {
                            currentState = 9;
                            continue block0;
                        }
                        if (yamlComment && (currentState & 0x50) == 0 && character == '#') {
                            currentState |= 0x20;
                            continue block0;
                        }
                        currentState &= 0xFFFFFFF9;
                        if (!notIgnoreLeadingSpace && character == ' ') continue;
                        currentState |= 0x10;
                    }
                    continue;
                }
                int nextEndOfLineChar = this.findNexEndOfLineChar(chars, currentIndex, bufferSize);
                if (nextEndOfLineChar != -1) {
                    currentIndex = nextEndOfLineChar + 1;
                    this.cellPreProcessor.newCell(chars, this.csvBuffer.mark, nextEndOfLineChar, cellConsumer, currentState);
                    this.csvBuffer.mark = currentIndex;
                    int n = currentState = chars[nextEndOfLineChar] == '\r' ? 2 : 0;
                    if (!cellConsumer.endOfRow()) continue;
                    this._currentState = currentState;
                    this._currentIndex = currentIndex;
                    return true;
                }
                currentIndex = bufferSize;
                continue;
            }
            int nextEscapeChar = this.findEndOfQuotedArea(chars, currentIndex, bufferSize, escapeChar, quoteChar, currentState);
            if (nextEscapeChar != -1) {
                currentIndex = nextEscapeChar + 1;
                currentState &= 0xFFFFFFFE;
                continue;
            }
            return false;
        }
        this._currentState = currentState;
        this._currentIndex = currentIndex;
        return false;
    }

    private int findEndOfQuotedArea(char[] chars, int start, int end, char escapeChar, char quoteChar, int currentState) {
        boolean escaped = (currentState & 0x80) != 0;
        for (int i = start; i < end; ++i) {
            if (!escaped) {
                char c = chars[i];
                if (c == quoteChar) {
                    return i;
                }
                escaped = c == escapeChar;
                continue;
            }
            escaped = false;
        }
        this._currentState = currentState | (escaped ? 128 : 0);
        this._currentIndex = end;
        return -1;
    }

    private int findNexEndOfLineChar(char[] chars, int start, int end) {
        for (int i = start; i < end; ++i) {
            char c = chars[i];
            if (c != '\r' && c != '\n') continue;
            return i;
        }
        return -1;
    }

    public final void finish(CellConsumer cellConsumer) {
        if (this.hasUnconsumedData() || (this._currentState & 4) != 0) {
            this.cellPreProcessor.newCell(this.csvBuffer.buffer, this.csvBuffer.mark, this._currentIndex, cellConsumer, this._currentState);
            this.csvBuffer.mark = this._currentIndex + 1;
            this._currentState = 0;
        }
        cellConsumer.end();
    }

    private boolean hasUnconsumedData() {
        return this._currentIndex > this.csvBuffer.mark;
    }

    public boolean next() throws IOException {
        int mark = this.csvBuffer.mark;
        boolean b = this.csvBuffer.next();
        this._currentIndex -= mark - this.csvBuffer.mark;
        return b;
    }
}

