/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.csv.mapper;

import java.lang.reflect.Type;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.simpleflatmapper.converter.Converter;
import org.simpleflatmapper.converter.ConverterService;
import org.simpleflatmapper.csv.CellWriter;
import org.simpleflatmapper.csv.CsvColumnKey;
import org.simpleflatmapper.csv.impl.writer.BooleanAppendableSetter;
import org.simpleflatmapper.csv.impl.writer.ByteAppendableSetter;
import org.simpleflatmapper.csv.impl.writer.CellWriterSetterWrapper;
import org.simpleflatmapper.csv.impl.writer.CharacterAppendableSetter;
import org.simpleflatmapper.csv.impl.writer.ConvertingAppender;
import org.simpleflatmapper.csv.impl.writer.DoubleAppendableSetter;
import org.simpleflatmapper.csv.impl.writer.FloatAppendableSetter;
import org.simpleflatmapper.csv.impl.writer.FormatingAppender;
import org.simpleflatmapper.csv.impl.writer.IntegerAppendableSetter;
import org.simpleflatmapper.csv.impl.writer.LongAppendableSetter;
import org.simpleflatmapper.csv.impl.writer.ObjectToStringSetter;
import org.simpleflatmapper.csv.impl.writer.ShortAppendableSetter;
import org.simpleflatmapper.map.FieldMapper;
import org.simpleflatmapper.map.MapperBuilderErrorHandler;
import org.simpleflatmapper.map.MappingContext;
import org.simpleflatmapper.map.context.MappingContextFactoryBuilder;
import org.simpleflatmapper.map.fieldmapper.BooleanFieldMapper;
import org.simpleflatmapper.map.fieldmapper.ByteFieldMapper;
import org.simpleflatmapper.map.fieldmapper.CharacterFieldMapper;
import org.simpleflatmapper.map.fieldmapper.DoubleFieldMapper;
import org.simpleflatmapper.map.fieldmapper.FieldMapperImpl;
import org.simpleflatmapper.map.fieldmapper.FloatFieldMapper;
import org.simpleflatmapper.map.fieldmapper.IntFieldMapper;
import org.simpleflatmapper.map.fieldmapper.LongFieldMapper;
import org.simpleflatmapper.map.fieldmapper.ShortFieldMapper;
import org.simpleflatmapper.map.mapper.ColumnDefinition;
import org.simpleflatmapper.map.mapper.ConstantTargetFieldMapperFactory;
import org.simpleflatmapper.map.mapper.PropertyMapping;
import org.simpleflatmapper.map.property.DateFormatProperty;
import org.simpleflatmapper.map.property.EnumOrdinalFormatProperty;
import org.simpleflatmapper.map.property.FieldMapperColumnDefinition;
import org.simpleflatmapper.map.property.FormatProperty;
import org.simpleflatmapper.map.property.SetterFactoryProperty;
import org.simpleflatmapper.map.property.SetterProperty;
import org.simpleflatmapper.reflect.Getter;
import org.simpleflatmapper.reflect.Setter;
import org.simpleflatmapper.reflect.SetterFactory;
import org.simpleflatmapper.reflect.meta.ClassMeta;
import org.simpleflatmapper.reflect.meta.ObjectClassMeta;
import org.simpleflatmapper.reflect.meta.PropertyMeta;
import org.simpleflatmapper.reflect.primitive.BooleanGetter;
import org.simpleflatmapper.reflect.primitive.BooleanSetter;
import org.simpleflatmapper.reflect.primitive.ByteGetter;
import org.simpleflatmapper.reflect.primitive.ByteSetter;
import org.simpleflatmapper.reflect.primitive.CharacterGetter;
import org.simpleflatmapper.reflect.primitive.CharacterSetter;
import org.simpleflatmapper.reflect.primitive.DoubleGetter;
import org.simpleflatmapper.reflect.primitive.DoubleSetter;
import org.simpleflatmapper.reflect.primitive.FloatGetter;
import org.simpleflatmapper.reflect.primitive.FloatSetter;
import org.simpleflatmapper.reflect.primitive.IntGetter;
import org.simpleflatmapper.reflect.primitive.IntSetter;
import org.simpleflatmapper.reflect.primitive.LongGetter;
import org.simpleflatmapper.reflect.primitive.LongSetter;
import org.simpleflatmapper.reflect.primitive.ShortGetter;
import org.simpleflatmapper.reflect.primitive.ShortSetter;
import org.simpleflatmapper.reflect.setter.SetterOnGetter;
import org.simpleflatmapper.util.Supplier;
import org.simpleflatmapper.util.TypeHelper;

public class FieldMapperToAppendableFactory
implements ConstantTargetFieldMapperFactory<Appendable, CsvColumnKey> {
    private static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private final CellWriter cellWriter;
    private final ConverterService converterService = ConverterService.getInstance();

    public FieldMapperToAppendableFactory(CellWriter cellWriter) {
        this.cellWriter = cellWriter;
    }

    public <S, P> FieldMapper<S, Appendable> newFieldMapper(PropertyMapping<S, P, CsvColumnKey, FieldMapperColumnDefinition<CsvColumnKey>> pm, MappingContextFactoryBuilder builder, MapperBuilderErrorHandler mappingErrorHandler) {
        Converter converter;
        if (pm == null) {
            throw new NullPointerException("pm is null");
        }
        Getter customGetter = ((FieldMapperColumnDefinition)pm.getColumnDefinition()).getCustomGetterFrom(pm.getPropertyMeta().getOwnerType());
        Getter getter = customGetter != null ? customGetter : pm.getPropertyMeta().getGetter();
        ColumnDefinition columnDefinition = pm.getColumnDefinition();
        Type type = pm.getPropertyMeta().getPropertyType();
        if (TypeHelper.isPrimitive((Type)type) && !columnDefinition.has(FormatProperty.class)) {
            if (getter instanceof BooleanGetter) {
                return new BooleanFieldMapper((BooleanGetter)getter, (BooleanSetter)new BooleanAppendableSetter(this.cellWriter));
            }
            if (getter instanceof ByteGetter) {
                return new ByteFieldMapper((ByteGetter)getter, (ByteSetter)new ByteAppendableSetter(this.cellWriter));
            }
            if (getter instanceof CharacterGetter) {
                return new CharacterFieldMapper((CharacterGetter)getter, (CharacterSetter)new CharacterAppendableSetter(this.cellWriter));
            }
            if (getter instanceof ShortGetter) {
                return new ShortFieldMapper((ShortGetter)getter, (ShortSetter)new ShortAppendableSetter(this.cellWriter));
            }
            if (getter instanceof IntGetter) {
                return new IntFieldMapper((IntGetter)getter, (IntSetter)new IntegerAppendableSetter(this.cellWriter));
            }
            if (getter instanceof LongGetter) {
                return new LongFieldMapper((LongGetter)getter, (LongSetter)new LongAppendableSetter(this.cellWriter));
            }
            if (getter instanceof FloatGetter) {
                return new FloatFieldMapper((FloatGetter)getter, (FloatSetter)new FloatAppendableSetter(this.cellWriter));
            }
            if (getter instanceof DoubleGetter) {
                return new DoubleFieldMapper((DoubleGetter)getter, (DoubleSetter)new DoubleAppendableSetter(this.cellWriter));
            }
        }
        Setter<Appendable, P> setter = null;
        if (TypeHelper.isEnum((Type)type) && columnDefinition.has(EnumOrdinalFormatProperty.class)) {
            setter = new Setter<Appendable, P>(this.cellWriter);
        }
        Format format = null;
        if (columnDefinition.has(FormatProperty.class)) {
            format = ((FormatProperty)columnDefinition.lookFor(FormatProperty.class)).format();
        } else if (TypeHelper.areEquals((Type)type, Date.class)) {
            String df = DEFAULT_DATE_FORMAT;
            DateFormatProperty dfp = (DateFormatProperty)columnDefinition.lookFor(DateFormatProperty.class);
            if (dfp != null) {
                df = dfp.get();
            }
            format = new SimpleDateFormat(df);
        }
        if (format != null) {
            Format f = format;
            builder.addSupplier(((CsvColumnKey)pm.getColumnKey()).getIndex(), (Supplier)new CloneFormatSupplier(f));
            return new FormatingAppender(getter, new MappingContextFormatGetter(((CsvColumnKey)pm.getColumnKey()).getIndex()), this.cellWriter);
        }
        if (setter == null) {
            setter = this.getSetter(pm, this.cellWriter);
        }
        if (setter == null && (converter = this.converterService.findConverter(pm.getPropertyMeta().getPropertyType(), CharSequence.class, columnDefinition != null ? columnDefinition.properties() : new Object[]{})) != null) {
            return new ConvertingAppender(getter, converter, this.cellWriter);
        }
        return new FieldMapperImpl(getter, setter);
    }

    private <S, P> Setter<Appendable, ? super P> getSetter(PropertyMapping<S, P, CsvColumnKey, FieldMapperColumnDefinition<CsvColumnKey>> pm, CellWriter cellWriter) {
        SetterProperty setterProperty = (SetterProperty)((FieldMapperColumnDefinition)pm.getColumnDefinition()).lookFor(SetterProperty.class);
        if (setterProperty != null) {
            return new CellWriterSetterWrapper(cellWriter, setterProperty.getSetter());
        }
        Setter<Appendable, P> setter = this.setterFromFactory(pm);
        if (setter != null) {
            return new CellWriterSetterWrapper<P>(cellWriter, setter);
        }
        return null;
    }

    private <S, P> Setter<Appendable, ? super P> setterFromFactory(PropertyMapping<S, P, CsvColumnKey, FieldMapperColumnDefinition<CsvColumnKey>> pm) {
        ObjectClassMeta ocm;
        ClassMeta classMeta;
        Setter setter = null;
        SetterFactoryProperty setterFactoryProperty = (SetterFactoryProperty)((FieldMapperColumnDefinition)pm.getColumnDefinition()).lookFor(SetterFactoryProperty.class);
        if (setterFactoryProperty != null) {
            SetterFactory setterFactory = setterFactoryProperty.getSetterFactory();
            setter = setterFactory.getSetter(pm);
        }
        if (setter == null && !pm.getPropertyMeta().isSelf() && (classMeta = pm.getPropertyMeta().getPropertyClassMeta()) instanceof ObjectClassMeta && (ocm = (ObjectClassMeta)classMeta).getNumberOfProperties() == 1) {
            PropertyMeta subProp = ocm.getFirstProperty();
            Setter<Appendable, P> subSetter = this.setterFromFactory(pm.propertyMeta(subProp));
            if (subSetter != null) {
                setter = new SetterOnGetter(subSetter, subProp.getGetter());
            } else {
                return new ObjectToStringSetter(subProp.getGetter());
            }
        }
        return setter;
    }

    private static class CloneFormatSupplier
    implements Supplier<Format> {
        private final Format f;

        public CloneFormatSupplier(Format f) {
            this.f = f;
        }

        public Format get() {
            return (Format)this.f.clone();
        }
    }

    private static class MappingContextFormatGetter<S>
    implements Getter<MappingContext<? super S>, Format> {
        private final int index;

        public MappingContextFormatGetter(int index) {
            this.index = index;
        }

        public Format get(MappingContext<? super S> target) throws Exception {
            return (Format)target.context(this.index);
        }
    }
}

