/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.csv.parser;

import org.simpleflatmapper.csv.parser.CellConsumer;
import org.simpleflatmapper.csv.parser.CharBuffer;
import org.simpleflatmapper.csv.parser.CharConsumer;

public final class CsvCharConsumer
extends CharConsumer {
    public static final char escapeChar = '\"';
    public static final char separatorChar = ',';

    public CsvCharConsumer(CharBuffer csvBuffer) {
        super(csvBuffer, false);
    }

    @Override
    protected final boolean isSeparator(char character) {
        return character == ',';
    }

    @Override
    protected final boolean isNotEscapeCharacter(char character) {
        return character != '\"';
    }

    @Override
    protected final void pushCell(char[] chars, int start, int end, CellConsumer cellConsumer) {
        int strStart = start;
        int strEnd = end;
        if (strStart < strEnd && chars[strStart] == '\"') {
            strEnd = this.unescape(chars, ++strStart, strEnd);
        }
        cellConsumer.newCell(chars, strStart, strEnd - strStart);
    }

    private int unescape(char[] chars, int start, int end) {
        for (int i = start; i < end - 1; ++i) {
            if (chars[i] != '\"') continue;
            return this.removeEscapeChars(chars, end, i);
        }
        if (start < end && chars[end - 1] == '\"') {
            return end - 1;
        }
        return end;
    }

    private int removeEscapeChars(char[] chars, int end, int firstEscapeChar) {
        int j = firstEscapeChar;
        boolean escaped = true;
        for (int i = firstEscapeChar + 1; i < end; ++i) {
            boolean bl = escaped = chars[i] == '\"' && !escaped;
            if (escaped) continue;
            chars[j++] = chars[i];
        }
        return j;
    }
}

