/*
 * Decompiled with CFR 0.152.
 */
package org.simple4j.wsclient.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectionsPathRetreiver {
    private static Logger logger = LoggerFactory.getLogger(CollectionsPathRetreiver.class);
    private String keysPropertyName = "KEYS";
    private String listLengthPropertyName = "LENGTH";

    public String getKeysPropertyName() {
        return this.keysPropertyName;
    }

    public void setKeysPropertyName(String keysPropertyName) {
        this.keysPropertyName = keysPropertyName;
    }

    public String getListLengthPropertyName() {
        return this.listLengthPropertyName;
    }

    public void setListLengthPropertyName(String listLengthPropertyName) {
        this.listLengthPropertyName = listLengthPropertyName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List getNestedProperty(Map target, String propertyPath) {
        if (target == null) {
            return null;
        }
        ArrayList<Object> ret = new ArrayList<Object>();
        String escapedPropertyPath = this.escapePropertyPath(propertyPath);
        String escapedPropertyPathSegment = null;
        String escapedRemainingPropertyPath = null;
        int dotIndex = escapedPropertyPath.indexOf(".");
        if (dotIndex + 1 >= escapedPropertyPath.length()) {
            throw new RuntimeException("Property path ending in a dot:" + propertyPath);
        }
        if (dotIndex > -1) {
            escapedPropertyPathSegment = escapedPropertyPath.substring(0, dotIndex);
            escapedRemainingPropertyPath = escapedPropertyPath.substring(dotIndex + 1);
        } else {
            escapedPropertyPathSegment = escapedPropertyPath;
        }
        String escapedPropertyPathSegmentBase = escapedPropertyPathSegment;
        int indexOfSqrBracketOpen = escapedPropertyPathSegment.indexOf("[");
        if (indexOfSqrBracketOpen > -1) {
            List vals;
            escapedPropertyPathSegmentBase = escapedPropertyPathSegment.substring(0, indexOfSqrBracketOpen);
            ArrayList property = (ArrayList)this.getProperty(target, escapedPropertyPathSegmentBase);
            if (property == null) {
                if (!escapedPropertyPathSegmentBase.equals(this.getKeysPropertyName())) return null;
                property = new ArrayList(target.keySet());
            }
            if ((vals = this.getMultilevelIndexedProperty(property, escapedPropertyPathSegment.substring(escapedPropertyPathSegmentBase.length()))) == null) return ret;
            if (escapedRemainingPropertyPath != null) {
                for (int i = 0; i < vals.size(); ++i) {
                    if (vals.get(i) instanceof Map) {
                        Map mapProperty = (Map)vals.get(i);
                        if (mapProperty == null) return null;
                        List val = this.getNestedProperty(mapProperty, escapedRemainingPropertyPath);
                        if (val == null) return null;
                        ret.addAll(val);
                        continue;
                    }
                    System.out.println("List element is not a Map but has remaining path to process:" + this.unescapePropertyPath(escapedRemainingPropertyPath));
                }
                return ret;
            } else {
                ret.addAll(vals);
            }
            return ret;
        } else if (escapedRemainingPropertyPath != null) {
            if (escapedPropertyPathSegmentBase.equalsIgnoreCase("*")) {
                Set entrySet = target.entrySet();
                for (Map.Entry entry : entrySet) {
                    Object val = entry.getValue();
                    if (val instanceof Map) {
                        List nestedVal = this.getNestedMappedProperty((Map)val, escapedRemainingPropertyPath, escapedPropertyPathSegmentBase);
                        if (nestedVal == null) continue;
                        ret.addAll(nestedVal);
                        continue;
                    }
                    System.out.println(val + " not instance of Map. But continuing processing.");
                }
                return ret;
            } else {
                List val = this.getNestedMappedProperty(target, escapedRemainingPropertyPath, escapedPropertyPathSegmentBase);
                if (val == null) return null;
                ret.addAll(val);
            }
            return ret;
        } else if (this.getKeysPropertyName().equals(escapedPropertyPathSegmentBase)) {
            ret.addAll(new ArrayList(target.keySet()));
            return ret;
        } else {
            Object property = this.getProperty(target, escapedPropertyPathSegmentBase);
            if (property == null) return ret;
            if (property instanceof List) {
                ret.addAll((List)property);
                return ret;
            } else {
                ret.add(property);
            }
        }
        return ret;
    }

    private List getNestedMappedProperty(Map target, String escapedRemainingPropertyPath, String escapedPropertyPathSegmentBase) {
        Map property;
        if (this.getKeysPropertyName().equals(escapedPropertyPathSegmentBase)) {
            if (escapedRemainingPropertyPath != null) {
                List ret = null;
                Set keySet = target.keySet();
                for (Object key : keySet) {
                    if (key == null) continue;
                    if (key instanceof Map) {
                        List val = this.getNestedProperty((Map)key, escapedRemainingPropertyPath);
                        if (ret == null) {
                            ret = val;
                            continue;
                        }
                        ret.addAll(val);
                        continue;
                    }
                    System.out.println("key is not Map but has remaining path without index to process:" + this.unescapePropertyPath(escapedRemainingPropertyPath));
                }
            } else {
                return new ArrayList(target.keySet());
            }
        }
        if ((property = (Map)this.getProperty(target, escapedPropertyPathSegmentBase)) != null) {
            List val = this.getNestedProperty(property, escapedRemainingPropertyPath);
            return val;
        }
        return null;
    }

    private String escapePropertyPath(String propertyPath) {
        String escapedPropertyPath = propertyPath.replaceAll("\\\\[.]", "~!@DOT@!~");
        escapedPropertyPath = escapedPropertyPath.replaceAll("\\\\[*]", "~!@STAR@!~");
        escapedPropertyPath = escapedPropertyPath.replaceAll("\\\\[\\(]", "~!@OPEN_BRACE@!~");
        escapedPropertyPath = escapedPropertyPath.replaceAll("\\\\[\\)]", "~!@CLOSE_BRACE@!~");
        escapedPropertyPath = escapedPropertyPath.replaceAll("\\\\[\\[]", "~!@OPEN_SQ_BRACE@!~");
        escapedPropertyPath = escapedPropertyPath.replaceAll("\\\\[\\]]", "~!@CLOSE_SQ_BRACE@!~");
        return escapedPropertyPath;
    }

    private Object getProperty(Map target, String escapedPropertyPathSegmentBase) {
        String propertyName = this.unescapePropertyPath(escapedPropertyPathSegmentBase);
        return target.get(propertyName);
    }

    private String unescapePropertyPath(String escapedPropertyPathSegmentBase) {
        String propertyPath = escapedPropertyPathSegmentBase.replaceAll("(~!@DOT@!~)", ".");
        propertyPath = propertyPath.replaceAll("(~!@STAR@!~)", "*");
        propertyPath = propertyPath.replaceAll("(~!@OPEN_BRACE@!~)", "(");
        propertyPath = propertyPath.replaceAll("(~!@CLOSE_BRACE@!~)", ")");
        propertyPath = propertyPath.replaceAll("(~!@OPEN_SQ_BRACE@!~)", "[");
        propertyPath = propertyPath.replaceAll("(~!@CLOSE_SQ_BRACE@!~)", "]");
        return propertyPath;
    }

    private List getMultilevelIndexedProperty(List target, String indexPaths) {
        int indexOfSqrBracketClose = indexPaths.indexOf("]");
        if (indexOfSqrBracketClose <= 1) {
            throw new RuntimeException("Square brackets out of sequence or not matching");
        }
        String indexStr = indexPaths.substring(1, indexOfSqrBracketClose);
        if (indexStr.matches("[0-9]+")) {
            int index = Integer.parseInt(indexStr);
            if (index < 0 || index > target.size() - 1) {
                logger.info("Property index out of range returning nothing. Target size:{} index:{}", (Object)target.size(), (Object)index);
                return new ArrayList();
            }
            Object val = target.get(index);
            if (indexPaths.length() - 1 > indexOfSqrBracketClose) {
                indexPaths = indexPaths.substring(indexOfSqrBracketClose + 1);
                if (val instanceof List) {
                    return this.getMultilevelIndexedProperty((List)val, indexPaths);
                }
                throw new RuntimeException("Nested indexed property does not contain List");
            }
            ArrayList ret = new ArrayList();
            ret.add(val);
            return ret;
        }
        if (indexStr.matches("[*]")) {
            if (indexPaths.length() - 1 > indexOfSqrBracketClose) {
                indexPaths = indexPaths.substring(indexOfSqrBracketClose + 1);
                ArrayList ret = new ArrayList();
                for (int i = 0; i < target.size(); ++i) {
                    if (target.get(i) instanceof List) {
                        List val = this.getMultilevelIndexedProperty((List)target.get(i), indexPaths);
                        if (val == null) continue;
                        ret.addAll(val);
                        continue;
                    }
                    throw new RuntimeException("Nested indexed property does not contain List");
                }
                return ret;
            }
            return target;
        }
        if (indexStr.matches("(" + this.getListLengthPropertyName() + ")")) {
            ArrayList<Integer> ret = new ArrayList<Integer>();
            ret.add(target.size());
            return ret;
        }
        throw new RuntimeException("Index not a positive integer and not a wildcard");
    }
}

