/*
 * Decompiled with CFR 0.152.
 */
package org.shipkit.auto.version;

import com.github.zafarkhaja.semver.Version;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class VersionNumber
implements Comparable<VersionNumber> {
    private int fourthDigit = -1;
    private Version semver;

    public VersionNumber(String version) {
        try {
            this.semver = Version.valueOf((String)version);
            return;
        }
        catch (Exception exception) {
            Matcher matcher = Pattern.compile("^(\\d+\\.\\d+\\.\\d+)\\.(\\d+)$").matcher(version);
            if (!matcher.matches()) {
                throw new UnsupportedVersionException(version);
            }
            String g1 = matcher.group(1);
            this.semver = Version.valueOf((String)g1);
            String g2 = matcher.group(2);
            try {
                this.fourthDigit = Integer.parseInt(g2);
            }
            catch (NumberFormatException e) {
                throw new UnsupportedVersionException(version);
            }
            return;
        }
    }

    @Override
    public int compareTo(VersionNumber v) {
        int result = this.semver.compareTo(v.semver);
        if (result != 0) {
            return result;
        }
        return Integer.compare(this.fourthDigit, v.fourthDigit);
    }

    public boolean satisfies(String versionSpec) {
        if (this.fourthDigit == -1 && versionSpec.matches("^\\d+\\.\\d+\\.\\*$")) {
            return this.semver.satisfies(versionSpec);
        }
        if (this.fourthDigit != -1 && versionSpec.matches("^\\d+\\.\\d+\\.\\d+\\.\\*$")) {
            String version = versionSpec.replaceAll("\\.\\*$", "");
            return this.semver.satisfies(version);
        }
        return false;
    }

    public VersionNumber incrementBy(int count) {
        if (this.fourthDigit == -1) {
            return new VersionNumber(this.semver.getMajorVersion() + "." + this.semver.getMinorVersion() + "." + (this.semver.getPatchVersion() + count));
        }
        return new VersionNumber(this.semver.toString() + "." + (this.fourthDigit + count));
    }

    public String toString() {
        if (this.fourthDigit == -1) {
            return this.semver.toString();
        }
        return this.semver.toString() + "." + this.fourthDigit;
    }

    public static class UnsupportedVersionException
    extends RuntimeException {
        public UnsupportedVersionException(String version) {
            super("Unsupported version: " + version + ". Expected semver OR 4-part number like 1.2.3.4");
        }
    }
}

