/*
 * Decompiled with CFR 0.152.
 */
package org.shipkit.auto.version;

import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.api.logging.Logger;
import org.shipkit.auto.version.CommitCounter;
import org.shipkit.auto.version.ProcessRunner;
import org.shipkit.auto.version.TagConvention;
import org.shipkit.auto.version.VersionConfig;
import org.shipkit.auto.version.VersionNumber;

class NextVersionPicker {
    private final ProcessRunner runner;
    private final Logger log;

    NextVersionPicker(ProcessRunner runner, Logger log) {
        this.runner = runner;
        this.log = log;
    }

    String pickNextVersion(Optional<VersionNumber> previousVersion, VersionConfig config, String projectVersion) {
        if (!"unspecified".equals(projectVersion)) {
            NextVersionPicker.explainVersion(this.log, projectVersion, "uses version already specified in the Gradle project");
            return projectVersion;
        }
        if (!config.getVersionSpec().isPresent()) {
            String result;
            String tag;
            try {
                tag = this.runner.run("git", "describe", "--tags").trim();
            }
            catch (Exception e) {
                String result2 = "0.0.1-SNAPSHOT";
                this.log.info("Process 'git describe --tags' exited with non-zero exit value. Assuming there are no tags. Run with --debug for more.");
                this.log.debug("Ignored exception from 'git describe --tags'. Assuming there are no tags.", (Throwable)e);
                NextVersionPicker.explainVersion(this.log, result2, "couldn't run 'git describe --tags' (assuming there are no tags)");
                return result2;
            }
            if (VersionConfig.isSupportedVersion(tag, config.getTagPrefix())) {
                result = tag.substring(config.getTagPrefix().length());
                NextVersionPicker.explainVersion(this.log, result, "deduced version based on tag: '" + tag + "'");
            } else if (VersionConfig.isSnapshot(tag, config.getTagPrefix())) {
                Pattern pattern = Pattern.compile("\\d+\\.\\d+\\.\\d+(\\.\\d+)?");
                Matcher matcher = pattern.matcher(tag);
                matcher.find();
                result = new VersionNumber(matcher.group()).incrementBy(1).toString() + "-SNAPSHOT";
                NextVersionPicker.explainVersion(this.log, result, "deduced snapshot based on tag: '" + config.getTagPrefix() + matcher.group() + "'");
            } else {
                result = "0.0.1-SNAPSHOT";
                NextVersionPicker.explainVersion(this.log, result, "found no version property and the code is not checked out on a valid tag");
            }
            return result;
        }
        if (!config.isWildcard()) {
            NextVersionPicker.explainVersion(this.log, config.getVersionSpec().get(), "uses verbatim version from version file");
            return config.getVersionSpec().get();
        }
        if (previousVersion.isPresent() && previousVersion.get().satisfies(config.getVersionSpec().get())) {
            VersionNumber prev = previousVersion.get();
            String gitOutput = this.runner.run("git", "log", "--pretty=oneline", TagConvention.tagFor(prev.toString(), config.getTagPrefix()) + "..HEAD");
            int commitCount = new CommitCounter().countCommitDelta(gitOutput);
            String result = prev.incrementBy(commitCount).toString();
            NextVersionPicker.explainVersion(this.log, result, "deduced version based on previous tag: '" + prev + "'");
            return result;
        }
        String result = config.newPatchVersion();
        NextVersionPicker.explainVersion(this.log, result, "found no tags matching version spec: '" + config + "'");
        return result;
    }

    static void explainVersion(Logger log, String version, String reason) {
        log.lifecycle("Building version '" + version + "'\n  - reason: shipkit-auto-version " + reason);
    }
}

