/*
 * Decompiled with CFR 0.152.
 */
package org.shipkit.auto.version;

import java.io.File;
import java.util.Collection;
import java.util.Optional;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.shipkit.auto.version.DeducedVersion;
import org.shipkit.auto.version.NextVersionPicker;
import org.shipkit.auto.version.PreviousVersionFinder;
import org.shipkit.auto.version.ProcessRunner;
import org.shipkit.auto.version.VersionConfig;
import org.shipkit.auto.version.VersionNumber;
import org.shipkit.auto.version.VersionsProvider;

class AutoVersion {
    private static final Logger LOG = Logging.getLogger(AutoVersion.class);
    private final ProcessRunner runner;
    private final File versionFile;

    AutoVersion(ProcessRunner runner, File versionFile) {
        this.runner = runner;
        this.versionFile = versionFile;
    }

    AutoVersion(File projectDir) {
        this(new ProcessRunner(projectDir), new File(projectDir, "version.properties"));
    }

    DeducedVersion deduceVersion(String projectVersion) {
        return this.deduceVersion(LOG, projectVersion);
    }

    DeducedVersion deduceVersion(Logger log, String projectVersion) {
        Optional<VersionNumber> previousVersion = Optional.empty();
        VersionConfig config = VersionConfig.parseVersionFile(this.versionFile);
        try {
            Collection<VersionNumber> versions = new VersionsProvider(this.runner).getAllVersions(config.getTagPrefix());
            PreviousVersionFinder previousVersionFinder = new PreviousVersionFinder();
            if (config.getVersionSpec().isPresent()) {
                previousVersion = previousVersionFinder.findPreviousVersion(versions, config);
            }
            String nextVersion = new NextVersionPicker(this.runner, log).pickNextVersion(previousVersion, config, projectVersion);
            if (!config.getVersionSpec().isPresent()) {
                previousVersion = previousVersionFinder.findPreviousVersion(versions, new VersionConfig(nextVersion, config.getTagPrefix()));
            }
            this.logPreviousVersion(log, previousVersion);
            return new DeducedVersion(nextVersion, previousVersion, config.getTagPrefix());
        }
        catch (Exception e) {
            String message = "caught an exception, falling back to reasonable default";
            log.debug("shipkit-auto-version " + message, (Throwable)e);
            String v = config.getVersionSpec().orElse("0.0.1-SNAPSHOT").replace("*", "unspecified");
            NextVersionPicker.explainVersion(log, v, message + "\n  - run with --debug for more info");
            return new DeducedVersion(v, previousVersion, config.getTagPrefix());
        }
    }

    private void logPreviousVersion(Logger log, Optional<VersionNumber> previousVersion) {
        log.info("[shipkit-auto-version] " + previousVersion.map(version -> "Previous version: " + version).orElse("No previous version"));
    }
}

