/*
 * Decompiled with CFR 0.152.
 */
package mjson;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Json {
    public static final Factory defaultFactory;
    private static Factory globalFactory;
    private static ThreadLocal<Factory> threadFactory;
    Json enclosing = null;
    static NullJson topnull;
    static Escaper escaper;

    private static Factory factory() {
        Factory f = threadFactory.get();
        return f != null ? f : globalFactory;
    }

    public static void setGlobalFactory(Factory factory) {
        globalFactory = factory;
    }

    public static void attachFactory(Factory factory) {
        threadFactory.set(factory);
    }

    public static void dettachFactory() {
        threadFactory.remove();
    }

    public static Json read(String jsonAsString) {
        return (Json)new Reader().read(jsonAsString);
    }

    public static Json read(CharacterIterator it) {
        return (Json)new Reader().read(it);
    }

    public static Json nil() {
        return Json.factory().nil();
    }

    public static Json object() {
        return Json.factory().object();
    }

    public static Json object(Object ... args) {
        Json j = Json.object();
        if (args.length % 2 != 0) {
            throw new IllegalArgumentException("An even number of arguments is expected.");
        }
        for (int i = 0; i < args.length; ++i) {
            j.set(args[i].toString(), Json.make(args[++i]));
        }
        return j;
    }

    public static Json array() {
        return Json.factory().array();
    }

    public static Json array(Object ... args) {
        Json A = Json.array();
        for (Object x : args) {
            A.add(Json.make(x));
        }
        return A;
    }

    public static Json make(Object anything) {
        return Json.factory().make(anything);
    }

    protected Json() {
    }

    protected Json(Json enclosing) {
        this.enclosing = enclosing;
    }

    public void attachTo(Json enclosing) {
        this.enclosing = enclosing;
    }

    public final Json up() {
        return this.enclosing;
    }

    public Json dup() {
        return this;
    }

    public Json at(int index) {
        throw new UnsupportedOperationException();
    }

    public Json at(String property) {
        throw new UnsupportedOperationException();
    }

    public final Json at(String property, Json def) {
        Json x = this.at(property);
        if (x == null) {
            this.set(property, def);
            return def;
        }
        return x;
    }

    public final Json at(String property, Object def) {
        return this.at(property, Json.make(def));
    }

    public boolean has(String property) {
        throw new UnsupportedOperationException();
    }

    public boolean is(String property, Object value) {
        throw new UnsupportedOperationException();
    }

    public boolean is(int index, Object value) {
        throw new UnsupportedOperationException();
    }

    public Json add(Json el) {
        throw new UnsupportedOperationException();
    }

    public final Json add(Object anything) {
        return this.add(Json.make(anything));
    }

    public Json atDel(String property) {
        throw new UnsupportedOperationException();
    }

    public Json atDel(int index) {
        throw new UnsupportedOperationException();
    }

    public Json delAt(String property) {
        throw new UnsupportedOperationException();
    }

    public Json delAt(int index) {
        throw new UnsupportedOperationException();
    }

    public Json remove(Json el) {
        throw new UnsupportedOperationException();
    }

    public final Json remove(Object anything) {
        return this.remove(Json.make(anything));
    }

    public Json set(String property, Json value) {
        throw new UnsupportedOperationException();
    }

    public final Json set(String property, Object value) {
        return this.set(property, Json.make(value));
    }

    public Json with(Json object) {
        throw new UnsupportedOperationException();
    }

    public Object getValue() {
        throw new UnsupportedOperationException();
    }

    public boolean asBoolean() {
        throw new UnsupportedOperationException();
    }

    public String asString() {
        throw new UnsupportedOperationException();
    }

    public int asInteger() {
        throw new UnsupportedOperationException();
    }

    public float asFloat() {
        throw new UnsupportedOperationException();
    }

    public double asDouble() {
        throw new UnsupportedOperationException();
    }

    public long asLong() {
        throw new UnsupportedOperationException();
    }

    public short asShort() {
        throw new UnsupportedOperationException();
    }

    public byte asByte() {
        throw new UnsupportedOperationException();
    }

    public char asChar() {
        throw new UnsupportedOperationException();
    }

    public Map<String, Object> asMap() {
        throw new UnsupportedOperationException();
    }

    public Map<String, Json> asJsonMap() {
        throw new UnsupportedOperationException();
    }

    public List<Object> asList() {
        throw new UnsupportedOperationException();
    }

    public List<Json> asJsonList() {
        throw new UnsupportedOperationException();
    }

    public boolean isNull() {
        return false;
    }

    public boolean isString() {
        return false;
    }

    public boolean isNumber() {
        return false;
    }

    public boolean isBoolean() {
        return false;
    }

    public boolean isArray() {
        return false;
    }

    public boolean isObject() {
        return false;
    }

    public boolean isPrimitive() {
        return this.isString() || this.isNumber() || this.isBoolean();
    }

    public String pad(String callback) {
        return callback != null && callback.length() > 0 ? callback + "(" + this.toString() + ");" : this.toString();
    }

    static {
        globalFactory = defaultFactory = new DefaultFactory();
        threadFactory = new ThreadLocal();
        topnull = new NullJson();
        escaper = new Escaper(false);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Reader {
        private static final Object OBJECT_END = new Object();
        private static final Object ARRAY_END = new Object();
        private static final Object COLON = new Object();
        private static final Object COMMA = new Object();
        public static final int FIRST = 0;
        public static final int CURRENT = 1;
        public static final int NEXT = 2;
        private static Map<Character, Character> escapes = new HashMap<Character, Character>();
        private CharacterIterator it;
        private char c;
        private Object token;
        private StringBuffer buf = new StringBuffer();

        private Reader() {
        }

        private char next() {
            if (this.it.getIndex() == this.it.getEndIndex()) {
                throw new RuntimeException("Reached end of input at the " + this.it.getIndex() + "th character.");
            }
            this.c = this.it.next();
            return this.c;
        }

        private char previous() {
            this.c = this.it.previous();
            return this.c;
        }

        private void skipWhiteSpace() {
            do {
                if (Character.isWhitespace(this.c)) continue;
                if (this.c != '/') break;
                this.next();
                if (this.c == '*') {
                    while (this.c != '\uffff' && (this.next() != '*' || this.next() != '/')) {
                    }
                    if (this.c != '\uffff') continue;
                    throw new RuntimeException("Unterminated comment while parsing JSON string.");
                }
                if (this.c == '/') {
                    while (this.c != '\n' && this.c != '\uffff') {
                        this.next();
                    }
                } else {
                    this.previous();
                    break;
                }
            } while (this.next() != '\uffff');
        }

        public Object read(CharacterIterator ci, int start) {
            this.it = ci;
            switch (start) {
                case 0: {
                    this.c = this.it.first();
                    break;
                }
                case 1: {
                    this.c = this.it.current();
                    break;
                }
                case 2: {
                    this.c = this.it.next();
                }
            }
            return this.read();
        }

        public Object read(CharacterIterator it) {
            return this.read(it, 2);
        }

        public Object read(String string) {
            return this.read(new StringCharacterIterator(string), 0);
        }

        private <T> T read() {
            this.skipWhiteSpace();
            char ch = this.c;
            this.next();
            switch (ch) {
                case '\"': {
                    this.token = this.readString();
                    break;
                }
                case '[': {
                    this.token = this.readArray();
                    break;
                }
                case ']': {
                    this.token = ARRAY_END;
                    break;
                }
                case ',': {
                    this.token = COMMA;
                    break;
                }
                case '{': {
                    this.token = this.readObject();
                    break;
                }
                case '}': {
                    this.token = OBJECT_END;
                    break;
                }
                case ':': {
                    this.token = COLON;
                    break;
                }
                case 't': {
                    if (this.c != 'r' || this.next() != 'u' || this.next() != 'e') {
                        throw new RuntimeException("Invalid JSON token: expected 'true' keyword.");
                    }
                    this.next();
                    this.token = Json.factory().bool(Boolean.TRUE);
                    break;
                }
                case 'f': {
                    if (this.c != 'a' || this.next() != 'l' || this.next() != 's' || this.next() != 'e') {
                        throw new RuntimeException("Invalid JSON token: expected 'false' keyword.");
                    }
                    this.next();
                    this.token = Json.factory().bool(Boolean.FALSE);
                    break;
                }
                case 'n': {
                    if (this.c != 'u' || this.next() != 'l' || this.next() != 'l') {
                        throw new RuntimeException("Invalid JSON token: expected 'null' keyword.");
                    }
                    this.next();
                    this.token = Json.nil();
                    break;
                }
                default: {
                    this.c = this.it.previous();
                    if (!Character.isDigit(this.c) && this.c != '-') break;
                    this.token = this.readNumber();
                }
            }
            return (T)this.token;
        }

        private String readObjectKey() {
            Object key = this.read();
            if (key == null) {
                throw new RuntimeException("Missing object key (don't forget to put quotes!).");
            }
            if (key != OBJECT_END) {
                return ((Json)key).asString();
            }
            return key.toString();
        }

        private Json readObject() {
            Json ret = Json.object();
            String key = this.readObjectKey();
            while (this.token != OBJECT_END) {
                this.read();
                if (this.token == OBJECT_END) continue;
                Json value = (Json)this.read();
                ret.set(key, value);
                if (this.read() != COMMA) continue;
                key = this.readObjectKey();
            }
            return ret;
        }

        private Json readArray() {
            Json ret = Json.array();
            Object value = this.read();
            while (this.token != ARRAY_END) {
                ret.add((Json)value);
                if (this.read() == COMMA) {
                    value = this.read();
                    continue;
                }
                if (this.token == ARRAY_END) continue;
                throw new RuntimeException("Unexpected token in array " + this.token);
            }
            return ret;
        }

        private Json readNumber() {
            int length = 0;
            boolean isFloatingPoint = false;
            this.buf.setLength(0);
            if (this.c == '-') {
                this.add();
            }
            length += this.addDigits();
            if (this.c == '.') {
                this.add();
                length += this.addDigits();
                isFloatingPoint = true;
            }
            if (this.c == 'e' || this.c == 'E') {
                this.add();
                if (this.c == '+' || this.c == '-') {
                    this.add();
                }
                this.addDigits();
                isFloatingPoint = true;
            }
            String s = this.buf.toString();
            Number n = isFloatingPoint ? (Number)(length < 17 ? Double.valueOf(s) : new BigDecimal(s)) : (Number)(length < 20 ? Long.valueOf(s) : new BigInteger(s));
            return Json.factory().number(n);
        }

        private int addDigits() {
            int ret = 0;
            while (Character.isDigit(this.c)) {
                this.add();
                ++ret;
            }
            return ret;
        }

        private Json readString() {
            this.buf.setLength(0);
            while (this.c != '\"') {
                if (this.c == '\\') {
                    this.next();
                    if (this.c == 'u') {
                        this.add(this.unicode());
                        continue;
                    }
                    Character value = escapes.get(new Character(this.c));
                    if (value == null) continue;
                    this.add(value.charValue());
                    continue;
                }
                this.add();
            }
            this.next();
            return Json.factory().string(this.buf.toString());
        }

        private void add(char cc) {
            this.buf.append(cc);
            this.next();
        }

        private void add() {
            this.add(this.c);
        }

        private char unicode() {
            int value = 0;
            block5: for (int i = 0; i < 4; ++i) {
                switch (this.next()) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        value = (value << 4) + this.c - 48;
                        continue block5;
                    }
                    case 'a': 
                    case 'b': 
                    case 'c': 
                    case 'd': 
                    case 'e': 
                    case 'f': {
                        value = (value << 4) + (this.c - 97) + 10;
                        continue block5;
                    }
                    case 'A': 
                    case 'B': 
                    case 'C': 
                    case 'D': 
                    case 'E': 
                    case 'F': {
                        value = (value << 4) + (this.c - 65) + 10;
                    }
                }
            }
            return (char)value;
        }

        static {
            escapes.put(new Character('\"'), new Character('\"'));
            escapes.put(new Character('\\'), new Character('\\'));
            escapes.put(new Character('/'), new Character('/'));
            escapes.put(new Character('b'), new Character('\b'));
            escapes.put(new Character('f'), new Character('\f'));
            escapes.put(new Character('n'), new Character('\n'));
            escapes.put(new Character('r'), new Character('\r'));
            escapes.put(new Character('t'), new Character('\t'));
        }
    }

    static final class Escaper {
        private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        private static final Set<Character> JS_ESCAPE_CHARS;
        private static final Set<Character> HTML_ESCAPE_CHARS;
        private final boolean escapeHtmlCharacters;

        Escaper(boolean escapeHtmlCharacters) {
            this.escapeHtmlCharacters = escapeHtmlCharacters;
        }

        public String escapeJsonString(CharSequence plainText) {
            StringBuilder escapedString = new StringBuilder(plainText.length() + 20);
            try {
                this.escapeJsonString(plainText, escapedString);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return escapedString.toString();
        }

        private void escapeJsonString(CharSequence plainText, StringBuilder out) throws IOException {
            int charCount;
            int pos = 0;
            int len = plainText.length();
            block10: for (int i = 0; i < len; i += charCount) {
                int codePoint = Character.codePointAt(plainText, i);
                charCount = Character.charCount(codePoint);
                if (!Escaper.isControlCharacter(codePoint) && !this.mustEscapeCharInJsString(codePoint)) continue;
                out.append(plainText, pos, i);
                pos = i + charCount;
                switch (codePoint) {
                    case 8: {
                        out.append("\\b");
                        continue block10;
                    }
                    case 9: {
                        out.append("\\t");
                        continue block10;
                    }
                    case 10: {
                        out.append("\\n");
                        continue block10;
                    }
                    case 12: {
                        out.append("\\f");
                        continue block10;
                    }
                    case 13: {
                        out.append("\\r");
                        continue block10;
                    }
                    case 92: {
                        out.append("\\\\");
                        continue block10;
                    }
                    case 47: {
                        out.append("\\/");
                        continue block10;
                    }
                    case 34: {
                        out.append("\\\"");
                        continue block10;
                    }
                    default: {
                        Escaper.appendHexJavaScriptRepresentation(codePoint, out);
                    }
                }
            }
            out.append(plainText, pos, len);
        }

        private boolean mustEscapeCharInJsString(int codepoint) {
            if (!Character.isSupplementaryCodePoint(codepoint)) {
                char c = (char)codepoint;
                return JS_ESCAPE_CHARS.contains(Character.valueOf(c)) || this.escapeHtmlCharacters && HTML_ESCAPE_CHARS.contains(Character.valueOf(c));
            }
            return false;
        }

        private static boolean isControlCharacter(int codePoint) {
            return codePoint < 32 || codePoint == 8232 || codePoint == 8233 || codePoint >= 127 && codePoint <= 159;
        }

        private static void appendHexJavaScriptRepresentation(int codePoint, Appendable out) throws IOException {
            if (Character.isSupplementaryCodePoint(codePoint)) {
                char[] surrogates = Character.toChars(codePoint);
                Escaper.appendHexJavaScriptRepresentation(surrogates[0], out);
                Escaper.appendHexJavaScriptRepresentation(surrogates[1], out);
                return;
            }
            out.append("\\u").append(HEX_CHARS[codePoint >>> 12 & 0xF]).append(HEX_CHARS[codePoint >>> 8 & 0xF]).append(HEX_CHARS[codePoint >>> 4 & 0xF]).append(HEX_CHARS[codePoint & 0xF]);
        }

        static {
            HashSet<Character> mandatoryEscapeSet = new HashSet<Character>();
            mandatoryEscapeSet.add(Character.valueOf('\"'));
            mandatoryEscapeSet.add(Character.valueOf('\\'));
            JS_ESCAPE_CHARS = Collections.unmodifiableSet(mandatoryEscapeSet);
            HashSet<Character> htmlEscapeSet = new HashSet<Character>();
            htmlEscapeSet.add(Character.valueOf('<'));
            htmlEscapeSet.add(Character.valueOf('>'));
            htmlEscapeSet.add(Character.valueOf('&'));
            htmlEscapeSet.add(Character.valueOf('='));
            htmlEscapeSet.add(Character.valueOf('\''));
            HTML_ESCAPE_CHARS = Collections.unmodifiableSet(htmlEscapeSet);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ObjectJson
    extends Json {
        Map<String, Json> object = new HashMap<String, Json>();

        ObjectJson() {
        }

        ObjectJson(Json e) {
            super(e);
        }

        @Override
        public Json dup() {
            ObjectJson j = new ObjectJson();
            for (Map.Entry<String, Json> e : this.object.entrySet()) {
                Json v = e.getValue().dup();
                v.enclosing = j;
                j.object.put(e.getKey(), v);
            }
            return j;
        }

        @Override
        public boolean has(String property) {
            return this.object.containsKey(property);
        }

        @Override
        public boolean is(String property, Object value) {
            Json p = this.object.get(property);
            if (p == null) {
                return false;
            }
            return p.equals(ObjectJson.make(value));
        }

        @Override
        public Json at(String property) {
            return this.object.get(property);
        }

        @Override
        public Json with(Json x) {
            if (!x.isObject()) {
                throw new UnsupportedOperationException();
            }
            this.object.putAll(((ObjectJson)x).object);
            return this;
        }

        @Override
        public Json set(String property, Json el) {
            el.enclosing = this;
            this.object.put(property, el);
            return this;
        }

        @Override
        public Json atDel(String property) {
            Json el = this.object.remove(property);
            if (el != null) {
                el.enclosing = null;
            }
            return el;
        }

        @Override
        public Json delAt(String property) {
            Json el = this.object.remove(property);
            if (el != null) {
                el.enclosing = null;
            }
            return this;
        }

        @Override
        public Object getValue() {
            return this.asMap();
        }

        @Override
        public boolean isObject() {
            return true;
        }

        @Override
        public Map<String, Object> asMap() {
            HashMap<String, Object> m = new HashMap<String, Object>();
            for (Map.Entry<String, Json> e : this.object.entrySet()) {
                m.put(e.getKey(), e.getValue().getValue());
            }
            return m;
        }

        @Override
        public Map<String, Json> asJsonMap() {
            return this.object;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("{");
            Iterator<Map.Entry<String, Json>> i = this.object.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry<String, Json> x = i.next();
                sb.append('\"');
                sb.append(escaper.escapeJsonString(x.getKey()));
                sb.append('\"');
                sb.append(":");
                sb.append(x.getValue().toString());
                if (!i.hasNext()) continue;
                sb.append(",");
            }
            sb.append("}");
            return sb.toString();
        }

        public int hashCode() {
            return ((Object)this.object).hashCode();
        }

        public boolean equals(Object x) {
            return x instanceof ObjectJson && ((Object)((ObjectJson)x).object).equals(this.object);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ArrayJson
    extends Json {
        List<Json> L = new ArrayList<Json>();

        ArrayJson() {
        }

        ArrayJson(Json e) {
            super(e);
        }

        @Override
        public Json dup() {
            ArrayJson j = new ArrayJson();
            for (Json e : this.L) {
                Json v = e.dup();
                v.enclosing = j;
                j.L.add(v);
            }
            return j;
        }

        @Override
        public List<Json> asJsonList() {
            return this.L;
        }

        @Override
        public List<Object> asList() {
            ArrayList<Object> A = new ArrayList<Object>();
            for (Json x : this.L) {
                A.add(x.getValue());
            }
            return A;
        }

        @Override
        public boolean is(int index, Object value) {
            if (index < 0 || index >= this.L.size()) {
                return false;
            }
            return this.L.get(index).equals(ArrayJson.make(value));
        }

        @Override
        public Object getValue() {
            return this.asList();
        }

        @Override
        public boolean isArray() {
            return true;
        }

        @Override
        public Json at(int index) {
            return this.L.get(index);
        }

        @Override
        public Json add(Json el) {
            this.L.add(el);
            el.enclosing = this;
            return this;
        }

        @Override
        public Json remove(Json el) {
            this.L.remove(el);
            el.enclosing = null;
            return this;
        }

        @Override
        public Json with(Json object) {
            if (!object.isArray()) {
                throw new UnsupportedOperationException();
            }
            this.L.addAll(((ArrayJson)object).L);
            return this;
        }

        @Override
        public Json atDel(int index) {
            Json el = this.L.remove(index);
            if (el != null) {
                el.enclosing = null;
            }
            return el;
        }

        @Override
        public Json delAt(int index) {
            Json el = this.L.remove(index);
            if (el != null) {
                el.enclosing = null;
            }
            return this;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("[");
            Iterator<Json> i = this.L.iterator();
            while (i.hasNext()) {
                sb.append(i.next().toString());
                if (!i.hasNext()) continue;
                sb.append(",");
            }
            sb.append("]");
            return sb.toString();
        }

        public int hashCode() {
            return ((Object)this.L).hashCode();
        }

        public boolean equals(Object x) {
            return x instanceof ArrayJson && ((Object)((ArrayJson)x).L).equals(this.L);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class NumberJson
    extends Json {
        Number val;

        NumberJson() {
        }

        NumberJson(Json e) {
            super(e);
        }

        NumberJson(Number val, Json e) {
            super(e);
            this.val = val;
        }

        @Override
        public Json dup() {
            return new NumberJson(this.val, null);
        }

        @Override
        public boolean isNumber() {
            return true;
        }

        @Override
        public Object getValue() {
            return this.val;
        }

        @Override
        public String asString() {
            return this.val.toString();
        }

        @Override
        public int asInteger() {
            return this.val.intValue();
        }

        @Override
        public float asFloat() {
            return this.val.floatValue();
        }

        @Override
        public double asDouble() {
            return this.val.doubleValue();
        }

        @Override
        public long asLong() {
            return this.val.longValue();
        }

        @Override
        public short asShort() {
            return this.val.shortValue();
        }

        @Override
        public byte asByte() {
            return this.val.byteValue();
        }

        @Override
        public List<Object> asList() {
            return Collections.singletonList(this.val);
        }

        public String toString() {
            return this.val.toString();
        }

        public int hashCode() {
            return this.val.hashCode();
        }

        public boolean equals(Object x) {
            return x instanceof NumberJson && ((NumberJson)x).val.equals(this.val);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class StringJson
    extends Json {
        String val;

        StringJson() {
        }

        StringJson(Json e) {
            super(e);
        }

        StringJson(String val, Json e) {
            super(e);
            this.val = val;
        }

        @Override
        public Json dup() {
            return new StringJson(this.val, null);
        }

        @Override
        public boolean isString() {
            return true;
        }

        @Override
        public Object getValue() {
            return this.val;
        }

        @Override
        public String asString() {
            return this.val;
        }

        @Override
        public int asInteger() {
            return Integer.parseInt(this.val);
        }

        @Override
        public float asFloat() {
            return Float.parseFloat(this.val);
        }

        @Override
        public double asDouble() {
            return Double.parseDouble(this.val);
        }

        @Override
        public long asLong() {
            return Long.parseLong(this.val);
        }

        @Override
        public short asShort() {
            return Short.parseShort(this.val);
        }

        @Override
        public byte asByte() {
            return Byte.parseByte(this.val);
        }

        @Override
        public char asChar() {
            return this.val.charAt(0);
        }

        @Override
        public List<Object> asList() {
            return Collections.singletonList(this.val);
        }

        public String toString() {
            return '\"' + escaper.escapeJsonString(this.val) + '\"';
        }

        public int hashCode() {
            return this.val.hashCode();
        }

        public boolean equals(Object x) {
            return x instanceof StringJson && ((StringJson)x).val.equals(this.val);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class BooleanJson
    extends Json {
        boolean val;

        BooleanJson() {
        }

        BooleanJson(Json e) {
            super(e);
        }

        BooleanJson(Boolean val, Json e) {
            super(e);
            this.val = val;
        }

        @Override
        public Json dup() {
            return new BooleanJson(this.val, null);
        }

        @Override
        public boolean asBoolean() {
            return this.val;
        }

        @Override
        public boolean isBoolean() {
            return true;
        }

        public String toString() {
            return this.val ? "true" : "false";
        }

        @Override
        public List<Object> asList() {
            return Collections.singletonList(this.val);
        }

        public int hashCode() {
            return this.val ? 1 : 0;
        }

        public boolean equals(Object x) {
            return x instanceof BooleanJson && ((BooleanJson)x).val == this.val;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class NullJson
    extends Json {
        NullJson() {
        }

        NullJson(Json e) {
            super(e);
        }

        @Override
        public Json dup() {
            return new NullJson();
        }

        @Override
        public boolean isNull() {
            return true;
        }

        public String toString() {
            return "null";
        }

        @Override
        public List<Object> asList() {
            return Collections.singletonList(null);
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object x) {
            return x instanceof NullJson;
        }
    }

    public static class DefaultFactory
    implements Factory {
        public Json nil() {
            return topnull;
        }

        public Json bool(boolean x) {
            return new BooleanJson(x ? Boolean.TRUE : Boolean.FALSE, null);
        }

        public Json string(String x) {
            return new StringJson(x, null);
        }

        public Json number(Number x) {
            return new NumberJson(x, null);
        }

        public Json array() {
            return new ArrayJson();
        }

        public Json object() {
            return new ObjectJson();
        }

        public Json make(Object anything) {
            if (anything == null) {
                return topnull;
            }
            if (anything instanceof Json) {
                return (Json)anything;
            }
            if (anything instanceof String) {
                return Json.factory().string((String)anything);
            }
            if (anything instanceof Collection) {
                Json L = this.array();
                for (Object x : (Collection)anything) {
                    L.add(this.make(x));
                }
                return L;
            }
            if (anything instanceof Map) {
                Json O = this.object();
                for (Map.Entry x : ((Map)anything).entrySet()) {
                    O.set(x.getKey().toString(), this.make(x.getValue()));
                }
                return O;
            }
            if (anything instanceof Boolean) {
                return Json.factory().bool((Boolean)anything);
            }
            if (anything instanceof Number) {
                return Json.factory().number((Number)anything);
            }
            if (anything.getClass().isArray()) {
                Class<?> comp = anything.getClass().getComponentType();
                if (!comp.isPrimitive()) {
                    return Json.array((Object[])anything);
                }
                Json A = this.array();
                if (Boolean.TYPE == comp) {
                    for (boolean b : (boolean[])anything) {
                        A.add(b);
                    }
                } else if (Byte.TYPE == comp) {
                    for (byte b : (byte[])anything) {
                        A.add(b);
                    }
                } else if (Character.TYPE == comp) {
                    for (char b : (char[])anything) {
                        A.add(Character.valueOf(b));
                    }
                } else if (Short.TYPE == comp) {
                    for (short b : (short[])anything) {
                        A.add(b);
                    }
                } else if (Integer.TYPE == comp) {
                    for (int b : (int[])anything) {
                        A.add(b);
                    }
                } else if (Long.TYPE == comp) {
                    for (long b : (long[])anything) {
                        A.add(b);
                    }
                } else if (Float.TYPE == comp) {
                    for (float b : (float[])anything) {
                        A.add(Float.valueOf(b));
                    }
                } else if (Double.TYPE == comp) {
                    for (double b : (double[])anything) {
                        A.add(b);
                    }
                }
                return A;
            }
            throw new IllegalArgumentException("Don't know how to convert to Json : " + anything);
        }
    }

    public static interface Factory {
        public Json nil();

        public Json bool(boolean var1);

        public Json string(String var1);

        public Json number(Number var1);

        public Json object();

        public Json array();

        public Json make(Object var1);
    }
}

