/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.web;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import java.util.logging.Logger;
import org.openqa.selenium.grid.web.CommandHandler;
import org.openqa.selenium.grid.web.Route;
import org.openqa.selenium.grid.web.Routes;
import org.openqa.selenium.remote.http.HttpRequest;

public class CombinedRoute
extends Route<CombinedRoute> {
    public static final Logger LOG = Logger.getLogger(Route.class.getName());
    private final List<Routes> factories;

    CombinedRoute(List<Routes> factories) {
        this.factories = ImmutableList.copyOf(factories);
    }

    @Override
    protected void validate() {
    }

    @Override
    protected CommandHandler newHandler(HttpRequest request) {
        for (Routes factory : this.factories) {
            try {
                Optional<CommandHandler> handler = factory.match(request);
                if (!handler.isPresent()) continue;
                return handler.get();
            }
            catch (IllegalArgumentException e) {
                LOG.warning(e.getMessage());
            }
        }
        return this.getFallback();
    }
}

